/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class StringUtils {
    private StringUtils() {
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter(512);
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            throwable.printStackTrace(printWriter);
        }
        return stringWriter.toString();
    }

    public static String getStackTrace(StackTraceElement[] elements) {
        StringBuilder builder = new StringBuilder();
        for (StackTraceElement element : elements) {
            builder.append("\tat ").append(element).append(System.lineSeparator());
        }
        return builder.toString();
    }

    public static boolean isBlank(String str) {
        return str == null || str.isBlank();
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static String normalizeWhitespaces(String str) {
        int start;
        if (str == null) {
            return "";
        }
        int end = str.length();
        for (start = 0; start < str.length() && Character.isWhitespace(str.charAt(start)); ++start) {
        }
        while (end > start && Character.isWhitespace(str.charAt(end - 1))) {
            --end;
        }
        if (end == start) {
            return "";
        }
        StringBuilder builder = null;
        int i = start;
        while (i < end) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch)) {
                int whitespaceEnd;
                for (whitespaceEnd = i + 1; whitespaceEnd < end && Character.isWhitespace(str.charAt(whitespaceEnd)); ++whitespaceEnd) {
                }
                if (whitespaceEnd - i > 1 || ch != ' ') {
                    if (builder == null) {
                        builder = new StringBuilder(end - start);
                        builder.append(str, start, i);
                    }
                    builder.append(' ');
                    i = whitespaceEnd;
                    continue;
                }
            }
            if (builder != null) {
                builder.append(ch);
            }
            ++i;
        }
        return builder != null ? builder.toString() : str.substring(start, end);
    }

    public static String capitalizeFirst(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String substringBeforeLast(String str, char delimiter) {
        return StringUtils.substringBeforeLast(str, delimiter, str);
    }

    public static String substringBeforeLast(String str, char delimiter, String missingDelimiterValue) {
        int index = str.lastIndexOf(delimiter);
        return index == -1 ? missingDelimiterValue : str.substring(0, index);
    }

    public static String substringBeforeLast(String str, String delimiter) {
        return StringUtils.substringBeforeLast(str, delimiter, str);
    }

    public static String substringBeforeLast(String str, String delimiter, String missingDelimiterValue) {
        int index = str.lastIndexOf(delimiter);
        return index == -1 ? missingDelimiterValue : str.substring(0, index);
    }

    public static String substringBefore(String str, char delimiter) {
        return StringUtils.substringBefore(str, delimiter, str);
    }

    public static String substringBefore(String str, char delimiter, String missingDelimiterValue) {
        int index = str.indexOf(delimiter);
        return index == -1 ? missingDelimiterValue : str.substring(0, index);
    }

    public static String substringBefore(String str, String delimiter) {
        return StringUtils.substringBefore(str, delimiter, str);
    }

    public static String substringBefore(String str, String delimiter, String missingDelimiterValue) {
        int index = str.indexOf(delimiter);
        return index == -1 ? missingDelimiterValue : str.substring(0, index);
    }

    public static String substringAfterLast(String str, char delimiter) {
        return StringUtils.substringAfterLast(str, delimiter, "");
    }

    public static String substringAfterLast(String str, char delimiter, String missingDelimiterValue) {
        int index = str.lastIndexOf(delimiter);
        return index == -1 ? missingDelimiterValue : str.substring(index + 1);
    }

    public static String substringAfterLast(String str, String delimiter) {
        return StringUtils.substringAfterLast(str, delimiter, "");
    }

    public static String substringAfterLast(String str, String delimiter, String missingDelimiterValue) {
        int index = str.lastIndexOf(delimiter);
        return index == -1 ? missingDelimiterValue : str.substring(index + delimiter.length());
    }

    public static String substringAfter(String str, char delimiter) {
        return StringUtils.substringAfter(str, delimiter, "");
    }

    public static String substringAfter(String str, char delimiter, String missingDelimiterValue) {
        int index = str.indexOf(delimiter);
        return index == -1 ? missingDelimiterValue : str.substring(index + 1);
    }

    public static String substringAfter(String str, String delimiter) {
        return StringUtils.substringAfter(str, delimiter, "");
    }

    public static String substringAfter(String str, String delimiter, String missingDelimiterValue) {
        int index = str.indexOf(delimiter);
        return index == -1 ? missingDelimiterValue : str.substring(index + delimiter.length());
    }

    public static boolean isSurrounded(String str, String prefix, String suffix) {
        return str.startsWith(prefix) && str.endsWith(suffix);
    }

    public static String removeSurrounding(String str, String delimiter) {
        return StringUtils.removeSurrounding(str, delimiter, delimiter);
    }

    public static String removeSurrounding(String str, String prefix, String suffix) {
        if (str.length() >= prefix.length() + suffix.length() && str.startsWith(prefix) && str.endsWith(suffix)) {
            return str.substring(prefix.length(), str.length() - suffix.length());
        }
        return str;
    }

    public static String addPrefix(String str, String prefix) {
        if (str.startsWith(prefix)) {
            return str;
        }
        return prefix + str;
    }

    public static String addSuffix(String str, String suffix) {
        if (str.endsWith(suffix)) {
            return str;
        }
        return str + suffix;
    }

    public static String removePrefix(String str, String prefix) {
        return str.startsWith(prefix) ? str.substring(prefix.length()) : str;
    }

    public static String removePrefix(String str, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!str.startsWith(prefix)) continue;
            return str.substring(prefix.length());
        }
        return str;
    }

    public static String removeSuffix(String str, String suffix) {
        return str.endsWith(suffix) ? str.substring(0, str.length() - suffix.length()) : str;
    }

    public static String removeSuffix(String str, String ... suffixes) {
        for (String suffix : suffixes) {
            if (!str.endsWith(suffix)) continue;
            return str.substring(0, str.length() - suffix.length());
        }
        return str;
    }

    public static boolean containsOne(Collection<String> patterns, String ... targets) {
        for (String pattern : patterns) {
            String lowerPattern = pattern.toLowerCase(Locale.ROOT);
            for (String target : targets) {
                if (!lowerPattern.contains(target.toLowerCase(Locale.ROOT))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsOne(String pattern, String ... targets) {
        String lowerPattern = pattern.toLowerCase(Locale.ROOT);
        for (String target : targets) {
            if (!lowerPattern.contains(target.toLowerCase(Locale.ROOT))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsChinese(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch < '\u4e00' || ch > '\u9fa5') continue;
            return true;
        }
        return false;
    }

    public static boolean containsEmoji(String str) {
        int ch;
        for (int i = 0; i < str.length(); i += Character.charCount(ch)) {
            ch = str.codePointAt(i);
            if (ch < 127744 || ch > 129791) continue;
            return true;
        }
        return false;
    }

    private static boolean isVarNameStart(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_';
    }

    private static boolean isVarNamePart(char ch) {
        return StringUtils.isVarNameStart(ch) || ch >= '0' && ch <= '9';
    }

    private static int findVarEnd(String str, int offset) {
        if (offset < str.length() - 1 && StringUtils.isVarNameStart(str.charAt(offset))) {
            int end;
            for (end = offset + 1; end < str.length() && StringUtils.isVarNamePart(str.charAt(end)); ++end) {
            }
            return end;
        }
        return -1;
    }

    public static List<String> tokenize(String str) {
        return StringUtils.tokenize(str, null);
    }

    public static List<String> tokenize(String str, Map<String, String> vars) {
        if (StringUtils.isBlank(str)) {
            return new ArrayList<String>();
        }
        if (vars == null) {
            vars = Collections.emptyMap();
        }
        ArrayList<String> parts = new ArrayList<String>();
        boolean hasValue = false;
        StringBuilder current = new StringBuilder(str.length());
        int i = 0;
        while (i < str.length()) {
            String value;
            int varEnd;
            char c = str.charAt(i);
            if (c == '\'') {
                hasValue = true;
                int end = str.indexOf(c, i + 1);
                if (end < 0) {
                    end = str.length();
                }
                current.append(str, i + 1, end);
                i = end + 1;
                continue;
            }
            if (c == '\"') {
                hasValue = true;
                ++i;
                while (i < str.length() && (c = str.charAt(i++)) != '\"') {
                    if (c == '`' && i < str.length()) {
                        c = str.charAt(i++);
                        switch (c) {
                            case 'a': {
                                c = '\u0007';
                                break;
                            }
                            case 'b': {
                                c = '\b';
                                break;
                            }
                            case 'f': {
                                c = '\f';
                                break;
                            }
                            case 'n': {
                                c = '\n';
                                break;
                            }
                            case 'r': {
                                c = '\r';
                                break;
                            }
                            case 't': {
                                c = '\t';
                                break;
                            }
                            case 'v': {
                                c = '\u000b';
                            }
                        }
                        current.append(c);
                        continue;
                    }
                    if (c == '$' && (varEnd = StringUtils.findVarEnd(str, i)) >= 0) {
                        String key = str.substring(i, varEnd);
                        value = vars.get(key);
                        if (value != null) {
                            current.append(value);
                        } else {
                            current.append('$').append(key);
                        }
                        i = varEnd;
                        continue;
                    }
                    current.append(c);
                }
                continue;
            }
            if (c == ' ') {
                if (hasValue) {
                    parts.add(current.toString());
                    current.setLength(0);
                    hasValue = false;
                }
                ++i;
                continue;
            }
            if (c == '$' && (varEnd = StringUtils.findVarEnd(str, i + 1)) >= 0) {
                hasValue = true;
                String key = str.substring(i + 1, varEnd);
                value = vars.get(key);
                if (value != null) {
                    current.append(value);
                } else {
                    current.append('$').append(key);
                }
                i = varEnd;
                continue;
            }
            hasValue = true;
            current.append(c);
            ++i;
        }
        if (hasValue) {
            parts.add(current.toString());
        }
        return parts;
    }

    public static String parseColorEscapes(String original) {
        if (original.indexOf(167) < 0) {
            return original;
        }
        return original.replaceAll("\u00a7[0-9a-gklmnor]", "");
    }

    public static String parseEscapeSequence(String str) {
        int idx = str.indexOf(27);
        if (idx < 0) {
            return str;
        }
        StringBuilder builder = new StringBuilder(str.length());
        boolean inEscape = false;
        builder.append(str, 0, idx);
        for (int i = idx; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\u001b') {
                inEscape = true;
            }
            if (!inEscape) {
                builder.append(ch);
            }
            if (!inEscape || ch != 'm') continue;
            inEscape = false;
        }
        return builder.toString();
    }

    public static String repeats(char ch, int repeat) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < repeat; ++i) {
            result.append(ch);
        }
        return result.toString();
    }

    public static String truncate(String str, int limit) {
        assert (limit > 5);
        if (str.length() <= limit) {
            return str;
        }
        int halfLength = (limit - 5) / 2;
        return str.substring(0, halfLength) + " ... " + str.substring(str.length() - halfLength);
    }

    public static boolean isASCII(String cs) {
        for (int i = 0; i < cs.length(); ++i) {
            if (cs.charAt(i) < '\u0080') continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphabeticOrNumber(String str) {
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') continue;
            return false;
        }
        return true;
    }

    public static final class LongestCommonSubsequence {
        private final int[][] f;
        private final int maxLengthA;
        private final int maxLengthB;

        public LongestCommonSubsequence(int maxLengthA, int maxLengthB) {
            this.maxLengthA = maxLengthA;
            this.maxLengthB = maxLengthB;
            this.f = new int[maxLengthA + 1][];
            for (int i = 0; i <= maxLengthA; ++i) {
                this.f[i] = new int[maxLengthB + 1];
            }
        }

        public int calc(CharSequence a, CharSequence b) {
            if (a.length() > this.maxLengthA || b.length() > this.maxLengthB) {
                throw new IllegalArgumentException("Too large length");
            }
            for (int i = 1; i <= a.length(); ++i) {
                for (int j = 1; j <= b.length(); ++j) {
                    this.f[i][j] = a.charAt(i - 1) == b.charAt(j - 1) ? 1 + this.f[i - 1][j - 1] : Math.max(this.f[i - 1][j], this.f[i][j - 1]);
                }
            }
            return this.f[a.length()][b.length()];
        }
    }

    public static class LevCalculator {
        private int[][] lev;

        public LevCalculator() {
        }

        public LevCalculator(int length1, int length2) {
            this.allocate(length1, length2);
        }

        private void allocate(int length1, int length2) {
            this.lev = new int[++length1][++length2];
            for (int i = 1; i < length1; ++i) {
                this.lev[i][0] = i;
            }
            int[] cache = this.lev[0];
            for (int i = 0; i < length2; ++i) {
                cache[i] = i;
            }
        }

        public int getLength1() {
            return this.lev.length;
        }

        public int getLength2() {
            return this.lev[0].length;
        }

        private int min(int a, int b, int c) {
            return Math.min(a, Math.min(b, c));
        }

        public int calc(CharSequence a, CharSequence b) {
            if (this.lev == null || a.length() >= this.lev.length || b.length() >= this.lev[0].length) {
                this.allocate(a.length(), b.length());
            }
            int lengthA = a.length() + 1;
            int lengthB = b.length() + 1;
            for (int i = 1; i < lengthA; ++i) {
                for (int j = 1; j < lengthB; ++j) {
                    this.lev[i][j] = this.min(this.lev[i][j - 1] + 1, this.lev[i - 1][j] + 1, a.charAt(i - 1) == b.charAt(j - 1) ? this.lev[i - 1][j - 1] : this.lev[i - 1][j - 1] + 1);
                }
            }
            return this.lev[a.length()][b.length()];
        }
    }
}

