/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform.windows;

import java.util.List;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.NativeUtils;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.hardware.CentralProcessor;
import org.jackhuang.hmcl.util.platform.hardware.GraphicsCard;
import org.jackhuang.hmcl.util.platform.hardware.HardwareDetector;
import org.jackhuang.hmcl.util.platform.windows.Kernel32;
import org.jackhuang.hmcl.util.platform.windows.WinTypes;
import org.jackhuang.hmcl.util.platform.windows.WindowsCPUDetector;
import org.jackhuang.hmcl.util.platform.windows.WindowsGPUDetector;
import org.jetbrains.annotations.Nullable;

public final class WindowsHardwareDetector
extends HardwareDetector {
    @Override
    @Nullable
    public CentralProcessor detectCentralProcessor() {
        if (!OperatingSystem.isWindows7OrLater()) {
            return null;
        }
        return WindowsCPUDetector.detect();
    }

    @Override
    public List<GraphicsCard> detectGraphicsCards() {
        if (!OperatingSystem.isWindows7OrLater()) {
            return null;
        }
        return WindowsGPUDetector.detect();
    }

    @Override
    public long getTotalMemorySize() {
        Kernel32 kernel32;
        if (NativeUtils.USE_JNA && (kernel32 = Kernel32.INSTANCE) != null) {
            WinTypes.MEMORYSTATUSEX status = new WinTypes.MEMORYSTATUSEX();
            if (kernel32.GlobalMemoryStatusEx(status)) {
                return status.ullTotalPhys;
            }
            Logger.LOG.warning("Failed to get memory status: " + kernel32.GetLastError());
        }
        return super.getTotalMemorySize();
    }

    @Override
    public long getFreeMemorySize() {
        Kernel32 kernel32;
        if (NativeUtils.USE_JNA && (kernel32 = Kernel32.INSTANCE) != null) {
            WinTypes.MEMORYSTATUSEX status = new WinTypes.MEMORYSTATUSEX();
            if (kernel32.GlobalMemoryStatusEx(status)) {
                return status.ullAvailPhys;
            }
            Logger.LOG.warning("Failed to get memory status: " + kernel32.GetLastError());
        }
        return super.getFreeMemorySize();
    }
}

