/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.EventHandler;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.util.Duration;
import org.jackhuang.hmcl.util.Holder;

final class ScrollUtils {
    private static final double[] FRICTIONS = new double[]{0.99, 0.1, 0.05, 0.04, 0.03, 0.02, 0.01, 0.04, 0.01, 0.008, 0.008, 0.008, 0.008, 6.0E-4, 5.0E-4, 3.0E-5, 1.0E-5};
    private static final Duration DURATION = Duration.millis((double)3.0);

    private ScrollUtils() {
    }

    public static boolean isTrackPad(ScrollEvent event, ScrollDirection scrollDirection) {
        switch (scrollDirection.ordinal()) {
            case 0: 
            case 2: {
                return Math.abs(event.getDeltaY()) < 10.0;
            }
            case 1: 
            case 3: {
                return Math.abs(event.getDeltaX()) < 10.0;
            }
        }
        return false;
    }

    public static ScrollDirection determineScrollDirection(ScrollEvent event) {
        double deltaX = event.getDeltaX();
        double deltaY = event.getDeltaY();
        if (deltaY == 0.0) {
            return deltaX < 0.0 ? ScrollDirection.LEFT : ScrollDirection.RIGHT;
        }
        return deltaY < 0.0 ? ScrollDirection.DOWN : ScrollDirection.UP;
    }

    public static void addSmoothScrolling(ScrollPane scrollPane) {
        ScrollUtils.addSmoothScrolling(scrollPane, 1.0);
    }

    public static void addSmoothScrolling(ScrollPane scrollPane, double speed) {
        ScrollUtils.addSmoothScrolling(scrollPane, speed, 7.0);
    }

    public static void addSmoothScrolling(ScrollPane scrollPane, double speed, double trackPadAdjustment) {
        ScrollUtils.smoothScroll(scrollPane, speed, trackPadAdjustment);
    }

    public static void addSmoothScrolling(VirtualFlow<?> virtualFlow) {
        ScrollUtils.addSmoothScrolling(virtualFlow, 1.0);
    }

    public static void addSmoothScrolling(VirtualFlow<?> virtualFlow, double speed) {
        ScrollUtils.addSmoothScrolling(virtualFlow, speed, 7.0);
    }

    public static void addSmoothScrolling(VirtualFlow<?> virtualFlow, double speed, double trackPadAdjustment) {
        ScrollUtils.smoothScroll(virtualFlow, speed, trackPadAdjustment);
    }

    private static void smoothScroll(ScrollPane scrollPane, double speed, double trackPadAdjustment) {
        double[] derivatives = new double[FRICTIONS.length];
        Timeline timeline = new Timeline();
        Holder scrollDirectionHolder = new Holder();
        EventHandler mouseHandler = event -> timeline.stop();
        EventHandler scrollHandler = event -> {
            if (event.getEventType() == ScrollEvent.SCROLL) {
                ScrollDirection scrollDirection = ScrollUtils.determineScrollDirection(event);
                scrollDirectionHolder.value = scrollDirection;
                double currentSpeed = ScrollUtils.isTrackPad(event, scrollDirection) ? speed / trackPadAdjustment : speed;
                derivatives[0] = derivatives[0] + (double)scrollDirection.intDirection * currentSpeed;
                if (timeline.getStatus() == Animation.Status.STOPPED) {
                    timeline.play();
                }
                event.consume();
            }
        };
        if (scrollPane.getContent().getParent() != null) {
            scrollPane.getContent().getParent().addEventHandler(MouseEvent.MOUSE_PRESSED, mouseHandler);
            scrollPane.getContent().getParent().addEventHandler(ScrollEvent.ANY, scrollHandler);
        }
        scrollPane.getContent().parentProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.removeEventHandler(MouseEvent.MOUSE_PRESSED, mouseHandler);
                oldValue.removeEventHandler(ScrollEvent.ANY, scrollHandler);
            }
            if (newValue != null) {
                newValue.addEventHandler(MouseEvent.MOUSE_PRESSED, mouseHandler);
                newValue.addEventHandler(ScrollEvent.ANY, scrollHandler);
            }
        });
        timeline.getKeyFrames().add((Object)new KeyFrame(DURATION, event -> {
            int i;
            for (i = 0; i < derivatives.length; ++i) {
                int n = i;
                derivatives[n] = derivatives[n] * FRICTIONS[i];
            }
            for (i = 1; i < derivatives.length; ++i) {
                int n = i;
                derivatives[n] = derivatives[n] + derivatives[i - 1];
            }
            double dy = derivatives[derivatives.length - 1];
            switch (((ScrollDirection)((Object)((Object)scrollDirectionHolder.value))).ordinal()) {
                case 1: 
                case 3: {
                    double size = scrollPane.getContent().getLayoutBounds().getWidth();
                    scrollPane.setHvalue(Math.min(Math.max(scrollPane.getHvalue() + dy / size, 0.0), 1.0));
                    break;
                }
                case 0: 
                case 2: {
                    double size = scrollPane.getContent().getLayoutBounds().getHeight();
                    scrollPane.setVvalue(Math.min(Math.max(scrollPane.getVvalue() + dy / size, 0.0), 1.0));
                }
            }
            if (Math.abs(dy) < 0.001) {
                timeline.stop();
            }
        }, new KeyValue[0]));
        timeline.setCycleCount(-1);
    }

    private static void smoothScroll(VirtualFlow<?> virtualFlow, double speed, double trackPadAdjustment) {
        if (!virtualFlow.isVertical()) {
            return;
        }
        double[] derivatives = new double[FRICTIONS.length];
        Timeline timeline = new Timeline();
        Holder scrollDirectionHolder = new Holder();
        EventHandler mouseHandler = event -> timeline.stop();
        EventHandler scrollHandler = event -> {
            if (event.getEventType() == ScrollEvent.SCROLL) {
                ScrollDirection scrollDirection = ScrollUtils.determineScrollDirection(event);
                if (scrollDirection == ScrollDirection.LEFT || scrollDirection == ScrollDirection.RIGHT) {
                    return;
                }
                scrollDirectionHolder.value = scrollDirection;
                double currentSpeed = ScrollUtils.isTrackPad(event, scrollDirection) ? speed / trackPadAdjustment : speed;
                derivatives[0] = derivatives[0] + (double)scrollDirection.intDirection * currentSpeed;
                if (timeline.getStatus() == Animation.Status.STOPPED) {
                    timeline.play();
                }
                event.consume();
            }
        };
        virtualFlow.addEventHandler(MouseEvent.MOUSE_PRESSED, mouseHandler);
        virtualFlow.addEventFilter(ScrollEvent.ANY, scrollHandler);
        timeline.getKeyFrames().add((Object)new KeyFrame(DURATION, event -> {
            double height;
            int i;
            for (i = 0; i < derivatives.length; ++i) {
                int n = i;
                derivatives[n] = derivatives[n] * FRICTIONS[i];
            }
            for (i = 1; i < derivatives.length; ++i) {
                int n = i;
                derivatives[n] = derivatives[n] + derivatives[i - 1];
            }
            double dy = derivatives[derivatives.length - 1];
            int cellCount = virtualFlow.getCellCount();
            IndexedCell firstVisibleCell = virtualFlow.getFirstVisibleCell();
            double d = height = firstVisibleCell != null ? firstVisibleCell.getHeight() * (double)cellCount : 0.0;
            double delta = height > 0.0 ? dy / height : (scrollDirectionHolder.value == ScrollDirection.DOWN ? 0.001 : -0.001);
            virtualFlow.setPosition(Math.min(Math.max(virtualFlow.getPosition() + delta, 0.0), 1.0));
            if (Math.abs(dy) < 0.001) {
                timeline.stop();
            }
        }, new KeyValue[0]));
        timeline.setCycleCount(-1);
    }

    public static enum ScrollDirection {
        UP(-1),
        RIGHT(-1),
        DOWN(1),
        LEFT(1);

        final int intDirection;

        private ScrollDirection(int intDirection) {
            this.intDirection = intDirection;
        }

        public int intDirection() {
            return this.intDirection;
        }
    }
}

