# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: billingconductor
using AWS.Compat
using AWS.UUIDs

"""
    associate_accounts(account_ids, arn)
    associate_accounts(account_ids, arn, params::Dict{String,<:Any})

Connects an array of account IDs in a consolidated billing family to a predefined billing
group. The account IDs must be a part of the consolidated billing family during the current
month, and not already associated with another billing group. The maximum number of
accounts that can be associated in one call is 30.

# Arguments
- `account_ids`:  The associating array of account IDs.
- `arn`:  The Amazon Resource Name (ARN) of the billing group that associates the array of
  account IDs.

"""
function associate_accounts(
    AccountIds, Arn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/associate-accounts",
        Dict{String,Any}("AccountIds" => AccountIds, "Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_accounts(
    AccountIds,
    Arn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return billingconductor(
        "POST",
        "/associate-accounts",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("AccountIds" => AccountIds, "Arn" => Arn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_pricing_rules(arn, pricing_rule_arns)
    associate_pricing_rules(arn, pricing_rule_arns, params::Dict{String,<:Any})

Connects an array of PricingRuleArns to a defined PricingPlan. The maximum number
PricingRuleArn that can be associated in one call is 30.

# Arguments
- `arn`:  The PricingPlanArn that the PricingRuleArns are associated with.
- `pricing_rule_arns`:  The PricingRuleArns that are associated with the Pricing Plan.

"""
function associate_pricing_rules(
    Arn, PricingRuleArns; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "PUT",
        "/associate-pricing-rules",
        Dict{String,Any}("Arn" => Arn, "PricingRuleArns" => PricingRuleArns);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_pricing_rules(
    Arn,
    PricingRuleArns,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return billingconductor(
        "PUT",
        "/associate-pricing-rules",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Arn" => Arn, "PricingRuleArns" => PricingRuleArns),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_associate_resources_to_custom_line_item(resource_arns, target_arn)
    batch_associate_resources_to_custom_line_item(resource_arns, target_arn, params::Dict{String,<:Any})

 Associates a batch of resources to a percentage custom line item.

# Arguments
- `resource_arns`:  A list containing the ARNs of the resources to be associated.
- `target_arn`:  A percentage custom line item ARN to associate the resources to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BillingPeriodRange"`:
"""
function batch_associate_resources_to_custom_line_item(
    ResourceArns, TargetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "PUT",
        "/batch-associate-resources-to-custom-line-item",
        Dict{String,Any}("ResourceArns" => ResourceArns, "TargetArn" => TargetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_associate_resources_to_custom_line_item(
    ResourceArns,
    TargetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return billingconductor(
        "PUT",
        "/batch-associate-resources-to-custom-line-item",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArns" => ResourceArns, "TargetArn" => TargetArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_disassociate_resources_from_custom_line_item(resource_arns, target_arn)
    batch_disassociate_resources_from_custom_line_item(resource_arns, target_arn, params::Dict{String,<:Any})

 Disassociates a batch of resources from a percentage custom line item.

# Arguments
- `resource_arns`:  A list containing the ARNs of resources to be disassociated.
- `target_arn`:  A percentage custom line item ARN to disassociate the resources from.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BillingPeriodRange"`:
"""
function batch_disassociate_resources_from_custom_line_item(
    ResourceArns, TargetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "PUT",
        "/batch-disassociate-resources-from-custom-line-item",
        Dict{String,Any}("ResourceArns" => ResourceArns, "TargetArn" => TargetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_disassociate_resources_from_custom_line_item(
    ResourceArns,
    TargetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return billingconductor(
        "PUT",
        "/batch-disassociate-resources-from-custom-line-item",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArns" => ResourceArns, "TargetArn" => TargetArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_billing_group(account_grouping, computation_preference, name)
    create_billing_group(account_grouping, computation_preference, name, params::Dict{String,<:Any})

 Creates a billing group that resembles a consolidated billing family that Amazon Web
Services charges, based off of the predefined pricing plan computation.

# Arguments
- `account_grouping`:  The set of accounts that will be under the billing group. The set of
  accounts resemble the linked accounts in a consolidated billing family.
- `computation_preference`:  The preferences and settings that will be used to compute the
  Amazon Web Services charges for a billing group.
- `name`:  The billing group name. The names must be unique.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: The description of the billing group.
- `"PrimaryAccountId"`:  The account ID that serves as the main account in a billing group.
- `"Tags"`:  A map that contains tag keys and tag values that are attached to a billing
  group. This feature isn't available during the beta.
- `"X-Amzn-Client-Token"`:  The token that is needed to support idempotency. Idempotency
  isn't currently supported, but will be implemented in a future update.
"""
function create_billing_group(
    AccountGrouping,
    ComputationPreference,
    Name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return billingconductor(
        "POST",
        "/create-billing-group",
        Dict{String,Any}(
            "AccountGrouping" => AccountGrouping,
            "ComputationPreference" => ComputationPreference,
            "Name" => Name,
            "X-Amzn-Client-Token" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_billing_group(
    AccountGrouping,
    ComputationPreference,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return billingconductor(
        "POST",
        "/create-billing-group",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountGrouping" => AccountGrouping,
                    "ComputationPreference" => ComputationPreference,
                    "Name" => Name,
                    "X-Amzn-Client-Token" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_custom_line_item(billing_group_arn, charge_details, description, name)
    create_custom_line_item(billing_group_arn, charge_details, description, name, params::Dict{String,<:Any})

Creates a custom line item that can be used to create a one-time fixed charge that can be
applied to a single billing group for the current or previous billing period. The one-time
fixed charge is either a fee or discount.

# Arguments
- `billing_group_arn`:  The Amazon Resource Name (ARN) that references the billing group
  where the custom line item applies to.
- `charge_details`:  A CustomLineItemChargeDetails that describes the charge details for a
  custom line item.
- `description`:  The description of the custom line item. This is shown on the Bills page
  in association with the charge value.
- `name`:  The name of the custom line item.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccountId"`: The Amazon Web Services account in which this custom line item will be
  applied to.
- `"BillingPeriodRange"`:  A time range for which the custom line item is effective.
- `"Tags"`:  A map that contains tag keys and tag values that are attached to a custom line
  item.
- `"X-Amzn-Client-Token"`:  The token that is needed to support idempotency. Idempotency
  isn't currently supported, but will be implemented in a future update.
"""
function create_custom_line_item(
    BillingGroupArn,
    ChargeDetails,
    Description,
    Name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return billingconductor(
        "POST",
        "/create-custom-line-item",
        Dict{String,Any}(
            "BillingGroupArn" => BillingGroupArn,
            "ChargeDetails" => ChargeDetails,
            "Description" => Description,
            "Name" => Name,
            "X-Amzn-Client-Token" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_custom_line_item(
    BillingGroupArn,
    ChargeDetails,
    Description,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return billingconductor(
        "POST",
        "/create-custom-line-item",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "BillingGroupArn" => BillingGroupArn,
                    "ChargeDetails" => ChargeDetails,
                    "Description" => Description,
                    "Name" => Name,
                    "X-Amzn-Client-Token" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_pricing_plan(name)
    create_pricing_plan(name, params::Dict{String,<:Any})

Creates a pricing plan that is used for computing Amazon Web Services charges for billing
groups.

# Arguments
- `name`: The name of the pricing plan. The names must be unique to each pricing plan.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: The description of the pricing plan.
- `"PricingRuleArns"`:  A list of Amazon Resource Names (ARNs) that define the pricing plan
  parameters.
- `"Tags"`:  A map that contains tag keys and tag values that are attached to a pricing
  plan.
- `"X-Amzn-Client-Token"`:  The token that is needed to support idempotency. Idempotency
  isn't currently supported, but will be implemented in a future update.
"""
function create_pricing_plan(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return billingconductor(
        "POST",
        "/create-pricing-plan",
        Dict{String,Any}("Name" => Name, "X-Amzn-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_pricing_plan(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/create-pricing-plan",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Name" => Name, "X-Amzn-Client-Token" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_pricing_rule(name, scope, type)
    create_pricing_rule(name, scope, type, params::Dict{String,<:Any})

 Creates a pricing rule can be associated to a pricing plan, or a set of pricing plans.

# Arguments
- `name`:  The pricing rule name. The names must be unique to each pricing rule.
- `scope`:  The scope of pricing rule that indicates if it's globally applicable, or it's
  service-specific.
- `type`:  The type of pricing rule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BillingEntity"`:  The seller of services provided by Amazon Web Services, their
  affiliates, or third-party providers selling services via Amazon Web Services Marketplace.
- `"Description"`:  The pricing rule description.
- `"ModifierPercentage"`:  A percentage modifier that's applied on the public pricing
  rates.
- `"Operation"`:  Operation is the specific Amazon Web Services action covered by this line
  item. This describes the specific usage of the line item.  If the Scope attribute is set to
  SKU, this attribute indicates which operation the PricingRule is modifying. For example, a
  value of RunInstances:0202 indicates the operation of running an Amazon EC2 instance.
- `"Service"`:  If the Scope attribute is set to SERVICE or SKU, the attribute indicates
  which service the PricingRule is applicable for.
- `"Tags"`:  A map that contains tag keys and tag values that are attached to a pricing
  rule.
- `"Tiering"`:  The set of tiering configurations for the pricing rule.
- `"UsageType"`:  Usage type is the unit that each service uses to measure the usage of a
  specific type of resource. If the Scope attribute is set to SKU, this attribute indicates
  which usage type the PricingRule is modifying. For example, USW2-BoxUsage:m2.2xlarge
  describes an M2 High Memory Double Extra Large instance in the US West (Oregon) Region.
  &lt;/p&gt;
- `"X-Amzn-Client-Token"`:  The token that's needed to support idempotency. Idempotency
  isn't currently supported, but will be implemented in a future update.
"""
function create_pricing_rule(
    Name, Scope, Type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/create-pricing-rule",
        Dict{String,Any}(
            "Name" => Name,
            "Scope" => Scope,
            "Type" => Type,
            "X-Amzn-Client-Token" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_pricing_rule(
    Name,
    Scope,
    Type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return billingconductor(
        "POST",
        "/create-pricing-rule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Name" => Name,
                    "Scope" => Scope,
                    "Type" => Type,
                    "X-Amzn-Client-Token" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_billing_group(arn)
    delete_billing_group(arn, params::Dict{String,<:Any})

 Deletes a billing group.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the billing group that you're deleting.

"""
function delete_billing_group(Arn; aws_config::AbstractAWSConfig=current_aws_config())
    return billingconductor(
        "POST",
        "/delete-billing-group",
        Dict{String,Any}("Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_billing_group(
    Arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/delete-billing-group",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Arn" => Arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_custom_line_item(arn)
    delete_custom_line_item(arn, params::Dict{String,<:Any})

 Deletes the custom line item identified by the given ARN in the current, or previous
billing period.

# Arguments
- `arn`:  The ARN of the custom line item to be deleted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BillingPeriodRange"`:
"""
function delete_custom_line_item(Arn; aws_config::AbstractAWSConfig=current_aws_config())
    return billingconductor(
        "POST",
        "/delete-custom-line-item",
        Dict{String,Any}("Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_custom_line_item(
    Arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/delete-custom-line-item",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Arn" => Arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_pricing_plan(arn)
    delete_pricing_plan(arn, params::Dict{String,<:Any})

Deletes a pricing plan. The pricing plan must not be associated with any billing groups to
delete successfully.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the pricing plan that you're deleting.

"""
function delete_pricing_plan(Arn; aws_config::AbstractAWSConfig=current_aws_config())
    return billingconductor(
        "POST",
        "/delete-pricing-plan",
        Dict{String,Any}("Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_pricing_plan(
    Arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/delete-pricing-plan",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Arn" => Arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_pricing_rule(arn)
    delete_pricing_rule(arn, params::Dict{String,<:Any})

 Deletes the pricing rule that's identified by the input Amazon Resource Name (ARN).

# Arguments
- `arn`:  The Amazon Resource Name (ARN) of the pricing rule that you are deleting.

"""
function delete_pricing_rule(Arn; aws_config::AbstractAWSConfig=current_aws_config())
    return billingconductor(
        "POST",
        "/delete-pricing-rule",
        Dict{String,Any}("Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_pricing_rule(
    Arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/delete-pricing-rule",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Arn" => Arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_accounts(account_ids, arn)
    disassociate_accounts(account_ids, arn, params::Dict{String,<:Any})

Removes the specified list of account IDs from the given billing group.

# Arguments
- `account_ids`: The array of account IDs to disassociate.
- `arn`: The Amazon Resource Name (ARN) of the billing group that the array of account IDs
  will disassociate from.

"""
function disassociate_accounts(
    AccountIds, Arn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/disassociate-accounts",
        Dict{String,Any}("AccountIds" => AccountIds, "Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_accounts(
    AccountIds,
    Arn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return billingconductor(
        "POST",
        "/disassociate-accounts",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("AccountIds" => AccountIds, "Arn" => Arn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_pricing_rules(arn, pricing_rule_arns)
    disassociate_pricing_rules(arn, pricing_rule_arns, params::Dict{String,<:Any})

 Disassociates a list of pricing rules from a pricing plan.

# Arguments
- `arn`:  The pricing plan Amazon Resource Name (ARN) to disassociate pricing rules from.
- `pricing_rule_arns`:  A list containing the Amazon Resource Name (ARN) of the pricing
  rules that will be disassociated.

"""
function disassociate_pricing_rules(
    Arn, PricingRuleArns; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "PUT",
        "/disassociate-pricing-rules",
        Dict{String,Any}("Arn" => Arn, "PricingRuleArns" => PricingRuleArns);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_pricing_rules(
    Arn,
    PricingRuleArns,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return billingconductor(
        "PUT",
        "/disassociate-pricing-rules",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Arn" => Arn, "PricingRuleArns" => PricingRuleArns),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_billing_group_cost_report(arn)
    get_billing_group_cost_report(arn, params::Dict{String,<:Any})

Retrieves the margin summary report, which includes the Amazon Web Services cost and
charged amount (pro forma cost) by Amazon Web Service for a specific billing group.

# Arguments
- `arn`: The Amazon Resource Number (ARN) that uniquely identifies the billing group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BillingPeriodRange"`: A time range for which the margin summary is effective. You can
  specify up to 12 months.
- `"GroupBy"`: A list of strings that specify the attributes that are used to break down
  costs in the margin summary reports for the billing group. For example, you can view your
  costs by the Amazon Web Service name or the billing period.
- `"MaxResults"`: The maximum number of margin summary reports to retrieve.
- `"NextToken"`: The pagination token used on subsequent calls to get reports.
"""
function get_billing_group_cost_report(
    Arn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/get-billing-group-cost-report",
        Dict{String,Any}("Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_billing_group_cost_report(
    Arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/get-billing-group-cost-report",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Arn" => Arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_account_associations()
    list_account_associations(params::Dict{String,<:Any})

 This is a paginated call to list linked accounts that are linked to the payer account for
the specified time period. If no information is provided, the current billing period is
used. The response will optionally include the billing group that's associated with the
linked account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BillingPeriod"`:  The preferred billing period to get account associations.
- `"Filters"`: The filter on the account ID of the linked account, or any of the following:
   MONITORED: linked accounts that are associated to billing groups.  UNMONITORED: linked
  accounts that aren't associated to billing groups.  Billing Group Arn: linked accounts that
  are associated to the provided billing group Arn.
- `"NextToken"`:  The pagination token that's used on subsequent calls to retrieve
  accounts.
"""
function list_account_associations(; aws_config::AbstractAWSConfig=current_aws_config())
    return billingconductor(
        "POST",
        "/list-account-associations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_account_associations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/list-account-associations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_billing_group_cost_reports()
    list_billing_group_cost_reports(params::Dict{String,<:Any})

A paginated call to retrieve a summary report of actual Amazon Web Services charges and the
calculated Amazon Web Services charges based on the associated pricing plan of a billing
group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BillingPeriod"`: The preferred billing period for your report.
- `"Filters"`: A ListBillingGroupCostReportsFilter to specify billing groups to retrieve
  reports from.
- `"MaxResults"`: The maximum number of reports to retrieve.
- `"NextToken"`: The pagination token that's used on subsequent calls to get reports.
"""
function list_billing_group_cost_reports(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/list-billing-group-cost-reports";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_billing_group_cost_reports(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/list-billing-group-cost-reports",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_billing_groups()
    list_billing_groups(params::Dict{String,<:Any})

A paginated call to retrieve a list of billing groups for the given billing period. If you
don't provide a billing group, the current billing period is used.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BillingPeriod"`: The preferred billing period to get billing groups.
- `"Filters"`: A ListBillingGroupsFilter that specifies the billing group and pricing plan
  to retrieve billing group information.
- `"MaxResults"`: The maximum number of billing groups to retrieve.
- `"NextToken"`: The pagination token that's used on subsequent calls to get billing
  groups.
"""
function list_billing_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return billingconductor(
        "POST",
        "/list-billing-groups";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_billing_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/list-billing-groups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_custom_line_item_versions(arn)
    list_custom_line_item_versions(arn, params::Dict{String,<:Any})

A paginated call to get a list of all custom line item versions.

# Arguments
- `arn`: The Amazon Resource Name (ARN) for the custom line item.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: A ListCustomLineItemVersionsFilter that specifies the billing period range
  in which the custom line item versions are applied.
- `"MaxResults"`: The maximum number of custom line item versions to retrieve.
- `"NextToken"`: The pagination token that's used on subsequent calls to retrieve custom
  line item versions.
"""
function list_custom_line_item_versions(
    Arn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/list-custom-line-item-versions",
        Dict{String,Any}("Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_custom_line_item_versions(
    Arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/list-custom-line-item-versions",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Arn" => Arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_custom_line_items()
    list_custom_line_items(params::Dict{String,<:Any})

 A paginated call to get a list of all custom line items (FFLIs) for the given billing
period. If you don't provide a billing period, the current billing period is used.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BillingPeriod"`:  The preferred billing period to get custom line items (FFLIs).
- `"Filters"`: A ListCustomLineItemsFilter that specifies the custom line item names and/or
  billing group Amazon Resource Names (ARNs) to retrieve FFLI information.
- `"MaxResults"`:  The maximum number of billing groups to retrieve.
- `"NextToken"`:  The pagination token that's used on subsequent calls to get custom line
  items (FFLIs).
"""
function list_custom_line_items(; aws_config::AbstractAWSConfig=current_aws_config())
    return billingconductor(
        "POST",
        "/list-custom-line-items";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_custom_line_items(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/list-custom-line-items",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_pricing_plans()
    list_pricing_plans(params::Dict{String,<:Any})

A paginated call to get pricing plans for the given billing period. If you don't provide a
billing period, the current billing period is used.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BillingPeriod"`: The preferred billing period to get pricing plan.
- `"Filters"`: A ListPricingPlansFilter that specifies the Amazon Resource Name (ARNs) of
  pricing plans to retrieve pricing plans information.
- `"MaxResults"`: The maximum number of pricing plans to retrieve.
- `"NextToken"`: The pagination token that's used on subsequent call to get pricing plans.
"""
function list_pricing_plans(; aws_config::AbstractAWSConfig=current_aws_config())
    return billingconductor(
        "POST",
        "/list-pricing-plans";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_pricing_plans(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/list-pricing-plans",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_pricing_plans_associated_with_pricing_rule(pricing_rule_arn)
    list_pricing_plans_associated_with_pricing_rule(pricing_rule_arn, params::Dict{String,<:Any})

 A list of the pricing plans that are associated with a pricing rule.

# Arguments
- `pricing_rule_arn`:  The pricing rule Amazon Resource Name (ARN) for which associations
  will be listed.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BillingPeriod"`:  The pricing plan billing period for which associations will be
  listed.
- `"MaxResults"`:  The optional maximum number of pricing rule associations to retrieve.
- `"NextToken"`:  The optional pagination token returned by a previous call.
"""
function list_pricing_plans_associated_with_pricing_rule(
    PricingRuleArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/list-pricing-plans-associated-with-pricing-rule",
        Dict{String,Any}("PricingRuleArn" => PricingRuleArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_pricing_plans_associated_with_pricing_rule(
    PricingRuleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return billingconductor(
        "POST",
        "/list-pricing-plans-associated-with-pricing-rule",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PricingRuleArn" => PricingRuleArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_pricing_rules()
    list_pricing_rules(params::Dict{String,<:Any})

 Describes a pricing rule that can be associated to a pricing plan, or set of pricing
plans.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BillingPeriod"`:  The preferred billing period to get the pricing plan.
- `"Filters"`:  A DescribePricingRuleFilter that specifies the Amazon Resource Name (ARNs)
  of pricing rules to retrieve pricing rules information.
- `"MaxResults"`:  The maximum number of pricing rules to retrieve.
- `"NextToken"`:  The pagination token that's used on subsequent call to get pricing rules.
"""
function list_pricing_rules(; aws_config::AbstractAWSConfig=current_aws_config())
    return billingconductor(
        "POST",
        "/list-pricing-rules";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_pricing_rules(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/list-pricing-rules",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_pricing_rules_associated_to_pricing_plan(pricing_plan_arn)
    list_pricing_rules_associated_to_pricing_plan(pricing_plan_arn, params::Dict{String,<:Any})

 Lists the pricing rules that are associated with a pricing plan.

# Arguments
- `pricing_plan_arn`:  The Amazon Resource Name (ARN) of the pricing plan for which
  associations are to be listed.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BillingPeriod"`:  The billing period for which the pricing rule associations are to be
  listed.
- `"MaxResults"`: The optional maximum number of pricing rule associations to retrieve.
- `"NextToken"`:  The optional pagination token returned by a previous call.
"""
function list_pricing_rules_associated_to_pricing_plan(
    PricingPlanArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/list-pricing-rules-associated-to-pricing-plan",
        Dict{String,Any}("PricingPlanArn" => PricingPlanArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_pricing_rules_associated_to_pricing_plan(
    PricingPlanArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return billingconductor(
        "POST",
        "/list-pricing-rules-associated-to-pricing-plan",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PricingPlanArn" => PricingPlanArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_resources_associated_to_custom_line_item(arn)
    list_resources_associated_to_custom_line_item(arn, params::Dict{String,<:Any})

 List the resources that are associated to a custom line item.

# Arguments
- `arn`:  The ARN of the custom line item for which the resource associations will be
  listed.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BillingPeriod"`:  The billing period for which the resource associations will be
  listed.
- `"Filters"`:  (Optional) A ListResourcesAssociatedToCustomLineItemFilter that can specify
  the types of resources that should be retrieved.
- `"MaxResults"`:  (Optional) The maximum number of resource associations to be retrieved.
- `"NextToken"`:  (Optional) The pagination token that's returned by a previous request.
"""
function list_resources_associated_to_custom_line_item(
    Arn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/list-resources-associated-to-custom-line-item",
        Dict{String,Any}("Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_resources_associated_to_custom_line_item(
    Arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/list-resources-associated-to-custom-line-item",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Arn" => Arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

 A list the tags for a resource.

# Arguments
- `resource_arn`:  The Amazon Resource Name (ARN) that identifies the resource to list the
  tags.

"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "GET",
        "/tags/$(ResourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return billingconductor(
        "GET",
        "/tags/$(ResourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

 Associates the specified tags to a resource with the specified resourceArn. If existing
tags on a resource are not specified in the request parameters, they are not changed.

# Arguments
- `resource_arn`:  The Amazon Resource Name (ARN) of the resource to which to add tags.
- `tags`:  The tags to add to the resource as a list of key-value pairs.

"""
function tag_resource(ResourceArn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return billingconductor(
        "POST",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return billingconductor(
        "POST",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Tags" => Tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

 Deletes specified tags from a resource.

# Arguments
- `resource_arn`:  The Amazon Resource Name (ARN) of the resource to which to delete tags.
- `tag_keys`:  The tags to delete from the resource as a list of key-value pairs.

"""
function untag_resource(
    ResourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return billingconductor(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_billing_group(arn)
    update_billing_group(arn, params::Dict{String,<:Any})

This updates an existing billing group.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the billing group being updated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccountGrouping"`: Specifies if the billing group has automatic account association
  (AutoAssociate) enabled.
- `"ComputationPreference"`:  The preferences and settings that will be used to compute the
  Amazon Web Services charges for a billing group.
- `"Description"`: A description of the billing group.
- `"Name"`: The name of the billing group. The names must be unique to each billing group.
- `"Status"`: The status of the billing group. Only one of the valid values can be used.
"""
function update_billing_group(Arn; aws_config::AbstractAWSConfig=current_aws_config())
    return billingconductor(
        "POST",
        "/update-billing-group",
        Dict{String,Any}("Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_billing_group(
    Arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/update-billing-group",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Arn" => Arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_custom_line_item(arn)
    update_custom_line_item(arn, params::Dict{String,<:Any})

 Update an existing custom line item in the current or previous billing period.

# Arguments
- `arn`:  The ARN of the custom line item to be updated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BillingPeriodRange"`:
- `"ChargeDetails"`:  A ListCustomLineItemChargeDetails containing the new charge details
  for the custom line item.
- `"Description"`:  The new line item description of the custom line item.
- `"Name"`:  The new name for the custom line item.
"""
function update_custom_line_item(Arn; aws_config::AbstractAWSConfig=current_aws_config())
    return billingconductor(
        "POST",
        "/update-custom-line-item",
        Dict{String,Any}("Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_custom_line_item(
    Arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "POST",
        "/update-custom-line-item",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Arn" => Arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_pricing_plan(arn)
    update_pricing_plan(arn, params::Dict{String,<:Any})

This updates an existing pricing plan.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the pricing plan that you're updating.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: The description of the pricing plan.
- `"Name"`: The name of the pricing plan. The name must be unique to each pricing plan.
"""
function update_pricing_plan(Arn; aws_config::AbstractAWSConfig=current_aws_config())
    return billingconductor(
        "PUT",
        "/update-pricing-plan",
        Dict{String,Any}("Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_pricing_plan(
    Arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "PUT",
        "/update-pricing-plan",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Arn" => Arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_pricing_rule(arn)
    update_pricing_rule(arn, params::Dict{String,<:Any})

 Updates an existing pricing rule.

# Arguments
- `arn`:  The Amazon Resource Name (ARN) of the pricing rule to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`:  The new description for the pricing rule.
- `"ModifierPercentage"`:  The new modifier to show pricing plan rates as a percentage.
- `"Name"`:  The new name of the pricing rule. The name must be unique to each pricing
  rule.
- `"Tiering"`:  The set of tiering configurations for the pricing rule.
- `"Type"`:  The new pricing rule type.
"""
function update_pricing_rule(Arn; aws_config::AbstractAWSConfig=current_aws_config())
    return billingconductor(
        "PUT",
        "/update-pricing-rule",
        Dict{String,Any}("Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_pricing_rule(
    Arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return billingconductor(
        "PUT",
        "/update-pricing-rule",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Arn" => Arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
