# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: managedblockchain_query
using AWS.Compat
using AWS.UUIDs

"""
    batch_get_token_balance()
    batch_get_token_balance(params::Dict{String,<:Any})

Gets the token balance for a batch of tokens by using the BatchGetTokenBalance action for
every token in the request.  Only the native tokens BTC and ETH, and the ERC-20, ERC-721,
and ERC 1155 token standards are supported.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"getTokenBalanceInputs"`: An array of BatchGetTokenBalanceInputItem objects whose
  balance is being requested.
"""
function batch_get_token_balance(; aws_config::AbstractAWSConfig=current_aws_config())
    return managedblockchain_query(
        "POST",
        "/batch-get-token-balance";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_get_token_balance(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return managedblockchain_query(
        "POST",
        "/batch-get-token-balance",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_asset_contract(contract_identifier)
    get_asset_contract(contract_identifier, params::Dict{String,<:Any})

Gets the information about a specific contract deployed on the blockchain.    The Bitcoin
blockchain networks do not support this operation.   Metadata is currently only available
for some ERC-20 contracts. Metadata will be available for additional contracts in the
future.

# Arguments
- `contract_identifier`: Contains the blockchain address and network information about the
  contract.

"""
function get_asset_contract(
    contractIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return managedblockchain_query(
        "POST",
        "/get-asset-contract",
        Dict{String,Any}("contractIdentifier" => contractIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_asset_contract(
    contractIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return managedblockchain_query(
        "POST",
        "/get-asset-contract",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("contractIdentifier" => contractIdentifier), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_token_balance(owner_identifier, token_identifier)
    get_token_balance(owner_identifier, token_identifier, params::Dict{String,<:Any})

Gets the balance of a specific token, including native tokens, for a given address (wallet
or contract) on the blockchain.  Only the native tokens BTC and ETH, and the ERC-20,
ERC-721, and ERC 1155 token standards are supported.

# Arguments
- `owner_identifier`: The container for the identifier for the owner.
- `token_identifier`: The container for the identifier for the token, including the unique
  token ID and its blockchain network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"atBlockchainInstant"`: The time for when the TokenBalance is requested or the current
  time if a time is not provided in the request.  This time will only be recorded up to the
  second.
"""
function get_token_balance(
    ownerIdentifier, tokenIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return managedblockchain_query(
        "POST",
        "/get-token-balance",
        Dict{String,Any}(
            "ownerIdentifier" => ownerIdentifier, "tokenIdentifier" => tokenIdentifier
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_token_balance(
    ownerIdentifier,
    tokenIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return managedblockchain_query(
        "POST",
        "/get-token-balance",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ownerIdentifier" => ownerIdentifier,
                    "tokenIdentifier" => tokenIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_transaction(network)
    get_transaction(network, params::Dict{String,<:Any})

Gets the details of a transaction.  This action will return transaction details for all
transactions that are confirmed on the blockchain, even if they have not reached finality.

# Arguments
- `network`: The blockchain network where the transaction occurred.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"transactionHash"`: The hash of a transaction. It is generated when a transaction is
  created.
- `"transactionId"`: The identifier of a Bitcoin transaction. It is generated when a
  transaction is created.   transactionId is only supported on the Bitcoin networks.
"""
function get_transaction(network; aws_config::AbstractAWSConfig=current_aws_config())
    return managedblockchain_query(
        "POST",
        "/get-transaction",
        Dict{String,Any}("network" => network);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_transaction(
    network,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return managedblockchain_query(
        "POST",
        "/get-transaction",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("network" => network), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_asset_contracts(contract_filter)
    list_asset_contracts(contract_filter, params::Dict{String,<:Any})

Lists all the contracts for a given contract type deployed by an address (either a contract
address or a wallet address). The Bitcoin blockchain networks do not support this operation.

# Arguments
- `contract_filter`: Contains the filter parameter for the request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of contracts to list. Default: 100   Even if
  additional results can be retrieved, the request can return less results than maxResults or
  an empty array of results. To retrieve the next set of results, make another request with
  the returned nextToken value. The value of nextToken is null when there are no more results
  to return
- `"nextToken"`:  The pagination token that indicates the next set of results to retrieve.
"""
function list_asset_contracts(
    contractFilter; aws_config::AbstractAWSConfig=current_aws_config()
)
    return managedblockchain_query(
        "POST",
        "/list-asset-contracts",
        Dict{String,Any}("contractFilter" => contractFilter);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_asset_contracts(
    contractFilter,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return managedblockchain_query(
        "POST",
        "/list-asset-contracts",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("contractFilter" => contractFilter), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_filtered_transaction_events(address_identifier_filter, network)
    list_filtered_transaction_events(address_identifier_filter, network, params::Dict{String,<:Any})

Lists all the transaction events for an address on the blockchain.  This operation is only
supported on the Bitcoin networks.

# Arguments
- `address_identifier_filter`: This is the unique public address on the blockchain for
  which the transaction events are being requested.
- `network`: The blockchain network where the transaction occurred. Valid Values:
  BITCOIN_MAINNET | BITCOIN_TESTNET

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"confirmationStatusFilter"`:
- `"maxResults"`: The maximum number of transaction events to list. Default: 100   Even if
  additional results can be retrieved, the request can return less results than maxResults or
  an empty array of results. To retrieve the next set of results, make another request with
  the returned nextToken value. The value of nextToken is null when there are no more results
  to return
- `"nextToken"`: The pagination token that indicates the next set of results to retrieve.
- `"sort"`: The order by which the results will be sorted.
- `"timeFilter"`: This container specifies the time frame for the transaction events
  returned in the response.
- `"voutFilter"`: This container specifies filtering attributes related to BITCOIN_VOUT
  event types
"""
function list_filtered_transaction_events(
    addressIdentifierFilter, network; aws_config::AbstractAWSConfig=current_aws_config()
)
    return managedblockchain_query(
        "POST",
        "/list-filtered-transaction-events",
        Dict{String,Any}(
            "addressIdentifierFilter" => addressIdentifierFilter, "network" => network
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_filtered_transaction_events(
    addressIdentifierFilter,
    network,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return managedblockchain_query(
        "POST",
        "/list-filtered-transaction-events",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "addressIdentifierFilter" => addressIdentifierFilter,
                    "network" => network,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_token_balances(token_filter)
    list_token_balances(token_filter, params::Dict{String,<:Any})

This action returns the following for a given blockchain network:   Lists all token
balances owned by an address (either a contract address or a wallet address).   Lists all
token balances for all tokens created by a contract.   Lists all token balances for a given
token.    You must always specify the network property of the tokenFilter when using this
operation.

# Arguments
- `token_filter`: The contract address or a token identifier on the blockchain network by
  which to filter the request. You must specify the contractAddress property of this
  container when listing tokens minted by a contract.  You must always specify the network
  property of this container when using this operation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of token balances to return. Default: 100   Even if
  additional results can be retrieved, the request can return less results than maxResults or
  an empty array of results. To retrieve the next set of results, make another request with
  the returned nextToken value. The value of nextToken is null when there are no more results
  to return
- `"nextToken"`: The pagination token that indicates the next set of results to retrieve.
- `"ownerFilter"`: The contract or wallet address on the blockchain network by which to
  filter the request. You must specify the address property of the ownerFilter when listing
  balances of tokens owned by the address.
"""
function list_token_balances(
    tokenFilter; aws_config::AbstractAWSConfig=current_aws_config()
)
    return managedblockchain_query(
        "POST",
        "/list-token-balances",
        Dict{String,Any}("tokenFilter" => tokenFilter);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_token_balances(
    tokenFilter,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return managedblockchain_query(
        "POST",
        "/list-token-balances",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("tokenFilter" => tokenFilter), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_transaction_events(network)
    list_transaction_events(network, params::Dict{String,<:Any})

Lists all the transaction events for a transaction   This action will return transaction
details for all transactions that are confirmed on the blockchain, even if they have not
reached finality.

# Arguments
- `network`: The blockchain network where the transaction events occurred.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of transaction events to list. Default: 100   Even if
  additional results can be retrieved, the request can return less results than maxResults or
  an empty array of results. To retrieve the next set of results, make another request with
  the returned nextToken value. The value of nextToken is null when there are no more results
  to return
- `"nextToken"`: The pagination token that indicates the next set of results to retrieve.
- `"transactionHash"`: The hash of a transaction. It is generated when a transaction is
  created.
- `"transactionId"`: The identifier of a Bitcoin transaction. It is generated when a
  transaction is created.   transactionId is only supported on the Bitcoin networks.
"""
function list_transaction_events(
    network; aws_config::AbstractAWSConfig=current_aws_config()
)
    return managedblockchain_query(
        "POST",
        "/list-transaction-events",
        Dict{String,Any}("network" => network);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_transaction_events(
    network,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return managedblockchain_query(
        "POST",
        "/list-transaction-events",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("network" => network), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_transactions(address, network)
    list_transactions(address, network, params::Dict{String,<:Any})

Lists all the transaction events for a transaction.

# Arguments
- `address`: The address (either a contract or wallet), whose transactions are being
  requested.
- `network`: The blockchain network where the transactions occurred.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"confirmationStatusFilter"`: This filter is used to include transactions in the response
  that haven't reached  finality . Transactions that have reached finality are always part of
  the response.
- `"fromBlockchainInstant"`:
- `"maxResults"`: The maximum number of transactions to list. Default: 100   Even if
  additional results can be retrieved, the request can return less results than maxResults or
  an empty array of results. To retrieve the next set of results, make another request with
  the returned nextToken value. The value of nextToken is null when there are no more results
  to return
- `"nextToken"`: The pagination token that indicates the next set of results to retrieve.
- `"sort"`: The order by which the results will be sorted.
- `"toBlockchainInstant"`:
"""
function list_transactions(
    address, network; aws_config::AbstractAWSConfig=current_aws_config()
)
    return managedblockchain_query(
        "POST",
        "/list-transactions",
        Dict{String,Any}("address" => address, "network" => network);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_transactions(
    address,
    network,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return managedblockchain_query(
        "POST",
        "/list-transactions",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("address" => address, "network" => network), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
