# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: appstream
using AWS.Compat
using AWS.UUIDs

"""
    associate_app_block_builder_app_block(app_block_arn, app_block_builder_name)
    associate_app_block_builder_app_block(app_block_arn, app_block_builder_name, params::Dict{String,<:Any})

Associates the specified app block builder with the specified app block.

# Arguments
- `app_block_arn`: The ARN of the app block.
- `app_block_builder_name`: The name of the app block builder.

"""
function associate_app_block_builder_app_block(
    AppBlockArn, AppBlockBuilderName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "AssociateAppBlockBuilderAppBlock",
        Dict{String,Any}(
            "AppBlockArn" => AppBlockArn, "AppBlockBuilderName" => AppBlockBuilderName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_app_block_builder_app_block(
    AppBlockArn,
    AppBlockBuilderName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "AssociateAppBlockBuilderAppBlock",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AppBlockArn" => AppBlockArn,
                    "AppBlockBuilderName" => AppBlockBuilderName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_application_fleet(application_arn, fleet_name)
    associate_application_fleet(application_arn, fleet_name, params::Dict{String,<:Any})

Associates the specified application with the specified fleet. This is only supported for
Elastic fleets.

# Arguments
- `application_arn`: The ARN of the application.
- `fleet_name`: The name of the fleet.

"""
function associate_application_fleet(
    ApplicationArn, FleetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "AssociateApplicationFleet",
        Dict{String,Any}("ApplicationArn" => ApplicationArn, "FleetName" => FleetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_application_fleet(
    ApplicationArn,
    FleetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "AssociateApplicationFleet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationArn" => ApplicationArn, "FleetName" => FleetName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_application_to_entitlement(application_identifier, entitlement_name, stack_name)
    associate_application_to_entitlement(application_identifier, entitlement_name, stack_name, params::Dict{String,<:Any})

Associates an application to entitle.

# Arguments
- `application_identifier`: The identifier of the application.
- `entitlement_name`: The name of the entitlement.
- `stack_name`: The name of the stack.

"""
function associate_application_to_entitlement(
    ApplicationIdentifier,
    EntitlementName,
    StackName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "AssociateApplicationToEntitlement",
        Dict{String,Any}(
            "ApplicationIdentifier" => ApplicationIdentifier,
            "EntitlementName" => EntitlementName,
            "StackName" => StackName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_application_to_entitlement(
    ApplicationIdentifier,
    EntitlementName,
    StackName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "AssociateApplicationToEntitlement",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationIdentifier" => ApplicationIdentifier,
                    "EntitlementName" => EntitlementName,
                    "StackName" => StackName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_fleet(fleet_name, stack_name)
    associate_fleet(fleet_name, stack_name, params::Dict{String,<:Any})

Associates the specified fleet with the specified stack.

# Arguments
- `fleet_name`: The name of the fleet.
- `stack_name`: The name of the stack.

"""
function associate_fleet(
    FleetName, StackName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "AssociateFleet",
        Dict{String,Any}("FleetName" => FleetName, "StackName" => StackName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_fleet(
    FleetName,
    StackName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "AssociateFleet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("FleetName" => FleetName, "StackName" => StackName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_associate_user_stack(user_stack_associations)
    batch_associate_user_stack(user_stack_associations, params::Dict{String,<:Any})

Associates the specified users with the specified stacks. Users in a user pool cannot be
assigned to stacks with fleets that are joined to an Active Directory domain.

# Arguments
- `user_stack_associations`: The list of UserStackAssociation objects.

"""
function batch_associate_user_stack(
    UserStackAssociations; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "BatchAssociateUserStack",
        Dict{String,Any}("UserStackAssociations" => UserStackAssociations);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_associate_user_stack(
    UserStackAssociations,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "BatchAssociateUserStack",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("UserStackAssociations" => UserStackAssociations),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_disassociate_user_stack(user_stack_associations)
    batch_disassociate_user_stack(user_stack_associations, params::Dict{String,<:Any})

Disassociates the specified users from the specified stacks.

# Arguments
- `user_stack_associations`: The list of UserStackAssociation objects.

"""
function batch_disassociate_user_stack(
    UserStackAssociations; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "BatchDisassociateUserStack",
        Dict{String,Any}("UserStackAssociations" => UserStackAssociations);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_disassociate_user_stack(
    UserStackAssociations,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "BatchDisassociateUserStack",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("UserStackAssociations" => UserStackAssociations),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    copy_image(destination_image_name, destination_region, source_image_name)
    copy_image(destination_image_name, destination_region, source_image_name, params::Dict{String,<:Any})

Copies the image within the same region or to a new region within the same AWS account.
Note that any tags you added to the image will not be copied.

# Arguments
- `destination_image_name`: The name that the image will have when it is copied to the
  destination.
- `destination_region`: The destination region to which the image will be copied. This
  parameter is required, even if you are copying an image within the same region.
- `source_image_name`: The name of the image to copy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DestinationImageDescription"`: The description that the image will have when it is
  copied to the destination.
"""
function copy_image(
    DestinationImageName,
    DestinationRegion,
    SourceImageName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "CopyImage",
        Dict{String,Any}(
            "DestinationImageName" => DestinationImageName,
            "DestinationRegion" => DestinationRegion,
            "SourceImageName" => SourceImageName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function copy_image(
    DestinationImageName,
    DestinationRegion,
    SourceImageName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "CopyImage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DestinationImageName" => DestinationImageName,
                    "DestinationRegion" => DestinationRegion,
                    "SourceImageName" => SourceImageName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_app_block(name, source_s3_location)
    create_app_block(name, source_s3_location, params::Dict{String,<:Any})

Creates an app block. App blocks are an Amazon AppStream 2.0 resource that stores the
details about the virtual hard disk in an S3 bucket. It also stores the setup script with
details about how to mount the virtual hard disk. The virtual hard disk includes the
application binaries and other files necessary to launch your applications. Multiple
applications can be assigned to a single app block. This is only supported for Elastic
fleets.

# Arguments
- `name`: The name of the app block.
- `source_s3_location`: The source S3 location of the app block.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: The description of the app block.
- `"DisplayName"`: The display name of the app block. This is not displayed to the user.
- `"PackagingType"`: The packaging type of the app block.
- `"PostSetupScriptDetails"`: The post setup script details of the app block. This can only
  be provided for the APPSTREAM2 PackagingType.
- `"SetupScriptDetails"`: The setup script details of the app block. This must be provided
  for the CUSTOM PackagingType.
- `"Tags"`: The tags assigned to the app block.
"""
function create_app_block(
    Name, SourceS3Location; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "CreateAppBlock",
        Dict{String,Any}("Name" => Name, "SourceS3Location" => SourceS3Location);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_app_block(
    Name,
    SourceS3Location,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "CreateAppBlock",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Name" => Name, "SourceS3Location" => SourceS3Location),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_app_block_builder(instance_type, name, platform, vpc_config)
    create_app_block_builder(instance_type, name, platform, vpc_config, params::Dict{String,<:Any})

Creates an app block builder.

# Arguments
- `instance_type`: The instance type to use when launching the app block builder. The
  following instance types are available:   stream.standard.small   stream.standard.medium
  stream.standard.large   stream.standard.xlarge   stream.standard.2xlarge
- `name`: The unique name for the app block builder.
- `platform`: The platform of the app block builder.  WINDOWS_SERVER_2019 is the only valid
  value.
- `vpc_config`: The VPC configuration for the app block builder. App block builders require
  that you specify at least two subnets in different availability zones.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessEndpoints"`: The list of interface VPC endpoint (interface endpoint) objects.
  Administrators can connect to the app block builder only through the specified endpoints.
- `"Description"`: The description of the app block builder.
- `"DisplayName"`: The display name of the app block builder.
- `"EnableDefaultInternetAccess"`: Enables or disables default internet access for the app
  block builder.
- `"IamRoleArn"`: The Amazon Resource Name (ARN) of the IAM role to apply to the app block
  builder. To assume a role, the app block builder calls the AWS Security Token Service (STS)
  AssumeRole API operation and passes the ARN of the role to use. The operation creates a new
  session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and
  creates the appstream_machine_role credential profile on the instance. For more
  information, see Using an IAM Role to Grant Permissions to Applications and Scripts Running
  on AppStream 2.0 Streaming Instances in the Amazon AppStream 2.0 Administration Guide.
- `"Tags"`: The tags to associate with the app block builder. A tag is a key-value pair,
  and the value is optional. For example, Environment=Test. If you do not specify a value,
  Environment=.  If you do not specify a value, the value is set to an empty string.
  Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and
  the following special characters:  _ . : / = +  - @ For more information, see Tagging Your
  Resources in the Amazon AppStream 2.0 Administration Guide.
"""
function create_app_block_builder(
    InstanceType,
    Name,
    Platform,
    VpcConfig;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "CreateAppBlockBuilder",
        Dict{String,Any}(
            "InstanceType" => InstanceType,
            "Name" => Name,
            "Platform" => Platform,
            "VpcConfig" => VpcConfig,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_app_block_builder(
    InstanceType,
    Name,
    Platform,
    VpcConfig,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "CreateAppBlockBuilder",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "InstanceType" => InstanceType,
                    "Name" => Name,
                    "Platform" => Platform,
                    "VpcConfig" => VpcConfig,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_app_block_builder_streaming_url(app_block_builder_name)
    create_app_block_builder_streaming_url(app_block_builder_name, params::Dict{String,<:Any})

Creates a URL to start a create app block builder streaming session.

# Arguments
- `app_block_builder_name`: The name of the app block builder.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Validity"`: The time that the streaming URL will be valid, in seconds. Specify a value
  between 1 and 604800 seconds. The default is 3600 seconds.
"""
function create_app_block_builder_streaming_url(
    AppBlockBuilderName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "CreateAppBlockBuilderStreamingURL",
        Dict{String,Any}("AppBlockBuilderName" => AppBlockBuilderName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_app_block_builder_streaming_url(
    AppBlockBuilderName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "CreateAppBlockBuilderStreamingURL",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AppBlockBuilderName" => AppBlockBuilderName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_application(app_block_arn, icon_s3_location, instance_families, launch_path, name, platforms)
    create_application(app_block_arn, icon_s3_location, instance_families, launch_path, name, platforms, params::Dict{String,<:Any})

Creates an application. Applications are an Amazon AppStream 2.0 resource that stores the
details about how to launch applications on Elastic fleet streaming instances. An
application consists of the launch details, icon, and display name. Applications are
associated with an app block that contains the application binaries and other files. The
applications assigned to an Elastic fleet are the applications users can launch.  This is
only supported for Elastic fleets.

# Arguments
- `app_block_arn`: The app block ARN to which the application should be associated
- `icon_s3_location`: The location in S3 of the application icon.
- `instance_families`: The instance families the application supports. Valid values are
  GENERAL_PURPOSE and GRAPHICS_G4.
- `launch_path`: The launch path of the application.
- `name`: The name of the application. This name is visible to users when display name is
  not specified.
- `platforms`: The platforms the application supports. WINDOWS_SERVER_2019 and
  AMAZON_LINUX2 are supported for Elastic fleets.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: The description of the application.
- `"DisplayName"`: The display name of the application. This name is visible to users in
  the application catalog.
- `"LaunchParameters"`: The launch parameters of the application.
- `"Tags"`: The tags assigned to the application.
- `"WorkingDirectory"`: The working directory of the application.
"""
function create_application(
    AppBlockArn,
    IconS3Location,
    InstanceFamilies,
    LaunchPath,
    Name,
    Platforms;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "CreateApplication",
        Dict{String,Any}(
            "AppBlockArn" => AppBlockArn,
            "IconS3Location" => IconS3Location,
            "InstanceFamilies" => InstanceFamilies,
            "LaunchPath" => LaunchPath,
            "Name" => Name,
            "Platforms" => Platforms,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_application(
    AppBlockArn,
    IconS3Location,
    InstanceFamilies,
    LaunchPath,
    Name,
    Platforms,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "CreateApplication",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AppBlockArn" => AppBlockArn,
                    "IconS3Location" => IconS3Location,
                    "InstanceFamilies" => InstanceFamilies,
                    "LaunchPath" => LaunchPath,
                    "Name" => Name,
                    "Platforms" => Platforms,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_directory_config(directory_name, organizational_unit_distinguished_names)
    create_directory_config(directory_name, organizational_unit_distinguished_names, params::Dict{String,<:Any})

Creates a Directory Config object in AppStream 2.0. This object includes the configuration
information required to join fleets and image builders to Microsoft Active Directory
domains.

# Arguments
- `directory_name`: The fully qualified name of the directory (for example,
  corp.example.com).
- `organizational_unit_distinguished_names`: The distinguished names of the organizational
  units for computer accounts.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CertificateBasedAuthProperties"`: The certificate-based authentication properties used
  to authenticate SAML 2.0 Identity Provider (IdP) user identities to Active Directory
  domain-joined streaming instances. Fallback is turned on by default when certificate-based
  authentication is Enabled . Fallback allows users to log in using their AD domain password
  if certificate-based authentication is unsuccessful, or to unlock a desktop lock screen.
  Enabled_no_directory_login_fallback enables certificate-based authentication, but does not
  allow users to log in using their AD domain password. Users will be disconnected to
  re-authenticate using certificates.
- `"ServiceAccountCredentials"`: The credentials for the service account used by the fleet
  or image builder to connect to the directory.
"""
function create_directory_config(
    DirectoryName,
    OrganizationalUnitDistinguishedNames;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "CreateDirectoryConfig",
        Dict{String,Any}(
            "DirectoryName" => DirectoryName,
            "OrganizationalUnitDistinguishedNames" => OrganizationalUnitDistinguishedNames,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_directory_config(
    DirectoryName,
    OrganizationalUnitDistinguishedNames,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "CreateDirectoryConfig",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DirectoryName" => DirectoryName,
                    "OrganizationalUnitDistinguishedNames" =>
                        OrganizationalUnitDistinguishedNames,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_entitlement(app_visibility, attributes, name, stack_name)
    create_entitlement(app_visibility, attributes, name, stack_name, params::Dict{String,<:Any})

Creates a new entitlement. Entitlements control access to specific applications within a
stack, based on user attributes. Entitlements apply to SAML 2.0 federated user identities.
Amazon AppStream 2.0 user pool and streaming URL users are entitled to all applications in
a stack. Entitlements don't apply to the desktop stream view application, or to
applications managed by a dynamic app provider using the Dynamic Application Framework.

# Arguments
- `app_visibility`: Specifies whether all or selected apps are entitled.
- `attributes`: The attributes of the entitlement.
- `name`: The name of the entitlement.
- `stack_name`: The name of the stack with which the entitlement is associated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: The description of the entitlement.
"""
function create_entitlement(
    AppVisibility,
    Attributes,
    Name,
    StackName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "CreateEntitlement",
        Dict{String,Any}(
            "AppVisibility" => AppVisibility,
            "Attributes" => Attributes,
            "Name" => Name,
            "StackName" => StackName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_entitlement(
    AppVisibility,
    Attributes,
    Name,
    StackName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "CreateEntitlement",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AppVisibility" => AppVisibility,
                    "Attributes" => Attributes,
                    "Name" => Name,
                    "StackName" => StackName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_fleet(instance_type, name)
    create_fleet(instance_type, name, params::Dict{String,<:Any})

Creates a fleet. A fleet consists of streaming instances that your users access for their
applications and desktops.

# Arguments
- `instance_type`: The instance type to use when launching fleet instances. The following
  instance types are available:   stream.standard.small   stream.standard.medium
  stream.standard.large   stream.standard.xlarge   stream.standard.2xlarge
  stream.compute.large   stream.compute.xlarge   stream.compute.2xlarge
  stream.compute.4xlarge   stream.compute.8xlarge   stream.memory.large
  stream.memory.xlarge   stream.memory.2xlarge   stream.memory.4xlarge
  stream.memory.8xlarge   stream.memory.z1d.large   stream.memory.z1d.xlarge
  stream.memory.z1d.2xlarge   stream.memory.z1d.3xlarge   stream.memory.z1d.6xlarge
  stream.memory.z1d.12xlarge   stream.graphics-design.large   stream.graphics-design.xlarge
  stream.graphics-design.2xlarge   stream.graphics-design.4xlarge
  stream.graphics-desktop.2xlarge   stream.graphics.g4dn.xlarge
  stream.graphics.g4dn.2xlarge   stream.graphics.g4dn.4xlarge   stream.graphics.g4dn.8xlarge
   stream.graphics.g4dn.12xlarge   stream.graphics.g4dn.16xlarge
  stream.graphics-pro.4xlarge   stream.graphics-pro.8xlarge   stream.graphics-pro.16xlarge
  The following instance types are available for Elastic fleets:   stream.standard.small
  stream.standard.medium   stream.standard.large   stream.standard.xlarge
  stream.standard.2xlarge
- `name`: A unique name for the fleet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ComputeCapacity"`: The desired capacity for the fleet. This is not allowed for Elastic
  fleets. For Elastic fleets, specify MaxConcurrentSessions instead.
- `"Description"`: The description to display.
- `"DisconnectTimeoutInSeconds"`: The amount of time that a streaming session remains
  active after users disconnect. If users try to reconnect to the streaming session after a
  disconnection or network interruption within this time interval, they are connected to
  their previous session. Otherwise, they are connected to a new session with a new streaming
  instance.  Specify a value between 60 and 360000.
- `"DisplayName"`: The fleet name to display.
- `"DomainJoinInfo"`: The name of the directory and organizational unit (OU) to use to join
  the fleet to a Microsoft Active Directory domain. This is not allowed for Elastic fleets.
- `"EnableDefaultInternetAccess"`: Enables or disables default internet access for the
  fleet.
- `"FleetType"`: The fleet type.  ALWAYS_ON  Provides users with instant-on access to their
  apps. You are charged for all running instances in your fleet, even if no users are
  streaming apps.  ON_DEMAND  Provide users with access to applications after they connect,
  which takes one to two minutes. You are charged for instance streaming when users are
  connected and a small hourly fee for instances that are not streaming apps.
- `"IamRoleArn"`: The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To
  assume a role, a fleet instance calls the AWS Security Token Service (STS) AssumeRole API
  operation and passes the ARN of the role to use. The operation creates a new session with
  temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the
  appstream_machine_role credential profile on the instance. For more information, see Using
  an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0
  Streaming Instances in the Amazon AppStream 2.0 Administration Guide.
- `"IdleDisconnectTimeoutInSeconds"`: The amount of time that users can be idle (inactive)
  before they are disconnected from their streaming session and the
  DisconnectTimeoutInSeconds time interval begins. Users are notified before they are
  disconnected due to inactivity. If they try to reconnect to the streaming session before
  the time interval specified in DisconnectTimeoutInSeconds elapses, they are connected to
  their previous session. Users are considered idle when they stop providing keyboard or
  mouse input during their streaming session. File uploads and downloads, audio in, audio
  out, and pixels changing do not qualify as user activity. If users continue to be idle
  after the time interval in IdleDisconnectTimeoutInSeconds elapses, they are disconnected.
  To prevent users from being disconnected due to inactivity, specify a value of 0.
  Otherwise, specify a value between 60 and 3600. The default value is 0.  If you enable this
  feature, we recommend that you specify a value that corresponds exactly to a whole number
  of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to
  the nearest minute. For example, if you specify a value of 70, users are disconnected after
  1 minute of inactivity. If you specify a value that is at the midpoint between two
  different minutes, the value is rounded up. For example, if you specify a value of 90,
  users are disconnected after 2 minutes of inactivity.
- `"ImageArn"`: The ARN of the public, private, or shared image to use.
- `"ImageName"`: The name of the image used to create the fleet.
- `"MaxConcurrentSessions"`: The maximum concurrent sessions of the Elastic fleet. This is
  required for Elastic fleets, and not allowed for other fleet types.
- `"MaxSessionsPerInstance"`: The maximum number of user sessions on an instance. This only
  applies to multi-session fleets.
- `"MaxUserDurationInSeconds"`: The maximum amount of time that a streaming session can
  remain active, in seconds. If users are still connected to a streaming instance five
  minutes before this limit is reached, they are prompted to save any open documents before
  being disconnected. After this time elapses, the instance is terminated and replaced by a
  new instance. Specify a value between 600 and 432000.
- `"Platform"`: The fleet platform. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for
  Elastic fleets.
- `"SessionScriptS3Location"`: The S3 location of the session scripts configuration zip
  file. This only applies to Elastic fleets.
- `"StreamView"`: The AppStream 2.0 view that is displayed to your users when they stream
  from the fleet. When APP is specified, only the windows of applications opened by users
  display. When DESKTOP is specified, the standard desktop that is provided by the operating
  system displays. The default value is APP.
- `"Tags"`: The tags to associate with the fleet. A tag is a key-value pair, and the value
  is optional. For example, Environment=Test. If you do not specify a value, Environment=.
  If you do not specify a value, the value is set to an empty string. Generally allowed
  characters are: letters, numbers, and spaces representable in UTF-8, and the following
  special characters:  _ . : / = +  - @ For more information, see Tagging Your Resources in
  the Amazon AppStream 2.0 Administration Guide.
- `"UsbDeviceFilterStrings"`: The USB device filter strings that specify which USB devices
  a user can redirect to the fleet streaming session, when using the Windows native client.
  This is allowed but not required for Elastic fleets.
- `"VpcConfig"`: The VPC configuration for the fleet. This is required for Elastic fleets,
  but not required for other fleet types. Elastic fleets require that you specify at least
  two subnets in different availability zones.
"""
function create_fleet(
    InstanceType, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "CreateFleet",
        Dict{String,Any}("InstanceType" => InstanceType, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_fleet(
    InstanceType,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "CreateFleet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("InstanceType" => InstanceType, "Name" => Name),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_image_builder(instance_type, name)
    create_image_builder(instance_type, name, params::Dict{String,<:Any})

Creates an image builder. An image builder is a virtual machine that is used to create an
image. The initial state of the builder is PENDING. When it is ready, the state is RUNNING.

# Arguments
- `instance_type`: The instance type to use when launching the image builder. The following
  instance types are available:   stream.standard.small   stream.standard.medium
  stream.standard.large   stream.compute.large   stream.compute.xlarge
  stream.compute.2xlarge   stream.compute.4xlarge   stream.compute.8xlarge
  stream.memory.large   stream.memory.xlarge   stream.memory.2xlarge   stream.memory.4xlarge
   stream.memory.8xlarge   stream.memory.z1d.large   stream.memory.z1d.xlarge
  stream.memory.z1d.2xlarge   stream.memory.z1d.3xlarge   stream.memory.z1d.6xlarge
  stream.memory.z1d.12xlarge   stream.graphics-design.large   stream.graphics-design.xlarge
  stream.graphics-design.2xlarge   stream.graphics-design.4xlarge
  stream.graphics-desktop.2xlarge   stream.graphics.g4dn.xlarge
  stream.graphics.g4dn.2xlarge   stream.graphics.g4dn.4xlarge   stream.graphics.g4dn.8xlarge
   stream.graphics.g4dn.12xlarge   stream.graphics.g4dn.16xlarge
  stream.graphics-pro.4xlarge   stream.graphics-pro.8xlarge   stream.graphics-pro.16xlarge
- `name`: A unique name for the image builder.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessEndpoints"`: The list of interface VPC endpoint (interface endpoint) objects.
  Administrators can connect to the image builder only through the specified endpoints.
- `"AppstreamAgentVersion"`: The version of the AppStream 2.0 agent to use for this image
  builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST].
- `"Description"`: The description to display.
- `"DisplayName"`: The image builder name to display.
- `"DomainJoinInfo"`: The name of the directory and organizational unit (OU) to use to join
  the image builder to a Microsoft Active Directory domain.
- `"EnableDefaultInternetAccess"`: Enables or disables default internet access for the
  image builder.
- `"IamRoleArn"`: The Amazon Resource Name (ARN) of the IAM role to apply to the image
  builder. To assume a role, the image builder calls the AWS Security Token Service (STS)
  AssumeRole API operation and passes the ARN of the role to use. The operation creates a new
  session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and
  creates the appstream_machine_role credential profile on the instance. For more
  information, see Using an IAM Role to Grant Permissions to Applications and Scripts Running
  on AppStream 2.0 Streaming Instances in the Amazon AppStream 2.0 Administration Guide.
- `"ImageArn"`: The ARN of the public, private, or shared image to use.
- `"ImageName"`: The name of the image used to create the image builder.
- `"Tags"`: The tags to associate with the image builder. A tag is a key-value pair, and
  the value is optional. For example, Environment=Test. If you do not specify a value,
  Environment=.  Generally allowed characters are: letters, numbers, and spaces representable
  in UTF-8, and the following special characters:  _ . : / = +  - @ If you do not specify a
  value, the value is set to an empty string. For more information about tags, see Tagging
  Your Resources in the Amazon AppStream 2.0 Administration Guide.
- `"VpcConfig"`: The VPC configuration for the image builder. You can specify only one
  subnet.
"""
function create_image_builder(
    InstanceType, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "CreateImageBuilder",
        Dict{String,Any}("InstanceType" => InstanceType, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_image_builder(
    InstanceType,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "CreateImageBuilder",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("InstanceType" => InstanceType, "Name" => Name),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_image_builder_streaming_url(name)
    create_image_builder_streaming_url(name, params::Dict{String,<:Any})

Creates a URL to start an image builder streaming session.

# Arguments
- `name`: The name of the image builder.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Validity"`: The time that the streaming URL will be valid, in seconds. Specify a value
  between 1 and 604800 seconds. The default is 3600 seconds.
"""
function create_image_builder_streaming_url(
    Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "CreateImageBuilderStreamingURL",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_image_builder_streaming_url(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "CreateImageBuilderStreamingURL",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_stack(name)
    create_stack(name, params::Dict{String,<:Any})

Creates a stack to start streaming applications to users. A stack consists of an associated
fleet, user access policies, and storage configurations.

# Arguments
- `name`: The name of the stack.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessEndpoints"`: The list of interface VPC endpoint (interface endpoint) objects.
  Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
- `"ApplicationSettings"`: The persistent application settings for users of a stack. When
  these settings are enabled, changes that users make to applications and Windows settings
  are automatically saved after each session and applied to the next session.
- `"Description"`: The description to display.
- `"DisplayName"`: The stack name to display.
- `"EmbedHostDomains"`: The domains where AppStream 2.0 streaming sessions can be embedded
  in an iframe. You must approve the domains that you want to host embedded AppStream 2.0
  streaming sessions.
- `"FeedbackURL"`: The URL that users are redirected to after they click the Send Feedback
  link. If no URL is specified, no Send Feedback link is displayed.
- `"RedirectURL"`: The URL that users are redirected to after their streaming session ends.
- `"StorageConnectors"`: The storage connectors to enable.
- `"StreamingExperienceSettings"`: The streaming protocol you want your stack to prefer.
  This can be UDP or TCP. Currently, UDP is only supported in the Windows native client.
- `"Tags"`: The tags to associate with the stack. A tag is a key-value pair, and the value
  is optional. For example, Environment=Test. If you do not specify a value, Environment=.
  If you do not specify a value, the value is set to an empty string. Generally allowed
  characters are: letters, numbers, and spaces representable in UTF-8, and the following
  special characters:  _ . : / = +  - @ For more information about tags, see Tagging Your
  Resources in the Amazon AppStream 2.0 Administration Guide.
- `"UserSettings"`: The actions that are enabled or disabled for users during their
  streaming sessions. By default, these actions are enabled.
"""
function create_stack(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "CreateStack",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_stack(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "CreateStack",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_streaming_url(fleet_name, stack_name, user_id)
    create_streaming_url(fleet_name, stack_name, user_id, params::Dict{String,<:Any})

Creates a temporary URL to start an AppStream 2.0 streaming session for the specified user.
A streaming URL enables application streaming to be tested without user setup.

# Arguments
- `fleet_name`: The name of the fleet.
- `stack_name`: The name of the stack.
- `user_id`: The identifier of the user.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ApplicationId"`: The name of the application to launch after the session starts. This
  is the name that you specified as Name in the Image Assistant. If your fleet is enabled for
  the Desktop stream view, you can also choose to launch directly to the operating system
  desktop. To do so, specify Desktop.
- `"SessionContext"`: The session context. For more information, see Session Context in the
  Amazon AppStream 2.0 Administration Guide.
- `"Validity"`: The time that the streaming URL will be valid, in seconds. Specify a value
  between 1 and 604800 seconds. The default is 60 seconds.
"""
function create_streaming_url(
    FleetName, StackName, UserId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "CreateStreamingURL",
        Dict{String,Any}(
            "FleetName" => FleetName, "StackName" => StackName, "UserId" => UserId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_streaming_url(
    FleetName,
    StackName,
    UserId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "CreateStreamingURL",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FleetName" => FleetName, "StackName" => StackName, "UserId" => UserId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_updated_image(existing_image_name, new_image_name)
    create_updated_image(existing_image_name, new_image_name, params::Dict{String,<:Any})

Creates a new image with the latest Windows operating system updates, driver updates, and
AppStream 2.0 agent software. For more information, see the \"Update an Image by Using
Managed AppStream 2.0 Image Updates\" section in Administer Your AppStream 2.0 Images, in
the Amazon AppStream 2.0 Administration Guide.

# Arguments
- `existing_image_name`: The name of the image to update.
- `new_image_name`: The name of the new image. The name must be unique within the AWS
  account and Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Indicates whether to display the status of image update availability before
  AppStream 2.0 initiates the process of creating a new updated image. If this value is set
  to true, AppStream 2.0 displays whether image updates are available. If this value is set
  to false, AppStream 2.0 initiates the process of creating a new updated image without
  displaying whether image updates are available.
- `"newImageDescription"`: The description to display for the new image.
- `"newImageDisplayName"`: The name to display for the new image.
- `"newImageTags"`: The tags to associate with the new image. A tag is a key-value pair,
  and the value is optional. For example, Environment=Test. If you do not specify a value,
  Environment=.  Generally allowed characters are: letters, numbers, and spaces representable
  in UTF-8, and the following special characters:  _ . : / = +  - @ If you do not specify a
  value, the value is set to an empty string. For more information about tags, see Tagging
  Your Resources in the Amazon AppStream 2.0 Administration Guide.
"""
function create_updated_image(
    existingImageName, newImageName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "CreateUpdatedImage",
        Dict{String,Any}(
            "existingImageName" => existingImageName, "newImageName" => newImageName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_updated_image(
    existingImageName,
    newImageName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "CreateUpdatedImage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "existingImageName" => existingImageName, "newImageName" => newImageName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_usage_report_subscription()
    create_usage_report_subscription(params::Dict{String,<:Any})

Creates a usage report subscription. Usage reports are generated daily.

"""
function create_usage_report_subscription(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "CreateUsageReportSubscription";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_usage_report_subscription(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "CreateUsageReportSubscription",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_user(authentication_type, user_name)
    create_user(authentication_type, user_name, params::Dict{String,<:Any})

Creates a new user in the user pool.

# Arguments
- `authentication_type`: The authentication type for the user. You must specify USERPOOL.
- `user_name`: The email address of the user.  Users' email addresses are case-sensitive.
  During login, if they specify an email address that doesn't use the same capitalization as
  the email address specified when their user pool account was created, a \"user does not
  exist\" error message displays.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FirstName"`: The first name, or given name, of the user.
- `"LastName"`: The last name, or surname, of the user.
- `"MessageAction"`: The action to take for the welcome email that is sent to a user after
  the user is created in the user pool. If you specify SUPPRESS, no email is sent. If you
  specify RESEND, do not specify the first name or last name of the user. If the value is
  null, the email is sent.   The temporary password in the welcome email is valid for only 7
  days. If users don’t set their passwords within 7 days, you must send them a new welcome
  email.
"""
function create_user(
    AuthenticationType, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "CreateUser",
        Dict{String,Any}(
            "AuthenticationType" => AuthenticationType, "UserName" => UserName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_user(
    AuthenticationType,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "CreateUser",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AuthenticationType" => AuthenticationType, "UserName" => UserName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_app_block(name)
    delete_app_block(name, params::Dict{String,<:Any})

Deletes an app block.

# Arguments
- `name`: The name of the app block.

"""
function delete_app_block(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "DeleteAppBlock",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_app_block(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DeleteAppBlock",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_app_block_builder(name)
    delete_app_block_builder(name, params::Dict{String,<:Any})

Deletes an app block builder. An app block builder can only be deleted when it has no
association with an app block.

# Arguments
- `name`: The name of the app block builder.

"""
function delete_app_block_builder(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "DeleteAppBlockBuilder",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_app_block_builder(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DeleteAppBlockBuilder",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_application(name)
    delete_application(name, params::Dict{String,<:Any})

Deletes an application.

# Arguments
- `name`: The name of the application.

"""
function delete_application(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "DeleteApplication",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_application(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DeleteApplication",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_directory_config(directory_name)
    delete_directory_config(directory_name, params::Dict{String,<:Any})

Deletes the specified Directory Config object from AppStream 2.0. This object includes the
information required to join streaming instances to an Active Directory domain.

# Arguments
- `directory_name`: The name of the directory configuration.

"""
function delete_directory_config(
    DirectoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DeleteDirectoryConfig",
        Dict{String,Any}("DirectoryName" => DirectoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_directory_config(
    DirectoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "DeleteDirectoryConfig",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DirectoryName" => DirectoryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_entitlement(name, stack_name)
    delete_entitlement(name, stack_name, params::Dict{String,<:Any})

Deletes the specified entitlement.

# Arguments
- `name`: The name of the entitlement.
- `stack_name`: The name of the stack with which the entitlement is associated.

"""
function delete_entitlement(
    Name, StackName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DeleteEntitlement",
        Dict{String,Any}("Name" => Name, "StackName" => StackName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_entitlement(
    Name,
    StackName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "DeleteEntitlement",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Name" => Name, "StackName" => StackName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_fleet(name)
    delete_fleet(name, params::Dict{String,<:Any})

Deletes the specified fleet.

# Arguments
- `name`: The name of the fleet.

"""
function delete_fleet(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "DeleteFleet",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_fleet(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DeleteFleet",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_image(name)
    delete_image(name, params::Dict{String,<:Any})

Deletes the specified image. You cannot delete an image when it is in use. After you delete
an image, you cannot provision new capacity using the image.

# Arguments
- `name`: The name of the image.

"""
function delete_image(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "DeleteImage",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_image(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DeleteImage",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_image_builder(name)
    delete_image_builder(name, params::Dict{String,<:Any})

Deletes the specified image builder and releases the capacity.

# Arguments
- `name`: The name of the image builder.

"""
function delete_image_builder(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "DeleteImageBuilder",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_image_builder(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DeleteImageBuilder",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_image_permissions(name, shared_account_id)
    delete_image_permissions(name, shared_account_id, params::Dict{String,<:Any})

Deletes permissions for the specified private image. After you delete permissions for an
image, AWS accounts to which you previously granted these permissions can no longer use the
image.

# Arguments
- `name`: The name of the private image.
- `shared_account_id`: The 12-digit identifier of the AWS account for which to delete image
  permissions.

"""
function delete_image_permissions(
    Name, SharedAccountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DeleteImagePermissions",
        Dict{String,Any}("Name" => Name, "SharedAccountId" => SharedAccountId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_image_permissions(
    Name,
    SharedAccountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "DeleteImagePermissions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Name" => Name, "SharedAccountId" => SharedAccountId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_stack(name)
    delete_stack(name, params::Dict{String,<:Any})

Deletes the specified stack. After the stack is deleted, the application streaming
environment provided by the stack is no longer available to users. Also, any reservations
made for application streaming sessions for the stack are released.

# Arguments
- `name`: The name of the stack.

"""
function delete_stack(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "DeleteStack",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_stack(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DeleteStack",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_usage_report_subscription()
    delete_usage_report_subscription(params::Dict{String,<:Any})

Disables usage report generation.

"""
function delete_usage_report_subscription(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DeleteUsageReportSubscription";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_usage_report_subscription(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DeleteUsageReportSubscription",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_user(authentication_type, user_name)
    delete_user(authentication_type, user_name, params::Dict{String,<:Any})

Deletes a user from the user pool.

# Arguments
- `authentication_type`: The authentication type for the user. You must specify USERPOOL.
- `user_name`: The email address of the user.  Users' email addresses are case-sensitive.

"""
function delete_user(
    AuthenticationType, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DeleteUser",
        Dict{String,Any}(
            "AuthenticationType" => AuthenticationType, "UserName" => UserName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_user(
    AuthenticationType,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "DeleteUser",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AuthenticationType" => AuthenticationType, "UserName" => UserName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_app_block_builder_app_block_associations()
    describe_app_block_builder_app_block_associations(params::Dict{String,<:Any})

Retrieves a list that describes one or more app block builder associations.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AppBlockArn"`: The ARN of the app block.
- `"AppBlockBuilderName"`: The name of the app block builder.
- `"MaxResults"`: The maximum size of each page of results.
- `"NextToken"`: The pagination token used to retrieve the next page of results for this
  operation.
"""
function describe_app_block_builder_app_block_associations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DescribeAppBlockBuilderAppBlockAssociations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_app_block_builder_app_block_associations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DescribeAppBlockBuilderAppBlockAssociations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_app_block_builders()
    describe_app_block_builders(params::Dict{String,<:Any})

Retrieves a list that describes one or more app block builders.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum size of each page of results. The maximum value is 25.
- `"Names"`: The names of the app block builders.
- `"NextToken"`: The pagination token used to retrieve the next page of results for this
  operation.
"""
function describe_app_block_builders(; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "DescribeAppBlockBuilders"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_app_block_builders(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DescribeAppBlockBuilders",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_app_blocks()
    describe_app_blocks(params::Dict{String,<:Any})

Retrieves a list that describes one or more app blocks.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Arns"`: The ARNs of the app blocks.
- `"MaxResults"`: The maximum size of each page of results.
- `"NextToken"`: The pagination token used to retrieve the next page of results for this
  operation.
"""
function describe_app_blocks(; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "DescribeAppBlocks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_app_blocks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DescribeAppBlocks", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_application_fleet_associations()
    describe_application_fleet_associations(params::Dict{String,<:Any})

Retrieves a list that describes one or more application fleet associations. Either
ApplicationArn or FleetName must be specified.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ApplicationArn"`: The ARN of the application.
- `"FleetName"`: The name of the fleet.
- `"MaxResults"`: The maximum size of each page of results.
- `"NextToken"`: The pagination token used to retrieve the next page of results for this
  operation.
"""
function describe_application_fleet_associations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DescribeApplicationFleetAssociations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_application_fleet_associations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DescribeApplicationFleetAssociations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_applications()
    describe_applications(params::Dict{String,<:Any})

Retrieves a list that describes one or more applications.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Arns"`: The ARNs for the applications.
- `"MaxResults"`: The maximum size of each page of results.
- `"NextToken"`: The pagination token used to retrieve the next page of results for this
  operation.
"""
function describe_applications(; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "DescribeApplications"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_applications(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DescribeApplications",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_directory_configs()
    describe_directory_configs(params::Dict{String,<:Any})

Retrieves a list that describes one or more specified Directory Config objects for
AppStream 2.0, if the names for these objects are provided. Otherwise, all Directory Config
objects in the account are described. These objects include the configuration information
required to join fleets and image builders to Microsoft Active Directory domains.  Although
the response syntax in this topic includes the account password, this password is not
returned in the actual response.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DirectoryNames"`: The directory names.
- `"MaxResults"`: The maximum size of each page of results.
- `"NextToken"`: The pagination token to use to retrieve the next page of results for this
  operation. If this value is null, it retrieves the first page.
"""
function describe_directory_configs(; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "DescribeDirectoryConfigs"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_directory_configs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DescribeDirectoryConfigs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_entitlements(stack_name)
    describe_entitlements(stack_name, params::Dict{String,<:Any})

Retrieves a list that describes one of more entitlements.

# Arguments
- `stack_name`: The name of the stack with which the entitlement is associated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum size of each page of results.
- `"Name"`: The name of the entitlement.
- `"NextToken"`: The pagination token used to retrieve the next page of results for this
  operation.
"""
function describe_entitlements(
    StackName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DescribeEntitlements",
        Dict{String,Any}("StackName" => StackName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_entitlements(
    StackName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "DescribeEntitlements",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("StackName" => StackName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_fleets()
    describe_fleets(params::Dict{String,<:Any})

Retrieves a list that describes one or more specified fleets, if the fleet names are
provided. Otherwise, all fleets in the account are described.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Names"`: The names of the fleets to describe.
- `"NextToken"`: The pagination token to use to retrieve the next page of results for this
  operation. If this value is null, it retrieves the first page.
"""
function describe_fleets(; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "DescribeFleets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_fleets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DescribeFleets", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_image_builders()
    describe_image_builders(params::Dict{String,<:Any})

Retrieves a list that describes one or more specified image builders, if the image builder
names are provided. Otherwise, all image builders in the account are described.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum size of each page of results.
- `"Names"`: The names of the image builders to describe.
- `"NextToken"`: The pagination token to use to retrieve the next page of results for this
  operation. If this value is null, it retrieves the first page.
"""
function describe_image_builders(; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "DescribeImageBuilders"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_image_builders(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DescribeImageBuilders",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_image_permissions(name)
    describe_image_permissions(name, params::Dict{String,<:Any})

Retrieves a list that describes the permissions for shared AWS account IDs on a private
image that you own.

# Arguments
- `name`: The name of the private image for which to describe permissions. The image must
  be one that you own.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum size of each page of results.
- `"NextToken"`: The pagination token to use to retrieve the next page of results for this
  operation. If this value is null, it retrieves the first page.
- `"SharedAwsAccountIds"`: The 12-digit identifier of one or more AWS accounts with which
  the image is shared.
"""
function describe_image_permissions(
    Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DescribeImagePermissions",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_image_permissions(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DescribeImagePermissions",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_images()
    describe_images(params::Dict{String,<:Any})

Retrieves a list that describes one or more specified images, if the image names or image
ARNs are provided. Otherwise, all images in the account are described.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Arns"`: The ARNs of the public, private, and shared images to describe.
- `"MaxResults"`: The maximum size of each page of results.
- `"Names"`: The names of the public or private images to describe.
- `"NextToken"`: The pagination token to use to retrieve the next page of results for this
  operation. If this value is null, it retrieves the first page.
- `"Type"`: The type of image (public, private, or shared) to describe.
"""
function describe_images(; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "DescribeImages"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_images(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DescribeImages", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_sessions(fleet_name, stack_name)
    describe_sessions(fleet_name, stack_name, params::Dict{String,<:Any})

Retrieves a list that describes the streaming sessions for a specified stack and fleet. If
a UserId is provided for the stack and fleet, only streaming sessions for that user are
described. If an authentication type is not provided, the default is to authenticate users
using a streaming URL.

# Arguments
- `fleet_name`: The name of the fleet. This value is case-sensitive.
- `stack_name`: The name of the stack. This value is case-sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AuthenticationType"`: The authentication method. Specify API for a user authenticated
  using a streaming URL or SAML for a SAML federated user. The default is to authenticate
  users using a streaming URL.
- `"InstanceId"`: The identifier for the instance hosting the session.
- `"Limit"`: The size of each page of results. The default value is 20 and the maximum
  value is 50.
- `"NextToken"`: The pagination token to use to retrieve the next page of results for this
  operation. If this value is null, it retrieves the first page.
- `"UserId"`: The user identifier (ID). If you specify a user ID, you must also specify the
  authentication type.
"""
function describe_sessions(
    FleetName, StackName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DescribeSessions",
        Dict{String,Any}("FleetName" => FleetName, "StackName" => StackName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_sessions(
    FleetName,
    StackName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "DescribeSessions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("FleetName" => FleetName, "StackName" => StackName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_stacks()
    describe_stacks(params::Dict{String,<:Any})

Retrieves a list that describes one or more specified stacks, if the stack names are
provided. Otherwise, all stacks in the account are described.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Names"`: The names of the stacks to describe.
- `"NextToken"`: The pagination token to use to retrieve the next page of results for this
  operation. If this value is null, it retrieves the first page.
"""
function describe_stacks(; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "DescribeStacks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_stacks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DescribeStacks", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_usage_report_subscriptions()
    describe_usage_report_subscriptions(params::Dict{String,<:Any})

Retrieves a list that describes one or more usage report subscriptions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum size of each page of results.
- `"NextToken"`: The pagination token to use to retrieve the next page of results for this
  operation. If this value is null, it retrieves the first page.
"""
function describe_usage_report_subscriptions(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DescribeUsageReportSubscriptions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_usage_report_subscriptions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DescribeUsageReportSubscriptions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_user_stack_associations()
    describe_user_stack_associations(params::Dict{String,<:Any})

Retrieves a list that describes the UserStackAssociation objects. You must specify either
or both of the following:   The stack name   The user name (email address of the user
associated with the stack) and the authentication type for the user

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AuthenticationType"`: The authentication type for the user who is associated with the
  stack. You must specify USERPOOL.
- `"MaxResults"`: The maximum size of each page of results.
- `"NextToken"`: The pagination token to use to retrieve the next page of results for this
  operation. If this value is null, it retrieves the first page.
- `"StackName"`: The name of the stack that is associated with the user.
- `"UserName"`: The email address of the user who is associated with the stack.  Users'
  email addresses are case-sensitive.
"""
function describe_user_stack_associations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DescribeUserStackAssociations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_user_stack_associations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DescribeUserStackAssociations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_users(authentication_type)
    describe_users(authentication_type, params::Dict{String,<:Any})

Retrieves a list that describes one or more specified users in the user pool.

# Arguments
- `authentication_type`: The authentication type for the users in the user pool to
  describe. You must specify USERPOOL.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum size of each page of results.
- `"NextToken"`: The pagination token to use to retrieve the next page of results for this
  operation. If this value is null, it retrieves the first page.
"""
function describe_users(
    AuthenticationType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DescribeUsers",
        Dict{String,Any}("AuthenticationType" => AuthenticationType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_users(
    AuthenticationType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "DescribeUsers",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("AuthenticationType" => AuthenticationType), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_user(authentication_type, user_name)
    disable_user(authentication_type, user_name, params::Dict{String,<:Any})

Disables the specified user in the user pool. Users can't sign in to AppStream 2.0 until
they are re-enabled. This action does not delete the user.

# Arguments
- `authentication_type`: The authentication type for the user. You must specify USERPOOL.
- `user_name`: The email address of the user.  Users' email addresses are case-sensitive.

"""
function disable_user(
    AuthenticationType, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DisableUser",
        Dict{String,Any}(
            "AuthenticationType" => AuthenticationType, "UserName" => UserName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_user(
    AuthenticationType,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "DisableUser",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AuthenticationType" => AuthenticationType, "UserName" => UserName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_app_block_builder_app_block(app_block_arn, app_block_builder_name)
    disassociate_app_block_builder_app_block(app_block_arn, app_block_builder_name, params::Dict{String,<:Any})

Disassociates a specified app block builder from a specified app block.

# Arguments
- `app_block_arn`: The ARN of the app block.
- `app_block_builder_name`: The name of the app block builder.

"""
function disassociate_app_block_builder_app_block(
    AppBlockArn, AppBlockBuilderName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DisassociateAppBlockBuilderAppBlock",
        Dict{String,Any}(
            "AppBlockArn" => AppBlockArn, "AppBlockBuilderName" => AppBlockBuilderName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_app_block_builder_app_block(
    AppBlockArn,
    AppBlockBuilderName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "DisassociateAppBlockBuilderAppBlock",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AppBlockArn" => AppBlockArn,
                    "AppBlockBuilderName" => AppBlockBuilderName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_application_fleet(application_arn, fleet_name)
    disassociate_application_fleet(application_arn, fleet_name, params::Dict{String,<:Any})

Disassociates the specified application from the fleet.

# Arguments
- `application_arn`: The ARN of the application.
- `fleet_name`: The name of the fleet.

"""
function disassociate_application_fleet(
    ApplicationArn, FleetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DisassociateApplicationFleet",
        Dict{String,Any}("ApplicationArn" => ApplicationArn, "FleetName" => FleetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_application_fleet(
    ApplicationArn,
    FleetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "DisassociateApplicationFleet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationArn" => ApplicationArn, "FleetName" => FleetName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_application_from_entitlement(application_identifier, entitlement_name, stack_name)
    disassociate_application_from_entitlement(application_identifier, entitlement_name, stack_name, params::Dict{String,<:Any})

Deletes the specified application from the specified entitlement.

# Arguments
- `application_identifier`: The identifier of the application to remove from the
  entitlement.
- `entitlement_name`: The name of the entitlement.
- `stack_name`: The name of the stack with which the entitlement is associated.

"""
function disassociate_application_from_entitlement(
    ApplicationIdentifier,
    EntitlementName,
    StackName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "DisassociateApplicationFromEntitlement",
        Dict{String,Any}(
            "ApplicationIdentifier" => ApplicationIdentifier,
            "EntitlementName" => EntitlementName,
            "StackName" => StackName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_application_from_entitlement(
    ApplicationIdentifier,
    EntitlementName,
    StackName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "DisassociateApplicationFromEntitlement",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationIdentifier" => ApplicationIdentifier,
                    "EntitlementName" => EntitlementName,
                    "StackName" => StackName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_fleet(fleet_name, stack_name)
    disassociate_fleet(fleet_name, stack_name, params::Dict{String,<:Any})

Disassociates the specified fleet from the specified stack.

# Arguments
- `fleet_name`: The name of the fleet.
- `stack_name`: The name of the stack.

"""
function disassociate_fleet(
    FleetName, StackName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "DisassociateFleet",
        Dict{String,Any}("FleetName" => FleetName, "StackName" => StackName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_fleet(
    FleetName,
    StackName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "DisassociateFleet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("FleetName" => FleetName, "StackName" => StackName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_user(authentication_type, user_name)
    enable_user(authentication_type, user_name, params::Dict{String,<:Any})

Enables a user in the user pool. After being enabled, users can sign in to AppStream 2.0
and open applications from the stacks to which they are assigned.

# Arguments
- `authentication_type`: The authentication type for the user. You must specify USERPOOL.
- `user_name`: The email address of the user.  Users' email addresses are case-sensitive.
  During login, if they specify an email address that doesn't use the same capitalization as
  the email address specified when their user pool account was created, a \"user does not
  exist\" error message displays.

"""
function enable_user(
    AuthenticationType, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "EnableUser",
        Dict{String,Any}(
            "AuthenticationType" => AuthenticationType, "UserName" => UserName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_user(
    AuthenticationType,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "EnableUser",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AuthenticationType" => AuthenticationType, "UserName" => UserName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    expire_session(session_id)
    expire_session(session_id, params::Dict{String,<:Any})

Immediately stops the specified streaming session.

# Arguments
- `session_id`: The identifier of the streaming session.

"""
function expire_session(SessionId; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "ExpireSession",
        Dict{String,Any}("SessionId" => SessionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function expire_session(
    SessionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "ExpireSession",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SessionId" => SessionId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_associated_fleets(stack_name)
    list_associated_fleets(stack_name, params::Dict{String,<:Any})

Retrieves the name of the fleet that is associated with the specified stack.

# Arguments
- `stack_name`: The name of the stack.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: The pagination token to use to retrieve the next page of results for this
  operation. If this value is null, it retrieves the first page.
"""
function list_associated_fleets(
    StackName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "ListAssociatedFleets",
        Dict{String,Any}("StackName" => StackName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_associated_fleets(
    StackName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "ListAssociatedFleets",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("StackName" => StackName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_associated_stacks(fleet_name)
    list_associated_stacks(fleet_name, params::Dict{String,<:Any})

Retrieves the name of the stack with which the specified fleet is associated.

# Arguments
- `fleet_name`: The name of the fleet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: The pagination token to use to retrieve the next page of results for this
  operation. If this value is null, it retrieves the first page.
"""
function list_associated_stacks(
    FleetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "ListAssociatedStacks",
        Dict{String,Any}("FleetName" => FleetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_associated_stacks(
    FleetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "ListAssociatedStacks",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FleetName" => FleetName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_entitled_applications(entitlement_name, stack_name)
    list_entitled_applications(entitlement_name, stack_name, params::Dict{String,<:Any})

Retrieves a list of entitled applications.

# Arguments
- `entitlement_name`: The name of the entitlement.
- `stack_name`: The name of the stack with which the entitlement is associated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum size of each page of results.
- `"NextToken"`: The pagination token used to retrieve the next page of results for this
  operation.
"""
function list_entitled_applications(
    EntitlementName, StackName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "ListEntitledApplications",
        Dict{String,Any}("EntitlementName" => EntitlementName, "StackName" => StackName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_entitled_applications(
    EntitlementName,
    StackName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "ListEntitledApplications",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "EntitlementName" => EntitlementName, "StackName" => StackName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Retrieves a list of all tags for the specified AppStream 2.0 resource. You can tag
AppStream 2.0 image builders, images, fleets, and stacks. For more information about tags,
see Tagging Your Resources in the Amazon AppStream 2.0 Administration Guide.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.

"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "ListTagsForResource",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_app_block_builder(name)
    start_app_block_builder(name, params::Dict{String,<:Any})

Starts an app block builder. An app block builder can only be started when it's associated
with an app block. Starting an app block builder starts a new instance, which is equivalent
to an elastic fleet instance with application builder assistance functionality.

# Arguments
- `name`: The name of the app block builder.

"""
function start_app_block_builder(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "StartAppBlockBuilder",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_app_block_builder(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "StartAppBlockBuilder",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_fleet(name)
    start_fleet(name, params::Dict{String,<:Any})

Starts the specified fleet.

# Arguments
- `name`: The name of the fleet.

"""
function start_fleet(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "StartFleet",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_fleet(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "StartFleet",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_image_builder(name)
    start_image_builder(name, params::Dict{String,<:Any})

Starts the specified image builder.

# Arguments
- `name`: The name of the image builder.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AppstreamAgentVersion"`: The version of the AppStream 2.0 agent to use for this image
  builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST].
"""
function start_image_builder(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "StartImageBuilder",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_image_builder(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "StartImageBuilder",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_app_block_builder(name)
    stop_app_block_builder(name, params::Dict{String,<:Any})

Stops an app block builder. Stopping an app block builder terminates the instance, and the
instance state is not persisted.

# Arguments
- `name`: The name of the app block builder.

"""
function stop_app_block_builder(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "StopAppBlockBuilder",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_app_block_builder(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "StopAppBlockBuilder",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_fleet(name)
    stop_fleet(name, params::Dict{String,<:Any})

Stops the specified fleet.

# Arguments
- `name`: The name of the fleet.

"""
function stop_fleet(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "StopFleet",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_fleet(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "StopFleet",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_image_builder(name)
    stop_image_builder(name, params::Dict{String,<:Any})

Stops the specified image builder.

# Arguments
- `name`: The name of the image builder.

"""
function stop_image_builder(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "StopImageBuilder",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_image_builder(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "StopImageBuilder",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds or overwrites one or more tags for the specified AppStream 2.0 resource. You can tag
AppStream 2.0 image builders, images, fleets, and stacks. Each tag consists of a key and an
optional value. If a resource already has a tag with the same key, this operation updates
its value. To list the current tags for your resources, use ListTagsForResource. To
disassociate tags from your resources, use UntagResource. For more information about tags,
see Tagging Your Resources in the Amazon AppStream 2.0 Administration Guide.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.
- `tags`: The tags to associate. A tag is a key-value pair, and the value is optional. For
  example, Environment=Test. If you do not specify a value, Environment=.  If you do not
  specify a value, the value is set to an empty string. Generally allowed characters are:
  letters, numbers, and spaces representable in UTF-8, and the following special characters:
  _ . : / = +  - @

"""
function tag_resource(ResourceArn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "TagResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Disassociates one or more specified tags from the specified AppStream 2.0 resource. To list
the current tags for your resources, use ListTagsForResource. For more information about
tags, see Tagging Your Resources in the Amazon AppStream 2.0 Administration Guide.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.
- `tag_keys`: The tag keys for the tags to disassociate.

"""
function untag_resource(
    ResourceArn, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "UntagResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_app_block_builder(name)
    update_app_block_builder(name, params::Dict{String,<:Any})

Updates an app block builder. If the app block builder is in the STARTING or STOPPING
state, you can't update it. If the app block builder is in the RUNNING state, you can only
update the DisplayName and Description. If the app block builder is in the STOPPED state,
you can update any attribute except the Name.

# Arguments
- `name`: The unique name for the app block builder.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessEndpoints"`: The list of interface VPC endpoint (interface endpoint) objects.
  Administrators can connect to the app block builder only through the specified endpoints.
- `"AttributesToDelete"`: The attributes to delete from the app block builder.
- `"Description"`: The description of the app block builder.
- `"DisplayName"`: The display name of the app block builder.
- `"EnableDefaultInternetAccess"`: Enables or disables default internet access for the app
  block builder.
- `"IamRoleArn"`: The Amazon Resource Name (ARN) of the IAM role to apply to the app block
  builder. To assume a role, the app block builder calls the AWS Security Token Service (STS)
  AssumeRole API operation and passes the ARN of the role to use. The operation creates a new
  session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and
  creates the appstream_machine_role credential profile on the instance. For more
  information, see Using an IAM Role to Grant Permissions to Applications and Scripts Running
  on AppStream 2.0 Streaming Instances in the Amazon AppStream 2.0 Administration Guide.
- `"InstanceType"`: The instance type to use when launching the app block builder. The
  following instance types are available:   stream.standard.small   stream.standard.medium
  stream.standard.large   stream.standard.xlarge   stream.standard.2xlarge
- `"Platform"`: The platform of the app block builder.  WINDOWS_SERVER_2019 is the only
  valid value.
- `"VpcConfig"`: The VPC configuration for the app block builder. App block builders
  require that you specify at least two subnets in different availability zones.
"""
function update_app_block_builder(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "UpdateAppBlockBuilder",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_app_block_builder(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "UpdateAppBlockBuilder",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_application(name)
    update_application(name, params::Dict{String,<:Any})

Updates the specified application.

# Arguments
- `name`: The name of the application. This name is visible to users when display name is
  not specified.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AppBlockArn"`: The ARN of the app block.
- `"AttributesToDelete"`: The attributes to delete for an application.
- `"Description"`: The description of the application.
- `"DisplayName"`: The display name of the application. This name is visible to users in
  the application catalog.
- `"IconS3Location"`: The icon S3 location of the application.
- `"LaunchParameters"`: The launch parameters of the application.
- `"LaunchPath"`: The launch path of the application.
- `"WorkingDirectory"`: The working directory of the application.
"""
function update_application(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "UpdateApplication",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_application(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "UpdateApplication",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_directory_config(directory_name)
    update_directory_config(directory_name, params::Dict{String,<:Any})

Updates the specified Directory Config object in AppStream 2.0. This object includes the
configuration information required to join fleets and image builders to Microsoft Active
Directory domains.

# Arguments
- `directory_name`: The name of the Directory Config object.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CertificateBasedAuthProperties"`: The certificate-based authentication properties used
  to authenticate SAML 2.0 Identity Provider (IdP) user identities to Active Directory
  domain-joined streaming instances. Fallback is turned on by default when certificate-based
  authentication is Enabled . Fallback allows users to log in using their AD domain password
  if certificate-based authentication is unsuccessful, or to unlock a desktop lock screen.
  Enabled_no_directory_login_fallback enables certificate-based authentication, but does not
  allow users to log in using their AD domain password. Users will be disconnected to
  re-authenticate using certificates.
- `"OrganizationalUnitDistinguishedNames"`: The distinguished names of the organizational
  units for computer accounts.
- `"ServiceAccountCredentials"`: The credentials for the service account used by the fleet
  or image builder to connect to the directory.
"""
function update_directory_config(
    DirectoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "UpdateDirectoryConfig",
        Dict{String,Any}("DirectoryName" => DirectoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_directory_config(
    DirectoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "UpdateDirectoryConfig",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DirectoryName" => DirectoryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_entitlement(name, stack_name)
    update_entitlement(name, stack_name, params::Dict{String,<:Any})

Updates the specified entitlement.

# Arguments
- `name`: The name of the entitlement.
- `stack_name`: The name of the stack with which the entitlement is associated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AppVisibility"`: Specifies whether all or only selected apps are entitled.
- `"Attributes"`: The attributes of the entitlement.
- `"Description"`: The description of the entitlement.
"""
function update_entitlement(
    Name, StackName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "UpdateEntitlement",
        Dict{String,Any}("Name" => Name, "StackName" => StackName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_entitlement(
    Name,
    StackName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "UpdateEntitlement",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Name" => Name, "StackName" => StackName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_fleet()
    update_fleet(params::Dict{String,<:Any})

Updates the specified fleet. If the fleet is in the STOPPED state, you can update any
attribute except the fleet name. If the fleet is in the RUNNING state, you can update the
following based on the fleet type:   Always-On and On-Demand fleet types You can update the
DisplayName, ComputeCapacity, ImageARN, ImageName, IdleDisconnectTimeoutInSeconds, and
DisconnectTimeoutInSeconds attributes.   Elastic fleet type You can update the DisplayName,
IdleDisconnectTimeoutInSeconds, DisconnectTimeoutInSeconds, MaxConcurrentSessions,
SessionScriptS3Location and UsbDeviceFilterStrings attributes.   If the fleet is in the
STARTING or STOPPED state, you can't update it.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AttributesToDelete"`: The fleet attributes to delete.
- `"ComputeCapacity"`: The desired capacity for the fleet. This is not allowed for Elastic
  fleets.
- `"DeleteVpcConfig"`: Deletes the VPC association for the specified fleet.
- `"Description"`: The description to display.
- `"DisconnectTimeoutInSeconds"`: The amount of time that a streaming session remains
  active after users disconnect. If users try to reconnect to the streaming session after a
  disconnection or network interruption within this time interval, they are connected to
  their previous session. Otherwise, they are connected to a new session with a new streaming
  instance.  Specify a value between 60 and 360000.
- `"DisplayName"`: The fleet name to display.
- `"DomainJoinInfo"`: The name of the directory and organizational unit (OU) to use to join
  the fleet to a Microsoft Active Directory domain.
- `"EnableDefaultInternetAccess"`: Enables or disables default internet access for the
  fleet.
- `"IamRoleArn"`: The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To
  assume a role, a fleet instance calls the AWS Security Token Service (STS) AssumeRole API
  operation and passes the ARN of the role to use. The operation creates a new session with
  temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the
  appstream_machine_role credential profile on the instance. For more information, see Using
  an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0
  Streaming Instances in the Amazon AppStream 2.0 Administration Guide.
- `"IdleDisconnectTimeoutInSeconds"`: The amount of time that users can be idle (inactive)
  before they are disconnected from their streaming session and the
  DisconnectTimeoutInSeconds time interval begins. Users are notified before they are
  disconnected due to inactivity. If users try to reconnect to the streaming session before
  the time interval specified in DisconnectTimeoutInSeconds elapses, they are connected to
  their previous session. Users are considered idle when they stop providing keyboard or
  mouse input during their streaming session. File uploads and downloads, audio in, audio
  out, and pixels changing do not qualify as user activity. If users continue to be idle
  after the time interval in IdleDisconnectTimeoutInSeconds elapses, they are disconnected.
  To prevent users from being disconnected due to inactivity, specify a value of 0.
  Otherwise, specify a value between 60 and 3600. The default value is 0.  If you enable this
  feature, we recommend that you specify a value that corresponds exactly to a whole number
  of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to
  the nearest minute. For example, if you specify a value of 70, users are disconnected after
  1 minute of inactivity. If you specify a value that is at the midpoint between two
  different minutes, the value is rounded up. For example, if you specify a value of 90,
  users are disconnected after 2 minutes of inactivity.
- `"ImageArn"`: The ARN of the public, private, or shared image to use.
- `"ImageName"`: The name of the image used to create the fleet.
- `"InstanceType"`: The instance type to use when launching fleet instances. The following
  instance types are available:   stream.standard.small   stream.standard.medium
  stream.standard.large   stream.standard.xlarge   stream.standard.2xlarge
  stream.compute.large   stream.compute.xlarge   stream.compute.2xlarge
  stream.compute.4xlarge   stream.compute.8xlarge   stream.memory.large
  stream.memory.xlarge   stream.memory.2xlarge   stream.memory.4xlarge
  stream.memory.8xlarge   stream.memory.z1d.large   stream.memory.z1d.xlarge
  stream.memory.z1d.2xlarge   stream.memory.z1d.3xlarge   stream.memory.z1d.6xlarge
  stream.memory.z1d.12xlarge   stream.graphics-design.large   stream.graphics-design.xlarge
  stream.graphics-design.2xlarge   stream.graphics-design.4xlarge
  stream.graphics-desktop.2xlarge   stream.graphics.g4dn.xlarge
  stream.graphics.g4dn.2xlarge   stream.graphics.g4dn.4xlarge   stream.graphics.g4dn.8xlarge
   stream.graphics.g4dn.12xlarge   stream.graphics.g4dn.16xlarge
  stream.graphics-pro.4xlarge   stream.graphics-pro.8xlarge   stream.graphics-pro.16xlarge
  The following instance types are available for Elastic fleets:   stream.standard.small
  stream.standard.medium   stream.standard.large   stream.standard.xlarge
  stream.standard.2xlarge
- `"MaxConcurrentSessions"`: The maximum number of concurrent sessions for a fleet.
- `"MaxSessionsPerInstance"`: The maximum number of user sessions on an instance. This only
  applies to multi-session fleets.
- `"MaxUserDurationInSeconds"`: The maximum amount of time that a streaming session can
  remain active, in seconds. If users are still connected to a streaming instance five
  minutes before this limit is reached, they are prompted to save any open documents before
  being disconnected. After this time elapses, the instance is terminated and replaced by a
  new instance. Specify a value between 600 and 432000.
- `"Name"`: A unique name for the fleet.
- `"Platform"`: The platform of the fleet. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are
  supported for Elastic fleets.
- `"SessionScriptS3Location"`: The S3 location of the session scripts configuration zip
  file. This only applies to Elastic fleets.
- `"StreamView"`: The AppStream 2.0 view that is displayed to your users when they stream
  from the fleet. When APP is specified, only the windows of applications opened by users
  display. When DESKTOP is specified, the standard desktop that is provided by the operating
  system displays. The default value is APP.
- `"UsbDeviceFilterStrings"`: The USB device filter strings that specify which USB devices
  a user can redirect to the fleet streaming session, when using the Windows native client.
  This is allowed but not required for Elastic fleets.
- `"VpcConfig"`: The VPC configuration for the fleet. This is required for Elastic fleets,
  but not required for other fleet types. Elastic fleets require that you specify at least
  two subnets in different availability zones.
"""
function update_fleet(; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream("UpdateFleet"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function update_fleet(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "UpdateFleet", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    update_image_permissions(image_permissions, name, shared_account_id)
    update_image_permissions(image_permissions, name, shared_account_id, params::Dict{String,<:Any})

Adds or updates permissions for the specified private image.

# Arguments
- `image_permissions`: The permissions for the image.
- `name`: The name of the private image.
- `shared_account_id`: The 12-digit identifier of the AWS account for which you want add or
  update image permissions.

"""
function update_image_permissions(
    ImagePermissions,
    Name,
    SharedAccountId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "UpdateImagePermissions",
        Dict{String,Any}(
            "ImagePermissions" => ImagePermissions,
            "Name" => Name,
            "SharedAccountId" => SharedAccountId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_image_permissions(
    ImagePermissions,
    Name,
    SharedAccountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appstream(
        "UpdateImagePermissions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ImagePermissions" => ImagePermissions,
                    "Name" => Name,
                    "SharedAccountId" => SharedAccountId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_stack(name)
    update_stack(name, params::Dict{String,<:Any})

Updates the specified fields for the specified stack.

# Arguments
- `name`: The name of the stack.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessEndpoints"`: The list of interface VPC endpoint (interface endpoint) objects.
  Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
- `"ApplicationSettings"`: The persistent application settings for users of a stack. When
  these settings are enabled, changes that users make to applications and Windows settings
  are automatically saved after each session and applied to the next session.
- `"AttributesToDelete"`: The stack attributes to delete.
- `"DeleteStorageConnectors"`: Deletes the storage connectors currently enabled for the
  stack.
- `"Description"`: The description to display.
- `"DisplayName"`: The stack name to display.
- `"EmbedHostDomains"`: The domains where AppStream 2.0 streaming sessions can be embedded
  in an iframe. You must approve the domains that you want to host embedded AppStream 2.0
  streaming sessions.
- `"FeedbackURL"`: The URL that users are redirected to after they choose the Send Feedback
  link. If no URL is specified, no Send Feedback link is displayed.
- `"RedirectURL"`: The URL that users are redirected to after their streaming session ends.
- `"StorageConnectors"`: The storage connectors to enable.
- `"StreamingExperienceSettings"`: The streaming protocol you want your stack to prefer.
  This can be UDP or TCP. Currently, UDP is only supported in the Windows native client.
- `"UserSettings"`: The actions that are enabled or disabled for users during their
  streaming sessions. By default, these actions are enabled.
"""
function update_stack(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return appstream(
        "UpdateStack",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_stack(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appstream(
        "UpdateStack",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
