# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: directory_service
using AWS.Compat
using AWS.UUIDs

"""
    accept_shared_directory(shared_directory_id)
    accept_shared_directory(shared_directory_id, params::Dict{String,<:Any})

Accepts a directory sharing request that was sent from the directory owner account.

# Arguments
- `shared_directory_id`: Identifier of the shared directory in the directory consumer
  account. This identifier is different for each directory owner account.

"""
function accept_shared_directory(
    SharedDirectoryId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "AcceptSharedDirectory",
        Dict{String,Any}("SharedDirectoryId" => SharedDirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_shared_directory(
    SharedDirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "AcceptSharedDirectory",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("SharedDirectoryId" => SharedDirectoryId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_ip_routes(directory_id, ip_routes)
    add_ip_routes(directory_id, ip_routes, params::Dict{String,<:Any})

If the DNS server for your self-managed domain uses a publicly addressable IP address, you
must add a CIDR address block to correctly route traffic to and from your Microsoft AD on
Amazon Web Services. AddIpRoutes adds this address block. You can also use AddIpRoutes to
facilitate routing traffic that uses public IP ranges from your Microsoft AD on Amazon Web
Services to a peer VPC.  Before you call AddIpRoutes, ensure that all of the required
permissions have been explicitly granted through a policy. For details about what
permissions are required to run the AddIpRoutes operation, see Directory Service API
Permissions: Actions, Resources, and Conditions Reference.

# Arguments
- `directory_id`: Identifier (ID) of the directory to which to add the address block.
- `ip_routes`: IP address blocks, using CIDR format, of the traffic to route. This is often
  the IP address block of the DNS server used for your self-managed domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"UpdateSecurityGroupForDirectoryControllers"`: If set to true, updates the inbound and
  outbound rules of the security group that has the description: \"Amazon Web Services
  created security group for directory ID directory controllers.\" Following are the new
  rules:  Inbound:   Type: Custom UDP Rule, Protocol: UDP, Range: 88, Source: 0.0.0.0/0
  Type: Custom UDP Rule, Protocol: UDP, Range: 123, Source: 0.0.0.0/0   Type: Custom UDP
  Rule, Protocol: UDP, Range: 138, Source: 0.0.0.0/0   Type: Custom UDP Rule, Protocol: UDP,
  Range: 389, Source: 0.0.0.0/0   Type: Custom UDP Rule, Protocol: UDP, Range: 464, Source:
  0.0.0.0/0   Type: Custom UDP Rule, Protocol: UDP, Range: 445, Source: 0.0.0.0/0   Type:
  Custom TCP Rule, Protocol: TCP, Range: 88, Source: 0.0.0.0/0   Type: Custom TCP Rule,
  Protocol: TCP, Range: 135, Source: 0.0.0.0/0   Type: Custom TCP Rule, Protocol: TCP, Range:
  445, Source: 0.0.0.0/0   Type: Custom TCP Rule, Protocol: TCP, Range: 464, Source:
  0.0.0.0/0   Type: Custom TCP Rule, Protocol: TCP, Range: 636, Source: 0.0.0.0/0   Type:
  Custom TCP Rule, Protocol: TCP, Range: 1024-65535, Source: 0.0.0.0/0   Type: Custom TCP
  Rule, Protocol: TCP, Range: 3268-33269, Source: 0.0.0.0/0   Type: DNS (UDP), Protocol: UDP,
  Range: 53, Source: 0.0.0.0/0   Type: DNS (TCP), Protocol: TCP, Range: 53, Source: 0.0.0.0/0
    Type: LDAP, Protocol: TCP, Range: 389, Source: 0.0.0.0/0   Type: All ICMP, Protocol: All,
  Range: N/A, Source: 0.0.0.0/0    Outbound:   Type: All traffic, Protocol: All, Range: All,
  Destination: 0.0.0.0/0   These security rules impact an internal network interface that is
  not exposed publicly.
"""
function add_ip_routes(
    DirectoryId, IpRoutes; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "AddIpRoutes",
        Dict{String,Any}("DirectoryId" => DirectoryId, "IpRoutes" => IpRoutes);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_ip_routes(
    DirectoryId,
    IpRoutes,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "AddIpRoutes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DirectoryId" => DirectoryId, "IpRoutes" => IpRoutes),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_region(directory_id, region_name, vpcsettings)
    add_region(directory_id, region_name, vpcsettings, params::Dict{String,<:Any})

Adds two domain controllers in the specified Region for the specified directory.

# Arguments
- `directory_id`: The identifier of the directory to which you want to add Region
  replication.
- `region_name`: The name of the Region where you want to add domain controllers for
  replication. For example, us-east-1.
- `vpcsettings`:

"""
function add_region(
    DirectoryId, RegionName, VPCSettings; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "AddRegion",
        Dict{String,Any}(
            "DirectoryId" => DirectoryId,
            "RegionName" => RegionName,
            "VPCSettings" => VPCSettings,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_region(
    DirectoryId,
    RegionName,
    VPCSettings,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "AddRegion",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DirectoryId" => DirectoryId,
                    "RegionName" => RegionName,
                    "VPCSettings" => VPCSettings,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_tags_to_resource(resource_id, tags)
    add_tags_to_resource(resource_id, tags, params::Dict{String,<:Any})

Adds or overwrites one or more tags for the specified directory. Each directory can have a
maximum of 50 tags. Each tag consists of a key and optional value. Tag keys must be unique
to each resource.

# Arguments
- `resource_id`: Identifier (ID) for the directory to which to add the tag.
- `tags`: The tags to be assigned to the directory.

"""
function add_tags_to_resource(
    ResourceId, Tags; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "AddTagsToResource",
        Dict{String,Any}("ResourceId" => ResourceId, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_tags_to_resource(
    ResourceId,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "AddTagsToResource",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ResourceId" => ResourceId, "Tags" => Tags), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_schema_extension(directory_id, schema_extension_id)
    cancel_schema_extension(directory_id, schema_extension_id, params::Dict{String,<:Any})

Cancels an in-progress schema extension to a Microsoft AD directory. Once a schema
extension has started replicating to all domain controllers, the task can no longer be
canceled. A schema extension can be canceled during any of the following states;
Initializing, CreatingSnapshot, and UpdatingSchema.

# Arguments
- `directory_id`: The identifier of the directory whose schema extension will be canceled.
- `schema_extension_id`: The identifier of the schema extension that will be canceled.

"""
function cancel_schema_extension(
    DirectoryId, SchemaExtensionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "CancelSchemaExtension",
        Dict{String,Any}(
            "DirectoryId" => DirectoryId, "SchemaExtensionId" => SchemaExtensionId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_schema_extension(
    DirectoryId,
    SchemaExtensionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "CancelSchemaExtension",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DirectoryId" => DirectoryId, "SchemaExtensionId" => SchemaExtensionId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    connect_directory(connect_settings, name, password, size)
    connect_directory(connect_settings, name, password, size, params::Dict{String,<:Any})

Creates an AD Connector to connect to a self-managed directory. Before you call
ConnectDirectory, ensure that all of the required permissions have been explicitly granted
through a policy. For details about what permissions are required to run the
ConnectDirectory operation, see Directory Service API Permissions: Actions, Resources, and
Conditions Reference.

# Arguments
- `connect_settings`: A DirectoryConnectSettings object that contains additional
  information for the operation.
- `name`: The fully qualified name of your self-managed directory, such as corp.example.com.
- `password`: The password for your self-managed user account.
- `size`: The size of the directory.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description for the directory.
- `"ShortName"`: The NetBIOS name of your self-managed directory, such as CORP.
- `"Tags"`: The tags to be assigned to AD Connector.
"""
function connect_directory(
    ConnectSettings,
    Name,
    Password,
    Size;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "ConnectDirectory",
        Dict{String,Any}(
            "ConnectSettings" => ConnectSettings,
            "Name" => Name,
            "Password" => Password,
            "Size" => Size,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function connect_directory(
    ConnectSettings,
    Name,
    Password,
    Size,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "ConnectDirectory",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConnectSettings" => ConnectSettings,
                    "Name" => Name,
                    "Password" => Password,
                    "Size" => Size,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_alias(alias, directory_id)
    create_alias(alias, directory_id, params::Dict{String,<:Any})

Creates an alias for a directory and assigns the alias to the directory. The alias is used
to construct the access URL for the directory, such as http://&lt;alias&gt;.awsapps.com.
After an alias has been created, it cannot be deleted or reused, so this operation should
only be used when absolutely necessary.

# Arguments
- `alias`: The requested alias. The alias must be unique amongst all aliases in Amazon Web
  Services. This operation throws an EntityAlreadyExistsException error if the alias already
  exists.
- `directory_id`: The identifier of the directory for which to create the alias.

"""
function create_alias(
    Alias, DirectoryId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "CreateAlias",
        Dict{String,Any}("Alias" => Alias, "DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_alias(
    Alias,
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "CreateAlias",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Alias" => Alias, "DirectoryId" => DirectoryId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_computer(computer_name, directory_id, password)
    create_computer(computer_name, directory_id, password, params::Dict{String,<:Any})

Creates an Active Directory computer object in the specified directory.

# Arguments
- `computer_name`: The name of the computer account.
- `directory_id`: The identifier of the directory in which to create the computer account.
- `password`: A one-time password that is used to join the computer to the directory. You
  should generate a random, strong password to use for this parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ComputerAttributes"`: An array of Attribute objects that contain any LDAP attributes to
  apply to the computer account.
- `"OrganizationalUnitDistinguishedName"`: The fully-qualified distinguished name of the
  organizational unit to place the computer account in.
"""
function create_computer(
    ComputerName, DirectoryId, Password; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "CreateComputer",
        Dict{String,Any}(
            "ComputerName" => ComputerName,
            "DirectoryId" => DirectoryId,
            "Password" => Password,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_computer(
    ComputerName,
    DirectoryId,
    Password,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "CreateComputer",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ComputerName" => ComputerName,
                    "DirectoryId" => DirectoryId,
                    "Password" => Password,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_conditional_forwarder(directory_id, dns_ip_addrs, remote_domain_name)
    create_conditional_forwarder(directory_id, dns_ip_addrs, remote_domain_name, params::Dict{String,<:Any})

Creates a conditional forwarder associated with your Amazon Web Services directory.
Conditional forwarders are required in order to set up a trust relationship with another
domain. The conditional forwarder points to the trusted domain.

# Arguments
- `directory_id`: The directory ID of the Amazon Web Services directory for which you are
  creating the conditional forwarder.
- `dns_ip_addrs`: The IP addresses of the remote DNS server associated with
  RemoteDomainName.
- `remote_domain_name`: The fully qualified domain name (FQDN) of the remote domain with
  which you will set up a trust relationship.

"""
function create_conditional_forwarder(
    DirectoryId,
    DnsIpAddrs,
    RemoteDomainName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "CreateConditionalForwarder",
        Dict{String,Any}(
            "DirectoryId" => DirectoryId,
            "DnsIpAddrs" => DnsIpAddrs,
            "RemoteDomainName" => RemoteDomainName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_conditional_forwarder(
    DirectoryId,
    DnsIpAddrs,
    RemoteDomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "CreateConditionalForwarder",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DirectoryId" => DirectoryId,
                    "DnsIpAddrs" => DnsIpAddrs,
                    "RemoteDomainName" => RemoteDomainName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_directory(name, password, size)
    create_directory(name, password, size, params::Dict{String,<:Any})

Creates a Simple AD directory. For more information, see Simple Active Directory in the
Directory Service Admin Guide. Before you call CreateDirectory, ensure that all of the
required permissions have been explicitly granted through a policy. For details about what
permissions are required to run the CreateDirectory operation, see Directory Service API
Permissions: Actions, Resources, and Conditions Reference.

# Arguments
- `name`: The fully qualified name for the directory, such as corp.example.com.
- `password`: The password for the directory administrator. The directory creation process
  creates a directory administrator account with the user name Administrator and this
  password. If you need to change the password for the administrator account, you can use the
  ResetUserPassword API call. The regex pattern for this string is made up of the following
  conditions:   Length (?=^.{8,64}) – Must be between 8 and 64 characters   AND any 3 of
  the following password complexity rules required by Active Directory:   Numbers and upper
  case and lowercase (?=.*d)(?=.*[A-Z])(?=.*[a-z])   Numbers and special characters and lower
  case (?=.*d)(?=.*[^A-Za-z0-9s])(?=.*[a-z])   Special characters and upper case and lower
  case (?=.*[^A-Za-z0-9s])(?=.*[A-Z])(?=.*[a-z])   Numbers and upper case and special
  characters (?=.*d)(?=.*[A-Z])(?=.*[^A-Za-z0-9s])   For additional information about how
  Active Directory passwords are enforced, see Password must meet complexity requirements on
  the Microsoft website.
- `size`: The size of the directory.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description for the directory.
- `"ShortName"`: The NetBIOS name of the directory, such as CORP.
- `"Tags"`: The tags to be assigned to the Simple AD directory.
- `"VpcSettings"`: A DirectoryVpcSettings object that contains additional information for
  the operation.
"""
function create_directory(
    Name, Password, Size; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "CreateDirectory",
        Dict{String,Any}("Name" => Name, "Password" => Password, "Size" => Size);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_directory(
    Name,
    Password,
    Size,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "CreateDirectory",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Name" => Name, "Password" => Password, "Size" => Size),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_log_subscription(directory_id, log_group_name)
    create_log_subscription(directory_id, log_group_name, params::Dict{String,<:Any})

Creates a subscription to forward real-time Directory Service domain controller security
logs to the specified Amazon CloudWatch log group in your Amazon Web Services account.

# Arguments
- `directory_id`: Identifier of the directory to which you want to subscribe and receive
  real-time logs to your specified CloudWatch log group.
- `log_group_name`: The name of the CloudWatch log group where the real-time domain
  controller logs are forwarded.

"""
function create_log_subscription(
    DirectoryId, LogGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "CreateLogSubscription",
        Dict{String,Any}("DirectoryId" => DirectoryId, "LogGroupName" => LogGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_log_subscription(
    DirectoryId,
    LogGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "CreateLogSubscription",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DirectoryId" => DirectoryId, "LogGroupName" => LogGroupName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_microsoft_ad(name, password, vpc_settings)
    create_microsoft_ad(name, password, vpc_settings, params::Dict{String,<:Any})

Creates a Microsoft AD directory in the Amazon Web Services Cloud. For more information,
see Managed Microsoft AD in the Directory Service Admin Guide. Before you call
CreateMicrosoftAD, ensure that all of the required permissions have been explicitly granted
through a policy. For details about what permissions are required to run the
CreateMicrosoftAD operation, see Directory Service API Permissions: Actions, Resources, and
Conditions Reference.

# Arguments
- `name`: The fully qualified domain name for the Managed Microsoft AD directory, such as
  corp.example.com. This name will resolve inside your VPC only. It does not need to be
  publicly resolvable.
- `password`: The password for the default administrative user named Admin. If you need to
  change the password for the administrator account, you can use the ResetUserPassword API
  call.
- `vpc_settings`: Contains VPC information for the CreateDirectory or CreateMicrosoftAD
  operation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description for the directory. This label will appear on the Amazon
  Web Services console Directory Details page after the directory is created.
- `"Edition"`: Managed Microsoft AD is available in two editions: Standard and Enterprise.
  Enterprise is the default.
- `"ShortName"`: The NetBIOS name for your domain, such as CORP. If you don't specify a
  NetBIOS name, it will default to the first part of your directory DNS. For example, CORP
  for the directory DNS corp.example.com.
- `"Tags"`: The tags to be assigned to the Managed Microsoft AD directory.
"""
function create_microsoft_ad(
    Name, Password, VpcSettings; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "CreateMicrosoftAD",
        Dict{String,Any}(
            "Name" => Name, "Password" => Password, "VpcSettings" => VpcSettings
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_microsoft_ad(
    Name,
    Password,
    VpcSettings,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "CreateMicrosoftAD",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Name" => Name, "Password" => Password, "VpcSettings" => VpcSettings
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_snapshot(directory_id)
    create_snapshot(directory_id, params::Dict{String,<:Any})

Creates a snapshot of a Simple AD or Microsoft AD directory in the Amazon Web Services
cloud.  You cannot take snapshots of AD Connector directories.

# Arguments
- `directory_id`: The identifier of the directory of which to take a snapshot.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Name"`: The descriptive name to apply to the snapshot.
"""
function create_snapshot(DirectoryId; aws_config::AbstractAWSConfig=current_aws_config())
    return directory_service(
        "CreateSnapshot",
        Dict{String,Any}("DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_snapshot(
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "CreateSnapshot",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DirectoryId" => DirectoryId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_trust(directory_id, remote_domain_name, trust_direction, trust_password)
    create_trust(directory_id, remote_domain_name, trust_direction, trust_password, params::Dict{String,<:Any})

Directory Service for Microsoft Active Directory allows you to configure trust
relationships. For example, you can establish a trust between your Managed Microsoft AD
directory, and your existing self-managed Microsoft Active Directory. This would allow you
to provide users and groups access to resources in either domain, with a single set of
credentials. This action initiates the creation of the Amazon Web Services side of a trust
relationship between an Managed Microsoft AD directory and an external domain. You can
create either a forest trust or an external trust.

# Arguments
- `directory_id`: The Directory ID of the Managed Microsoft AD directory for which to
  establish the trust relationship.
- `remote_domain_name`: The Fully Qualified Domain Name (FQDN) of the external domain for
  which to create the trust relationship.
- `trust_direction`: The direction of the trust relationship.
- `trust_password`: The trust password. The must be the same password that was used when
  creating the trust relationship on the external domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConditionalForwarderIpAddrs"`: The IP addresses of the remote DNS server associated
  with RemoteDomainName.
- `"SelectiveAuth"`: Optional parameter to enable selective authentication for the trust.
- `"TrustType"`: The trust relationship type. Forest is the default.
"""
function create_trust(
    DirectoryId,
    RemoteDomainName,
    TrustDirection,
    TrustPassword;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "CreateTrust",
        Dict{String,Any}(
            "DirectoryId" => DirectoryId,
            "RemoteDomainName" => RemoteDomainName,
            "TrustDirection" => TrustDirection,
            "TrustPassword" => TrustPassword,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_trust(
    DirectoryId,
    RemoteDomainName,
    TrustDirection,
    TrustPassword,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "CreateTrust",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DirectoryId" => DirectoryId,
                    "RemoteDomainName" => RemoteDomainName,
                    "TrustDirection" => TrustDirection,
                    "TrustPassword" => TrustPassword,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_conditional_forwarder(directory_id, remote_domain_name)
    delete_conditional_forwarder(directory_id, remote_domain_name, params::Dict{String,<:Any})

Deletes a conditional forwarder that has been set up for your Amazon Web Services directory.

# Arguments
- `directory_id`: The directory ID for which you are deleting the conditional forwarder.
- `remote_domain_name`: The fully qualified domain name (FQDN) of the remote domain with
  which you are deleting the conditional forwarder.

"""
function delete_conditional_forwarder(
    DirectoryId, RemoteDomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "DeleteConditionalForwarder",
        Dict{String,Any}(
            "DirectoryId" => DirectoryId, "RemoteDomainName" => RemoteDomainName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_conditional_forwarder(
    DirectoryId,
    RemoteDomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "DeleteConditionalForwarder",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DirectoryId" => DirectoryId, "RemoteDomainName" => RemoteDomainName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_directory(directory_id)
    delete_directory(directory_id, params::Dict{String,<:Any})

Deletes an Directory Service directory. Before you call DeleteDirectory, ensure that all of
the required permissions have been explicitly granted through a policy. For details about
what permissions are required to run the DeleteDirectory operation, see Directory Service
API Permissions: Actions, Resources, and Conditions Reference.

# Arguments
- `directory_id`: The identifier of the directory to delete.

"""
function delete_directory(DirectoryId; aws_config::AbstractAWSConfig=current_aws_config())
    return directory_service(
        "DeleteDirectory",
        Dict{String,Any}("DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_directory(
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "DeleteDirectory",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DirectoryId" => DirectoryId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_log_subscription(directory_id)
    delete_log_subscription(directory_id, params::Dict{String,<:Any})

Deletes the specified log subscription.

# Arguments
- `directory_id`: Identifier of the directory whose log subscription you want to delete.

"""
function delete_log_subscription(
    DirectoryId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "DeleteLogSubscription",
        Dict{String,Any}("DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_log_subscription(
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "DeleteLogSubscription",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DirectoryId" => DirectoryId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_snapshot(snapshot_id)
    delete_snapshot(snapshot_id, params::Dict{String,<:Any})

Deletes a directory snapshot.

# Arguments
- `snapshot_id`: The identifier of the directory snapshot to be deleted.

"""
function delete_snapshot(SnapshotId; aws_config::AbstractAWSConfig=current_aws_config())
    return directory_service(
        "DeleteSnapshot",
        Dict{String,Any}("SnapshotId" => SnapshotId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_snapshot(
    SnapshotId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "DeleteSnapshot",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SnapshotId" => SnapshotId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_trust(trust_id)
    delete_trust(trust_id, params::Dict{String,<:Any})

Deletes an existing trust relationship between your Managed Microsoft AD directory and an
external domain.

# Arguments
- `trust_id`: The Trust ID of the trust relationship to be deleted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeleteAssociatedConditionalForwarder"`: Delete a conditional forwarder as part of a
  DeleteTrustRequest.
"""
function delete_trust(TrustId; aws_config::AbstractAWSConfig=current_aws_config())
    return directory_service(
        "DeleteTrust",
        Dict{String,Any}("TrustId" => TrustId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_trust(
    TrustId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "DeleteTrust",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("TrustId" => TrustId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_certificate(certificate_id, directory_id)
    deregister_certificate(certificate_id, directory_id, params::Dict{String,<:Any})

Deletes from the system the certificate that was registered for secure LDAP or client
certificate authentication.

# Arguments
- `certificate_id`: The identifier of the certificate.
- `directory_id`: The identifier of the directory.

"""
function deregister_certificate(
    CertificateId, DirectoryId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "DeregisterCertificate",
        Dict{String,Any}("CertificateId" => CertificateId, "DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_certificate(
    CertificateId,
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "DeregisterCertificate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CertificateId" => CertificateId, "DirectoryId" => DirectoryId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_event_topic(directory_id, topic_name)
    deregister_event_topic(directory_id, topic_name, params::Dict{String,<:Any})

Removes the specified directory as a publisher to the specified Amazon SNS topic.

# Arguments
- `directory_id`: The Directory ID to remove as a publisher. This directory will no longer
  send messages to the specified Amazon SNS topic.
- `topic_name`: The name of the Amazon SNS topic from which to remove the directory as a
  publisher.

"""
function deregister_event_topic(
    DirectoryId, TopicName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "DeregisterEventTopic",
        Dict{String,Any}("DirectoryId" => DirectoryId, "TopicName" => TopicName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_event_topic(
    DirectoryId,
    TopicName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "DeregisterEventTopic",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DirectoryId" => DirectoryId, "TopicName" => TopicName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_certificate(certificate_id, directory_id)
    describe_certificate(certificate_id, directory_id, params::Dict{String,<:Any})

Displays information about the certificate registered for secure LDAP or client certificate
authentication.

# Arguments
- `certificate_id`: The identifier of the certificate.
- `directory_id`: The identifier of the directory.

"""
function describe_certificate(
    CertificateId, DirectoryId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "DescribeCertificate",
        Dict{String,Any}("CertificateId" => CertificateId, "DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_certificate(
    CertificateId,
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "DescribeCertificate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CertificateId" => CertificateId, "DirectoryId" => DirectoryId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_client_authentication_settings(directory_id)
    describe_client_authentication_settings(directory_id, params::Dict{String,<:Any})

Retrieves information about the type of client authentication for the specified directory,
if the type is specified. If no type is specified, information about all client
authentication types that are supported for the specified directory is retrieved.
Currently, only SmartCard is supported.

# Arguments
- `directory_id`: The identifier of the directory for which to retrieve information.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The maximum number of items to return. If this value is zero, the maximum
  number of items is specified by the limitations of the operation.
- `"NextToken"`: The DescribeClientAuthenticationSettingsResult.NextToken value from a
  previous call to DescribeClientAuthenticationSettings. Pass null if this is the first call.
- `"Type"`: The type of client authentication for which to retrieve information. If no type
  is specified, a list of all client authentication types that are supported for the
  specified directory is retrieved.
"""
function describe_client_authentication_settings(
    DirectoryId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "DescribeClientAuthenticationSettings",
        Dict{String,Any}("DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_client_authentication_settings(
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "DescribeClientAuthenticationSettings",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DirectoryId" => DirectoryId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_conditional_forwarders(directory_id)
    describe_conditional_forwarders(directory_id, params::Dict{String,<:Any})

Obtains information about the conditional forwarders for this account. If no input
parameters are provided for RemoteDomainNames, this request describes all conditional
forwarders for the specified directory ID.

# Arguments
- `directory_id`: The directory ID for which to get the list of associated conditional
  forwarders.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"RemoteDomainNames"`: The fully qualified domain names (FQDN) of the remote domains for
  which to get the list of associated conditional forwarders. If this member is null, all
  conditional forwarders are returned.
"""
function describe_conditional_forwarders(
    DirectoryId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "DescribeConditionalForwarders",
        Dict{String,Any}("DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_conditional_forwarders(
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "DescribeConditionalForwarders",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DirectoryId" => DirectoryId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_directories()
    describe_directories(params::Dict{String,<:Any})

Obtains information about the directories that belong to this account. You can retrieve
information about specific directories by passing the directory identifiers in the
DirectoryIds parameter. Otherwise, all directories that belong to the current account are
returned. This operation supports pagination with the use of the NextToken request and
response parameters. If more results are available, the DescribeDirectoriesResult.NextToken
member contains a token that you pass in the next call to DescribeDirectories to retrieve
the next set of items. You can also specify a maximum number of return results with the
Limit parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DirectoryIds"`: A list of identifiers of the directories for which to obtain the
  information. If this member is null, all directories that belong to the current account are
  returned. An empty list results in an InvalidParameterException being thrown.
- `"Limit"`: The maximum number of items to return. If this value is zero, the maximum
  number of items is specified by the limitations of the operation.
- `"NextToken"`: The DescribeDirectoriesResult.NextToken value from a previous call to
  DescribeDirectories. Pass null if this is the first call.
"""
function describe_directories(; aws_config::AbstractAWSConfig=current_aws_config())
    return directory_service(
        "DescribeDirectories"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_directories(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "DescribeDirectories",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_domain_controllers(directory_id)
    describe_domain_controllers(directory_id, params::Dict{String,<:Any})

Provides information about any domain controllers in your directory.

# Arguments
- `directory_id`: Identifier of the directory for which to retrieve the domain controller
  information.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DomainControllerIds"`: A list of identifiers for the domain controllers whose
  information will be provided.
- `"Limit"`: The maximum number of items to return.
- `"NextToken"`: The DescribeDomainControllers.NextToken value from a previous call to
  DescribeDomainControllers. Pass null if this is the first call.
"""
function describe_domain_controllers(
    DirectoryId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "DescribeDomainControllers",
        Dict{String,Any}("DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_domain_controllers(
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "DescribeDomainControllers",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DirectoryId" => DirectoryId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_event_topics()
    describe_event_topics(params::Dict{String,<:Any})

Obtains information about which Amazon SNS topics receive status messages from the
specified directory. If no input parameters are provided, such as DirectoryId or TopicName,
this request describes all of the associations in the account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DirectoryId"`: The Directory ID for which to get the list of associated Amazon SNS
  topics. If this member is null, associations for all Directory IDs are returned.
- `"TopicNames"`: A list of Amazon SNS topic names for which to obtain the information. If
  this member is null, all associations for the specified Directory ID are returned. An empty
  list results in an InvalidParameterException being thrown.
"""
function describe_event_topics(; aws_config::AbstractAWSConfig=current_aws_config())
    return directory_service(
        "DescribeEventTopics"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_event_topics(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "DescribeEventTopics",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_ldapssettings(directory_id)
    describe_ldapssettings(directory_id, params::Dict{String,<:Any})

Describes the status of LDAP security for the specified directory.

# Arguments
- `directory_id`: The identifier of the directory.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies the number of items that should be displayed on one page.
- `"NextToken"`: The type of next token used for pagination.
- `"Type"`: The type of LDAP security to enable. Currently only the value Client is
  supported.
"""
function describe_ldapssettings(
    DirectoryId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "DescribeLDAPSSettings",
        Dict{String,Any}("DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_ldapssettings(
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "DescribeLDAPSSettings",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DirectoryId" => DirectoryId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_regions(directory_id)
    describe_regions(directory_id, params::Dict{String,<:Any})

Provides information about the Regions that are configured for multi-Region replication.

# Arguments
- `directory_id`: The identifier of the directory.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: The DescribeRegionsResult.NextToken value from a previous call to
  DescribeRegions. Pass null if this is the first call.
- `"RegionName"`: The name of the Region. For example, us-east-1.
"""
function describe_regions(DirectoryId; aws_config::AbstractAWSConfig=current_aws_config())
    return directory_service(
        "DescribeRegions",
        Dict{String,Any}("DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_regions(
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "DescribeRegions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DirectoryId" => DirectoryId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_settings(directory_id)
    describe_settings(directory_id, params::Dict{String,<:Any})

Retrieves information about the configurable settings for the specified directory.

# Arguments
- `directory_id`: The identifier of the directory for which to retrieve information.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: The DescribeSettingsResult.NextToken value from a previous call to
  DescribeSettings. Pass null if this is the first call.
- `"Status"`: The status of the directory settings for which to retrieve information.
"""
function describe_settings(DirectoryId; aws_config::AbstractAWSConfig=current_aws_config())
    return directory_service(
        "DescribeSettings",
        Dict{String,Any}("DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_settings(
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "DescribeSettings",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DirectoryId" => DirectoryId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_shared_directories(owner_directory_id)
    describe_shared_directories(owner_directory_id, params::Dict{String,<:Any})

Returns the shared directories in your account.

# Arguments
- `owner_directory_id`: Returns the identifier of the directory in the directory owner
  account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The number of shared directories to return in the response object.
- `"NextToken"`: The DescribeSharedDirectoriesResult.NextToken value from a previous call
  to DescribeSharedDirectories. Pass null if this is the first call.
- `"SharedDirectoryIds"`: A list of identifiers of all shared directories in your account.
"""
function describe_shared_directories(
    OwnerDirectoryId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "DescribeSharedDirectories",
        Dict{String,Any}("OwnerDirectoryId" => OwnerDirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_shared_directories(
    OwnerDirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "DescribeSharedDirectories",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("OwnerDirectoryId" => OwnerDirectoryId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_snapshots()
    describe_snapshots(params::Dict{String,<:Any})

Obtains information about the directory snapshots that belong to this account. This
operation supports pagination with the use of the NextToken request and response
parameters. If more results are available, the DescribeSnapshots.NextToken member contains
a token that you pass in the next call to DescribeSnapshots to retrieve the next set of
items. You can also specify a maximum number of return results with the Limit parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DirectoryId"`: The identifier of the directory for which to retrieve snapshot
  information.
- `"Limit"`: The maximum number of objects to return.
- `"NextToken"`: The DescribeSnapshotsResult.NextToken value from a previous call to
  DescribeSnapshots. Pass null if this is the first call.
- `"SnapshotIds"`: A list of identifiers of the snapshots to obtain the information for. If
  this member is null or empty, all snapshots are returned using the Limit and NextToken
  members.
"""
function describe_snapshots(; aws_config::AbstractAWSConfig=current_aws_config())
    return directory_service(
        "DescribeSnapshots"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_snapshots(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "DescribeSnapshots", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_trusts()
    describe_trusts(params::Dict{String,<:Any})

Obtains information about the trust relationships for this account. If no input parameters
are provided, such as DirectoryId or TrustIds, this request describes all the trust
relationships belonging to the account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DirectoryId"`: The Directory ID of the Amazon Web Services directory that is a part of
  the requested trust relationship.
- `"Limit"`: The maximum number of objects to return.
- `"NextToken"`: The DescribeTrustsResult.NextToken value from a previous call to
  DescribeTrusts. Pass null if this is the first call.
- `"TrustIds"`: A list of identifiers of the trust relationships for which to obtain the
  information. If this member is null, all trust relationships that belong to the current
  account are returned. An empty list results in an InvalidParameterException being thrown.
"""
function describe_trusts(; aws_config::AbstractAWSConfig=current_aws_config())
    return directory_service(
        "DescribeTrusts"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_trusts(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "DescribeTrusts", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_update_directory(directory_id, update_type)
    describe_update_directory(directory_id, update_type, params::Dict{String,<:Any})

 Describes the updates of a directory for a particular update type.

# Arguments
- `directory_id`:  The unique identifier of the directory.
- `update_type`:  The type of updates you want to describe for the directory.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`:  The DescribeUpdateDirectoryResult. NextToken value from a previous call
  to DescribeUpdateDirectory. Pass null if this is the first call.
- `"RegionName"`:  The name of the Region.
"""
function describe_update_directory(
    DirectoryId, UpdateType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "DescribeUpdateDirectory",
        Dict{String,Any}("DirectoryId" => DirectoryId, "UpdateType" => UpdateType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_update_directory(
    DirectoryId,
    UpdateType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "DescribeUpdateDirectory",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DirectoryId" => DirectoryId, "UpdateType" => UpdateType),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_client_authentication(directory_id, type)
    disable_client_authentication(directory_id, type, params::Dict{String,<:Any})

Disables alternative client authentication methods for the specified directory.

# Arguments
- `directory_id`: The identifier of the directory
- `type`: The type of client authentication to disable. Currently, only the parameter,
  SmartCard is supported.

"""
function disable_client_authentication(
    DirectoryId, Type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "DisableClientAuthentication",
        Dict{String,Any}("DirectoryId" => DirectoryId, "Type" => Type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_client_authentication(
    DirectoryId,
    Type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "DisableClientAuthentication",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DirectoryId" => DirectoryId, "Type" => Type),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_ldaps(directory_id, type)
    disable_ldaps(directory_id, type, params::Dict{String,<:Any})

Deactivates LDAP secure calls for the specified directory.

# Arguments
- `directory_id`: The identifier of the directory.
- `type`: The type of LDAP security to enable. Currently only the value Client is supported.

"""
function disable_ldaps(
    DirectoryId, Type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "DisableLDAPS",
        Dict{String,Any}("DirectoryId" => DirectoryId, "Type" => Type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_ldaps(
    DirectoryId,
    Type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "DisableLDAPS",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DirectoryId" => DirectoryId, "Type" => Type),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_radius(directory_id)
    disable_radius(directory_id, params::Dict{String,<:Any})

Disables multi-factor authentication (MFA) with the Remote Authentication Dial In User
Service (RADIUS) server for an AD Connector or Microsoft AD directory.

# Arguments
- `directory_id`: The identifier of the directory for which to disable MFA.

"""
function disable_radius(DirectoryId; aws_config::AbstractAWSConfig=current_aws_config())
    return directory_service(
        "DisableRadius",
        Dict{String,Any}("DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_radius(
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "DisableRadius",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DirectoryId" => DirectoryId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_sso(directory_id)
    disable_sso(directory_id, params::Dict{String,<:Any})

Disables single-sign on for a directory.

# Arguments
- `directory_id`: The identifier of the directory for which to disable single-sign on.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Password"`: The password of an alternate account to use to disable single-sign on. This
  is only used for AD Connector directories. For more information, see the UserName parameter.
- `"UserName"`: The username of an alternate account to use to disable single-sign on. This
  is only used for AD Connector directories. This account must have privileges to remove a
  service principal name. If the AD Connector service account does not have privileges to
  remove a service principal name, you can specify an alternate account with the UserName and
  Password parameters. These credentials are only used to disable single sign-on and are not
  stored by the service. The AD Connector service account is not changed.
"""
function disable_sso(DirectoryId; aws_config::AbstractAWSConfig=current_aws_config())
    return directory_service(
        "DisableSso",
        Dict{String,Any}("DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_sso(
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "DisableSso",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DirectoryId" => DirectoryId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_client_authentication(directory_id, type)
    enable_client_authentication(directory_id, type, params::Dict{String,<:Any})

Enables alternative client authentication methods for the specified directory.

# Arguments
- `directory_id`: The identifier of the specified directory.
- `type`: The type of client authentication to enable. Currently only the value SmartCard
  is supported. Smart card authentication in AD Connector requires that you enable Kerberos
  Constrained Delegation for the Service User to the LDAP service in your self-managed AD.

"""
function enable_client_authentication(
    DirectoryId, Type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "EnableClientAuthentication",
        Dict{String,Any}("DirectoryId" => DirectoryId, "Type" => Type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_client_authentication(
    DirectoryId,
    Type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "EnableClientAuthentication",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DirectoryId" => DirectoryId, "Type" => Type),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_ldaps(directory_id, type)
    enable_ldaps(directory_id, type, params::Dict{String,<:Any})

Activates the switch for the specific directory to always use LDAP secure calls.

# Arguments
- `directory_id`: The identifier of the directory.
- `type`: The type of LDAP security to enable. Currently only the value Client is supported.

"""
function enable_ldaps(DirectoryId, Type; aws_config::AbstractAWSConfig=current_aws_config())
    return directory_service(
        "EnableLDAPS",
        Dict{String,Any}("DirectoryId" => DirectoryId, "Type" => Type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_ldaps(
    DirectoryId,
    Type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "EnableLDAPS",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DirectoryId" => DirectoryId, "Type" => Type),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_radius(directory_id, radius_settings)
    enable_radius(directory_id, radius_settings, params::Dict{String,<:Any})

Enables multi-factor authentication (MFA) with the Remote Authentication Dial In User
Service (RADIUS) server for an AD Connector or Microsoft AD directory.

# Arguments
- `directory_id`: The identifier of the directory for which to enable MFA.
- `radius_settings`: A RadiusSettings object that contains information about the RADIUS
  server.

"""
function enable_radius(
    DirectoryId, RadiusSettings; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "EnableRadius",
        Dict{String,Any}("DirectoryId" => DirectoryId, "RadiusSettings" => RadiusSettings);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_radius(
    DirectoryId,
    RadiusSettings,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "EnableRadius",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DirectoryId" => DirectoryId, "RadiusSettings" => RadiusSettings
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_sso(directory_id)
    enable_sso(directory_id, params::Dict{String,<:Any})

Enables single sign-on for a directory. Single sign-on allows users in your directory to
access certain Amazon Web Services services from a computer joined to the directory without
having to enter their credentials separately.

# Arguments
- `directory_id`: The identifier of the directory for which to enable single-sign on.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Password"`: The password of an alternate account to use to enable single-sign on. This
  is only used for AD Connector directories. For more information, see the UserName parameter.
- `"UserName"`: The username of an alternate account to use to enable single-sign on. This
  is only used for AD Connector directories. This account must have privileges to add a
  service principal name. If the AD Connector service account does not have privileges to add
  a service principal name, you can specify an alternate account with the UserName and
  Password parameters. These credentials are only used to enable single sign-on and are not
  stored by the service. The AD Connector service account is not changed.
"""
function enable_sso(DirectoryId; aws_config::AbstractAWSConfig=current_aws_config())
    return directory_service(
        "EnableSso",
        Dict{String,Any}("DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_sso(
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "EnableSso",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DirectoryId" => DirectoryId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_directory_limits()
    get_directory_limits(params::Dict{String,<:Any})

Obtains directory limit information for the current Region.

"""
function get_directory_limits(; aws_config::AbstractAWSConfig=current_aws_config())
    return directory_service(
        "GetDirectoryLimits"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_directory_limits(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "GetDirectoryLimits", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_snapshot_limits(directory_id)
    get_snapshot_limits(directory_id, params::Dict{String,<:Any})

Obtains the manual snapshot limits for a directory.

# Arguments
- `directory_id`: Contains the identifier of the directory to obtain the limits for.

"""
function get_snapshot_limits(
    DirectoryId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "GetSnapshotLimits",
        Dict{String,Any}("DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_snapshot_limits(
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "GetSnapshotLimits",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DirectoryId" => DirectoryId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_certificates(directory_id)
    list_certificates(directory_id, params::Dict{String,<:Any})

For the specified directory, lists all the certificates registered for a secure LDAP or
client certificate authentication.

# Arguments
- `directory_id`: The identifier of the directory.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The number of items that should show up on one page
- `"NextToken"`: A token for requesting another page of certificates if the NextToken
  response element indicates that more certificates are available. Use the value of the
  returned NextToken element in your request until the token comes back as null. Pass null if
  this is the first call.
"""
function list_certificates(DirectoryId; aws_config::AbstractAWSConfig=current_aws_config())
    return directory_service(
        "ListCertificates",
        Dict{String,Any}("DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_certificates(
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "ListCertificates",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DirectoryId" => DirectoryId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_ip_routes(directory_id)
    list_ip_routes(directory_id, params::Dict{String,<:Any})

Lists the address blocks that you have added to a directory.

# Arguments
- `directory_id`: Identifier (ID) of the directory for which you want to retrieve the IP
  addresses.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Maximum number of items to return. If this value is zero, the maximum number
  of items is specified by the limitations of the operation.
- `"NextToken"`: The ListIpRoutes.NextToken value from a previous call to ListIpRoutes.
  Pass null if this is the first call.
"""
function list_ip_routes(DirectoryId; aws_config::AbstractAWSConfig=current_aws_config())
    return directory_service(
        "ListIpRoutes",
        Dict{String,Any}("DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_ip_routes(
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "ListIpRoutes",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DirectoryId" => DirectoryId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_log_subscriptions()
    list_log_subscriptions(params::Dict{String,<:Any})

Lists the active log subscriptions for the Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DirectoryId"`: If a DirectoryID is provided, lists only the log subscription associated
  with that directory. If no DirectoryId is provided, lists all log subscriptions associated
  with your Amazon Web Services account. If there are no log subscriptions for the Amazon Web
  Services account or the directory, an empty list will be returned.
- `"Limit"`: The maximum number of items returned.
- `"NextToken"`: The token for the next set of items to return.
"""
function list_log_subscriptions(; aws_config::AbstractAWSConfig=current_aws_config())
    return directory_service(
        "ListLogSubscriptions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_log_subscriptions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "ListLogSubscriptions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_schema_extensions(directory_id)
    list_schema_extensions(directory_id, params::Dict{String,<:Any})

Lists all schema extensions applied to a Microsoft AD Directory.

# Arguments
- `directory_id`: The identifier of the directory from which to retrieve the schema
  extension information.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The maximum number of items to return.
- `"NextToken"`: The ListSchemaExtensions.NextToken value from a previous call to
  ListSchemaExtensions. Pass null if this is the first call.
"""
function list_schema_extensions(
    DirectoryId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "ListSchemaExtensions",
        Dict{String,Any}("DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_schema_extensions(
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "ListSchemaExtensions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DirectoryId" => DirectoryId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_id)
    list_tags_for_resource(resource_id, params::Dict{String,<:Any})

Lists all tags on a directory.

# Arguments
- `resource_id`: Identifier (ID) of the directory for which you want to retrieve tags.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Reserved for future use.
- `"NextToken"`: Reserved for future use.
"""
function list_tags_for_resource(
    ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "ListTagsForResource",
        Dict{String,Any}("ResourceId" => ResourceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceId" => ResourceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_certificate(certificate_data, directory_id)
    register_certificate(certificate_data, directory_id, params::Dict{String,<:Any})

Registers a certificate for a secure LDAP or client certificate authentication.

# Arguments
- `certificate_data`: The certificate PEM string that needs to be registered.
- `directory_id`: The identifier of the directory.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientCertAuthSettings"`: A ClientCertAuthSettings object that contains client
  certificate authentication settings.
- `"Type"`: The function that the registered certificate performs. Valid values include
  ClientLDAPS or ClientCertAuth. The default value is ClientLDAPS.
"""
function register_certificate(
    CertificateData, DirectoryId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "RegisterCertificate",
        Dict{String,Any}(
            "CertificateData" => CertificateData, "DirectoryId" => DirectoryId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_certificate(
    CertificateData,
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "RegisterCertificate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CertificateData" => CertificateData, "DirectoryId" => DirectoryId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_event_topic(directory_id, topic_name)
    register_event_topic(directory_id, topic_name, params::Dict{String,<:Any})

Associates a directory with an Amazon SNS topic. This establishes the directory as a
publisher to the specified Amazon SNS topic. You can then receive email or text (SMS)
messages when the status of your directory changes. You get notified if your directory goes
from an Active status to an Impaired or Inoperable status. You also receive a notification
when the directory returns to an Active status.

# Arguments
- `directory_id`: The Directory ID that will publish status messages to the Amazon SNS
  topic.
- `topic_name`: The Amazon SNS topic name to which the directory will publish status
  messages. This Amazon SNS topic must be in the same region as the specified Directory ID.

"""
function register_event_topic(
    DirectoryId, TopicName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "RegisterEventTopic",
        Dict{String,Any}("DirectoryId" => DirectoryId, "TopicName" => TopicName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_event_topic(
    DirectoryId,
    TopicName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "RegisterEventTopic",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DirectoryId" => DirectoryId, "TopicName" => TopicName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reject_shared_directory(shared_directory_id)
    reject_shared_directory(shared_directory_id, params::Dict{String,<:Any})

Rejects a directory sharing request that was sent from the directory owner account.

# Arguments
- `shared_directory_id`: Identifier of the shared directory in the directory consumer
  account. This identifier is different for each directory owner account.

"""
function reject_shared_directory(
    SharedDirectoryId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "RejectSharedDirectory",
        Dict{String,Any}("SharedDirectoryId" => SharedDirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reject_shared_directory(
    SharedDirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "RejectSharedDirectory",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("SharedDirectoryId" => SharedDirectoryId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_ip_routes(cidr_ips, directory_id)
    remove_ip_routes(cidr_ips, directory_id, params::Dict{String,<:Any})

Removes IP address blocks from a directory.

# Arguments
- `cidr_ips`: IP address blocks that you want to remove.
- `directory_id`: Identifier (ID) of the directory from which you want to remove the IP
  addresses.

"""
function remove_ip_routes(
    CidrIps, DirectoryId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "RemoveIpRoutes",
        Dict{String,Any}("CidrIps" => CidrIps, "DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_ip_routes(
    CidrIps,
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "RemoveIpRoutes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CidrIps" => CidrIps, "DirectoryId" => DirectoryId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_region(directory_id)
    remove_region(directory_id, params::Dict{String,<:Any})

Stops all replication and removes the domain controllers from the specified Region. You
cannot remove the primary Region with this operation. Instead, use the DeleteDirectory API.

# Arguments
- `directory_id`: The identifier of the directory for which you want to remove Region
  replication.

"""
function remove_region(DirectoryId; aws_config::AbstractAWSConfig=current_aws_config())
    return directory_service(
        "RemoveRegion",
        Dict{String,Any}("DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_region(
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "RemoveRegion",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DirectoryId" => DirectoryId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_tags_from_resource(resource_id, tag_keys)
    remove_tags_from_resource(resource_id, tag_keys, params::Dict{String,<:Any})

Removes tags from a directory.

# Arguments
- `resource_id`: Identifier (ID) of the directory from which to remove the tag.
- `tag_keys`: The tag key (name) of the tag to be removed.

"""
function remove_tags_from_resource(
    ResourceId, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "RemoveTagsFromResource",
        Dict{String,Any}("ResourceId" => ResourceId, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_tags_from_resource(
    ResourceId,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "RemoveTagsFromResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceId" => ResourceId, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reset_user_password(directory_id, new_password, user_name)
    reset_user_password(directory_id, new_password, user_name, params::Dict{String,<:Any})

Resets the password for any user in your Managed Microsoft AD or Simple AD directory. You
can reset the password for any user in your directory with the following exceptions:   For
Simple AD, you cannot reset the password for any user that is a member of either the Domain
Admins or Enterprise Admins group except for the administrator user.   For Managed
Microsoft AD, you can only reset the password for a user that is in an OU based off of the
NetBIOS name that you typed when you created your directory. For example, you cannot reset
the password for a user in the Amazon Web Services Reserved OU. For more information about
the OU structure for an Managed Microsoft AD directory, see What Gets Created in the
Directory Service Administration Guide.

# Arguments
- `directory_id`: Identifier of the Managed Microsoft AD or Simple AD directory in which
  the user resides.
- `new_password`: The new password that will be reset.
- `user_name`: The user name of the user whose password will be reset.

"""
function reset_user_password(
    DirectoryId, NewPassword, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "ResetUserPassword",
        Dict{String,Any}(
            "DirectoryId" => DirectoryId,
            "NewPassword" => NewPassword,
            "UserName" => UserName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reset_user_password(
    DirectoryId,
    NewPassword,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "ResetUserPassword",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DirectoryId" => DirectoryId,
                    "NewPassword" => NewPassword,
                    "UserName" => UserName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_from_snapshot(snapshot_id)
    restore_from_snapshot(snapshot_id, params::Dict{String,<:Any})

Restores a directory using an existing directory snapshot. When you restore a directory
from a snapshot, any changes made to the directory after the snapshot date are overwritten.
This action returns as soon as the restore operation is initiated. You can monitor the
progress of the restore operation by calling the DescribeDirectories operation with the
directory identifier. When the DirectoryDescription.Stage value changes to Active, the
restore operation is complete.

# Arguments
- `snapshot_id`: The identifier of the snapshot to restore from.

"""
function restore_from_snapshot(
    SnapshotId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "RestoreFromSnapshot",
        Dict{String,Any}("SnapshotId" => SnapshotId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_from_snapshot(
    SnapshotId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "RestoreFromSnapshot",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SnapshotId" => SnapshotId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    share_directory(directory_id, share_method, share_target)
    share_directory(directory_id, share_method, share_target, params::Dict{String,<:Any})

Shares a specified directory (DirectoryId) in your Amazon Web Services account (directory
owner) with another Amazon Web Services account (directory consumer). With this operation
you can use your directory from any Amazon Web Services account and from any Amazon VPC
within an Amazon Web Services Region. When you share your Managed Microsoft AD directory,
Directory Service creates a shared directory in the directory consumer account. This shared
directory contains the metadata to provide access to the directory within the directory
owner account. The shared directory is visible in all VPCs in the directory consumer
account. The ShareMethod parameter determines whether the specified directory can be shared
between Amazon Web Services accounts inside the same Amazon Web Services organization
(ORGANIZATIONS). It also determines whether you can share the directory with any other
Amazon Web Services account either inside or outside of the organization (HANDSHAKE). The
ShareNotes parameter is only used when HANDSHAKE is called, which sends a directory sharing
request to the directory consumer.

# Arguments
- `directory_id`: Identifier of the Managed Microsoft AD directory that you want to share
  with other Amazon Web Services accounts.
- `share_method`: The method used when sharing a directory to determine whether the
  directory should be shared within your Amazon Web Services organization (ORGANIZATIONS) or
  with any Amazon Web Services account by sending a directory sharing request (HANDSHAKE).
- `share_target`: Identifier for the directory consumer account with whom the directory is
  to be shared.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ShareNotes"`: A directory share request that is sent by the directory owner to the
  directory consumer. The request includes a typed message to help the directory consumer
  administrator determine whether to approve or reject the share invitation.
"""
function share_directory(
    DirectoryId,
    ShareMethod,
    ShareTarget;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "ShareDirectory",
        Dict{String,Any}(
            "DirectoryId" => DirectoryId,
            "ShareMethod" => ShareMethod,
            "ShareTarget" => ShareTarget,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function share_directory(
    DirectoryId,
    ShareMethod,
    ShareTarget,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "ShareDirectory",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DirectoryId" => DirectoryId,
                    "ShareMethod" => ShareMethod,
                    "ShareTarget" => ShareTarget,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_schema_extension(create_snapshot_before_schema_extension, description, directory_id, ldif_content)
    start_schema_extension(create_snapshot_before_schema_extension, description, directory_id, ldif_content, params::Dict{String,<:Any})

Applies a schema extension to a Microsoft AD directory.

# Arguments
- `create_snapshot_before_schema_extension`: If true, creates a snapshot of the directory
  before applying the schema extension.
- `description`: A description of the schema extension.
- `directory_id`: The identifier of the directory for which the schema extension will be
  applied to.
- `ldif_content`: The LDIF file represented as a string. To construct the LdifContent
  string, precede each line as it would be formatted in an ldif file with n. See the example
  request below for more details. The file size can be no larger than 1MB.

"""
function start_schema_extension(
    CreateSnapshotBeforeSchemaExtension,
    Description,
    DirectoryId,
    LdifContent;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "StartSchemaExtension",
        Dict{String,Any}(
            "CreateSnapshotBeforeSchemaExtension" => CreateSnapshotBeforeSchemaExtension,
            "Description" => Description,
            "DirectoryId" => DirectoryId,
            "LdifContent" => LdifContent,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_schema_extension(
    CreateSnapshotBeforeSchemaExtension,
    Description,
    DirectoryId,
    LdifContent,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "StartSchemaExtension",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CreateSnapshotBeforeSchemaExtension" =>
                        CreateSnapshotBeforeSchemaExtension,
                    "Description" => Description,
                    "DirectoryId" => DirectoryId,
                    "LdifContent" => LdifContent,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    unshare_directory(directory_id, unshare_target)
    unshare_directory(directory_id, unshare_target, params::Dict{String,<:Any})

Stops the directory sharing between the directory owner and consumer accounts.

# Arguments
- `directory_id`: The identifier of the Managed Microsoft AD directory that you want to
  stop sharing.
- `unshare_target`: Identifier for the directory consumer account with whom the directory
  has to be unshared.

"""
function unshare_directory(
    DirectoryId, UnshareTarget; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "UnshareDirectory",
        Dict{String,Any}("DirectoryId" => DirectoryId, "UnshareTarget" => UnshareTarget);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function unshare_directory(
    DirectoryId,
    UnshareTarget,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "UnshareDirectory",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DirectoryId" => DirectoryId, "UnshareTarget" => UnshareTarget
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_conditional_forwarder(directory_id, dns_ip_addrs, remote_domain_name)
    update_conditional_forwarder(directory_id, dns_ip_addrs, remote_domain_name, params::Dict{String,<:Any})

Updates a conditional forwarder that has been set up for your Amazon Web Services directory.

# Arguments
- `directory_id`: The directory ID of the Amazon Web Services directory for which to update
  the conditional forwarder.
- `dns_ip_addrs`: The updated IP addresses of the remote DNS server associated with the
  conditional forwarder.
- `remote_domain_name`: The fully qualified domain name (FQDN) of the remote domain with
  which you will set up a trust relationship.

"""
function update_conditional_forwarder(
    DirectoryId,
    DnsIpAddrs,
    RemoteDomainName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "UpdateConditionalForwarder",
        Dict{String,Any}(
            "DirectoryId" => DirectoryId,
            "DnsIpAddrs" => DnsIpAddrs,
            "RemoteDomainName" => RemoteDomainName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_conditional_forwarder(
    DirectoryId,
    DnsIpAddrs,
    RemoteDomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "UpdateConditionalForwarder",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DirectoryId" => DirectoryId,
                    "DnsIpAddrs" => DnsIpAddrs,
                    "RemoteDomainName" => RemoteDomainName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_directory_setup(directory_id, update_type)
    update_directory_setup(directory_id, update_type, params::Dict{String,<:Any})

 Updates the directory for a particular update type.

# Arguments
- `directory_id`:  The identifier of the directory on which you want to perform the update.
- `update_type`:  The type of update that needs to be performed on the directory. For
  example, OS.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CreateSnapshotBeforeUpdate"`:  The boolean that specifies if a snapshot for the
  directory needs to be taken before updating the directory.
- `"OSUpdateSettings"`:  The settings for the OS update that needs to be performed on the
  directory.
"""
function update_directory_setup(
    DirectoryId, UpdateType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "UpdateDirectorySetup",
        Dict{String,Any}("DirectoryId" => DirectoryId, "UpdateType" => UpdateType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_directory_setup(
    DirectoryId,
    UpdateType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "UpdateDirectorySetup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DirectoryId" => DirectoryId, "UpdateType" => UpdateType),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_number_of_domain_controllers(desired_number, directory_id)
    update_number_of_domain_controllers(desired_number, directory_id, params::Dict{String,<:Any})

Adds or removes domain controllers to or from the directory. Based on the difference
between current value and new value (provided through this API call), domain controllers
will be added or removed. It may take up to 45 minutes for any new domain controllers to
become fully active once the requested number of domain controllers is updated. During this
time, you cannot make another update request.

# Arguments
- `desired_number`: The number of domain controllers desired in the directory.
- `directory_id`: Identifier of the directory to which the domain controllers will be added
  or removed.

"""
function update_number_of_domain_controllers(
    DesiredNumber, DirectoryId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "UpdateNumberOfDomainControllers",
        Dict{String,Any}("DesiredNumber" => DesiredNumber, "DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_number_of_domain_controllers(
    DesiredNumber,
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "UpdateNumberOfDomainControllers",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DesiredNumber" => DesiredNumber, "DirectoryId" => DirectoryId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_radius(directory_id, radius_settings)
    update_radius(directory_id, radius_settings, params::Dict{String,<:Any})

Updates the Remote Authentication Dial In User Service (RADIUS) server information for an
AD Connector or Microsoft AD directory.

# Arguments
- `directory_id`: The identifier of the directory for which to update the RADIUS server
  information.
- `radius_settings`: A RadiusSettings object that contains information about the RADIUS
  server.

"""
function update_radius(
    DirectoryId, RadiusSettings; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "UpdateRadius",
        Dict{String,Any}("DirectoryId" => DirectoryId, "RadiusSettings" => RadiusSettings);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_radius(
    DirectoryId,
    RadiusSettings,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "UpdateRadius",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DirectoryId" => DirectoryId, "RadiusSettings" => RadiusSettings
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_settings(directory_id, settings)
    update_settings(directory_id, settings, params::Dict{String,<:Any})

Updates the configurable settings for the specified directory.

# Arguments
- `directory_id`: The identifier of the directory for which to update settings.
- `settings`: The list of Setting objects.

"""
function update_settings(
    DirectoryId, Settings; aws_config::AbstractAWSConfig=current_aws_config()
)
    return directory_service(
        "UpdateSettings",
        Dict{String,Any}("DirectoryId" => DirectoryId, "Settings" => Settings);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_settings(
    DirectoryId,
    Settings,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "UpdateSettings",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DirectoryId" => DirectoryId, "Settings" => Settings),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_trust(trust_id)
    update_trust(trust_id, params::Dict{String,<:Any})

Updates the trust that has been set up between your Managed Microsoft AD directory and an
self-managed Active Directory.

# Arguments
- `trust_id`: Identifier of the trust relationship.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SelectiveAuth"`: Updates selective authentication for the trust.
"""
function update_trust(TrustId; aws_config::AbstractAWSConfig=current_aws_config())
    return directory_service(
        "UpdateTrust",
        Dict{String,Any}("TrustId" => TrustId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_trust(
    TrustId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "UpdateTrust",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("TrustId" => TrustId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    verify_trust(trust_id)
    verify_trust(trust_id, params::Dict{String,<:Any})

Directory Service for Microsoft Active Directory allows you to configure and verify trust
relationships. This action verifies a trust relationship between your Managed Microsoft AD
directory and an external domain.

# Arguments
- `trust_id`: The unique Trust ID of the trust relationship to verify.

"""
function verify_trust(TrustId; aws_config::AbstractAWSConfig=current_aws_config())
    return directory_service(
        "VerifyTrust",
        Dict{String,Any}("TrustId" => TrustId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function verify_trust(
    TrustId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return directory_service(
        "VerifyTrust",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("TrustId" => TrustId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
