# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: organizations
using AWS.Compat
using AWS.UUIDs

"""
    accept_handshake(handshake_id)
    accept_handshake(handshake_id, params::Dict{String,<:Any})

Sends a response to the originator of a handshake agreeing to the action proposed by the
handshake request. You can only call this operation by the following principals when they
also have the relevant IAM permissions:    Invitation to join or Approve all features
request handshakes: only a principal from the member account. The user who calls the API
for an invitation to join must have the organizations:AcceptHandshake permission. If you
enabled all features in the organization, the user must also have the
iam:CreateServiceLinkedRole permission so that Organizations can create the required
service-linked role named AWSServiceRoleForOrganizations. For more information, see
Organizations and service-linked roles in the Organizations User Guide.    Enable all
features final confirmation handshake: only a principal from the management account. For
more information about invitations, see Inviting an Amazon Web Services account to join
your organization in the Organizations User Guide. For more information about requests to
enable all features in the organization, see Enabling all features in your organization in
the Organizations User Guide.   After you accept a handshake, it continues to appear in the
results of relevant APIs for only 30 days. After that, it's deleted.

# Arguments
- `handshake_id`: The unique identifier (ID) of the handshake that you want to accept. The
  regex pattern for handshake ID string requires \"h-\" followed by from 8 to 32 lowercase
  letters or digits.

"""
function accept_handshake(HandshakeId; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "AcceptHandshake",
        Dict{String,Any}("HandshakeId" => HandshakeId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_handshake(
    HandshakeId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "AcceptHandshake",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("HandshakeId" => HandshakeId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    attach_policy(policy_id, target_id)
    attach_policy(policy_id, target_id, params::Dict{String,<:Any})

Attaches a policy to a root, an organizational unit (OU), or an individual account. How the
policy affects accounts depends on the type of policy. Refer to the Organizations User
Guide for information about each policy type:    AISERVICES_OPT_OUT_POLICY
BACKUP_POLICY     SERVICE_CONTROL_POLICY     TAG_POLICY    This operation can be called
only from the organization's management account or by a member account that is a delegated
administrator for an Amazon Web Services service.

# Arguments
- `policy_id`: The unique identifier (ID) of the policy that you want to attach to the
  target. You can get the ID for the policy by calling the ListPolicies operation. The regex
  pattern for a policy ID string requires \"p-\" followed by from 8 to 128 lowercase or
  uppercase letters, digits, or the underscore character (_).
- `target_id`: The unique identifier (ID) of the root, OU, or account that you want to
  attach the policy to. You can get the ID by calling the ListRoots,
  ListOrganizationalUnitsForParent, or ListAccounts operations. The regex pattern for a
  target ID string requires one of the following:    Root - A string that begins with \"r-\"
  followed by from 4 to 32 lowercase letters or digits.    Account - A string that consists
  of exactly 12 digits.    Organizational unit (OU) - A string that begins with \"ou-\"
  followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is
  in). This string is followed by a second \"-\" dash and from 8 to 32 additional lowercase
  letters or digits.

"""
function attach_policy(
    PolicyId, TargetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "AttachPolicy",
        Dict{String,Any}("PolicyId" => PolicyId, "TargetId" => TargetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function attach_policy(
    PolicyId,
    TargetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "AttachPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("PolicyId" => PolicyId, "TargetId" => TargetId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_handshake(handshake_id)
    cancel_handshake(handshake_id, params::Dict{String,<:Any})

Cancels a handshake. Canceling a handshake sets the handshake state to CANCELED. This
operation can be called only from the account that originated the handshake. The recipient
of the handshake can't cancel it, but can use DeclineHandshake instead. After a handshake
is canceled, the recipient can no longer respond to that handshake. After you cancel a
handshake, it continues to appear in the results of relevant APIs for only 30 days. After
that, it's deleted.

# Arguments
- `handshake_id`: The unique identifier (ID) of the handshake that you want to cancel. You
  can get the ID from the ListHandshakesForOrganization operation. The regex pattern for
  handshake ID string requires \"h-\" followed by from 8 to 32 lowercase letters or digits.

"""
function cancel_handshake(HandshakeId; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "CancelHandshake",
        Dict{String,Any}("HandshakeId" => HandshakeId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_handshake(
    HandshakeId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "CancelHandshake",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("HandshakeId" => HandshakeId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    close_account(account_id)
    close_account(account_id, params::Dict{String,<:Any})

Closes an Amazon Web Services member account within an organization. You can close an
account when all features are enabled . You can't close the management account with this
API. This is an asynchronous request that Amazon Web Services performs in the background.
Because CloseAccount operates asynchronously, it can return a successful completion message
even though account closure might still be in progress. You need to wait a few minutes
before the account is fully closed. To check the status of the request, do one of the
following:   Use the AccountId that you sent in the CloseAccount request to provide as a
parameter to the DescribeAccount operation.  While the close account request is in
progress, Account status will indicate PENDING_CLOSURE. When the close account request
completes, the status will change to SUSPENDED.    Check the CloudTrail log for the
CloseAccountResult event that gets published after the account closes successfully. For
information on using CloudTrail with Organizations, see Logging and monitoring in
Organizations in the Organizations User Guide.      You can close only 10% of member
accounts, between 10 and 1000, within a rolling 30 day period. This quota is not bound by a
calendar month, but starts when you close an account. After you reach this limit, you can
close additional accounts. For more information, see Closing a member account in your
organization and Quotas for Organizationsin the Organizations User Guide.    To reinstate a
closed account, contact Amazon Web Services Support within the 90-day grace period while
the account is in SUSPENDED status.    If the Amazon Web Services account you attempt to
close is linked to an Amazon Web Services GovCloud (US) account, the CloseAccount request
will close both accounts. To learn important pre-closure details, see  Closing an Amazon
Web Services GovCloud (US) account in the  Amazon Web Services GovCloud User Guide.

# Arguments
- `account_id`: Retrieves the Amazon Web Services account Id for the current CloseAccount
  API request.

"""
function close_account(AccountId; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "CloseAccount",
        Dict{String,Any}("AccountId" => AccountId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function close_account(
    AccountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "CloseAccount",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AccountId" => AccountId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_account(account_name, email)
    create_account(account_name, email, params::Dict{String,<:Any})

Creates an Amazon Web Services account that is automatically a member of the organization
whose credentials made the request. This is an asynchronous request that Amazon Web
Services performs in the background. Because CreateAccount operates asynchronously, it can
return a successful completion message even though account initialization might still be in
progress. You might need to wait a few minutes before you can successfully access the
account. To check the status of the request, do one of the following:   Use the Id value of
the CreateAccountStatus response element from this operation to provide as a parameter to
the DescribeCreateAccountStatus operation.   Check the CloudTrail log for the
CreateAccountResult event. For information on using CloudTrail with Organizations, see
Logging and monitoring in Organizations in the Organizations User Guide.   The user who
calls the API to create an account must have the organizations:CreateAccount permission. If
you enabled all features in the organization, Organizations creates the required
service-linked role named AWSServiceRoleForOrganizations. For more information, see
Organizations and service-linked roles in the Organizations User Guide. If the request
includes tags, then the requester must have the organizations:TagResource permission.
Organizations preconfigures the new member account with a role (named
OrganizationAccountAccessRole by default) that grants users in the management account
administrator permissions in the new member account. Principals in the management account
can assume the role. Organizations clones the company name and address information for the
new account from the organization's management account. This operation can be called only
from the organization's management account. For more information about creating accounts,
see Creating a member account in your organization in the Organizations User Guide.    When
you create an account in an organization using the Organizations console, API, or CLI
commands, the information required for the account to operate as a standalone account, such
as a payment method and signing the end user license agreement (EULA) is not automatically
collected. If you must remove an account from your organization later, you can do so only
after you provide the missing information. For more information, see Considerations before
removing an account from an organization in the Organizations User Guide.   If you get an
exception that indicates that you exceeded your account limits for the organization,
contact Amazon Web Services Support.   If you get an exception that indicates that the
operation failed because your organization is still initializing, wait one hour and then
try again. If the error persists, contact Amazon Web Services Support.   Using
CreateAccount to create multiple temporary accounts isn't recommended. You can only close
an account from the Billing and Cost Management console, and you must be signed in as the
root user. For information on the requirements and process for closing an account, see
Closing a member account in your organization in the Organizations User Guide.     When you
create a member account with this operation, you can choose whether to create the account
with the IAM User and Role Access to Billing Information switch enabled. If you enable it,
IAM users and roles that have appropriate permissions can view billing information for the
account. If you disable it, only the account root user can access billing information. For
information about how to disable this switch for an account, see Granting access to your
billing information and tools.

# Arguments
- `account_name`: The friendly name of the member account.
- `email`: The email address of the owner to assign to the new member account. This email
  address must not already be associated with another Amazon Web Services account. You must
  use a valid email address to complete account creation. The rules for a valid email
  address:   The address must be a minimum of 6 and a maximum of 64 characters long.   All
  characters must be 7-bit ASCII characters.   There must be one and only one @ symbol, which
  separates the local name from the domain name.   The local name can't contain any of the
  following characters: whitespace, \" ' ( ) &lt; &gt; [ ] : ; ,  | % &amp;   The local name
  can't begin with a dot (.)   The domain name can consist of only the characters
  [a-z],[A-Z],[0-9], hyphen (-), or dot (.)   The domain name can't begin or end with a
  hyphen (-) or dot (.)   The domain name must contain at least one dot   You can't access
  the root user of the account or remove an account that was created with an invalid email
  address.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IamUserAccessToBilling"`: If set to ALLOW, the new account enables IAM users to access
  account billing information if they have the required permissions. If set to DENY, only the
  root user of the new account can access account billing information. For more information,
  see About IAM access to the Billing and Cost Management console in the Amazon Web Services
  Billing and Cost Management User Guide. If you don't specify this parameter, the value
  defaults to ALLOW, and IAM users and roles with the required permissions can access billing
  information for the new account.
- `"RoleName"`: The name of an IAM role that Organizations automatically preconfigures in
  the new member account. This role trusts the management account, allowing users in the
  management account to assume the role, as permitted by the management account
  administrator. The role has administrator permissions in the new member account. If you
  don't specify this parameter, the role name defaults to OrganizationAccountAccessRole. For
  more information about how to use this role to access the member account, see the following
  links:    Creating the OrganizationAccountAccessRole in an invited member account in the
  Organizations User Guide    Steps 2 and 3 in IAM Tutorial: Delegate access across Amazon
  Web Services accounts using IAM roles in the IAM User Guide    The regex pattern that is
  used to validate this parameter. The pattern can include uppercase letters, lowercase
  letters, digits with no spaces, and any of the following characters: =,.@-
- `"Tags"`: A list of tags that you want to attach to the newly created account. For each
  tag in the list, you must specify both a tag key and a value. You can set the value to an
  empty string, but you can't set it to null. For more information about tagging, see Tagging
  Organizations resources in the Organizations User Guide.  If any one of the tags is not
  valid or if you exceed the maximum allowed number of tags for an account, then the entire
  request fails and the account is not created.
"""
function create_account(
    AccountName, Email; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "CreateAccount",
        Dict{String,Any}("AccountName" => AccountName, "Email" => Email);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_account(
    AccountName,
    Email,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "CreateAccount",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AccountName" => AccountName, "Email" => Email),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_gov_cloud_account(account_name, email)
    create_gov_cloud_account(account_name, email, params::Dict{String,<:Any})

This action is available if all of the following are true:   You're authorized to create
accounts in the Amazon Web Services GovCloud (US) Region. For more information on the
Amazon Web Services GovCloud (US) Region, see the  Amazon Web Services GovCloud User Guide.
   You already have an account in the Amazon Web Services GovCloud (US) Region that is
paired with a management account of an organization in the commercial Region.   You call
this action from the management account of your organization in the commercial Region.
You have the organizations:CreateGovCloudAccount permission.    Organizations automatically
creates the required service-linked role named AWSServiceRoleForOrganizations. For more
information, see Organizations and service-linked roles in the Organizations User Guide.
Amazon Web Services automatically enables CloudTrail for Amazon Web Services GovCloud (US)
accounts, but you should also do the following:   Verify that CloudTrail is enabled to
store logs.   Create an Amazon S3 bucket for CloudTrail log storage. For more information,
see Verifying CloudTrail Is Enabled in the Amazon Web Services GovCloud User Guide.    If
the request includes tags, then the requester must have the organizations:TagResource
permission. The tags are attached to the commercial account associated with the GovCloud
account, rather than the GovCloud account itself. To add tags to the GovCloud account, call
the TagResource operation in the GovCloud Region after the new GovCloud account exists. You
call this action from the management account of your organization in the commercial Region
to create a standalone Amazon Web Services account in the Amazon Web Services GovCloud (US)
Region. After the account is created, the management account of an organization in the
Amazon Web Services GovCloud (US) Region can invite it to that organization. For more
information on inviting standalone accounts in the Amazon Web Services GovCloud (US) to
join an organization, see Organizations in the Amazon Web Services GovCloud User Guide.
Calling CreateGovCloudAccount is an asynchronous request that Amazon Web Services performs
in the background. Because CreateGovCloudAccount operates asynchronously, it can return a
successful completion message even though account initialization might still be in
progress. You might need to wait a few minutes before you can successfully access the
account. To check the status of the request, do one of the following:   Use the OperationId
response element from this operation to provide as a parameter to the
DescribeCreateAccountStatus operation.   Check the CloudTrail log for the
CreateAccountResult event. For information on using CloudTrail with Organizations, see
Logging and monitoring in Organizations in the Organizations User Guide.    When you call
the CreateGovCloudAccount action, you create two accounts: a standalone account in the
Amazon Web Services GovCloud (US) Region and an associated account in the commercial Region
for billing and support purposes. The account in the commercial Region is automatically a
member of the organization whose credentials made the request. Both accounts are associated
with the same email address. A role is created in the new account in the commercial Region
that allows the management account in the organization in the commercial Region to assume
it. An Amazon Web Services GovCloud (US) account is then created and associated with the
commercial account that you just created. A role is also created in the new Amazon Web
Services GovCloud (US) account that can be assumed by the Amazon Web Services GovCloud (US)
account that is associated with the management account of the commercial organization. For
more information and to view a diagram that explains how account access works, see
Organizations in the Amazon Web Services GovCloud User Guide. For more information about
creating accounts, see Creating a member account in your organization in the Organizations
User Guide.    When you create an account in an organization using the Organizations
console, API, or CLI commands, the information required for the account to operate as a
standalone account is not automatically collected. This includes a payment method and
signing the end user license agreement (EULA). If you must remove an account from your
organization later, you can do so only after you provide the missing information. For more
information, see Considerations before removing an account from an organization in the
Organizations User Guide.   If you get an exception that indicates that you exceeded your
account limits for the organization, contact Amazon Web Services Support.   If you get an
exception that indicates that the operation failed because your organization is still
initializing, wait one hour and then try again. If the error persists, contact Amazon Web
Services Support.   Using CreateGovCloudAccount to create multiple temporary accounts isn't
recommended. You can only close an account from the Amazon Web Services Billing and Cost
Management console, and you must be signed in as the root user. For information on the
requirements and process for closing an account, see Closing a member account in your
organization in the Organizations User Guide.     When you create a member account with
this operation, you can choose whether to create the account with the IAM User and Role
Access to Billing Information switch enabled. If you enable it, IAM users and roles that
have appropriate permissions can view billing information for the account. If you disable
it, only the account root user can access billing information. For information about how to
disable this switch for an account, see Granting access to your billing information and
tools.

# Arguments
- `account_name`: The friendly name of the member account.  The account name can consist of
  only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.) You can't separate characters
  with a dash (–).
- `email`: Specifies the email address of the owner to assign to the new member account in
  the commercial Region. This email address must not already be associated with another
  Amazon Web Services account. You must use a valid email address to complete account
  creation. The rules for a valid email address:   The address must be a minimum of 6 and a
  maximum of 64 characters long.   All characters must be 7-bit ASCII characters.   There
  must be one and only one @ symbol, which separates the local name from the domain name.
  The local name can't contain any of the following characters: whitespace, \" ' ( ) &lt;
  &gt; [ ] : ; ,  | % &amp;   The local name can't begin with a dot (.)   The domain name can
  consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.)   The domain name
  can't begin or end with a hyphen (-) or dot (.)   The domain name must contain at least one
  dot   You can't access the root user of the account or remove an account that was created
  with an invalid email address. Like all request parameters for CreateGovCloudAccount, the
  request for the email address for the Amazon Web Services GovCloud (US) account originates
  from the commercial Region, not from the Amazon Web Services GovCloud (US) Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IamUserAccessToBilling"`: If set to ALLOW, the new linked account in the commercial
  Region enables IAM users to access account billing information if they have the required
  permissions. If set to DENY, only the root user of the new account can access account
  billing information. For more information, see About IAM access to the Billing and Cost
  Management console in the Amazon Web Services Billing and Cost Management User Guide. If
  you don't specify this parameter, the value defaults to ALLOW, and IAM users and roles with
  the required permissions can access billing information for the new account.
- `"RoleName"`: (Optional) The name of an IAM role that Organizations automatically
  preconfigures in the new member accounts in both the Amazon Web Services GovCloud (US)
  Region and in the commercial Region. This role trusts the management account, allowing
  users in the management account to assume the role, as permitted by the management account
  administrator. The role has administrator permissions in the new member account. If you
  don't specify this parameter, the role name defaults to OrganizationAccountAccessRole. For
  more information about how to use this role to access the member account, see the following
  links:    Creating the OrganizationAccountAccessRole in an invited member account in the
  Organizations User Guide    Steps 2 and 3 in IAM Tutorial: Delegate access across Amazon
  Web Services accounts using IAM roles in the IAM User Guide    The regex pattern that is
  used to validate this parameter. The pattern can include uppercase letters, lowercase
  letters, digits with no spaces, and any of the following characters: =,.@-
- `"Tags"`: A list of tags that you want to attach to the newly created account. These tags
  are attached to the commercial account associated with the GovCloud account, and not to the
  GovCloud account itself. To add tags to the actual GovCloud account, call the TagResource
  operation in the GovCloud region after the new GovCloud account exists. For each tag in the
  list, you must specify both a tag key and a value. You can set the value to an empty
  string, but you can't set it to null. For more information about tagging, see Tagging
  Organizations resources in the Organizations User Guide.  If any one of the tags is not
  valid or if you exceed the maximum allowed number of tags for an account, then the entire
  request fails and the account is not created.
"""
function create_gov_cloud_account(
    AccountName, Email; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "CreateGovCloudAccount",
        Dict{String,Any}("AccountName" => AccountName, "Email" => Email);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_gov_cloud_account(
    AccountName,
    Email,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "CreateGovCloudAccount",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AccountName" => AccountName, "Email" => Email),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_organization()
    create_organization(params::Dict{String,<:Any})

Creates an Amazon Web Services organization. The account whose user is calling the
CreateOrganization operation automatically becomes the management account of the new
organization. This operation must be called using credentials from the account that is to
become the new organization's management account. The principal must also have the relevant
IAM permissions. By default (or if you set the FeatureSet parameter to ALL), the new
organization is created with all features enabled and service control policies
automatically enabled in the root. If you instead choose to create the organization
supporting only the consolidated billing features by setting the FeatureSet parameter to
CONSOLIDATED_BILLING, no policy types are enabled by default and you can't use organization
policies.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FeatureSet"`: Specifies the feature set supported by the new organization. Each feature
  set supports different levels of functionality.    CONSOLIDATED_BILLING: All member
  accounts have their bills consolidated to and paid by the management account. For more
  information, see Consolidated billing in the Organizations User Guide.  The consolidated
  billing feature subset isn't available for organizations in the Amazon Web Services
  GovCloud (US) Region.    ALL: In addition to all the features supported by the consolidated
  billing feature set, the management account can also apply any policy type to any member
  account in the organization. For more information, see All features in the Organizations
  User Guide.
"""
function create_organization(; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "CreateOrganization"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function create_organization(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "CreateOrganization", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    create_organizational_unit(name, parent_id)
    create_organizational_unit(name, parent_id, params::Dict{String,<:Any})

Creates an organizational unit (OU) within a root or parent OU. An OU is a container for
accounts that enables you to organize your accounts to apply policies according to your
business requirements. The number of levels deep that you can nest OUs is dependent upon
the policy types enabled for that root. For service control policies, the limit is five.
For more information about OUs, see Managing organizational units (OUs) in the
Organizations User Guide. If the request includes tags, then the requester must have the
organizations:TagResource permission. This operation can be called only from the
organization's management account.

# Arguments
- `name`: The friendly name to assign to the new OU.
- `parent_id`: The unique identifier (ID) of the parent root or OU that you want to create
  the new OU in. The regex pattern for a parent ID string requires one of the following:
  Root - A string that begins with \"r-\" followed by from 4 to 32 lowercase letters or
  digits.    Organizational unit (OU) - A string that begins with \"ou-\" followed by from 4
  to 32 lowercase letters or digits (the ID of the root that the OU is in). This string is
  followed by a second \"-\" dash and from 8 to 32 additional lowercase letters or digits.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: A list of tags that you want to attach to the newly created OU. For each tag in
  the list, you must specify both a tag key and a value. You can set the value to an empty
  string, but you can't set it to null. For more information about tagging, see Tagging
  Organizations resources in the Organizations User Guide.  If any one of the tags is not
  valid or if you exceed the allowed number of tags for an OU, then the entire request fails
  and the OU is not created.
"""
function create_organizational_unit(
    Name, ParentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "CreateOrganizationalUnit",
        Dict{String,Any}("Name" => Name, "ParentId" => ParentId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_organizational_unit(
    Name,
    ParentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "CreateOrganizationalUnit",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Name" => Name, "ParentId" => ParentId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_policy(content, description, name, type)
    create_policy(content, description, name, type, params::Dict{String,<:Any})

Creates a policy of a specified type that you can attach to a root, an organizational unit
(OU), or an individual Amazon Web Services account. For more information about policies and
their use, see Managing Organizations policies. If the request includes tags, then the
requester must have the organizations:TagResource permission. This operation can be called
only from the organization's management account or by a member account that is a delegated
administrator for an Amazon Web Services service.

# Arguments
- `content`: The policy text content to add to the new policy. The text that you supply
  must adhere to the rules of the policy type you specify in the Type parameter.  The maximum
  size of a policy document depends on the policy's type. For more information, see Maximum
  and minimum values in the Organizations User Guide.
- `description`: An optional description to assign to the policy.
- `name`: The friendly name to assign to the policy. The regex pattern that is used to
  validate this parameter is a string of any of the characters in the ASCII character range.
- `type`: The type of policy to create. You can specify one of the following values:
  AISERVICES_OPT_OUT_POLICY     BACKUP_POLICY     SERVICE_CONTROL_POLICY     TAG_POLICY

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: A list of tags that you want to attach to the newly created policy. For each
  tag in the list, you must specify both a tag key and a value. You can set the value to an
  empty string, but you can't set it to null. For more information about tagging, see Tagging
  Organizations resources in the Organizations User Guide.  If any one of the tags is not
  valid or if you exceed the allowed number of tags for a policy, then the entire request
  fails and the policy is not created.
"""
function create_policy(
    Content, Description, Name, Type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "CreatePolicy",
        Dict{String,Any}(
            "Content" => Content,
            "Description" => Description,
            "Name" => Name,
            "Type" => Type,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_policy(
    Content,
    Description,
    Name,
    Type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "CreatePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Content" => Content,
                    "Description" => Description,
                    "Name" => Name,
                    "Type" => Type,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    decline_handshake(handshake_id)
    decline_handshake(handshake_id, params::Dict{String,<:Any})

Declines a handshake request. This sets the handshake state to DECLINED and effectively
deactivates the request. This operation can be called only from the account that received
the handshake. The originator of the handshake can use CancelHandshake instead. The
originator can't reactivate a declined request, but can reinitiate the process with a new
handshake request. After you decline a handshake, it continues to appear in the results of
relevant APIs for only 30 days. After that, it's deleted.

# Arguments
- `handshake_id`: The unique identifier (ID) of the handshake that you want to decline. You
  can get the ID from the ListHandshakesForAccount operation. The regex pattern for handshake
  ID string requires \"h-\" followed by from 8 to 32 lowercase letters or digits.

"""
function decline_handshake(HandshakeId; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "DeclineHandshake",
        Dict{String,Any}("HandshakeId" => HandshakeId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function decline_handshake(
    HandshakeId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "DeclineHandshake",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("HandshakeId" => HandshakeId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_organization()
    delete_organization(params::Dict{String,<:Any})

Deletes the organization. You can delete an organization only by using credentials from the
management account. The organization must be empty of member accounts.

"""
function delete_organization(; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "DeleteOrganization"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function delete_organization(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "DeleteOrganization", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    delete_organizational_unit(organizational_unit_id)
    delete_organizational_unit(organizational_unit_id, params::Dict{String,<:Any})

Deletes an organizational unit (OU) from a root or another OU. You must first remove all
accounts and child OUs from the OU that you want to delete. This operation can be called
only from the organization's management account.

# Arguments
- `organizational_unit_id`: The unique identifier (ID) of the organizational unit that you
  want to delete. You can get the ID from the ListOrganizationalUnitsForParent operation. The
  regex pattern for an organizational unit ID string requires \"ou-\" followed by from 4 to
  32 lowercase letters or digits (the ID of the root that contains the OU). This string is
  followed by a second \"-\" dash and from 8 to 32 additional lowercase letters or digits.

"""
function delete_organizational_unit(
    OrganizationalUnitId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "DeleteOrganizationalUnit",
        Dict{String,Any}("OrganizationalUnitId" => OrganizationalUnitId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_organizational_unit(
    OrganizationalUnitId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "DeleteOrganizationalUnit",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("OrganizationalUnitId" => OrganizationalUnitId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_policy(policy_id)
    delete_policy(policy_id, params::Dict{String,<:Any})

Deletes the specified policy from your organization. Before you perform this operation, you
must first detach the policy from all organizational units (OUs), roots, and accounts. This
operation can be called only from the organization's management account or by a member
account that is a delegated administrator for an Amazon Web Services service.

# Arguments
- `policy_id`: The unique identifier (ID) of the policy that you want to delete. You can
  get the ID from the ListPolicies or ListPoliciesForTarget operations. The regex pattern for
  a policy ID string requires \"p-\" followed by from 8 to 128 lowercase or uppercase
  letters, digits, or the underscore character (_).

"""
function delete_policy(PolicyId; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "DeletePolicy",
        Dict{String,Any}("PolicyId" => PolicyId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_policy(
    PolicyId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "DeletePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PolicyId" => PolicyId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_resource_policy()
    delete_resource_policy(params::Dict{String,<:Any})

Deletes the resource policy from your organization. You can only call this operation from
the organization's management account.

"""
function delete_resource_policy(; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "DeleteResourcePolicy"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function delete_resource_policy(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "DeleteResourcePolicy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_delegated_administrator(account_id, service_principal)
    deregister_delegated_administrator(account_id, service_principal, params::Dict{String,<:Any})

Removes the specified member Amazon Web Services account as a delegated administrator for
the specified Amazon Web Services service.  Deregistering a delegated administrator can
have unintended impacts on the functionality of the enabled Amazon Web Services service.
See the documentation for the enabled service before you deregister a delegated
administrator so that you understand any potential impacts.  You can run this action only
for Amazon Web Services services that support this feature. For a current list of services
that support it, see the column Supports Delegated Administrator in the table at Amazon Web
Services Services that you can use with Organizations in the Organizations User Guide.
This operation can be called only from the organization's management account.

# Arguments
- `account_id`: The account ID number of the member account in the organization that you
  want to deregister as a delegated administrator.
- `service_principal`: The service principal name of an Amazon Web Services service for
  which the account is a delegated administrator. Delegated administrator privileges are
  revoked for only the specified Amazon Web Services service from the member account. If the
  specified service is the only service for which the member account is a delegated
  administrator, the operation also revokes Organizations read action permissions.

"""
function deregister_delegated_administrator(
    AccountId, ServicePrincipal; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "DeregisterDelegatedAdministrator",
        Dict{String,Any}("AccountId" => AccountId, "ServicePrincipal" => ServicePrincipal);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_delegated_administrator(
    AccountId,
    ServicePrincipal,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "DeregisterDelegatedAdministrator",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId, "ServicePrincipal" => ServicePrincipal
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_account(account_id)
    describe_account(account_id, params::Dict{String,<:Any})

Retrieves Organizations-related information about the specified account. This operation can
be called only from the organization's management account or by a member account that is a
delegated administrator for an Amazon Web Services service.

# Arguments
- `account_id`: The unique identifier (ID) of the Amazon Web Services account that you want
  information about. You can get the ID from the ListAccounts or ListAccountsForParent
  operations. The regex pattern for an account ID string requires exactly 12 digits.

"""
function describe_account(AccountId; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "DescribeAccount",
        Dict{String,Any}("AccountId" => AccountId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_account(
    AccountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "DescribeAccount",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AccountId" => AccountId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_create_account_status(create_account_request_id)
    describe_create_account_status(create_account_request_id, params::Dict{String,<:Any})

Retrieves the current status of an asynchronous request to create an account. This
operation can be called only from the organization's management account or by a member
account that is a delegated administrator for an Amazon Web Services service.

# Arguments
- `create_account_request_id`: Specifies the Id value that uniquely identifies the
  CreateAccount request. You can get the value from the CreateAccountStatus.Id response in an
  earlier CreateAccount request, or from the ListCreateAccountStatus operation. The regex
  pattern for a create account request ID string requires \"car-\" followed by from 8 to 32
  lowercase letters or digits.

"""
function describe_create_account_status(
    CreateAccountRequestId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "DescribeCreateAccountStatus",
        Dict{String,Any}("CreateAccountRequestId" => CreateAccountRequestId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_create_account_status(
    CreateAccountRequestId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "DescribeCreateAccountStatus",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CreateAccountRequestId" => CreateAccountRequestId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_effective_policy(policy_type)
    describe_effective_policy(policy_type, params::Dict{String,<:Any})

Returns the contents of the effective policy for specified policy type and account. The
effective policy is the aggregation of any policies of the specified type that the account
inherits, plus any policy of that type that is directly attached to the account. This
operation applies only to policy types other than service control policies (SCPs). For more
information about policy inheritance, see Understanding management policy inheritance in
the Organizations User Guide. This operation can be called from any account in the
organization.

# Arguments
- `policy_type`: The type of policy that you want information about. You can specify one of
  the following values:    AISERVICES_OPT_OUT_POLICY     BACKUP_POLICY     TAG_POLICY

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"TargetId"`: When you're signed in as the management account, specify the ID of the
  account that you want details about. Specifying an organization root or organizational unit
  (OU) as the target is not supported.
"""
function describe_effective_policy(
    PolicyType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "DescribeEffectivePolicy",
        Dict{String,Any}("PolicyType" => PolicyType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_effective_policy(
    PolicyType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "DescribeEffectivePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PolicyType" => PolicyType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_handshake(handshake_id)
    describe_handshake(handshake_id, params::Dict{String,<:Any})

Retrieves information about a previously requested handshake. The handshake ID comes from
the response to the original InviteAccountToOrganization operation that generated the
handshake. You can access handshakes that are ACCEPTED, DECLINED, or CANCELED for only 30
days after they change to that state. They're then deleted and no longer accessible. This
operation can be called from any account in the organization.

# Arguments
- `handshake_id`: The unique identifier (ID) of the handshake that you want information
  about. You can get the ID from the original call to InviteAccountToOrganization, or from a
  call to ListHandshakesForAccount or ListHandshakesForOrganization. The regex pattern for
  handshake ID string requires \"h-\" followed by from 8 to 32 lowercase letters or digits.

"""
function describe_handshake(HandshakeId; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "DescribeHandshake",
        Dict{String,Any}("HandshakeId" => HandshakeId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_handshake(
    HandshakeId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "DescribeHandshake",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("HandshakeId" => HandshakeId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_organization()
    describe_organization(params::Dict{String,<:Any})

Retrieves information about the organization that the user's account belongs to. This
operation can be called from any account in the organization.  Even if a policy type is
shown as available in the organization, you can disable it separately at the root level
with DisablePolicyType. Use ListRoots to see the status of policy types for a specified
root.

"""
function describe_organization(; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "DescribeOrganization"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_organization(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "DescribeOrganization",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_organizational_unit(organizational_unit_id)
    describe_organizational_unit(organizational_unit_id, params::Dict{String,<:Any})

Retrieves information about an organizational unit (OU). This operation can be called only
from the organization's management account or by a member account that is a delegated
administrator for an Amazon Web Services service.

# Arguments
- `organizational_unit_id`: The unique identifier (ID) of the organizational unit that you
  want details about. You can get the ID from the ListOrganizationalUnitsForParent operation.
  The regex pattern for an organizational unit ID string requires \"ou-\" followed by from 4
  to 32 lowercase letters or digits (the ID of the root that contains the OU). This string is
  followed by a second \"-\" dash and from 8 to 32 additional lowercase letters or digits.

"""
function describe_organizational_unit(
    OrganizationalUnitId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "DescribeOrganizationalUnit",
        Dict{String,Any}("OrganizationalUnitId" => OrganizationalUnitId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_organizational_unit(
    OrganizationalUnitId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "DescribeOrganizationalUnit",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("OrganizationalUnitId" => OrganizationalUnitId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_policy(policy_id)
    describe_policy(policy_id, params::Dict{String,<:Any})

Retrieves information about a policy. This operation can be called only from the
organization's management account or by a member account that is a delegated administrator
for an Amazon Web Services service.

# Arguments
- `policy_id`: The unique identifier (ID) of the policy that you want details about. You
  can get the ID from the ListPolicies or ListPoliciesForTarget operations. The regex pattern
  for a policy ID string requires \"p-\" followed by from 8 to 128 lowercase or uppercase
  letters, digits, or the underscore character (_).

"""
function describe_policy(PolicyId; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "DescribePolicy",
        Dict{String,Any}("PolicyId" => PolicyId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_policy(
    PolicyId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "DescribePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PolicyId" => PolicyId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_resource_policy()
    describe_resource_policy(params::Dict{String,<:Any})

Retrieves information about a resource policy. This operation can be called only from the
organization's management account or by a member account that is a delegated administrator
for an Amazon Web Services service.

"""
function describe_resource_policy(; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "DescribeResourcePolicy"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_resource_policy(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "DescribeResourcePolicy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detach_policy(policy_id, target_id)
    detach_policy(policy_id, target_id, params::Dict{String,<:Any})

Detaches a policy from a target root, organizational unit (OU), or account.  If the policy
being detached is a service control policy (SCP), the changes to permissions for Identity
and Access Management (IAM) users and roles in affected accounts are immediate.  Every
root, OU, and account must have at least one SCP attached. If you want to replace the
default FullAWSAccess policy with an SCP that limits the permissions that can be delegated,
you must attach the replacement SCP before you can remove the default SCP. This is the
authorization strategy of an \"allow list\". If you instead attach a second SCP and leave
the FullAWSAccess SCP still attached, and specify \"Effect\": \"Deny\" in the second SCP to
override the \"Effect\": \"Allow\" in the FullAWSAccess policy (or any other attached SCP),
you're using the authorization strategy of a \"deny list\". This operation can be called
only from the organization's management account or by a member account that is a delegated
administrator for an Amazon Web Services service.

# Arguments
- `policy_id`: The unique identifier (ID) of the policy you want to detach. You can get the
  ID from the ListPolicies or ListPoliciesForTarget operations. The regex pattern for a
  policy ID string requires \"p-\" followed by from 8 to 128 lowercase or uppercase letters,
  digits, or the underscore character (_).
- `target_id`: The unique identifier (ID) of the root, OU, or account that you want to
  detach the policy from. You can get the ID from the ListRoots,
  ListOrganizationalUnitsForParent, or ListAccounts operations. The regex pattern for a
  target ID string requires one of the following:    Root - A string that begins with \"r-\"
  followed by from 4 to 32 lowercase letters or digits.    Account - A string that consists
  of exactly 12 digits.    Organizational unit (OU) - A string that begins with \"ou-\"
  followed by from 4 to 32 lowercase letters or digits (the ID of the root that the OU is
  in). This string is followed by a second \"-\" dash and from 8 to 32 additional lowercase
  letters or digits.

"""
function detach_policy(
    PolicyId, TargetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "DetachPolicy",
        Dict{String,Any}("PolicyId" => PolicyId, "TargetId" => TargetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detach_policy(
    PolicyId,
    TargetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "DetachPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("PolicyId" => PolicyId, "TargetId" => TargetId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_awsservice_access(service_principal)
    disable_awsservice_access(service_principal, params::Dict{String,<:Any})

Disables the integration of an Amazon Web Services service (the service that is specified
by ServicePrincipal) with Organizations. When you disable integration, the specified
service no longer can create a service-linked role in new accounts in your organization.
This means the service can't perform operations on your behalf on any new accounts in your
organization. The service can still perform operations in older accounts until the service
completes its clean-up from Organizations.  We  strongly recommend  that you don't use this
command to disable integration between Organizations and the specified Amazon Web Services
service. Instead, use the console or commands that are provided by the specified service.
This lets the trusted service perform any required initialization when enabling trusted
access, such as creating any required resources and any required clean up of resources when
disabling trusted access.  For information about how to disable trusted service access to
your organization using the trusted service, see the Learn more link under the Supports
Trusted Access column at Amazon Web Services services that you can use with Organizations.
on this page. If you disable access by using this command, it causes the following actions
to occur:   The service can no longer create a service-linked role in the accounts in your
organization. This means that the service can't perform operations on your behalf on any
new accounts in your organization. The service can still perform operations in older
accounts until the service completes its clean-up from Organizations.    The service can no
longer perform tasks in the member accounts in the organization, unless those operations
are explicitly permitted by the IAM policies that are attached to your roles. This includes
any data aggregation from the member accounts to the management account, or to a delegated
administrator account, where relevant.   Some services detect this and clean up any
remaining data or resources related to the integration, while other services stop accessing
the organization but leave any historical data and configuration in place to support a
possible re-enabling of the integration.   Using the other service's console or commands to
disable the integration ensures that the other service is aware that it can clean up any
resources that are required only for the integration. How the service cleans up its
resources in the organization's accounts depends on that service. For more information, see
the documentation for the other Amazon Web Services service.   After you perform the
DisableAWSServiceAccess operation, the specified service can no longer perform operations
in your organization's accounts  For more information about integrating other services with
Organizations, including the list of services that work with Organizations, see Using
Organizations with other Amazon Web Services services in the Organizations User Guide. This
operation can be called only from the organization's management account.

# Arguments
- `service_principal`: The service principal name of the Amazon Web Services service for
  which you want to disable integration with your organization. This is typically in the form
  of a URL, such as  service-abbreviation.amazonaws.com.

"""
function disable_awsservice_access(
    ServicePrincipal; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "DisableAWSServiceAccess",
        Dict{String,Any}("ServicePrincipal" => ServicePrincipal);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_awsservice_access(
    ServicePrincipal,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "DisableAWSServiceAccess",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ServicePrincipal" => ServicePrincipal), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_policy_type(policy_type, root_id)
    disable_policy_type(policy_type, root_id, params::Dict{String,<:Any})

Disables an organizational policy type in a root. A policy of a certain type can be
attached to entities in a root only if that type is enabled in the root. After you perform
this operation, you no longer can attach policies of the specified type to that root or to
any organizational unit (OU) or account in that root. You can undo this by using the
EnablePolicyType operation. This is an asynchronous request that Amazon Web Services
performs in the background. If you disable a policy type for a root, it still appears
enabled for the organization if all features are enabled for the organization. Amazon Web
Services recommends that you first use ListRoots to see the status of policy types for a
specified root, and then use this operation. This operation can be called only from the
organization's management account or by a member account that is a delegated administrator
for an Amazon Web Services service.  To view the status of available policy types in the
organization, use DescribeOrganization.

# Arguments
- `policy_type`: The policy type that you want to disable in this root. You can specify one
  of the following values:    AISERVICES_OPT_OUT_POLICY     BACKUP_POLICY
  SERVICE_CONTROL_POLICY     TAG_POLICY
- `root_id`: The unique identifier (ID) of the root in which you want to disable a policy
  type. You can get the ID from the ListRoots operation. The regex pattern for a root ID
  string requires \"r-\" followed by from 4 to 32 lowercase letters or digits.

"""
function disable_policy_type(
    PolicyType, RootId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "DisablePolicyType",
        Dict{String,Any}("PolicyType" => PolicyType, "RootId" => RootId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_policy_type(
    PolicyType,
    RootId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "DisablePolicyType",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("PolicyType" => PolicyType, "RootId" => RootId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_all_features()
    enable_all_features(params::Dict{String,<:Any})

Enables all features in an organization. This enables the use of organization policies that
can restrict the services and actions that can be called in each account. Until you enable
all features, you have access only to consolidated billing, and you can't use any of the
advanced account administration features that Organizations supports. For more information,
see Enabling all features in your organization in the Organizations User Guide.  This
operation is required only for organizations that were created explicitly with only the
consolidated billing features enabled. Calling this operation sends a handshake to every
invited account in the organization. The feature set change can be finalized and the
additional features enabled only after all administrators in the invited accounts approve
the change by accepting the handshake.  After you enable all features, you can separately
enable or disable individual policy types in a root using EnablePolicyType and
DisablePolicyType. To see the status of policy types in a root, use ListRoots. After all
invited member accounts accept the handshake, you finalize the feature set change by
accepting the handshake that contains \"Action\": \"ENABLE_ALL_FEATURES\". This completes
the change. After you enable all features in your organization, the management account in
the organization can apply policies on all member accounts. These policies can restrict
what users and even administrators in those accounts can do. The management account can
apply policies that prevent accounts from leaving the organization. Ensure that your
account administrators are aware of this. This operation can be called only from the
organization's management account.

"""
function enable_all_features(; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "EnableAllFeatures"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function enable_all_features(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "EnableAllFeatures", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    enable_awsservice_access(service_principal)
    enable_awsservice_access(service_principal, params::Dict{String,<:Any})

Enables the integration of an Amazon Web Services service (the service that is specified by
ServicePrincipal) with Organizations. When you enable integration, you allow the specified
service to create a service-linked role in all the accounts in your organization. This
allows the service to perform operations on your behalf in your organization and its
accounts.  We recommend that you enable integration between Organizations and the specified
Amazon Web Services service by using the console or commands that are provided by the
specified service. Doing so ensures that the service is aware that it can create the
resources that are required for the integration. How the service creates those resources in
the organization's accounts depends on that service. For more information, see the
documentation for the other Amazon Web Services service.  For more information about
enabling services to integrate with Organizations, see Using Organizations with other
Amazon Web Services services in the Organizations User Guide. You can only call this
operation from the organization's management account and only if the organization has
enabled all features.

# Arguments
- `service_principal`: The service principal name of the Amazon Web Services service for
  which you want to enable integration with your organization. This is typically in the form
  of a URL, such as  service-abbreviation.amazonaws.com.

"""
function enable_awsservice_access(
    ServicePrincipal; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "EnableAWSServiceAccess",
        Dict{String,Any}("ServicePrincipal" => ServicePrincipal);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_awsservice_access(
    ServicePrincipal,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "EnableAWSServiceAccess",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ServicePrincipal" => ServicePrincipal), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_policy_type(policy_type, root_id)
    enable_policy_type(policy_type, root_id, params::Dict{String,<:Any})

Enables a policy type in a root. After you enable a policy type in a root, you can attach
policies of that type to the root, any organizational unit (OU), or account in that root.
You can undo this by using the DisablePolicyType operation. This is an asynchronous request
that Amazon Web Services performs in the background. Amazon Web Services recommends that
you first use ListRoots to see the status of policy types for a specified root, and then
use this operation. This operation can be called only from the organization's management
account or by a member account that is a delegated administrator for an Amazon Web Services
service. You can enable a policy type in a root only if that policy type is available in
the organization. To view the status of available policy types in the organization, use
DescribeOrganization.

# Arguments
- `policy_type`: The policy type that you want to enable. You can specify one of the
  following values:    AISERVICES_OPT_OUT_POLICY     BACKUP_POLICY     SERVICE_CONTROL_POLICY
      TAG_POLICY
- `root_id`: The unique identifier (ID) of the root in which you want to enable a policy
  type. You can get the ID from the ListRoots operation. The regex pattern for a root ID
  string requires \"r-\" followed by from 4 to 32 lowercase letters or digits.

"""
function enable_policy_type(
    PolicyType, RootId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "EnablePolicyType",
        Dict{String,Any}("PolicyType" => PolicyType, "RootId" => RootId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_policy_type(
    PolicyType,
    RootId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "EnablePolicyType",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("PolicyType" => PolicyType, "RootId" => RootId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    invite_account_to_organization(target)
    invite_account_to_organization(target, params::Dict{String,<:Any})

Sends an invitation to another account to join your organization as a member account.
Organizations sends email on your behalf to the email address that is associated with the
other account's owner. The invitation is implemented as a Handshake whose details are in
the response.    You can invite Amazon Web Services accounts only from the same seller as
the management account. For example, if your organization's management account was created
by Amazon Internet Services Pvt. Ltd (AISPL), an Amazon Web Services seller in India, you
can invite only other AISPL accounts to your organization. You can't combine accounts from
AISPL and Amazon Web Services or from any other Amazon Web Services seller. For more
information, see Consolidated billing in India.   If you receive an exception that
indicates that you exceeded your account limits for the organization or that the operation
failed because your organization is still initializing, wait one hour and then try again.
If the error persists after an hour, contact Amazon Web Services Support.    If the request
includes tags, then the requester must have the organizations:TagResource permission. This
operation can be called only from the organization's management account.

# Arguments
- `target`: The identifier (ID) of the Amazon Web Services account that you want to invite
  to join your organization. This is a JSON object that contains the following elements:  {
  \"Type\": \"ACCOUNT\", \"Id\": \"&lt; account id number &gt;\" }  If you use the CLI, you
  can submit this as a single string, similar to the following example:  --target
  Id=123456789012,Type=ACCOUNT  If you specify \"Type\": \"ACCOUNT\", you must provide the
  Amazon Web Services account ID number as the Id. If you specify \"Type\": \"EMAIL\", you
  must specify the email address that is associated with the account.  --target
  Id=diego@example.com,Type=EMAIL

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Notes"`: Additional information that you want to include in the generated email to the
  recipient account owner.
- `"Tags"`: A list of tags that you want to attach to the account when it becomes a member
  of the organization. For each tag in the list, you must specify both a tag key and a value.
  You can set the value to an empty string, but you can't set it to null. For more
  information about tagging, see Tagging Organizations resources in the Organizations User
  Guide.  Any tags in the request are checked for compliance with any applicable tag policies
  when the request is made. The request is rejected if the tags in the request don't match
  the requirements of the policy at that time. Tag policy compliance is  not  checked again
  when the invitation is accepted and the tags are actually attached to the account. That
  means that if the tag policy changes between the invitation and the acceptance, then that
  tags could potentially be non-compliant.   If any one of the tags is not valid or if you
  exceed the allowed number of tags for an account, then the entire request fails and
  invitations are not sent.
"""
function invite_account_to_organization(
    Target; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "InviteAccountToOrganization",
        Dict{String,Any}("Target" => Target);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function invite_account_to_organization(
    Target, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "InviteAccountToOrganization",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Target" => Target), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    leave_organization()
    leave_organization(params::Dict{String,<:Any})

Removes a member account from its parent organization. This version of the operation is
performed by the account that wants to leave. To remove a member account as a user in the
management account, use RemoveAccountFromOrganization instead. This operation can be called
only from a member account in the organization.    The management account in an
organization with all features enabled can set service control policies (SCPs) that can
restrict what administrators of member accounts can do. This includes preventing them from
successfully calling LeaveOrganization and leaving the organization.   You can leave an
organization as a member account only if the account is configured with the information
required to operate as a standalone account. When you create an account in an organization
using the Organizations console, API, or CLI commands, the information required of
standalone accounts is not automatically collected. For each account that you want to make
standalone, you must perform the following steps. If any of the steps are already completed
for this account, that step doesn't appear.   Choose a support plan   Provide and verify
the required contact information   Provide a current payment method   Amazon Web Services
uses the payment method to charge for any billable (not free tier) Amazon Web Services
activity that occurs while the account isn't attached to an organization. For more
information, see Considerations before removing an account from an organization in the
Organizations User Guide.   The account that you want to leave must not be a delegated
administrator account for any Amazon Web Services service enabled for your organization. If
the account is a delegated administrator, you must first change the delegated administrator
account to another account that is remaining in the organization.   You can leave an
organization only after you enable IAM user access to billing in your account. For more
information, see About IAM access to the Billing and Cost Management console in the Amazon
Web Services Billing and Cost Management User Guide.   After the account leaves the
organization, all tags that were attached to the account object in the organization are
deleted. Amazon Web Services accounts outside of an organization do not support tags.   A
newly created account has a waiting period before it can be removed from its organization.
If you get an error that indicates that a wait period is required, then try again in a few
days.   If you are using an organization principal to call LeaveOrganization across
multiple accounts, you can only do this up to 5 accounts per second in a single
organization.

"""
function leave_organization(; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "LeaveOrganization"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function leave_organization(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "LeaveOrganization", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_accounts()
    list_accounts(params::Dict{String,<:Any})

Lists all the accounts in the organization. To request only the accounts in a specified
root or organizational unit (OU), use the ListAccountsForParent operation instead.  Always
check the NextToken response parameter for a null value when calling a List* operation.
These operations can occasionally return an empty set of results even when there are more
results available. The NextToken response parameter value is null only when there are no
more results to display.  This operation can be called only from the organization's
management account or by a member account that is a delegated administrator for an Amazon
Web Services service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The total number of results that you want included on each page of the
  response. If you do not include this parameter, it defaults to a value that is specific to
  the operation. If additional items exist beyond the maximum you specify, the NextToken
  response element is present and has a value (is not null). Include that value as the
  NextToken request parameter in the next call to the operation to get the next part of the
  results. Note that Organizations might return fewer results than the maximum even when
  there are more results available. You should check NextToken after every operation to
  ensure that you receive all of the results.
- `"NextToken"`: The parameter for receiving additional results if you receive a NextToken
  response in a previous request. A NextToken response indicates that more output is
  available. Set this parameter to the value of the previous call's NextToken response to
  indicate where the output should continue from.
"""
function list_accounts(; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "ListAccounts"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_accounts(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "ListAccounts", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_accounts_for_parent(parent_id)
    list_accounts_for_parent(parent_id, params::Dict{String,<:Any})

Lists the accounts in an organization that are contained by the specified target root or
organizational unit (OU). If you specify the root, you get a list of all the accounts that
aren't in any OU. If you specify an OU, you get a list of all the accounts in only that OU
and not in any child OUs. To get a list of all accounts in the organization, use the
ListAccounts operation.  Always check the NextToken response parameter for a null value
when calling a List* operation. These operations can occasionally return an empty set of
results even when there are more results available. The NextToken response parameter value
is null only when there are no more results to display.  This operation can be called only
from the organization's management account or by a member account that is a delegated
administrator for an Amazon Web Services service.

# Arguments
- `parent_id`: The unique identifier (ID) for the parent root or organization unit (OU)
  whose accounts you want to list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The total number of results that you want included on each page of the
  response. If you do not include this parameter, it defaults to a value that is specific to
  the operation. If additional items exist beyond the maximum you specify, the NextToken
  response element is present and has a value (is not null). Include that value as the
  NextToken request parameter in the next call to the operation to get the next part of the
  results. Note that Organizations might return fewer results than the maximum even when
  there are more results available. You should check NextToken after every operation to
  ensure that you receive all of the results.
- `"NextToken"`: The parameter for receiving additional results if you receive a NextToken
  response in a previous request. A NextToken response indicates that more output is
  available. Set this parameter to the value of the previous call's NextToken response to
  indicate where the output should continue from.
"""
function list_accounts_for_parent(
    ParentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "ListAccountsForParent",
        Dict{String,Any}("ParentId" => ParentId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_accounts_for_parent(
    ParentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "ListAccountsForParent",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ParentId" => ParentId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_awsservice_access_for_organization()
    list_awsservice_access_for_organization(params::Dict{String,<:Any})

Returns a list of the Amazon Web Services services that you enabled to integrate with your
organization. After a service on this list creates the resources that it requires for the
integration, it can perform operations on your organization and its accounts. For more
information about integrating other services with Organizations, including the list of
services that currently work with Organizations, see Using Organizations with other Amazon
Web Services services in the Organizations User Guide. This operation can be called only
from the organization's management account or by a member account that is a delegated
administrator for an Amazon Web Services service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The total number of results that you want included on each page of the
  response. If you do not include this parameter, it defaults to a value that is specific to
  the operation. If additional items exist beyond the maximum you specify, the NextToken
  response element is present and has a value (is not null). Include that value as the
  NextToken request parameter in the next call to the operation to get the next part of the
  results. Note that Organizations might return fewer results than the maximum even when
  there are more results available. You should check NextToken after every operation to
  ensure that you receive all of the results.
- `"NextToken"`: The parameter for receiving additional results if you receive a NextToken
  response in a previous request. A NextToken response indicates that more output is
  available. Set this parameter to the value of the previous call's NextToken response to
  indicate where the output should continue from.
"""
function list_awsservice_access_for_organization(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "ListAWSServiceAccessForOrganization";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_awsservice_access_for_organization(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "ListAWSServiceAccessForOrganization",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_children(child_type, parent_id)
    list_children(child_type, parent_id, params::Dict{String,<:Any})

Lists all of the organizational units (OUs) or accounts that are contained in the specified
parent OU or root. This operation, along with ListParents enables you to traverse the tree
structure that makes up this root.  Always check the NextToken response parameter for a
null value when calling a List* operation. These operations can occasionally return an
empty set of results even when there are more results available. The NextToken response
parameter value is null only when there are no more results to display.  This operation can
be called only from the organization's management account or by a member account that is a
delegated administrator for an Amazon Web Services service.

# Arguments
- `child_type`: Filters the output to include only the specified child type.
- `parent_id`: The unique identifier (ID) for the parent root or OU whose children you want
  to list. The regex pattern for a parent ID string requires one of the following:    Root -
  A string that begins with \"r-\" followed by from 4 to 32 lowercase letters or digits.
  Organizational unit (OU) - A string that begins with \"ou-\" followed by from 4 to 32
  lowercase letters or digits (the ID of the root that the OU is in). This string is followed
  by a second \"-\" dash and from 8 to 32 additional lowercase letters or digits.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The total number of results that you want included on each page of the
  response. If you do not include this parameter, it defaults to a value that is specific to
  the operation. If additional items exist beyond the maximum you specify, the NextToken
  response element is present and has a value (is not null). Include that value as the
  NextToken request parameter in the next call to the operation to get the next part of the
  results. Note that Organizations might return fewer results than the maximum even when
  there are more results available. You should check NextToken after every operation to
  ensure that you receive all of the results.
- `"NextToken"`: The parameter for receiving additional results if you receive a NextToken
  response in a previous request. A NextToken response indicates that more output is
  available. Set this parameter to the value of the previous call's NextToken response to
  indicate where the output should continue from.
"""
function list_children(
    ChildType, ParentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "ListChildren",
        Dict{String,Any}("ChildType" => ChildType, "ParentId" => ParentId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_children(
    ChildType,
    ParentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "ListChildren",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ChildType" => ChildType, "ParentId" => ParentId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_create_account_status()
    list_create_account_status(params::Dict{String,<:Any})

Lists the account creation requests that match the specified status that is currently being
tracked for the organization.  Always check the NextToken response parameter for a null
value when calling a List* operation. These operations can occasionally return an empty set
of results even when there are more results available. The NextToken response parameter
value is null only when there are no more results to display.  This operation can be called
only from the organization's management account or by a member account that is a delegated
administrator for an Amazon Web Services service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The total number of results that you want included on each page of the
  response. If you do not include this parameter, it defaults to a value that is specific to
  the operation. If additional items exist beyond the maximum you specify, the NextToken
  response element is present and has a value (is not null). Include that value as the
  NextToken request parameter in the next call to the operation to get the next part of the
  results. Note that Organizations might return fewer results than the maximum even when
  there are more results available. You should check NextToken after every operation to
  ensure that you receive all of the results.
- `"NextToken"`: The parameter for receiving additional results if you receive a NextToken
  response in a previous request. A NextToken response indicates that more output is
  available. Set this parameter to the value of the previous call's NextToken response to
  indicate where the output should continue from.
- `"States"`: A list of one or more states that you want included in the response. If this
  parameter isn't present, all requests are included in the response.
"""
function list_create_account_status(; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "ListCreateAccountStatus"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_create_account_status(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "ListCreateAccountStatus",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_delegated_administrators()
    list_delegated_administrators(params::Dict{String,<:Any})

Lists the Amazon Web Services accounts that are designated as delegated administrators in
this organization. This operation can be called only from the organization's management
account or by a member account that is a delegated administrator for an Amazon Web Services
service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The total number of results that you want included on each page of the
  response. If you do not include this parameter, it defaults to a value that is specific to
  the operation. If additional items exist beyond the maximum you specify, the NextToken
  response element is present and has a value (is not null). Include that value as the
  NextToken request parameter in the next call to the operation to get the next part of the
  results. Note that Organizations might return fewer results than the maximum even when
  there are more results available. You should check NextToken after every operation to
  ensure that you receive all of the results.
- `"NextToken"`: The parameter for receiving additional results if you receive a NextToken
  response in a previous request. A NextToken response indicates that more output is
  available. Set this parameter to the value of the previous call's NextToken response to
  indicate where the output should continue from.
- `"ServicePrincipal"`: Specifies a service principal name. If specified, then the
  operation lists the delegated administrators only for the specified service. If you don't
  specify a service principal, the operation lists all delegated administrators for all
  services in your organization.
"""
function list_delegated_administrators(; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "ListDelegatedAdministrators";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_delegated_administrators(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "ListDelegatedAdministrators",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_delegated_services_for_account(account_id)
    list_delegated_services_for_account(account_id, params::Dict{String,<:Any})

List the Amazon Web Services services for which the specified account is a delegated
administrator. This operation can be called only from the organization's management account
or by a member account that is a delegated administrator for an Amazon Web Services service.

# Arguments
- `account_id`: The account ID number of a delegated administrator account in the
  organization.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The total number of results that you want included on each page of the
  response. If you do not include this parameter, it defaults to a value that is specific to
  the operation. If additional items exist beyond the maximum you specify, the NextToken
  response element is present and has a value (is not null). Include that value as the
  NextToken request parameter in the next call to the operation to get the next part of the
  results. Note that Organizations might return fewer results than the maximum even when
  there are more results available. You should check NextToken after every operation to
  ensure that you receive all of the results.
- `"NextToken"`: The parameter for receiving additional results if you receive a NextToken
  response in a previous request. A NextToken response indicates that more output is
  available. Set this parameter to the value of the previous call's NextToken response to
  indicate where the output should continue from.
"""
function list_delegated_services_for_account(
    AccountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "ListDelegatedServicesForAccount",
        Dict{String,Any}("AccountId" => AccountId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_delegated_services_for_account(
    AccountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "ListDelegatedServicesForAccount",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AccountId" => AccountId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_handshakes_for_account()
    list_handshakes_for_account(params::Dict{String,<:Any})

Lists the current handshakes that are associated with the account of the requesting user.
Handshakes that are ACCEPTED, DECLINED, CANCELED, or EXPIRED appear in the results of this
API for only 30 days after changing to that state. After that, they're deleted and no
longer accessible.  Always check the NextToken response parameter for a null value when
calling a List* operation. These operations can occasionally return an empty set of results
even when there are more results available. The NextToken response parameter value is null
only when there are no more results to display.  This operation can be called from any
account in the organization.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: Filters the handshakes that you want included in the response. The default is
  all types. Use the ActionType element to limit the output to only a specified type, such as
  INVITE, ENABLE_ALL_FEATURES, or APPROVE_ALL_FEATURES. Alternatively, for the
  ENABLE_ALL_FEATURES handshake that generates a separate child handshake for each member
  account, you can specify ParentHandshakeId to see only the handshakes that were generated
  by that parent request.
- `"MaxResults"`: The total number of results that you want included on each page of the
  response. If you do not include this parameter, it defaults to a value that is specific to
  the operation. If additional items exist beyond the maximum you specify, the NextToken
  response element is present and has a value (is not null). Include that value as the
  NextToken request parameter in the next call to the operation to get the next part of the
  results. Note that Organizations might return fewer results than the maximum even when
  there are more results available. You should check NextToken after every operation to
  ensure that you receive all of the results.
- `"NextToken"`: The parameter for receiving additional results if you receive a NextToken
  response in a previous request. A NextToken response indicates that more output is
  available. Set this parameter to the value of the previous call's NextToken response to
  indicate where the output should continue from.
"""
function list_handshakes_for_account(; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "ListHandshakesForAccount"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_handshakes_for_account(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "ListHandshakesForAccount",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_handshakes_for_organization()
    list_handshakes_for_organization(params::Dict{String,<:Any})

Lists the handshakes that are associated with the organization that the requesting user is
part of. The ListHandshakesForOrganization operation returns a list of handshake
structures. Each structure contains details and status about a handshake. Handshakes that
are ACCEPTED, DECLINED, CANCELED, or EXPIRED appear in the results of this API for only 30
days after changing to that state. After that, they're deleted and no longer accessible.
Always check the NextToken response parameter for a null value when calling a List*
operation. These operations can occasionally return an empty set of results even when there
are more results available. The NextToken response parameter value is null only when there
are no more results to display.  This operation can be called only from the organization's
management account or by a member account that is a delegated administrator for an Amazon
Web Services service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: A filter of the handshakes that you want included in the response. The
  default is all types. Use the ActionType element to limit the output to only a specified
  type, such as INVITE, ENABLE-ALL-FEATURES, or APPROVE-ALL-FEATURES. Alternatively, for the
  ENABLE-ALL-FEATURES handshake that generates a separate child handshake for each member
  account, you can specify the ParentHandshakeId to see only the handshakes that were
  generated by that parent request.
- `"MaxResults"`: The total number of results that you want included on each page of the
  response. If you do not include this parameter, it defaults to a value that is specific to
  the operation. If additional items exist beyond the maximum you specify, the NextToken
  response element is present and has a value (is not null). Include that value as the
  NextToken request parameter in the next call to the operation to get the next part of the
  results. Note that Organizations might return fewer results than the maximum even when
  there are more results available. You should check NextToken after every operation to
  ensure that you receive all of the results.
- `"NextToken"`: The parameter for receiving additional results if you receive a NextToken
  response in a previous request. A NextToken response indicates that more output is
  available. Set this parameter to the value of the previous call's NextToken response to
  indicate where the output should continue from.
"""
function list_handshakes_for_organization(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "ListHandshakesForOrganization";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_handshakes_for_organization(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "ListHandshakesForOrganization",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_organizational_units_for_parent(parent_id)
    list_organizational_units_for_parent(parent_id, params::Dict{String,<:Any})

Lists the organizational units (OUs) in a parent organizational unit or root.  Always check
the NextToken response parameter for a null value when calling a List* operation. These
operations can occasionally return an empty set of results even when there are more results
available. The NextToken response parameter value is null only when there are no more
results to display.  This operation can be called only from the organization's management
account or by a member account that is a delegated administrator for an Amazon Web Services
service.

# Arguments
- `parent_id`: The unique identifier (ID) of the root or OU whose child OUs you want to
  list. The regex pattern for a parent ID string requires one of the following:    Root - A
  string that begins with \"r-\" followed by from 4 to 32 lowercase letters or digits.
  Organizational unit (OU) - A string that begins with \"ou-\" followed by from 4 to 32
  lowercase letters or digits (the ID of the root that the OU is in). This string is followed
  by a second \"-\" dash and from 8 to 32 additional lowercase letters or digits.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The total number of results that you want included on each page of the
  response. If you do not include this parameter, it defaults to a value that is specific to
  the operation. If additional items exist beyond the maximum you specify, the NextToken
  response element is present and has a value (is not null). Include that value as the
  NextToken request parameter in the next call to the operation to get the next part of the
  results. Note that Organizations might return fewer results than the maximum even when
  there are more results available. You should check NextToken after every operation to
  ensure that you receive all of the results.
- `"NextToken"`: The parameter for receiving additional results if you receive a NextToken
  response in a previous request. A NextToken response indicates that more output is
  available. Set this parameter to the value of the previous call's NextToken response to
  indicate where the output should continue from.
"""
function list_organizational_units_for_parent(
    ParentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "ListOrganizationalUnitsForParent",
        Dict{String,Any}("ParentId" => ParentId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_organizational_units_for_parent(
    ParentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "ListOrganizationalUnitsForParent",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ParentId" => ParentId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_parents(child_id)
    list_parents(child_id, params::Dict{String,<:Any})

Lists the root or organizational units (OUs) that serve as the immediate parent of the
specified child OU or account. This operation, along with ListChildren enables you to
traverse the tree structure that makes up this root.  Always check the NextToken response
parameter for a null value when calling a List* operation. These operations can
occasionally return an empty set of results even when there are more results available. The
NextToken response parameter value is null only when there are no more results to display.
This operation can be called only from the organization's management account or by a member
account that is a delegated administrator for an Amazon Web Services service.  In the
current release, a child can have only a single parent.

# Arguments
- `child_id`: The unique identifier (ID) of the OU or account whose parent containers you
  want to list. Don't specify a root. The regex pattern for a child ID string requires one of
  the following:    Account - A string that consists of exactly 12 digits.    Organizational
  unit (OU) - A string that begins with \"ou-\" followed by from 4 to 32 lowercase letters or
  digits (the ID of the root that contains the OU). This string is followed by a second \"-\"
  dash and from 8 to 32 additional lowercase letters or digits.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The total number of results that you want included on each page of the
  response. If you do not include this parameter, it defaults to a value that is specific to
  the operation. If additional items exist beyond the maximum you specify, the NextToken
  response element is present and has a value (is not null). Include that value as the
  NextToken request parameter in the next call to the operation to get the next part of the
  results. Note that Organizations might return fewer results than the maximum even when
  there are more results available. You should check NextToken after every operation to
  ensure that you receive all of the results.
- `"NextToken"`: The parameter for receiving additional results if you receive a NextToken
  response in a previous request. A NextToken response indicates that more output is
  available. Set this parameter to the value of the previous call's NextToken response to
  indicate where the output should continue from.
"""
function list_parents(ChildId; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "ListParents",
        Dict{String,Any}("ChildId" => ChildId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_parents(
    ChildId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "ListParents",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("ChildId" => ChildId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_policies(filter)
    list_policies(filter, params::Dict{String,<:Any})

Retrieves the list of all policies in an organization of a specified type.  Always check
the NextToken response parameter for a null value when calling a List* operation. These
operations can occasionally return an empty set of results even when there are more results
available. The NextToken response parameter value is null only when there are no more
results to display.  This operation can be called only from the organization's management
account or by a member account that is a delegated administrator for an Amazon Web Services
service.

# Arguments
- `filter`: Specifies the type of policy that you want to include in the response. You must
  specify one of the following values:    AISERVICES_OPT_OUT_POLICY     BACKUP_POLICY
  SERVICE_CONTROL_POLICY     TAG_POLICY

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The total number of results that you want included on each page of the
  response. If you do not include this parameter, it defaults to a value that is specific to
  the operation. If additional items exist beyond the maximum you specify, the NextToken
  response element is present and has a value (is not null). Include that value as the
  NextToken request parameter in the next call to the operation to get the next part of the
  results. Note that Organizations might return fewer results than the maximum even when
  there are more results available. You should check NextToken after every operation to
  ensure that you receive all of the results.
- `"NextToken"`: The parameter for receiving additional results if you receive a NextToken
  response in a previous request. A NextToken response indicates that more output is
  available. Set this parameter to the value of the previous call's NextToken response to
  indicate where the output should continue from.
"""
function list_policies(Filter; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "ListPolicies",
        Dict{String,Any}("Filter" => Filter);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_policies(
    Filter, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "ListPolicies",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Filter" => Filter), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_policies_for_target(filter, target_id)
    list_policies_for_target(filter, target_id, params::Dict{String,<:Any})

Lists the policies that are directly attached to the specified target root, organizational
unit (OU), or account. You must specify the policy type that you want included in the
returned list.  Always check the NextToken response parameter for a null value when calling
a List* operation. These operations can occasionally return an empty set of results even
when there are more results available. The NextToken response parameter value is null only
when there are no more results to display.  This operation can be called only from the
organization's management account or by a member account that is a delegated administrator
for an Amazon Web Services service.

# Arguments
- `filter`: The type of policy that you want to include in the returned list. You must
  specify one of the following values:    AISERVICES_OPT_OUT_POLICY     BACKUP_POLICY
  SERVICE_CONTROL_POLICY     TAG_POLICY
- `target_id`: The unique identifier (ID) of the root, organizational unit, or account
  whose policies you want to list. The regex pattern for a target ID string requires one of
  the following:    Root - A string that begins with \"r-\" followed by from 4 to 32
  lowercase letters or digits.    Account - A string that consists of exactly 12 digits.
  Organizational unit (OU) - A string that begins with \"ou-\" followed by from 4 to 32
  lowercase letters or digits (the ID of the root that the OU is in). This string is followed
  by a second \"-\" dash and from 8 to 32 additional lowercase letters or digits.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The total number of results that you want included on each page of the
  response. If you do not include this parameter, it defaults to a value that is specific to
  the operation. If additional items exist beyond the maximum you specify, the NextToken
  response element is present and has a value (is not null). Include that value as the
  NextToken request parameter in the next call to the operation to get the next part of the
  results. Note that Organizations might return fewer results than the maximum even when
  there are more results available. You should check NextToken after every operation to
  ensure that you receive all of the results.
- `"NextToken"`: The parameter for receiving additional results if you receive a NextToken
  response in a previous request. A NextToken response indicates that more output is
  available. Set this parameter to the value of the previous call's NextToken response to
  indicate where the output should continue from.
"""
function list_policies_for_target(
    Filter, TargetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "ListPoliciesForTarget",
        Dict{String,Any}("Filter" => Filter, "TargetId" => TargetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_policies_for_target(
    Filter,
    TargetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "ListPoliciesForTarget",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Filter" => Filter, "TargetId" => TargetId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_roots()
    list_roots(params::Dict{String,<:Any})

Lists the roots that are defined in the current organization.  Always check the NextToken
response parameter for a null value when calling a List* operation. These operations can
occasionally return an empty set of results even when there are more results available. The
NextToken response parameter value is null only when there are no more results to display.
This operation can be called only from the organization's management account or by a member
account that is a delegated administrator for an Amazon Web Services service.  Policy types
can be enabled and disabled in roots. This is distinct from whether they're available in
the organization. When you enable all features, you make policy types available for use in
that organization. Individual policy types can then be enabled and disabled in a root. To
see the availability of a policy type in an organization, use DescribeOrganization.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The total number of results that you want included on each page of the
  response. If you do not include this parameter, it defaults to a value that is specific to
  the operation. If additional items exist beyond the maximum you specify, the NextToken
  response element is present and has a value (is not null). Include that value as the
  NextToken request parameter in the next call to the operation to get the next part of the
  results. Note that Organizations might return fewer results than the maximum even when
  there are more results available. You should check NextToken after every operation to
  ensure that you receive all of the results.
- `"NextToken"`: The parameter for receiving additional results if you receive a NextToken
  response in a previous request. A NextToken response indicates that more output is
  available. Set this parameter to the value of the previous call's NextToken response to
  indicate where the output should continue from.
"""
function list_roots(; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "ListRoots"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_roots(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "ListRoots", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_id)
    list_tags_for_resource(resource_id, params::Dict{String,<:Any})

Lists tags that are attached to the specified resource. You can attach tags to the
following resources in Organizations.   Amazon Web Services account   Organization root
Organizational unit (OU)   Policy (any type)   This operation can be called only from the
organization's management account or by a member account that is a delegated administrator
for an Amazon Web Services service.

# Arguments
- `resource_id`: The ID of the resource with the tags to list. You can specify any of the
  following taggable resources.   Amazon Web Services account – specify the account ID
  number.   Organizational unit – specify the OU ID that begins with ou- and looks similar
  to: ou-1a2b-34uvwxyz     Root – specify the root ID that begins with r- and looks similar
  to: r-1a2b     Policy – specify the policy ID that begins with p- andlooks similar to:
  p-12abcdefg3

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: The parameter for receiving additional results if you receive a NextToken
  response in a previous request. A NextToken response indicates that more output is
  available. Set this parameter to the value of the previous call's NextToken response to
  indicate where the output should continue from.
"""
function list_tags_for_resource(
    ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "ListTagsForResource",
        Dict{String,Any}("ResourceId" => ResourceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceId" => ResourceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_targets_for_policy(policy_id)
    list_targets_for_policy(policy_id, params::Dict{String,<:Any})

Lists all the roots, organizational units (OUs), and accounts that the specified policy is
attached to.  Always check the NextToken response parameter for a null value when calling a
List* operation. These operations can occasionally return an empty set of results even when
there are more results available. The NextToken response parameter value is null only when
there are no more results to display.  This operation can be called only from the
organization's management account or by a member account that is a delegated administrator
for an Amazon Web Services service.

# Arguments
- `policy_id`: The unique identifier (ID) of the policy whose attachments you want to know.
  The regex pattern for a policy ID string requires \"p-\" followed by from 8 to 128
  lowercase or uppercase letters, digits, or the underscore character (_).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The total number of results that you want included on each page of the
  response. If you do not include this parameter, it defaults to a value that is specific to
  the operation. If additional items exist beyond the maximum you specify, the NextToken
  response element is present and has a value (is not null). Include that value as the
  NextToken request parameter in the next call to the operation to get the next part of the
  results. Note that Organizations might return fewer results than the maximum even when
  there are more results available. You should check NextToken after every operation to
  ensure that you receive all of the results.
- `"NextToken"`: The parameter for receiving additional results if you receive a NextToken
  response in a previous request. A NextToken response indicates that more output is
  available. Set this parameter to the value of the previous call's NextToken response to
  indicate where the output should continue from.
"""
function list_targets_for_policy(
    PolicyId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "ListTargetsForPolicy",
        Dict{String,Any}("PolicyId" => PolicyId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_targets_for_policy(
    PolicyId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "ListTargetsForPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PolicyId" => PolicyId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    move_account(account_id, destination_parent_id, source_parent_id)
    move_account(account_id, destination_parent_id, source_parent_id, params::Dict{String,<:Any})

Moves an account from its current source parent root or organizational unit (OU) to the
specified destination parent root or OU. This operation can be called only from the
organization's management account.

# Arguments
- `account_id`: The unique identifier (ID) of the account that you want to move. The regex
  pattern for an account ID string requires exactly 12 digits.
- `destination_parent_id`: The unique identifier (ID) of the root or organizational unit
  that you want to move the account to. The regex pattern for a parent ID string requires one
  of the following:    Root - A string that begins with \"r-\" followed by from 4 to 32
  lowercase letters or digits.    Organizational unit (OU) - A string that begins with
  \"ou-\" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the
  OU is in). This string is followed by a second \"-\" dash and from 8 to 32 additional
  lowercase letters or digits.
- `source_parent_id`: The unique identifier (ID) of the root or organizational unit that
  you want to move the account from. The regex pattern for a parent ID string requires one of
  the following:    Root - A string that begins with \"r-\" followed by from 4 to 32
  lowercase letters or digits.    Organizational unit (OU) - A string that begins with
  \"ou-\" followed by from 4 to 32 lowercase letters or digits (the ID of the root that the
  OU is in). This string is followed by a second \"-\" dash and from 8 to 32 additional
  lowercase letters or digits.

"""
function move_account(
    AccountId,
    DestinationParentId,
    SourceParentId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "MoveAccount",
        Dict{String,Any}(
            "AccountId" => AccountId,
            "DestinationParentId" => DestinationParentId,
            "SourceParentId" => SourceParentId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function move_account(
    AccountId,
    DestinationParentId,
    SourceParentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "MoveAccount",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId,
                    "DestinationParentId" => DestinationParentId,
                    "SourceParentId" => SourceParentId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_resource_policy(content)
    put_resource_policy(content, params::Dict{String,<:Any})

Creates or updates a resource policy. You can only call this operation from the
organization's management account.

# Arguments
- `content`: If provided, the new content for the resource policy. The text must be
  correctly formatted JSON that complies with the syntax for the resource policy's type. For
  more information, see SCP syntax in the Organizations User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: A list of tags that you want to attach to the newly created resource policy.
  For each tag in the list, you must specify both a tag key and a value. You can set the
  value to an empty string, but you can't set it to null. For more information about tagging,
  see Tagging Organizations resources in the Organizations User Guide.  Calls with tags apply
  to the initial creation of the resource policy, otherwise an exception is thrown. If any
  one of the tags is not valid or if you exceed the allowed number of tags for the resource
  policy, then the entire request fails and the resource policy is not created.
"""
function put_resource_policy(Content; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "PutResourcePolicy",
        Dict{String,Any}("Content" => Content);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_resource_policy(
    Content,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "PutResourcePolicy",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Content" => Content), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_delegated_administrator(account_id, service_principal)
    register_delegated_administrator(account_id, service_principal, params::Dict{String,<:Any})

Enables the specified member account to administer the Organizations features of the
specified Amazon Web Services service. It grants read-only access to Organizations service
data. The account still requires IAM permissions to access and administer the Amazon Web
Services service. You can run this action only for Amazon Web Services services that
support this feature. For a current list of services that support it, see the column
Supports Delegated Administrator in the table at Amazon Web Services Services that you can
use with Organizations in the Organizations User Guide.  This operation can be called only
from the organization's management account.

# Arguments
- `account_id`: The account ID number of the member account in the organization to register
  as a delegated administrator.
- `service_principal`: The service principal of the Amazon Web Services service for which
  you want to make the member account a delegated administrator.

"""
function register_delegated_administrator(
    AccountId, ServicePrincipal; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "RegisterDelegatedAdministrator",
        Dict{String,Any}("AccountId" => AccountId, "ServicePrincipal" => ServicePrincipal);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_delegated_administrator(
    AccountId,
    ServicePrincipal,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "RegisterDelegatedAdministrator",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccountId" => AccountId, "ServicePrincipal" => ServicePrincipal
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_account_from_organization(account_id)
    remove_account_from_organization(account_id, params::Dict{String,<:Any})

Removes the specified account from the organization. The removed account becomes a
standalone account that isn't a member of any organization. It's no longer subject to any
policies and is responsible for its own bill payments. The organization's management
account is no longer charged for any expenses accrued by the member account after it's
removed from the organization. This operation can be called only from the organization's
management account. Member accounts can remove themselves with LeaveOrganization instead.
 You can remove an account from your organization only if the account is configured with
the information required to operate as a standalone account. When you create an account in
an organization using the Organizations console, API, or CLI commands, the information
required of standalone accounts is not automatically collected. For more information, see
Considerations before removing an account from an organization in the Organizations User
Guide.   The account that you want to leave must not be a delegated administrator account
for any Amazon Web Services service enabled for your organization. If the account is a
delegated administrator, you must first change the delegated administrator account to
another account that is remaining in the organization.   After the account leaves the
organization, all tags that were attached to the account object in the organization are
deleted. Amazon Web Services accounts outside of an organization do not support tags.

# Arguments
- `account_id`: The unique identifier (ID) of the member account that you want to remove
  from the organization. The regex pattern for an account ID string requires exactly 12
  digits.

"""
function remove_account_from_organization(
    AccountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "RemoveAccountFromOrganization",
        Dict{String,Any}("AccountId" => AccountId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_account_from_organization(
    AccountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "RemoveAccountFromOrganization",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AccountId" => AccountId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_id, tags)
    tag_resource(resource_id, tags, params::Dict{String,<:Any})

Adds one or more tags to the specified resource. Currently, you can attach tags to the
following resources in Organizations.   Amazon Web Services account   Organization root
Organizational unit (OU)   Policy (any type)   This operation can be called only from the
organization's management account or by a member account that is a delegated administrator
for an Amazon Web Services service.

# Arguments
- `resource_id`: The ID of the resource to add a tag to. You can specify any of the
  following taggable resources.   Amazon Web Services account – specify the account ID
  number.   Organizational unit – specify the OU ID that begins with ou- and looks similar
  to: ou-1a2b-34uvwxyz     Root – specify the root ID that begins with r- and looks similar
  to: r-1a2b     Policy – specify the policy ID that begins with p- andlooks similar to:
  p-12abcdefg3
- `tags`: A list of tags to add to the specified resource. For each tag in the list, you
  must specify both a tag key and a value. The value can be an empty string, but you can't
  set it to null.  If any one of the tags is not valid or if you exceed the maximum allowed
  number of tags for a resource, then the entire request fails.

"""
function tag_resource(ResourceId, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "TagResource",
        Dict{String,Any}("ResourceId" => ResourceId, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceId,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ResourceId" => ResourceId, "Tags" => Tags), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_id, tag_keys)
    untag_resource(resource_id, tag_keys, params::Dict{String,<:Any})

Removes any tags with the specified keys from the specified resource. You can attach tags
to the following resources in Organizations.   Amazon Web Services account   Organization
root   Organizational unit (OU)   Policy (any type)   This operation can be called only
from the organization's management account or by a member account that is a delegated
administrator for an Amazon Web Services service.

# Arguments
- `resource_id`: The ID of the resource to remove a tag from. You can specify any of the
  following taggable resources.   Amazon Web Services account – specify the account ID
  number.   Organizational unit – specify the OU ID that begins with ou- and looks similar
  to: ou-1a2b-34uvwxyz     Root – specify the root ID that begins with r- and looks similar
  to: r-1a2b     Policy – specify the policy ID that begins with p- andlooks similar to:
  p-12abcdefg3
- `tag_keys`: The list of keys for tags to remove from the specified resource.

"""
function untag_resource(
    ResourceId, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "UntagResource",
        Dict{String,Any}("ResourceId" => ResourceId, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceId,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceId" => ResourceId, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_organizational_unit(organizational_unit_id)
    update_organizational_unit(organizational_unit_id, params::Dict{String,<:Any})

Renames the specified organizational unit (OU). The ID and ARN don't change. The child OUs
and accounts remain in place, and any attached policies of the OU remain attached. This
operation can be called only from the organization's management account.

# Arguments
- `organizational_unit_id`: The unique identifier (ID) of the OU that you want to rename.
  You can get the ID from the ListOrganizationalUnitsForParent operation. The regex pattern
  for an organizational unit ID string requires \"ou-\" followed by from 4 to 32 lowercase
  letters or digits (the ID of the root that contains the OU). This string is followed by a
  second \"-\" dash and from 8 to 32 additional lowercase letters or digits.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Name"`: The new name that you want to assign to the OU. The regex pattern that is used
  to validate this parameter is a string of any of the characters in the ASCII character
  range.
"""
function update_organizational_unit(
    OrganizationalUnitId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return organizations(
        "UpdateOrganizationalUnit",
        Dict{String,Any}("OrganizationalUnitId" => OrganizationalUnitId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_organizational_unit(
    OrganizationalUnitId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "UpdateOrganizationalUnit",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("OrganizationalUnitId" => OrganizationalUnitId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_policy(policy_id)
    update_policy(policy_id, params::Dict{String,<:Any})

Updates an existing policy with a new name, description, or content. If you don't supply
any parameter, that value remains unchanged. You can't change a policy's type. This
operation can be called only from the organization's management account or by a member
account that is a delegated administrator for an Amazon Web Services service.

# Arguments
- `policy_id`: The unique identifier (ID) of the policy that you want to update. The regex
  pattern for a policy ID string requires \"p-\" followed by from 8 to 128 lowercase or
  uppercase letters, digits, or the underscore character (_).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Content"`: If provided, the new content for the policy. The text must be correctly
  formatted JSON that complies with the syntax for the policy's type. For more information,
  see SCP syntax in the Organizations User Guide. The maximum size of a policy document
  depends on the policy's type. For more information, see Maximum and minimum values in the
  Organizations User Guide.
- `"Description"`: If provided, the new description for the policy.
- `"Name"`: If provided, the new name for the policy. The regex pattern that is used to
  validate this parameter is a string of any of the characters in the ASCII character range.
"""
function update_policy(PolicyId; aws_config::AbstractAWSConfig=current_aws_config())
    return organizations(
        "UpdatePolicy",
        Dict{String,Any}("PolicyId" => PolicyId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_policy(
    PolicyId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return organizations(
        "UpdatePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PolicyId" => PolicyId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
