# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: simpledb
using AWS.Compat
using AWS.UUIDs

"""
    batch_delete_attributes(domain_name, item)
    batch_delete_attributes(domain_name, item, params::Dict{String,<:Any})

 Performs multiple DeleteAttributes operations in a single call, which reduces round trips
and latencies. This enables Amazon SimpleDB to optimize requests, which generally yields
better throughput.    If you specify BatchDeleteAttributes without attributes or values,
all the attributes for the item are deleted.   BatchDeleteAttributes is an idempotent
operation; running it multiple times on the same item or attribute doesn't result in an
error.   The BatchDeleteAttributes operation succeeds or fails in its entirety. There are
no partial deletes. You can execute multiple BatchDeleteAttributes operations and other
operations in parallel. However, large numbers of concurrent BatchDeleteAttributes calls
can result in Service Unavailable (503) responses.   This operation is vulnerable to
exceeding the maximum URL size when making a REST request using the HTTP GET method.   This
operation does not support conditions using Expected.X.Name, Expected.X.Value, or
Expected.X.Exists.    The following limitations are enforced for this operation:  1 MB
request size 25 item limit per BatchDeleteAttributes operation

# Arguments
- `domain_name`: The name of the domain in which the attributes are being deleted.
- `item`: A list of items on which to perform the operation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Items"`: A list of items on which to perform the operation.
"""
function batch_delete_attributes(
    DomainName, Item; aws_config::AbstractAWSConfig=current_aws_config()
)
    return simpledb(
        "BatchDeleteAttributes",
        Dict{String,Any}("DomainName" => DomainName, "Item" => Item);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_delete_attributes(
    DomainName,
    Item,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return simpledb(
        "BatchDeleteAttributes",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("DomainName" => DomainName, "Item" => Item), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_put_attributes(domain_name, item)
    batch_put_attributes(domain_name, item, params::Dict{String,<:Any})

 The BatchPutAttributes operation creates or replaces attributes within one or more items.
By using this operation, the client can perform multiple PutAttribute operation with a
single call. This helps yield savings in round trips and latencies, enabling Amazon
SimpleDB to optimize requests and generally produce better throughput.   The client may
specify the item name with the Item.X.ItemName parameter. The client may specify new
attributes using a combination of the Item.X.Attribute.Y.Name and Item.X.Attribute.Y.Value
parameters. The client may specify the first attribute for the first item using the
parameters Item.0.Attribute.0.Name and Item.0.Attribute.0.Value, and for the second
attribute for the first item by the parameters Item.0.Attribute.1.Name and
Item.0.Attribute.1.Value, and so on.   Attributes are uniquely identified within an item by
their name/value combination. For example, a single item can have the attributes {
\"first_name\", \"first_value\" } and { \"first_name\", \"second_value\" }. However, it
cannot have two attribute instances where both the Item.X.Attribute.Y.Name and
Item.X.Attribute.Y.Value are the same.   Optionally, the requester can supply the Replace
parameter for each individual value. Setting this value to true will cause the new
attribute values to replace the existing attribute values. For example, if an item I has
the attributes { 'a', '1' }, { 'b', '2'} and { 'b', '3' } and the requester does a
BatchPutAttributes of {'I', 'b', '4' } with the Replace parameter set to true, the final
attributes of the item will be { 'a', '1' } and { 'b', '4' }, replacing the previous values
of the 'b' attribute with the new value.   You cannot specify an empty string as an item or
as an attribute name. The BatchPutAttributes operation succeeds or fails in its entirety.
There are no partial puts.   This operation is vulnerable to exceeding the maximum URL size
when making a REST request using the HTTP GET method. This operation does not support
conditions using Expected.X.Name, Expected.X.Value, or Expected.X.Exists.   You can execute
multiple BatchPutAttributes operations and other operations in parallel. However, large
numbers of concurrent BatchPutAttributes calls can result in Service Unavailable (503)
responses.   The following limitations are enforced for this operation:  256 attribute
name-value pairs per item 1 MB request size 1 billion attributes per domain 10 GB of total
user data storage per domain 25 item limit per BatchPutAttributes operation

# Arguments
- `domain_name`: The name of the domain in which the attributes are being stored.
- `item`: A list of items on which to perform the operation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Items"`: A list of items on which to perform the operation.
"""
function batch_put_attributes(
    DomainName, Item; aws_config::AbstractAWSConfig=current_aws_config()
)
    return simpledb(
        "BatchPutAttributes",
        Dict{String,Any}("DomainName" => DomainName, "Item" => Item);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_put_attributes(
    DomainName,
    Item,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return simpledb(
        "BatchPutAttributes",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("DomainName" => DomainName, "Item" => Item), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_domain(domain_name)
    create_domain(domain_name, params::Dict{String,<:Any})

 The CreateDomain operation creates a new domain. The domain name should be unique among
the domains associated with the Access Key ID provided in the request. The CreateDomain
operation may take 10 or more seconds to complete.   CreateDomain is an idempotent
operation; running it multiple times using the same domain name will not result in an error
response.   The client can create up to 100 domains per account.   If the client requires
additional domains, go to  http://aws.amazon.com/contact-us/simpledb-limit-request/.

# Arguments
- `domain_name`: The name of the domain to create. The name can range between 3 and 255
  characters and can contain the following characters: a-z, A-Z, 0-9, '_', '-', and '.'.

"""
function create_domain(DomainName; aws_config::AbstractAWSConfig=current_aws_config())
    return simpledb(
        "CreateDomain",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_domain(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return simpledb(
        "CreateDomain",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_attributes(domain_name, item_name)
    delete_attributes(domain_name, item_name, params::Dict{String,<:Any})

 Deletes one or more attributes associated with an item. If all attributes of the item are
deleted, the item is deleted.   If DeleteAttributes is called without being passed any
attributes or values specified, all the attributes for the item are deleted.
DeleteAttributes is an idempotent operation; running it multiple times on the same item or
attribute does not result in an error response.   Because Amazon SimpleDB makes multiple
copies of item data and uses an eventual consistency update model, performing a
GetAttributes or Select operation (read) immediately after a DeleteAttributes or
PutAttributes operation (write) might not return updated item data.

# Arguments
- `domain_name`: The name of the domain in which to perform the operation.
- `item_name`: The name of the item. Similar to rows on a spreadsheet, items represent
  individual objects that contain one or more value-attribute pairs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Attributes"`: A list of Attributes. Similar to columns on a spreadsheet, attributes
  represent categories of data that can be assigned to items.
- `"Expected"`: The update condition which, if specified, determines whether the specified
  attributes will be deleted or not. The update condition must be satisfied in order for this
  request to be processed and the attributes to be deleted.
"""
function delete_attributes(
    DomainName, ItemName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return simpledb(
        "DeleteAttributes",
        Dict{String,Any}("DomainName" => DomainName, "ItemName" => ItemName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_attributes(
    DomainName,
    ItemName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return simpledb(
        "DeleteAttributes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DomainName" => DomainName, "ItemName" => ItemName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_domain(domain_name)
    delete_domain(domain_name, params::Dict{String,<:Any})

 The DeleteDomain operation deletes a domain. Any items (and their attributes) in the
domain are deleted as well. The DeleteDomain operation might take 10 or more seconds to
complete.   Running DeleteDomain on a domain that does not exist or running the function
multiple times using the same domain name will not result in an error response.

# Arguments
- `domain_name`: The name of the domain to delete.

"""
function delete_domain(DomainName; aws_config::AbstractAWSConfig=current_aws_config())
    return simpledb(
        "DeleteDomain",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_domain(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return simpledb(
        "DeleteDomain",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    domain_metadata(domain_name)
    domain_metadata(domain_name, params::Dict{String,<:Any})

 Returns information about the domain, including when the domain was created, the number of
items and attributes in the domain, and the size of the attribute names and values.

# Arguments
- `domain_name`: The name of the domain for which to display the metadata of.

"""
function domain_metadata(DomainName; aws_config::AbstractAWSConfig=current_aws_config())
    return simpledb(
        "DomainMetadata",
        Dict{String,Any}("DomainName" => DomainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function domain_metadata(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return simpledb(
        "DomainMetadata",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DomainName" => DomainName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_attributes(domain_name, item_name)
    get_attributes(domain_name, item_name, params::Dict{String,<:Any})

 Returns all of the attributes associated with the specified item. Optionally, the
attributes returned can be limited to one or more attributes by specifying an attribute
name parameter.   If the item does not exist on the replica that was accessed for this
operation, an empty set is returned. The system does not return an error as it cannot
guarantee the item does not exist on other replicas.   If GetAttributes is called without
being passed any attribute names, all the attributes for the item are returned.

# Arguments
- `domain_name`: The name of the domain in which to perform the operation.
- `item_name`: The name of the item.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AttributeNames"`: The names of the attributes.
- `"ConsistentRead"`: Determines whether or not strong consistency should be enforced when
  data is read from SimpleDB. If true, any data previously written to SimpleDB will be
  returned. Otherwise, results will be consistent eventually, and the client may not see data
  that was written immediately before your read.
"""
function get_attributes(
    DomainName, ItemName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return simpledb(
        "GetAttributes",
        Dict{String,Any}("DomainName" => DomainName, "ItemName" => ItemName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_attributes(
    DomainName,
    ItemName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return simpledb(
        "GetAttributes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DomainName" => DomainName, "ItemName" => ItemName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_domains()
    list_domains(params::Dict{String,<:Any})

 The ListDomains operation lists all domains associated with the Access Key ID. It returns
domain names up to the limit set by MaxNumberOfDomains. A NextToken is returned if there
are more than MaxNumberOfDomains domains. Calling ListDomains successive times with the
NextToken provided by the operation returns up to MaxNumberOfDomains more domain names with
each successive operation call.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxNumberOfDomains"`: The maximum number of domain names you want returned. The range
  is 1 to 100. The default setting is 100.
- `"NextToken"`: A string informing Amazon SimpleDB where to start the next list of domain
  names.
"""
function list_domains(; aws_config::AbstractAWSConfig=current_aws_config())
    return simpledb("ListDomains"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_domains(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return simpledb(
        "ListDomains", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    put_attributes(attribute, domain_name, item_name)
    put_attributes(attribute, domain_name, item_name, params::Dict{String,<:Any})

 The PutAttributes operation creates or replaces attributes in an item. The client may
specify new attributes using a combination of the Attribute.X.Name and Attribute.X.Value
parameters. The client specifies the first attribute by the parameters Attribute.0.Name and
Attribute.0.Value, the second attribute by the parameters Attribute.1.Name and
Attribute.1.Value, and so on.   Attributes are uniquely identified in an item by their
name/value combination. For example, a single item can have the attributes {
\"first_name\", \"first_value\" } and { \"first_name\", second_value\" }. However, it
cannot have two attribute instances where both the Attribute.X.Name and Attribute.X.Value
are the same.   Optionally, the requestor can supply the Replace parameter for each
individual attribute. Setting this value to true causes the new attribute value to replace
the existing attribute value(s). For example, if an item has the attributes { 'a', '1' }, {
'b', '2'} and { 'b', '3' } and the requestor calls PutAttributes using the attributes {
'b', '4' } with the Replace parameter set to true, the final attributes of the item are
changed to { 'a', '1' } and { 'b', '4' }, which replaces the previous values of the 'b'
attribute with the new value.   Using PutAttributes to replace attribute values that do not
exist will not result in an error response.   You cannot specify an empty string as an
attribute name.   Because Amazon SimpleDB makes multiple copies of client data and uses an
eventual consistency update model, an immediate GetAttributes or Select operation (read)
immediately after a PutAttributes or DeleteAttributes operation (write) might not return
the updated data.   The following limitations are enforced for this operation:  256 total
attribute name-value pairs per item One billion attributes per domain 10 GB of total user
data storage per domain

# Arguments
- `attribute`: The list of attributes.
- `domain_name`: The name of the domain in which to perform the operation.
- `item_name`: The name of the item.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Attributes"`: The list of attributes.
- `"Expected"`: The update condition which, if specified, determines whether the specified
  attributes will be updated or not. The update condition must be satisfied in order for this
  request to be processed and the attributes to be updated.
"""
function put_attributes(
    Attribute, DomainName, ItemName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return simpledb(
        "PutAttributes",
        Dict{String,Any}(
            "Attribute" => Attribute, "DomainName" => DomainName, "ItemName" => ItemName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_attributes(
    Attribute,
    DomainName,
    ItemName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return simpledb(
        "PutAttributes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Attribute" => Attribute,
                    "DomainName" => DomainName,
                    "ItemName" => ItemName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    select(select_expression)
    select(select_expression, params::Dict{String,<:Any})

 The Select operation returns a set of attributes for ItemNames that match the select
expression. Select is similar to the standard SQL SELECT statement.   The total size of the
response cannot exceed 1 MB in total size. Amazon SimpleDB automatically adjusts the number
of items returned per page to enforce this limit. For example, if the client asks to
retrieve 2500 items, but each individual item is 10 kB in size, the system returns 100
items and an appropriate NextToken so the client can access the next page of results.   For
information on how to construct select expressions, see Using Select to Create Amazon
SimpleDB Queries in the Developer Guide.

# Arguments
- `select_expression`: The expression used to query the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConsistentRead"`: Determines whether or not strong consistency should be enforced when
  data is read from SimpleDB. If true, any data previously written to SimpleDB will be
  returned. Otherwise, results will be consistent eventually, and the client may not see data
  that was written immediately before your read.
- `"NextToken"`: A string informing Amazon SimpleDB where to start the next list of
  ItemNames.
"""
function select(SelectExpression; aws_config::AbstractAWSConfig=current_aws_config())
    return simpledb(
        "Select",
        Dict{String,Any}("SelectExpression" => SelectExpression);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function select(
    SelectExpression,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return simpledb(
        "Select",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("SelectExpression" => SelectExpression), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
