# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: dynamodb
using AWS.Compat
using AWS.UUIDs

"""
    batch_execute_statement(statements)
    batch_execute_statement(statements, params::Dict{String,<:Any})

This operation allows you to perform batch reads or writes on data stored in DynamoDB,
using PartiQL. Each read statement in a BatchExecuteStatement must specify an equality
condition on all key attributes. This enforces that each SELECT statement in a batch
returns at most a single item.  The entire batch must consist of either read statements or
write statements, you cannot mix both in one batch.   A HTTP 200 response does not mean
that all statements in the BatchExecuteStatement succeeded. Error details for individual
statements can be found under the Error field of the BatchStatementResponse for each
statement.

# Arguments
- `statements`: The list of PartiQL statements representing the batch to run.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ReturnConsumedCapacity"`:
"""
function batch_execute_statement(
    Statements; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "BatchExecuteStatement",
        Dict{String,Any}("Statements" => Statements);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_execute_statement(
    Statements,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "BatchExecuteStatement",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Statements" => Statements), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_get_item(request_items)
    batch_get_item(request_items, params::Dict{String,<:Any})

The BatchGetItem operation returns the attributes of one or more items from one or more
tables. You identify requested items by primary key. A single operation can retrieve up to
16 MB of data, which can contain as many as 100 items. BatchGetItem returns a partial
result if the response size limit is exceeded, the table's provisioned throughput is
exceeded, more than 1MB per partition is requested, or an internal processing failure
occurs. If a partial result is returned, the operation returns a value for UnprocessedKeys.
You can use this value to retry the operation starting with the next item to get.  If you
request more than 100 items, BatchGetItem returns a ValidationException with the message
\"Too many items requested for the BatchGetItem call.\"  For example, if you ask to
retrieve 100 items, but each individual item is 300 KB in size, the system returns 52 items
(so as not to exceed the 16 MB limit). It also returns an appropriate UnprocessedKeys value
so you can get the next page of results. If desired, your application can include its own
logic to assemble the pages of results into one dataset. If none of the items can be
processed due to insufficient provisioned throughput on all of the tables in the request,
then BatchGetItem returns a ProvisionedThroughputExceededException. If at least one of the
items is successfully processed, then BatchGetItem completes successfully, while returning
the keys of the unread items in UnprocessedKeys.  If DynamoDB returns any unprocessed
items, you should retry the batch operation on those items. However, we strongly recommend
that you use an exponential backoff algorithm. If you retry the batch operation
immediately, the underlying read or write requests can still fail due to throttling on the
individual tables. If you delay the batch operation using exponential backoff, the
individual requests in the batch are much more likely to succeed. For more information, see
Batch Operations and Error Handling in the Amazon DynamoDB Developer Guide.  By default,
BatchGetItem performs eventually consistent reads on every table in the request. If you
want strongly consistent reads instead, you can set ConsistentRead to true for any or all
tables. In order to minimize response latency, BatchGetItem may retrieve items in parallel.
When designing your application, keep in mind that DynamoDB does not return items in any
particular order. To help parse the response by item, include the primary key values for
the items in your request in the ProjectionExpression parameter. If a requested item does
not exist, it is not returned in the result. Requests for nonexistent items consume the
minimum read capacity units according to the type of read. For more information, see
Working with Tables in the Amazon DynamoDB Developer Guide.

# Arguments
- `request_items`: A map of one or more table names or table ARNs and, for each table, a
  map that describes one or more items to retrieve from that table. Each table name or ARN
  can be used only once per BatchGetItem request. Each element in the map of items to
  retrieve consists of the following:    ConsistentRead - If true, a strongly consistent read
  is used; if false (the default), an eventually consistent read is used.
  ExpressionAttributeNames - One or more substitution tokens for attribute names in the
  ProjectionExpression parameter. The following are some use cases for using
  ExpressionAttributeNames:   To access an attribute whose name conflicts with a DynamoDB
  reserved word.   To create a placeholder for repeating occurrences of an attribute name in
  an expression.   To prevent special characters in an attribute name from being
  misinterpreted in an expression.   Use the # character in an expression to dereference an
  attribute name. For example, consider the following attribute name:    Percentile    The
  name of this attribute conflicts with a reserved word, so it cannot be used directly in an
  expression. (For the complete list of reserved words, see Reserved Words in the Amazon
  DynamoDB Developer Guide). To work around this, you could specify the following for
  ExpressionAttributeNames:    {\"#P\":\"Percentile\"}    You could then use this
  substitution in an expression, as in this example:    #P = :val     Tokens that begin with
  the : character are expression attribute values, which are placeholders for the actual
  value at runtime.  For more information about expression attribute names, see Accessing
  Item Attributes in the Amazon DynamoDB Developer Guide.    Keys - An array of primary key
  attribute values that define specific items in the table. For each primary key, you must
  provide all of the key attributes. For example, with a simple primary key, you only need to
  provide the partition key value. For a composite key, you must provide both the partition
  key value and the sort key value.    ProjectionExpression - A string that identifies one or
  more attributes to retrieve from the table. These attributes can include scalars, sets, or
  elements of a JSON document. The attributes in the expression must be separated by commas.
  If no attribute names are specified, then all attributes are returned. If any of the
  requested attributes are not found, they do not appear in the result. For more information,
  see Accessing Item Attributes in the Amazon DynamoDB Developer Guide.    AttributesToGet -
  This is a legacy parameter. Use ProjectionExpression instead. For more information, see
  AttributesToGet in the Amazon DynamoDB Developer Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ReturnConsumedCapacity"`:
"""
function batch_get_item(RequestItems; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb(
        "BatchGetItem",
        Dict{String,Any}("RequestItems" => RequestItems);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_get_item(
    RequestItems,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "BatchGetItem",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RequestItems" => RequestItems), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_write_item(request_items)
    batch_write_item(request_items, params::Dict{String,<:Any})

The BatchWriteItem operation puts or deletes multiple items in one or more tables. A single
call to BatchWriteItem can transmit up to 16MB of data over the network, consisting of up
to 25 item put or delete operations. While individual items can be up to 400 KB once
stored, it's important to note that an item's representation might be greater than 400KB
while being sent in DynamoDB's JSON format for the API call. For more details on this
distinction, see Naming Rules and Data Types.   BatchWriteItem cannot update items. If you
perform a BatchWriteItem operation on an existing item, that item's values will be
overwritten by the operation and it will appear like it was updated. To update items, we
recommend you use the UpdateItem action.  The individual PutItem and DeleteItem operations
specified in BatchWriteItem are atomic; however BatchWriteItem as a whole is not. If any
requested operations fail because the table's provisioned throughput is exceeded or an
internal processing failure occurs, the failed operations are returned in the
UnprocessedItems response parameter. You can investigate and optionally resend the
requests. Typically, you would call BatchWriteItem in a loop. Each iteration would check
for unprocessed items and submit a new BatchWriteItem request with those unprocessed items
until all items have been processed. If none of the items can be processed due to
insufficient provisioned throughput on all of the tables in the request, then
BatchWriteItem returns a ProvisionedThroughputExceededException.  If DynamoDB returns any
unprocessed items, you should retry the batch operation on those items. However, we
strongly recommend that you use an exponential backoff algorithm. If you retry the batch
operation immediately, the underlying read or write requests can still fail due to
throttling on the individual tables. If you delay the batch operation using exponential
backoff, the individual requests in the batch are much more likely to succeed. For more
information, see Batch Operations and Error Handling in the Amazon DynamoDB Developer
Guide.  With BatchWriteItem, you can efficiently write or delete large amounts of data,
such as from Amazon EMR, or copy data from another database into DynamoDB. In order to
improve performance with these large-scale operations, BatchWriteItem does not behave in
the same way as individual PutItem and DeleteItem calls would. For example, you cannot
specify conditions on individual put and delete requests, and BatchWriteItem does not
return deleted items in the response. If you use a programming language that supports
concurrency, you can use threads to write items in parallel. Your application must include
the necessary logic to manage the threads. With languages that don't support threading, you
must update or delete the specified items one at a time. In both situations, BatchWriteItem
performs the specified put and delete operations in parallel, giving you the power of the
thread pool approach without having to introduce complexity into your application. Parallel
processing reduces latency, but each specified put and delete request consumes the same
number of write capacity units whether it is processed in parallel or not. Delete
operations on nonexistent items consume one write capacity unit. If one or more of the
following is true, DynamoDB rejects the entire batch write operation:   One or more tables
specified in the BatchWriteItem request does not exist.   Primary key attributes specified
on an item in the request do not match those in the corresponding table's primary key
schema.   You try to perform multiple operations on the same item in the same
BatchWriteItem request. For example, you cannot put and delete the same item in the same
BatchWriteItem request.     Your request contains at least two items with identical hash
and range keys (which essentially is two put operations).    There are more than 25
requests in the batch.   Any individual item in a batch exceeds 400 KB.   The total request
size exceeds 16 MB.   Any individual items with keys exceeding the key length limits. For a
partition key, the limit is 2048 bytes and for a sort key, the limit is 1024 bytes.

# Arguments
- `request_items`: A map of one or more table names or table ARNs and, for each table, a
  list of operations to be performed (DeleteRequest or PutRequest). Each element in the map
  consists of the following:    DeleteRequest - Perform a DeleteItem operation on the
  specified item. The item to be deleted is identified by a Key subelement:    Key - A map of
  primary key attribute values that uniquely identify the item. Each entry in this map
  consists of an attribute name and an attribute value. For each primary key, you must
  provide all of the key attributes. For example, with a simple primary key, you only need to
  provide a value for the partition key. For a composite primary key, you must provide values
  for both the partition key and the sort key.      PutRequest - Perform a PutItem operation
  on the specified item. The item to be put is identified by an Item subelement:    Item - A
  map of attributes and their values. Each entry in this map consists of an attribute name
  and an attribute value. Attribute values must not be null; string and binary type
  attributes must have lengths greater than zero; and set type attributes must not be empty.
  Requests that contain empty values are rejected with a ValidationException exception. If
  you specify any attributes that are part of an index key, then the data types for those
  attributes must match those of the schema in the table's attribute definition.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ReturnConsumedCapacity"`:
- `"ReturnItemCollectionMetrics"`: Determines whether item collection metrics are returned.
  If set to SIZE, the response includes statistics about item collections, if any, that were
  modified during the operation are returned in the response. If set to NONE (the default),
  no statistics are returned.
"""
function batch_write_item(RequestItems; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb(
        "BatchWriteItem",
        Dict{String,Any}("RequestItems" => RequestItems);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_write_item(
    RequestItems,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "BatchWriteItem",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RequestItems" => RequestItems), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_backup(backup_name, table_name)
    create_backup(backup_name, table_name, params::Dict{String,<:Any})

Creates a backup for an existing table.  Each time you create an on-demand backup, the
entire table data is backed up. There is no limit to the number of on-demand backups that
can be taken.   When you create an on-demand backup, a time marker of the request is
cataloged, and the backup is created asynchronously, by applying all changes until the time
of the request to the last full table snapshot. Backup requests are processed
instantaneously and become available for restore within minutes.  You can call CreateBackup
at a maximum rate of 50 times per second. All backups in DynamoDB work without consuming
any provisioned throughput on the table.  If you submit a backup request on 2018-12-14 at
14:25:00, the backup is guaranteed to contain all data committed to the table up to
14:24:00, and data committed after 14:26:00 will not be. The backup might contain data
modifications made between 14:24:00 and 14:26:00. On-demand backup does not support causal
consistency.   Along with data, the following are also included on the backups:    Global
secondary indexes (GSIs)   Local secondary indexes (LSIs)   Streams   Provisioned read and
write capacity

# Arguments
- `backup_name`: Specified name for the backup.
- `table_name`: The name of the table. You can also provide the Amazon Resource Name (ARN)
  of the table in this parameter.

"""
function create_backup(
    BackupName, TableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "CreateBackup",
        Dict{String,Any}("BackupName" => BackupName, "TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_backup(
    BackupName,
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "CreateBackup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("BackupName" => BackupName, "TableName" => TableName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_global_table(global_table_name, replication_group)
    create_global_table(global_table_name, replication_group, params::Dict{String,<:Any})

Creates a global table from an existing table. A global table creates a replication
relationship between two or more DynamoDB tables with the same table name in the provided
Regions.   This documentation is for version 2017.11.29 (Legacy) of global tables, which
should be avoided for new global tables. Customers should use Global Tables version
2019.11.21 (Current) when possible, because it provides greater flexibility, higher
efficiency, and consumes less write capacity than 2017.11.29 (Legacy). To determine which
version you're using, see Determining the global table version you are using. To update
existing global tables from version 2017.11.29 (Legacy) to version 2019.11.21 (Current),
see Upgrading global tables.  If you want to add a new replica table to a global table,
each of the following conditions must be true:   The table must have the same primary key
as all of the other replicas.   The table must have the same name as all of the other
replicas.   The table must have DynamoDB Streams enabled, with the stream containing both
the new and the old images of the item.   None of the replica tables in the global table
can contain any data.    If global secondary indexes are specified, then the following
conditions must also be met:     The global secondary indexes must have the same name.
The global secondary indexes must have the same hash key and sort key (if present).     If
local secondary indexes are specified, then the following conditions must also be met:
The local secondary indexes must have the same name.     The local secondary indexes must
have the same hash key and sort key (if present).      Write capacity settings should be
set consistently across your replica tables and secondary indexes. DynamoDB strongly
recommends enabling auto scaling to manage the write capacity settings for all of your
global tables replicas and indexes.   If you prefer to manage write capacity settings
manually, you should provision equal replicated write capacity units to your replica
tables. You should also provision equal replicated write capacity units to matching
secondary indexes across your global table.

# Arguments
- `global_table_name`: The global table name.
- `replication_group`: The Regions where the global table needs to be created.

"""
function create_global_table(
    GlobalTableName, ReplicationGroup; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "CreateGlobalTable",
        Dict{String,Any}(
            "GlobalTableName" => GlobalTableName, "ReplicationGroup" => ReplicationGroup
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_global_table(
    GlobalTableName,
    ReplicationGroup,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "CreateGlobalTable",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GlobalTableName" => GlobalTableName,
                    "ReplicationGroup" => ReplicationGroup,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_table(attribute_definitions, key_schema, table_name)
    create_table(attribute_definitions, key_schema, table_name, params::Dict{String,<:Any})

The CreateTable operation adds a new table to your account. In an Amazon Web Services
account, table names must be unique within each Region. That is, you can have two tables
with same name if you create the tables in different Regions.  CreateTable is an
asynchronous operation. Upon receiving a CreateTable request, DynamoDB immediately returns
a response with a TableStatus of CREATING. After the table is created, DynamoDB sets the
TableStatus to ACTIVE. You can perform read and write operations only on an ACTIVE table.
You can optionally define secondary indexes on the new table, as part of the CreateTable
operation. If you want to create multiple tables with secondary indexes on them, you must
create the tables sequentially. Only one table with secondary indexes can be in the
CREATING state at any given time. You can use the DescribeTable action to check the table
status.

# Arguments
- `attribute_definitions`: An array of attributes that describe the key schema for the
  table and indexes.
- `key_schema`: Specifies the attributes that make up the primary key for a table or an
  index. The attributes in KeySchema must also be defined in the AttributeDefinitions array.
  For more information, see Data Model in the Amazon DynamoDB Developer Guide. Each
  KeySchemaElement in the array is composed of:    AttributeName - The name of this key
  attribute.    KeyType - The role that the key attribute will assume:    HASH - partition
  key    RANGE - sort key      The partition key of an item is also known as its hash
  attribute. The term \"hash attribute\" derives from the DynamoDB usage of an internal hash
  function to evenly distribute data items across partitions, based on their partition key
  values. The sort key of an item is also known as its range attribute. The term \"range
  attribute\" derives from the way DynamoDB stores items with the same partition key
  physically close together, in sorted order by the sort key value.  For a simple primary key
  (partition key), you must provide exactly one element with a KeyType of HASH. For a
  composite primary key (partition key and sort key), you must provide exactly two elements,
  in this order: The first element must have a KeyType of HASH, and the second element must
  have a KeyType of RANGE. For more information, see Working with Tables in the Amazon
  DynamoDB Developer Guide.
- `table_name`: The name of the table to create. You can also provide the Amazon Resource
  Name (ARN) of the table in this parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BillingMode"`: Controls how you are charged for read and write throughput and how you
  manage capacity. This setting can be changed later.    PROVISIONED - We recommend using
  PROVISIONED for predictable workloads. PROVISIONED sets the billing mode to Provisioned
  capacity mode.    PAY_PER_REQUEST - We recommend using PAY_PER_REQUEST for unpredictable
  workloads. PAY_PER_REQUEST sets the billing mode to On-demand capacity mode.
- `"DeletionProtectionEnabled"`: Indicates whether deletion protection is to be enabled
  (true) or disabled (false) on the table.
- `"GlobalSecondaryIndexes"`: One or more global secondary indexes (the maximum is 20) to
  be created on the table. Each global secondary index in the array includes the following:
   IndexName - The name of the global secondary index. Must be unique only for this table.
   KeySchema - Specifies the key schema for the global secondary index.    Projection -
  Specifies attributes that are copied (projected) from the table into the index. These are
  in addition to the primary key attributes and index key attributes, which are automatically
  projected. Each attribute specification is composed of:    ProjectionType - One of the
  following:    KEYS_ONLY - Only the index and primary keys are projected into the index.
  INCLUDE - Only the specified table attributes are projected into the index. The list of
  projected attributes is in NonKeyAttributes.    ALL - All of the table attributes are
  projected into the index.      NonKeyAttributes - A list of one or more non-key attribute
  names that are projected into the secondary index. The total count of attributes provided
  in NonKeyAttributes, summed across all of the secondary indexes, must not exceed 100. If
  you project the same attribute into two different indexes, this counts as two distinct
  attributes when determining the total.      ProvisionedThroughput - The provisioned
  throughput settings for the global secondary index, consisting of read and write capacity
  units.
- `"LocalSecondaryIndexes"`: One or more local secondary indexes (the maximum is 5) to be
  created on the table. Each index is scoped to a given partition key value. There is a 10 GB
  size limit per partition key value; otherwise, the size of a local secondary index is
  unconstrained. Each local secondary index in the array includes the following:    IndexName
  - The name of the local secondary index. Must be unique only for this table.     KeySchema
  - Specifies the key schema for the local secondary index. The key schema must begin with
  the same partition key as the table.    Projection - Specifies attributes that are copied
  (projected) from the table into the index. These are in addition to the primary key
  attributes and index key attributes, which are automatically projected. Each attribute
  specification is composed of:    ProjectionType - One of the following:    KEYS_ONLY - Only
  the index and primary keys are projected into the index.    INCLUDE - Only the specified
  table attributes are projected into the index. The list of projected attributes is in
  NonKeyAttributes.    ALL - All of the table attributes are projected into the index.
  NonKeyAttributes - A list of one or more non-key attribute names that are projected into
  the secondary index. The total count of attributes provided in NonKeyAttributes, summed
  across all of the secondary indexes, must not exceed 100. If you project the same attribute
  into two different indexes, this counts as two distinct attributes when determining the
  total.
- `"OnDemandThroughput"`: Sets the maximum number of read and write units for the specified
  table in on-demand capacity mode. If you use this parameter, you must specify
  MaxReadRequestUnits, MaxWriteRequestUnits, or both.
- `"ProvisionedThroughput"`: Represents the provisioned throughput settings for a specified
  table or index. The settings can be modified using the UpdateTable operation.  If you set
  BillingMode as PROVISIONED, you must specify this property. If you set BillingMode as
  PAY_PER_REQUEST, you cannot specify this property. For current minimum and maximum
  provisioned throughput values, see Service, Account, and Table Quotas in the Amazon
  DynamoDB Developer Guide.
- `"ResourcePolicy"`: An Amazon Web Services resource-based policy document in JSON format
  that will be attached to the table. When you attach a resource-based policy while creating
  a table, the policy application is strongly consistent. The maximum size supported for a
  resource-based policy document is 20 KB. DynamoDB counts whitespaces when calculating the
  size of a policy against this limit. For a full list of all considerations that apply for
  resource-based policies, see Resource-based policy considerations.  You need to specify the
  CreateTable and PutResourcePolicy IAM actions for authorizing a user to create a table with
  a resource-based policy.
- `"SSESpecification"`: Represents the settings used to enable server-side encryption.
- `"StreamSpecification"`: The settings for DynamoDB Streams on the table. These settings
  consist of:    StreamEnabled - Indicates whether DynamoDB Streams is to be enabled (true)
  or disabled (false).    StreamViewType - When an item in the table is modified,
  StreamViewType determines what information is written to the table's stream. Valid values
  for StreamViewType are:    KEYS_ONLY - Only the key attributes of the modified item are
  written to the stream.    NEW_IMAGE - The entire item, as it appears after it was modified,
  is written to the stream.    OLD_IMAGE - The entire item, as it appeared before it was
  modified, is written to the stream.    NEW_AND_OLD_IMAGES - Both the new and the old item
  images of the item are written to the stream.
- `"TableClass"`: The table class of the new table. Valid values are STANDARD and
  STANDARD_INFREQUENT_ACCESS.
- `"Tags"`: A list of key-value pairs to label the table. For more information, see Tagging
  for DynamoDB.
"""
function create_table(
    AttributeDefinitions,
    KeySchema,
    TableName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "CreateTable",
        Dict{String,Any}(
            "AttributeDefinitions" => AttributeDefinitions,
            "KeySchema" => KeySchema,
            "TableName" => TableName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_table(
    AttributeDefinitions,
    KeySchema,
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "CreateTable",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AttributeDefinitions" => AttributeDefinitions,
                    "KeySchema" => KeySchema,
                    "TableName" => TableName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_backup(backup_arn)
    delete_backup(backup_arn, params::Dict{String,<:Any})

Deletes an existing backup of a table. You can call DeleteBackup at a maximum rate of 10
times per second.

# Arguments
- `backup_arn`: The ARN associated with the backup.

"""
function delete_backup(BackupArn; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb(
        "DeleteBackup",
        Dict{String,Any}("BackupArn" => BackupArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_backup(
    BackupArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "DeleteBackup",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("BackupArn" => BackupArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_item(key, table_name)
    delete_item(key, table_name, params::Dict{String,<:Any})

Deletes a single item in a table by primary key. You can perform a conditional delete
operation that deletes the item if it exists, or if it has an expected attribute value. In
addition to deleting an item, you can also return the item's attribute values in the same
operation, using the ReturnValues parameter. Unless you specify conditions, the DeleteItem
is an idempotent operation; running it multiple times on the same item or attribute does
not result in an error response. Conditional deletes are useful for deleting items only if
specific conditions are met. If those conditions are met, DynamoDB performs the delete.
Otherwise, the item is not deleted.

# Arguments
- `key`: A map of attribute names to AttributeValue objects, representing the primary key
  of the item to delete. For the primary key, you must provide all of the key attributes. For
  example, with a simple primary key, you only need to provide a value for the partition key.
  For a composite primary key, you must provide values for both the partition key and the
  sort key.
- `table_name`: The name of the table from which to delete the item. You can also provide
  the Amazon Resource Name (ARN) of the table in this parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConditionExpression"`: A condition that must be satisfied in order for a conditional
  DeleteItem to succeed. An expression can contain any of the following:   Functions:
  attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size
  These function names are case-sensitive.   Comparison operators: = | &lt;&gt; | &lt; | &gt;
  | &lt;= | &gt;= | BETWEEN | IN      Logical operators: AND | OR | NOT    For more
  information about condition expressions, see Condition Expressions in the Amazon DynamoDB
  Developer Guide.
- `"ConditionalOperator"`: This is a legacy parameter. Use ConditionExpression instead. For
  more information, see ConditionalOperator in the Amazon DynamoDB Developer Guide.
- `"Expected"`: This is a legacy parameter. Use ConditionExpression instead. For more
  information, see Expected in the Amazon DynamoDB Developer Guide.
- `"ExpressionAttributeNames"`: One or more substitution tokens for attribute names in an
  expression. The following are some use cases for using ExpressionAttributeNames:   To
  access an attribute whose name conflicts with a DynamoDB reserved word.   To create a
  placeholder for repeating occurrences of an attribute name in an expression.   To prevent
  special characters in an attribute name from being misinterpreted in an expression.   Use
  the # character in an expression to dereference an attribute name. For example, consider
  the following attribute name:    Percentile    The name of this attribute conflicts with a
  reserved word, so it cannot be used directly in an expression. (For the complete list of
  reserved words, see Reserved Words in the Amazon DynamoDB Developer Guide). To work around
  this, you could specify the following for ExpressionAttributeNames:
  {\"#P\":\"Percentile\"}    You could then use this substitution in an expression, as in
  this example:    #P = :val     Tokens that begin with the : character are expression
  attribute values, which are placeholders for the actual value at runtime.  For more
  information on expression attribute names, see Specifying Item Attributes in the Amazon
  DynamoDB Developer Guide.
- `"ExpressionAttributeValues"`: One or more values that can be substituted in an
  expression. Use the : (colon) character in an expression to dereference an attribute value.
  For example, suppose that you wanted to check whether the value of the ProductStatus
  attribute was one of the following:   Available | Backordered | Discontinued  You would
  first need to specify ExpressionAttributeValues as follows:  {
  \":avail\":{\"S\":\"Available\"}, \":back\":{\"S\":\"Backordered\"},
  \":disc\":{\"S\":\"Discontinued\"} }  You could then use these values in an expression,
  such as this:  ProductStatus IN (:avail, :back, :disc)  For more information on expression
  attribute values, see Condition Expressions in the Amazon DynamoDB Developer Guide.
- `"ReturnConsumedCapacity"`:
- `"ReturnItemCollectionMetrics"`: Determines whether item collection metrics are returned.
  If set to SIZE, the response includes statistics about item collections, if any, that were
  modified during the operation are returned in the response. If set to NONE (the default),
  no statistics are returned.
- `"ReturnValues"`: Use ReturnValues if you want to get the item attributes as they
  appeared before they were deleted. For DeleteItem, the valid values are:    NONE - If
  ReturnValues is not specified, or if its value is NONE, then nothing is returned. (This
  setting is the default for ReturnValues.)    ALL_OLD - The content of the old item is
  returned.   There is no additional cost associated with requesting a return value aside
  from the small network and processing overhead of receiving a larger response. No read
  capacity units are consumed.  The ReturnValues parameter is used by several DynamoDB
  operations; however, DeleteItem does not recognize any values other than NONE or ALL_OLD.
- `"ReturnValuesOnConditionCheckFailure"`: An optional parameter that returns the item
  attributes for a DeleteItem operation that failed a condition check. There is no additional
  cost associated with requesting a return value aside from the small network and processing
  overhead of receiving a larger response. No read capacity units are consumed.
"""
function delete_item(Key, TableName; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb(
        "DeleteItem",
        Dict{String,Any}("Key" => Key, "TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_item(
    Key,
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "DeleteItem",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Key" => Key, "TableName" => TableName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_resource_policy(resource_arn)
    delete_resource_policy(resource_arn, params::Dict{String,<:Any})

Deletes the resource-based policy attached to the resource, which can be a table or stream.
 DeleteResourcePolicy is an idempotent operation; running it multiple times on the same
resource doesn't result in an error response, unless you specify an ExpectedRevisionId,
which will then return a PolicyNotFoundException.  To make sure that you don't
inadvertently lock yourself out of your own resources, the root principal in your Amazon
Web Services account can perform DeleteResourcePolicy requests, even if your resource-based
policy explicitly denies the root principal's access.     DeleteResourcePolicy is an
asynchronous operation. If you issue a GetResourcePolicy request immediately after running
the DeleteResourcePolicy request, DynamoDB might still return the deleted policy. This is
because the policy for your resource might not have been deleted yet. Wait for a few
seconds, and then try the GetResourcePolicy request again.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the DynamoDB resource from which the
  policy will be removed. The resources you can specify include tables and streams. If you
  remove the policy of a table, it will also remove the permissions for the table's indexes
  defined in that policy document. This is because index permissions are defined in the
  table's policy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExpectedRevisionId"`: A string value that you can use to conditionally delete your
  policy. When you provide an expected revision ID, if the revision ID of the existing policy
  on the resource doesn't match or if there's no policy attached to the resource, the request
  will fail and return a PolicyNotFoundException.
"""
function delete_resource_policy(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "DeleteResourcePolicy",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_resource_policy(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "DeleteResourcePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_table(table_name)
    delete_table(table_name, params::Dict{String,<:Any})

The DeleteTable operation deletes a table and all of its items. After a DeleteTable
request, the specified table is in the DELETING state until DynamoDB completes the
deletion. If the table is in the ACTIVE state, you can delete it. If a table is in CREATING
or UPDATING states, then DynamoDB returns a ResourceInUseException. If the specified table
does not exist, DynamoDB returns a ResourceNotFoundException. If table is already in the
DELETING state, no error is returned.   For global tables, this operation only applies to
global tables using Version 2019.11.21 (Current version).    DynamoDB might continue to
accept data read and write operations, such as GetItem and PutItem, on a table in the
DELETING state until the table deletion is complete.  When you delete a table, any indexes
on that table are also deleted. If you have DynamoDB Streams enabled on the table, then the
corresponding stream on that table goes into the DISABLED state, and the stream is
automatically deleted after 24 hours. Use the DescribeTable action to check the status of
the table.

# Arguments
- `table_name`: The name of the table to delete. You can also provide the Amazon Resource
  Name (ARN) of the table in this parameter.

"""
function delete_table(TableName; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb(
        "DeleteTable",
        Dict{String,Any}("TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_table(
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "DeleteTable",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TableName" => TableName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_backup(backup_arn)
    describe_backup(backup_arn, params::Dict{String,<:Any})

Describes an existing backup of a table. You can call DescribeBackup at a maximum rate of
10 times per second.

# Arguments
- `backup_arn`: The Amazon Resource Name (ARN) associated with the backup.

"""
function describe_backup(BackupArn; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb(
        "DescribeBackup",
        Dict{String,Any}("BackupArn" => BackupArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_backup(
    BackupArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "DescribeBackup",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("BackupArn" => BackupArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_continuous_backups(table_name)
    describe_continuous_backups(table_name, params::Dict{String,<:Any})

Checks the status of continuous backups and point in time recovery on the specified table.
Continuous backups are ENABLED on all tables at table creation. If point in time recovery
is enabled, PointInTimeRecoveryStatus will be set to ENABLED.  After continuous backups and
point in time recovery are enabled, you can restore to any point in time within
EarliestRestorableDateTime and LatestRestorableDateTime.   LatestRestorableDateTime is
typically 5 minutes before the current time. You can restore your table to any point in
time during the last 35 days.  You can call DescribeContinuousBackups at a maximum rate of
10 times per second.

# Arguments
- `table_name`: Name of the table for which the customer wants to check the continuous
  backups and point in time recovery settings. You can also provide the Amazon Resource Name
  (ARN) of the table in this parameter.

"""
function describe_continuous_backups(
    TableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "DescribeContinuousBackups",
        Dict{String,Any}("TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_continuous_backups(
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "DescribeContinuousBackups",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TableName" => TableName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_contributor_insights(table_name)
    describe_contributor_insights(table_name, params::Dict{String,<:Any})

Returns information about contributor insights for a given table or global secondary index.

# Arguments
- `table_name`: The name of the table to describe. You can also provide the Amazon Resource
  Name (ARN) of the table in this parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IndexName"`: The name of the global secondary index to describe, if applicable.
"""
function describe_contributor_insights(
    TableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "DescribeContributorInsights",
        Dict{String,Any}("TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_contributor_insights(
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "DescribeContributorInsights",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TableName" => TableName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_endpoints()
    describe_endpoints(params::Dict{String,<:Any})

Returns the regional endpoint information. For more information on policy permissions,
please see Internetwork traffic privacy.

"""
function describe_endpoints(; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb(
        "DescribeEndpoints"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_endpoints(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "DescribeEndpoints", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_export(export_arn)
    describe_export(export_arn, params::Dict{String,<:Any})

Describes an existing table export.

# Arguments
- `export_arn`: The Amazon Resource Name (ARN) associated with the export.

"""
function describe_export(ExportArn; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb(
        "DescribeExport",
        Dict{String,Any}("ExportArn" => ExportArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_export(
    ExportArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "DescribeExport",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ExportArn" => ExportArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_global_table(global_table_name)
    describe_global_table(global_table_name, params::Dict{String,<:Any})

Returns information about the specified global table.  This documentation is for version
2017.11.29 (Legacy) of global tables, which should be avoided for new global tables.
Customers should use Global Tables version 2019.11.21 (Current) when possible, because it
provides greater flexibility, higher efficiency, and consumes less write capacity than
2017.11.29 (Legacy). To determine which version you're using, see Determining the global
table version you are using. To update existing global tables from version 2017.11.29
(Legacy) to version 2019.11.21 (Current), see Upgrading global tables.

# Arguments
- `global_table_name`: The name of the global table.

"""
function describe_global_table(
    GlobalTableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "DescribeGlobalTable",
        Dict{String,Any}("GlobalTableName" => GlobalTableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_global_table(
    GlobalTableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "DescribeGlobalTable",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("GlobalTableName" => GlobalTableName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_global_table_settings(global_table_name)
    describe_global_table_settings(global_table_name, params::Dict{String,<:Any})

Describes Region-specific settings for a global table.  This documentation is for version
2017.11.29 (Legacy) of global tables, which should be avoided for new global tables.
Customers should use Global Tables version 2019.11.21 (Current) when possible, because it
provides greater flexibility, higher efficiency, and consumes less write capacity than
2017.11.29 (Legacy). To determine which version you're using, see Determining the global
table version you are using. To update existing global tables from version 2017.11.29
(Legacy) to version 2019.11.21 (Current), see Upgrading global tables.

# Arguments
- `global_table_name`: The name of the global table to describe.

"""
function describe_global_table_settings(
    GlobalTableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "DescribeGlobalTableSettings",
        Dict{String,Any}("GlobalTableName" => GlobalTableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_global_table_settings(
    GlobalTableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "DescribeGlobalTableSettings",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("GlobalTableName" => GlobalTableName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_import(import_arn)
    describe_import(import_arn, params::Dict{String,<:Any})

 Represents the properties of the import.

# Arguments
- `import_arn`:  The Amazon Resource Name (ARN) associated with the table you're importing
  to.

"""
function describe_import(ImportArn; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb(
        "DescribeImport",
        Dict{String,Any}("ImportArn" => ImportArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_import(
    ImportArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "DescribeImport",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ImportArn" => ImportArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_kinesis_streaming_destination(table_name)
    describe_kinesis_streaming_destination(table_name, params::Dict{String,<:Any})

Returns information about the status of Kinesis streaming.

# Arguments
- `table_name`: The name of the table being described. You can also provide the Amazon
  Resource Name (ARN) of the table in this parameter.

"""
function describe_kinesis_streaming_destination(
    TableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "DescribeKinesisStreamingDestination",
        Dict{String,Any}("TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_kinesis_streaming_destination(
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "DescribeKinesisStreamingDestination",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TableName" => TableName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_limits()
    describe_limits(params::Dict{String,<:Any})

Returns the current provisioned-capacity quotas for your Amazon Web Services account in a
Region, both for the Region as a whole and for any one DynamoDB table that you create
there. When you establish an Amazon Web Services account, the account has initial quotas on
the maximum read capacity units and write capacity units that you can provision across all
of your DynamoDB tables in a given Region. Also, there are per-table quotas that apply when
you create a table there. For more information, see Service, Account, and Table Quotas page
in the Amazon DynamoDB Developer Guide. Although you can increase these quotas by filing a
case at Amazon Web Services Support Center, obtaining the increase is not instantaneous.
The DescribeLimits action lets you write code to compare the capacity you are currently
using to those quotas imposed by your account so that you have enough time to apply for an
increase before you hit a quota. For example, you could use one of the Amazon Web Services
SDKs to do the following:   Call DescribeLimits for a particular Region to obtain your
current account quotas on provisioned capacity there.   Create a variable to hold the
aggregate read capacity units provisioned for all your tables in that Region, and one to
hold the aggregate write capacity units. Zero them both.   Call ListTables to obtain a list
of all your DynamoDB tables.   For each table name listed by ListTables, do the following:
 Call DescribeTable with the table name.   Use the data returned by DescribeTable to add
the read capacity units and write capacity units provisioned for the table itself to your
variables.   If the table has one or more global secondary indexes (GSIs), loop over these
GSIs and add their provisioned capacity values to your variables as well.     Report the
account quotas for that Region returned by DescribeLimits, along with the total current
provisioned capacity levels you have calculated.   This will let you see whether you are
getting close to your account-level quotas. The per-table quotas apply only when you are
creating a new table. They restrict the sum of the provisioned capacity of the new table
itself and all its global secondary indexes. For existing tables and their GSIs, DynamoDB
doesn't let you increase provisioned capacity extremely rapidly, but the only quota that
applies is that the aggregate provisioned capacity over all your tables and GSIs cannot
exceed either of the per-account quotas.   DescribeLimits should only be called
periodically. You can expect throttling errors if you call it more than once in a minute.
The DescribeLimits Request element has no content.

"""
function describe_limits(; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb(
        "DescribeLimits"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_limits(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "DescribeLimits", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_table(table_name)
    describe_table(table_name, params::Dict{String,<:Any})

Returns information about the table, including the current status of the table, when it was
created, the primary key schema, and any indexes on the table.  For global tables, this
operation only applies to global tables using Version 2019.11.21 (Current version).    If
you issue a DescribeTable request immediately after a CreateTable request, DynamoDB might
return a ResourceNotFoundException. This is because DescribeTable uses an eventually
consistent query, and the metadata for your table might not be available at that moment.
Wait for a few seconds, and then try the DescribeTable request again.

# Arguments
- `table_name`: The name of the table to describe. You can also provide the Amazon Resource
  Name (ARN) of the table in this parameter.

"""
function describe_table(TableName; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb(
        "DescribeTable",
        Dict{String,Any}("TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_table(
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "DescribeTable",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TableName" => TableName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_table_replica_auto_scaling(table_name)
    describe_table_replica_auto_scaling(table_name, params::Dict{String,<:Any})

Describes auto scaling settings across replicas of the global table at once.  For global
tables, this operation only applies to global tables using Version 2019.11.21 (Current
version).

# Arguments
- `table_name`: The name of the table. You can also provide the Amazon Resource Name (ARN)
  of the table in this parameter.

"""
function describe_table_replica_auto_scaling(
    TableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "DescribeTableReplicaAutoScaling",
        Dict{String,Any}("TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_table_replica_auto_scaling(
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "DescribeTableReplicaAutoScaling",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TableName" => TableName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_time_to_live(table_name)
    describe_time_to_live(table_name, params::Dict{String,<:Any})

Gives a description of the Time to Live (TTL) status on the specified table.

# Arguments
- `table_name`: The name of the table to be described. You can also provide the Amazon
  Resource Name (ARN) of the table in this parameter.

"""
function describe_time_to_live(
    TableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "DescribeTimeToLive",
        Dict{String,Any}("TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_time_to_live(
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "DescribeTimeToLive",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TableName" => TableName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_kinesis_streaming_destination(stream_arn, table_name)
    disable_kinesis_streaming_destination(stream_arn, table_name, params::Dict{String,<:Any})

Stops replication from the DynamoDB table to the Kinesis data stream. This is done without
deleting either of the resources.

# Arguments
- `stream_arn`: The ARN for a Kinesis data stream.
- `table_name`: The name of the DynamoDB table. You can also provide the Amazon Resource
  Name (ARN) of the table in this parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EnableKinesisStreamingConfiguration"`: The source for the Kinesis streaming information
  that is being enabled.
"""
function disable_kinesis_streaming_destination(
    StreamArn, TableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "DisableKinesisStreamingDestination",
        Dict{String,Any}("StreamArn" => StreamArn, "TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_kinesis_streaming_destination(
    StreamArn,
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "DisableKinesisStreamingDestination",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("StreamArn" => StreamArn, "TableName" => TableName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_kinesis_streaming_destination(stream_arn, table_name)
    enable_kinesis_streaming_destination(stream_arn, table_name, params::Dict{String,<:Any})

Starts table data replication to the specified Kinesis data stream at a timestamp chosen
during the enable workflow. If this operation doesn't return results immediately, use
DescribeKinesisStreamingDestination to check if streaming to the Kinesis data stream is
ACTIVE.

# Arguments
- `stream_arn`: The ARN for a Kinesis data stream.
- `table_name`: The name of the DynamoDB table. You can also provide the Amazon Resource
  Name (ARN) of the table in this parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EnableKinesisStreamingConfiguration"`: The source for the Kinesis streaming information
  that is being enabled.
"""
function enable_kinesis_streaming_destination(
    StreamArn, TableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "EnableKinesisStreamingDestination",
        Dict{String,Any}("StreamArn" => StreamArn, "TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_kinesis_streaming_destination(
    StreamArn,
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "EnableKinesisStreamingDestination",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("StreamArn" => StreamArn, "TableName" => TableName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    execute_statement(statement)
    execute_statement(statement, params::Dict{String,<:Any})

This operation allows you to perform reads and singleton writes on data stored in DynamoDB,
using PartiQL. For PartiQL reads (SELECT statement), if the total number of processed items
exceeds the maximum dataset size limit of 1 MB, the read stops and results are returned to
the user as a LastEvaluatedKey value to continue the read in a subsequent operation. If the
filter criteria in WHERE clause does not match any data, the read will return an empty
result set. A single SELECT statement response can return up to the maximum number of items
(if using the Limit parameter) or a maximum of 1 MB of data (and then apply any filtering
to the results using WHERE clause). If LastEvaluatedKey is present in the response, you
need to paginate the result set. If NextToken is present, you need to paginate the result
set and include NextToken.

# Arguments
- `statement`: The PartiQL statement representing the operation to run.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConsistentRead"`: The consistency of a read operation. If set to true, then a strongly
  consistent read is used; otherwise, an eventually consistent read is used.
- `"Limit"`: The maximum number of items to evaluate (not necessarily the number of
  matching items). If DynamoDB processes the number of items up to the limit while processing
  the results, it stops the operation and returns the matching values up to that point, along
  with a key in LastEvaluatedKey to apply in a subsequent operation so you can pick up where
  you left off. Also, if the processed dataset size exceeds 1 MB before DynamoDB reaches this
  limit, it stops the operation and returns the matching values up to the limit, and a key in
  LastEvaluatedKey to apply in a subsequent operation to continue the operation.
- `"NextToken"`: Set this value to get remaining results, if NextToken was returned in the
  statement response.
- `"Parameters"`: The parameters for the PartiQL statement, if any.
- `"ReturnConsumedCapacity"`:
- `"ReturnValuesOnConditionCheckFailure"`: An optional parameter that returns the item
  attributes for an ExecuteStatement operation that failed a condition check. There is no
  additional cost associated with requesting a return value aside from the small network and
  processing overhead of receiving a larger response. No read capacity units are consumed.
"""
function execute_statement(Statement; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb(
        "ExecuteStatement",
        Dict{String,Any}("Statement" => Statement);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function execute_statement(
    Statement,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "ExecuteStatement",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Statement" => Statement), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    execute_transaction(transact_statements)
    execute_transaction(transact_statements, params::Dict{String,<:Any})

This operation allows you to perform transactional reads or writes on data stored in
DynamoDB, using PartiQL.  The entire transaction must consist of either read statements or
write statements, you cannot mix both in one transaction. The EXISTS function is an
exception and can be used to check the condition of specific attributes of the item in a
similar manner to ConditionCheck in the TransactWriteItems API.

# Arguments
- `transact_statements`: The list of PartiQL statements representing the transaction to run.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Set this value to get remaining results, if NextToken was
  returned in the statement response.
- `"ReturnConsumedCapacity"`: Determines the level of detail about either provisioned or
  on-demand throughput consumption that is returned in the response. For more information,
  see TransactGetItems and TransactWriteItems.
"""
function execute_transaction(
    TransactStatements; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "ExecuteTransaction",
        Dict{String,Any}(
            "TransactStatements" => TransactStatements,
            "ClientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function execute_transaction(
    TransactStatements,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "ExecuteTransaction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransactStatements" => TransactStatements,
                    "ClientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    export_table_to_point_in_time(s3_bucket, table_arn)
    export_table_to_point_in_time(s3_bucket, table_arn, params::Dict{String,<:Any})

Exports table data to an S3 bucket. The table must have point in time recovery enabled, and
you can export data from any time within the point in time recovery window.

# Arguments
- `s3_bucket`: The name of the Amazon S3 bucket to export the snapshot to.
- `table_arn`: The Amazon Resource Name (ARN) associated with the table to export.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Providing a ClientToken makes the call to ExportTableToPointInTimeInput
  idempotent, meaning that multiple identical calls have the same effect as one single call.
  A client token is valid for 8 hours after the first request that uses it is completed.
  After 8 hours, any request with the same client token is treated as a new request. Do not
  resubmit the same request with the same client token for more than 8 hours, or the result
  might not be idempotent. If you submit a request with the same client token but a change in
  other parameters within the 8-hour idempotency window, DynamoDB returns an
  ImportConflictException.
- `"ExportFormat"`: The format for the exported data. Valid values for ExportFormat are
  DYNAMODB_JSON or ION.
- `"ExportTime"`: Time in the past from which to export table data, counted in seconds from
  the start of the Unix epoch. The table export will be a snapshot of the table's state at
  this point in time.
- `"ExportType"`: Choice of whether to execute as a full export or incremental export.
  Valid values are FULL_EXPORT or INCREMENTAL_EXPORT. The default value is FULL_EXPORT. If
  INCREMENTAL_EXPORT is provided, the IncrementalExportSpecification must also be used.
- `"IncrementalExportSpecification"`: Optional object containing the parameters specific to
  an incremental export.
- `"S3BucketOwner"`: The ID of the Amazon Web Services account that owns the bucket the
  export will be stored in.  S3BucketOwner is a required parameter when exporting to a S3
  bucket in another account.
- `"S3Prefix"`: The Amazon S3 bucket prefix to use as the file name and path of the
  exported snapshot.
- `"S3SseAlgorithm"`: Type of encryption used on the bucket where export data will be
  stored. Valid values for S3SseAlgorithm are:    AES256 - server-side encryption with Amazon
  S3 managed keys    KMS - server-side encryption with KMS managed keys
- `"S3SseKmsKeyId"`: The ID of the KMS managed key used to encrypt the S3 bucket where
  export data will be stored (if applicable).
"""
function export_table_to_point_in_time(
    S3Bucket, TableArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "ExportTableToPointInTime",
        Dict{String,Any}(
            "S3Bucket" => S3Bucket, "TableArn" => TableArn, "ClientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function export_table_to_point_in_time(
    S3Bucket,
    TableArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "ExportTableToPointInTime",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "S3Bucket" => S3Bucket,
                    "TableArn" => TableArn,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_item(key, table_name)
    get_item(key, table_name, params::Dict{String,<:Any})

The GetItem operation returns a set of attributes for the item with the given primary key.
If there is no matching item, GetItem does not return any data and there will be no Item
element in the response.  GetItem provides an eventually consistent read by default. If
your application requires a strongly consistent read, set ConsistentRead to true. Although
a strongly consistent read might take more time than an eventually consistent read, it
always returns the last updated value.

# Arguments
- `key`: A map of attribute names to AttributeValue objects, representing the primary key
  of the item to retrieve. For the primary key, you must provide all of the attributes. For
  example, with a simple primary key, you only need to provide a value for the partition key.
  For a composite primary key, you must provide values for both the partition key and the
  sort key.
- `table_name`: The name of the table containing the requested item. You can also provide
  the Amazon Resource Name (ARN) of the table in this parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AttributesToGet"`: This is a legacy parameter. Use ProjectionExpression instead. For
  more information, see AttributesToGet in the Amazon DynamoDB Developer Guide.
- `"ConsistentRead"`: Determines the read consistency model: If set to true, then the
  operation uses strongly consistent reads; otherwise, the operation uses eventually
  consistent reads.
- `"ExpressionAttributeNames"`: One or more substitution tokens for attribute names in an
  expression. The following are some use cases for using ExpressionAttributeNames:   To
  access an attribute whose name conflicts with a DynamoDB reserved word.   To create a
  placeholder for repeating occurrences of an attribute name in an expression.   To prevent
  special characters in an attribute name from being misinterpreted in an expression.   Use
  the # character in an expression to dereference an attribute name. For example, consider
  the following attribute name:    Percentile    The name of this attribute conflicts with a
  reserved word, so it cannot be used directly in an expression. (For the complete list of
  reserved words, see Reserved Words in the Amazon DynamoDB Developer Guide). To work around
  this, you could specify the following for ExpressionAttributeNames:
  {\"#P\":\"Percentile\"}    You could then use this substitution in an expression, as in
  this example:    #P = :val     Tokens that begin with the : character are expression
  attribute values, which are placeholders for the actual value at runtime.  For more
  information on expression attribute names, see Specifying Item Attributes in the Amazon
  DynamoDB Developer Guide.
- `"ProjectionExpression"`: A string that identifies one or more attributes to retrieve
  from the table. These attributes can include scalars, sets, or elements of a JSON document.
  The attributes in the expression must be separated by commas. If no attribute names are
  specified, then all attributes are returned. If any of the requested attributes are not
  found, they do not appear in the result. For more information, see Specifying Item
  Attributes in the Amazon DynamoDB Developer Guide.
- `"ReturnConsumedCapacity"`:
"""
function get_item(Key, TableName; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb(
        "GetItem",
        Dict{String,Any}("Key" => Key, "TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_item(
    Key,
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "GetItem",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Key" => Key, "TableName" => TableName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resource_policy(resource_arn)
    get_resource_policy(resource_arn, params::Dict{String,<:Any})

Returns the resource-based policy document attached to the resource, which can be a table
or stream, in JSON format.  GetResourcePolicy follows an  eventually consistent  model. The
following list describes the outcomes when you issue the GetResourcePolicy request
immediately after issuing another request:   If you issue a GetResourcePolicy request
immediately after a PutResourcePolicy request, DynamoDB might return a
PolicyNotFoundException.   If you issue a GetResourcePolicyrequest immediately after a
DeleteResourcePolicy request, DynamoDB might return the policy that was present before the
deletion request.   If you issue a GetResourcePolicy request immediately after a
CreateTable request, which includes a resource-based policy, DynamoDB might return a
ResourceNotFoundException or a PolicyNotFoundException.   Because GetResourcePolicy uses an
eventually consistent query, the metadata for your policy or table might not be available
at that moment. Wait for a few seconds, and then retry the GetResourcePolicy request. After
a GetResourcePolicy request returns a policy created using the PutResourcePolicy request,
the policy will be applied in the authorization of requests to the resource. Because this
process is eventually consistent, it will take some time to apply the policy to all
requests to a resource. Policies that you attach while creating a table using the
CreateTable request will always be applied to all requests for that table.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the DynamoDB resource to which the
  policy is attached. The resources you can specify include tables and streams.

"""
function get_resource_policy(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "GetResourcePolicy",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resource_policy(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "GetResourcePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    import_table(input_format, s3_bucket_source, table_creation_parameters)
    import_table(input_format, s3_bucket_source, table_creation_parameters, params::Dict{String,<:Any})

 Imports table data from an S3 bucket.

# Arguments
- `input_format`:  The format of the source data. Valid values for ImportFormat are CSV,
  DYNAMODB_JSON or ION.
- `s3_bucket_source`:  The S3 bucket that provides the source for the import.
- `table_creation_parameters`: Parameters for the table to import the data into.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Providing a ClientToken makes the call to ImportTableInput idempotent,
  meaning that multiple identical calls have the same effect as one single call. A client
  token is valid for 8 hours after the first request that uses it is completed. After 8
  hours, any request with the same client token is treated as a new request. Do not resubmit
  the same request with the same client token for more than 8 hours, or the result might not
  be idempotent. If you submit a request with the same client token but a change in other
  parameters within the 8-hour idempotency window, DynamoDB returns an
  IdempotentParameterMismatch exception.
- `"InputCompressionType"`:  Type of compression to be used on the input coming from the
  imported table.
- `"InputFormatOptions"`:  Additional properties that specify how the input is formatted,
"""
function import_table(
    InputFormat,
    S3BucketSource,
    TableCreationParameters;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "ImportTable",
        Dict{String,Any}(
            "InputFormat" => InputFormat,
            "S3BucketSource" => S3BucketSource,
            "TableCreationParameters" => TableCreationParameters,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function import_table(
    InputFormat,
    S3BucketSource,
    TableCreationParameters,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "ImportTable",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "InputFormat" => InputFormat,
                    "S3BucketSource" => S3BucketSource,
                    "TableCreationParameters" => TableCreationParameters,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_backups()
    list_backups(params::Dict{String,<:Any})

List DynamoDB backups that are associated with an Amazon Web Services account and weren't
made with Amazon Web Services Backup. To list these backups for a given table, specify
TableName. ListBackups returns a paginated list of results with at most 1 MB worth of items
in a page. You can also specify a maximum number of entries to be returned in a page. In
the request, start time is inclusive, but end time is exclusive. Note that these boundaries
are for the time at which the original backup was requested. You can call ListBackups a
maximum of five times per second. If you want to retrieve the complete list of backups made
with Amazon Web Services Backup, use the Amazon Web Services Backup list API.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BackupType"`: The backups from the table specified by BackupType are listed. Where
  BackupType can be:    USER - On-demand backup created by you. (The default setting if no
  other backup types are specified.)    SYSTEM - On-demand backup automatically created by
  DynamoDB.    ALL - All types of on-demand backups (USER and SYSTEM).
- `"ExclusiveStartBackupArn"`:  LastEvaluatedBackupArn is the Amazon Resource Name (ARN) of
  the backup last evaluated when the current page of results was returned, inclusive of the
  current page of results. This value may be specified as the ExclusiveStartBackupArn of a
  new ListBackups operation in order to fetch the next page of results.
- `"Limit"`: Maximum number of backups to return at once.
- `"TableName"`: Lists the backups from the table specified in TableName. You can also
  provide the Amazon Resource Name (ARN) of the table in this parameter.
- `"TimeRangeLowerBound"`: Only backups created after this time are listed.
  TimeRangeLowerBound is inclusive.
- `"TimeRangeUpperBound"`: Only backups created before this time are listed.
  TimeRangeUpperBound is exclusive.
"""
function list_backups(; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb("ListBackups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_backups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "ListBackups", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_contributor_insights()
    list_contributor_insights(params::Dict{String,<:Any})

Returns a list of ContributorInsightsSummary for a table and all its global secondary
indexes.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Maximum number of results to return per page.
- `"NextToken"`: A token to for the desired page, if there is one.
- `"TableName"`: The name of the table. You can also provide the Amazon Resource Name (ARN)
  of the table in this parameter.
"""
function list_contributor_insights(; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb(
        "ListContributorInsights"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_contributor_insights(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "ListContributorInsights",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_exports()
    list_exports(params::Dict{String,<:Any})

Lists completed exports within the past 90 days.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Maximum number of results to return per page.
- `"NextToken"`: An optional string that, if supplied, must be copied from the output of a
  previous call to ListExports. When provided in this manner, the API fetches the next page
  of results.
- `"TableArn"`: The Amazon Resource Name (ARN) associated with the exported table.
"""
function list_exports(; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb("ListExports"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_exports(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "ListExports", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_global_tables()
    list_global_tables(params::Dict{String,<:Any})

Lists all global tables that have a replica in the specified Region.  This documentation is
for version 2017.11.29 (Legacy) of global tables, which should be avoided for new global
tables. Customers should use Global Tables version 2019.11.21 (Current) when possible,
because it provides greater flexibility, higher efficiency, and consumes less write
capacity than 2017.11.29 (Legacy). To determine which version you're using, see Determining
the global table version you are using. To update existing global tables from version
2017.11.29 (Legacy) to version 2019.11.21 (Current), see Upgrading global tables.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExclusiveStartGlobalTableName"`: The first global table name that this operation will
  evaluate.
- `"Limit"`: The maximum number of table names to return, if the parameter is not specified
  DynamoDB defaults to 100. If the number of global tables DynamoDB finds reaches this limit,
  it stops the operation and returns the table names collected up to that point, with a table
  name in the LastEvaluatedGlobalTableName to apply in a subsequent operation to the
  ExclusiveStartGlobalTableName parameter.
- `"RegionName"`: Lists the global tables in a specific Region.
"""
function list_global_tables(; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb(
        "ListGlobalTables"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_global_tables(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "ListGlobalTables", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_imports()
    list_imports(params::Dict{String,<:Any})

 Lists completed imports within the past 90 days.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`:  An optional string that, if supplied, must be copied from the output of a
  previous call to ListImports. When provided in this manner, the API fetches the next page
  of results.
- `"PageSize"`:  The number of ImportSummary objects returned in a single page.
- `"TableArn"`:  The Amazon Resource Name (ARN) associated with the table that was imported
  to.
"""
function list_imports(; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb("ListImports"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_imports(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "ListImports", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tables()
    list_tables(params::Dict{String,<:Any})

Returns an array of table names associated with the current account and endpoint. The
output from ListTables is paginated, with each page returning a maximum of 100 table names.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExclusiveStartTableName"`: The first table name that this operation will evaluate. Use
  the value that was returned for LastEvaluatedTableName in a previous operation, so that you
  can obtain the next page of results.
- `"Limit"`: A maximum number of table names to return. If this parameter is not specified,
  the limit is 100.
"""
function list_tables(; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb("ListTables"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_tables(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "ListTables", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_of_resource(resource_arn)
    list_tags_of_resource(resource_arn, params::Dict{String,<:Any})

List all tags on an Amazon DynamoDB resource. You can call ListTagsOfResource up to 10
times per second, per account. For an overview on tagging DynamoDB resources, see Tagging
for DynamoDB in the Amazon DynamoDB Developer Guide.

# Arguments
- `resource_arn`: The Amazon DynamoDB resource with tags to be listed. This value is an
  Amazon Resource Name (ARN).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: An optional string that, if supplied, must be copied from the output of a
  previous call to ListTagOfResource. When provided in this manner, this API fetches the next
  page of results.
"""
function list_tags_of_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "ListTagsOfResource",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_of_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "ListTagsOfResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_item(item, table_name)
    put_item(item, table_name, params::Dict{String,<:Any})

Creates a new item, or replaces an old item with a new item. If an item that has the same
primary key as the new item already exists in the specified table, the new item completely
replaces the existing item. You can perform a conditional put operation (add a new item if
one with the specified primary key doesn't exist), or replace an existing item if it has
certain attribute values. You can return the item's attribute values in the same operation,
using the ReturnValues parameter. When you add an item, the primary key attributes are the
only required attributes.  Empty String and Binary attribute values are allowed. Attribute
values of type String and Binary must have a length greater than zero if the attribute is
used as a key attribute for a table or index. Set type attributes cannot be empty.  Invalid
Requests with empty values will be rejected with a ValidationException exception.  To
prevent a new item from replacing an existing item, use a conditional expression that
contains the attribute_not_exists function with the name of the attribute being used as the
partition key for the table. Since every record must contain that attribute, the
attribute_not_exists function will only succeed if no matching item exists.  For more
information about PutItem, see Working with Items in the Amazon DynamoDB Developer Guide.

# Arguments
- `item`: A map of attribute name/value pairs, one for each attribute. Only the primary key
  attributes are required; you can optionally provide other attribute name-value pairs for
  the item. You must provide all of the attributes for the primary key. For example, with a
  simple primary key, you only need to provide a value for the partition key. For a composite
  primary key, you must provide both values for both the partition key and the sort key. If
  you specify any attributes that are part of an index key, then the data types for those
  attributes must match those of the schema in the table's attribute definition. Empty String
  and Binary attribute values are allowed. Attribute values of type String and Binary must
  have a length greater than zero if the attribute is used as a key attribute for a table or
  index. For more information about primary keys, see Primary Key in the Amazon DynamoDB
  Developer Guide. Each element in the Item map is an AttributeValue object.
- `table_name`: The name of the table to contain the item. You can also provide the Amazon
  Resource Name (ARN) of the table in this parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConditionExpression"`: A condition that must be satisfied in order for a conditional
  PutItem operation to succeed. An expression can contain any of the following:   Functions:
  attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size
  These function names are case-sensitive.   Comparison operators: = | &lt;&gt; | &lt; | &gt;
  | &lt;= | &gt;= | BETWEEN | IN      Logical operators: AND | OR | NOT    For more
  information on condition expressions, see Condition Expressions in the Amazon DynamoDB
  Developer Guide.
- `"ConditionalOperator"`: This is a legacy parameter. Use ConditionExpression instead. For
  more information, see ConditionalOperator in the Amazon DynamoDB Developer Guide.
- `"Expected"`: This is a legacy parameter. Use ConditionExpression instead. For more
  information, see Expected in the Amazon DynamoDB Developer Guide.
- `"ExpressionAttributeNames"`: One or more substitution tokens for attribute names in an
  expression. The following are some use cases for using ExpressionAttributeNames:   To
  access an attribute whose name conflicts with a DynamoDB reserved word.   To create a
  placeholder for repeating occurrences of an attribute name in an expression.   To prevent
  special characters in an attribute name from being misinterpreted in an expression.   Use
  the # character in an expression to dereference an attribute name. For example, consider
  the following attribute name:    Percentile    The name of this attribute conflicts with a
  reserved word, so it cannot be used directly in an expression. (For the complete list of
  reserved words, see Reserved Words in the Amazon DynamoDB Developer Guide). To work around
  this, you could specify the following for ExpressionAttributeNames:
  {\"#P\":\"Percentile\"}    You could then use this substitution in an expression, as in
  this example:    #P = :val     Tokens that begin with the : character are expression
  attribute values, which are placeholders for the actual value at runtime.  For more
  information on expression attribute names, see Specifying Item Attributes in the Amazon
  DynamoDB Developer Guide.
- `"ExpressionAttributeValues"`: One or more values that can be substituted in an
  expression. Use the : (colon) character in an expression to dereference an attribute value.
  For example, suppose that you wanted to check whether the value of the ProductStatus
  attribute was one of the following:   Available | Backordered | Discontinued  You would
  first need to specify ExpressionAttributeValues as follows:  {
  \":avail\":{\"S\":\"Available\"}, \":back\":{\"S\":\"Backordered\"},
  \":disc\":{\"S\":\"Discontinued\"} }  You could then use these values in an expression,
  such as this:  ProductStatus IN (:avail, :back, :disc)  For more information on expression
  attribute values, see Condition Expressions in the Amazon DynamoDB Developer Guide.
- `"ReturnConsumedCapacity"`:
- `"ReturnItemCollectionMetrics"`: Determines whether item collection metrics are returned.
  If set to SIZE, the response includes statistics about item collections, if any, that were
  modified during the operation are returned in the response. If set to NONE (the default),
  no statistics are returned.
- `"ReturnValues"`: Use ReturnValues if you want to get the item attributes as they
  appeared before they were updated with the PutItem request. For PutItem, the valid values
  are:    NONE - If ReturnValues is not specified, or if its value is NONE, then nothing is
  returned. (This setting is the default for ReturnValues.)    ALL_OLD - If PutItem overwrote
  an attribute name-value pair, then the content of the old item is returned.   The values
  returned are strongly consistent. There is no additional cost associated with requesting a
  return value aside from the small network and processing overhead of receiving a larger
  response. No read capacity units are consumed.  The ReturnValues parameter is used by
  several DynamoDB operations; however, PutItem does not recognize any values other than NONE
  or ALL_OLD.
- `"ReturnValuesOnConditionCheckFailure"`: An optional parameter that returns the item
  attributes for a PutItem operation that failed a condition check. There is no additional
  cost associated with requesting a return value aside from the small network and processing
  overhead of receiving a larger response. No read capacity units are consumed.
"""
function put_item(Item, TableName; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb(
        "PutItem",
        Dict{String,Any}("Item" => Item, "TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_item(
    Item,
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "PutItem",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Item" => Item, "TableName" => TableName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_resource_policy(policy, resource_arn)
    put_resource_policy(policy, resource_arn, params::Dict{String,<:Any})

Attaches a resource-based policy document to the resource, which can be a table or stream.
When you attach a resource-based policy using this API, the policy application is
eventually consistent .  PutResourcePolicy is an idempotent operation; running it multiple
times on the same resource using the same policy document will return the same revision ID.
If you specify an ExpectedRevisionId that doesn't match the current policy's RevisionId,
the PolicyNotFoundException will be returned.   PutResourcePolicy is an asynchronous
operation. If you issue a GetResourcePolicy request immediately after a PutResourcePolicy
request, DynamoDB might return your previous policy, if there was one, or return the
PolicyNotFoundException. This is because GetResourcePolicy uses an eventually consistent
query, and the metadata for your policy or table might not be available at that moment.
Wait for a few seconds, and then try the GetResourcePolicy request again.

# Arguments
- `policy`: An Amazon Web Services resource-based policy document in JSON format.   The
  maximum size supported for a resource-based policy document is 20 KB. DynamoDB counts
  whitespaces when calculating the size of a policy against this limit.   Within a
  resource-based policy, if the action for a DynamoDB service-linked role (SLR) to replicate
  data for a global table is denied, adding or deleting a replica will fail with an error.
  For a full list of all considerations that apply while attaching a resource-based policy,
  see Resource-based policy considerations.
- `resource_arn`: The Amazon Resource Name (ARN) of the DynamoDB resource to which the
  policy will be attached. The resources you can specify include tables and streams. You can
  control index permissions using the base table's policy. To specify the same permission
  level for your table and its indexes, you can provide both the table and index Amazon
  Resource Name (ARN)s in the Resource field of a given Statement in your policy document.
  Alternatively, to specify different permissions for your table, indexes, or both, you can
  define multiple Statement fields in your policy document.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConfirmRemoveSelfResourceAccess"`: Set this parameter to true to confirm that you want
  to remove your permissions to change the policy of this resource in the future.
- `"ExpectedRevisionId"`: A string value that you can use to conditionally update your
  policy. You can provide the revision ID of your existing policy to make mutating requests
  against that policy.  When you provide an expected revision ID, if the revision ID of the
  existing policy on the resource doesn't match or if there's no policy attached to the
  resource, your request will be rejected with a PolicyNotFoundException.  To conditionally
  attach a policy when no policy exists for the resource, specify NO_POLICY for the revision
  ID.
"""
function put_resource_policy(
    Policy, ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "PutResourcePolicy",
        Dict{String,Any}("Policy" => Policy, "ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_resource_policy(
    Policy,
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "PutResourcePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Policy" => Policy, "ResourceArn" => ResourceArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    query(table_name)
    query(table_name, params::Dict{String,<:Any})

You must provide the name of the partition key attribute and a single value for that
attribute. Query returns all items with that partition key value. Optionally, you can
provide a sort key attribute and use a comparison operator to refine the search results.
Use the KeyConditionExpression parameter to provide a specific value for the partition key.
The Query operation will return all of the items from the table or index with that
partition key value. You can optionally narrow the scope of the Query operation by
specifying a sort key value and a comparison operator in KeyConditionExpression. To further
refine the Query results, you can optionally provide a FilterExpression. A FilterExpression
determines which items within the results should be returned to you. All of the other
results are discarded.   A Query operation always returns a result set. If no matching
items are found, the result set will be empty. Queries that do not return results consume
the minimum number of read capacity units for that type of read operation.    DynamoDB
calculates the number of read capacity units consumed based on item size, not on the amount
of data that is returned to an application. The number of capacity units consumed will be
the same whether you request all of the attributes (the default behavior) or just some of
them (using a projection expression). The number will also be the same whether or not you
use a FilterExpression.    Query results are always sorted by the sort key value. If the
data type of the sort key is Number, the results are returned in numeric order; otherwise,
the results are returned in order of UTF-8 bytes. By default, the sort order is ascending.
To reverse the order, set the ScanIndexForward parameter to false.   A single Query
operation will read up to the maximum number of items set (if using the Limit parameter) or
a maximum of 1 MB of data and then apply any filtering to the results using
FilterExpression. If LastEvaluatedKey is present in the response, you will need to paginate
the result set. For more information, see Paginating the Results in the Amazon DynamoDB
Developer Guide.   FilterExpression is applied after a Query finishes, but before the
results are returned. A FilterExpression cannot contain partition key or sort key
attributes. You need to specify those attributes in the KeyConditionExpression.    A Query
operation can return an empty result set and a LastEvaluatedKey if all the items read for
the page of results are filtered out.   You can query a table, a local secondary index, or
a global secondary index. For a query on a table or on a local secondary index, you can set
the ConsistentRead parameter to true and obtain a strongly consistent result. Global
secondary indexes support eventually consistent reads only, so do not specify
ConsistentRead when querying a global secondary index.

# Arguments
- `table_name`: The name of the table containing the requested items. You can also provide
  the Amazon Resource Name (ARN) of the table in this parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AttributesToGet"`: This is a legacy parameter. Use ProjectionExpression instead. For
  more information, see AttributesToGet in the Amazon DynamoDB Developer Guide.
- `"ConditionalOperator"`: This is a legacy parameter. Use FilterExpression instead. For
  more information, see ConditionalOperator in the Amazon DynamoDB Developer Guide.
- `"ConsistentRead"`: Determines the read consistency model: If set to true, then the
  operation uses strongly consistent reads; otherwise, the operation uses eventually
  consistent reads. Strongly consistent reads are not supported on global secondary indexes.
  If you query a global secondary index with ConsistentRead set to true, you will receive a
  ValidationException.
- `"ExclusiveStartKey"`: The primary key of the first item that this operation will
  evaluate. Use the value that was returned for LastEvaluatedKey in the previous operation.
  The data type for ExclusiveStartKey must be String, Number, or Binary. No set data types
  are allowed.
- `"ExpressionAttributeNames"`: One or more substitution tokens for attribute names in an
  expression. The following are some use cases for using ExpressionAttributeNames:   To
  access an attribute whose name conflicts with a DynamoDB reserved word.   To create a
  placeholder for repeating occurrences of an attribute name in an expression.   To prevent
  special characters in an attribute name from being misinterpreted in an expression.   Use
  the # character in an expression to dereference an attribute name. For example, consider
  the following attribute name:    Percentile    The name of this attribute conflicts with a
  reserved word, so it cannot be used directly in an expression. (For the complete list of
  reserved words, see Reserved Words in the Amazon DynamoDB Developer Guide). To work around
  this, you could specify the following for ExpressionAttributeNames:
  {\"#P\":\"Percentile\"}    You could then use this substitution in an expression, as in
  this example:    #P = :val     Tokens that begin with the : character are expression
  attribute values, which are placeholders for the actual value at runtime.  For more
  information on expression attribute names, see Specifying Item Attributes in the Amazon
  DynamoDB Developer Guide.
- `"ExpressionAttributeValues"`: One or more values that can be substituted in an
  expression. Use the : (colon) character in an expression to dereference an attribute value.
  For example, suppose that you wanted to check whether the value of the ProductStatus
  attribute was one of the following:   Available | Backordered | Discontinued  You would
  first need to specify ExpressionAttributeValues as follows:  {
  \":avail\":{\"S\":\"Available\"}, \":back\":{\"S\":\"Backordered\"},
  \":disc\":{\"S\":\"Discontinued\"} }  You could then use these values in an expression,
  such as this:  ProductStatus IN (:avail, :back, :disc)  For more information on expression
  attribute values, see Specifying Conditions in the Amazon DynamoDB Developer Guide.
- `"FilterExpression"`: A string that contains conditions that DynamoDB applies after the
  Query operation, but before the data is returned to you. Items that do not satisfy the
  FilterExpression criteria are not returned. A FilterExpression does not allow key
  attributes. You cannot define a filter expression based on a partition key or a sort key.
  A FilterExpression is applied after the items have already been read; the process of
  filtering does not consume any additional read capacity units.  For more information, see
  Filter Expressions in the Amazon DynamoDB Developer Guide.
- `"IndexName"`: The name of an index to query. This index can be any local secondary index
  or global secondary index on the table. Note that if you use the IndexName parameter, you
  must also provide TableName.
- `"KeyConditionExpression"`: The condition that specifies the key values for items to be
  retrieved by the Query action. The condition must perform an equality test on a single
  partition key value. The condition can optionally perform one of several comparison tests
  on a single sort key value. This allows Query to retrieve one item with a given partition
  key value and sort key value, or several items that have the same partition key value but
  different sort key values. The partition key equality test is required, and must be
  specified in the following format:  partitionKeyName = :partitionkeyval  If you also want
  to provide a condition for the sort key, it must be combined using AND with the condition
  for the sort key. Following is an example, using the = comparison operator for the sort
  key:  partitionKeyName = :partitionkeyval AND sortKeyName = :sortkeyval  Valid comparisons
  for the sort key condition are as follows:    sortKeyName = :sortkeyval - true if the sort
  key value is equal to :sortkeyval.    sortKeyName &lt; :sortkeyval - true if the sort key
  value is less than :sortkeyval.    sortKeyName &lt;= :sortkeyval - true if the sort key
  value is less than or equal to :sortkeyval.    sortKeyName &gt; :sortkeyval - true if the
  sort key value is greater than :sortkeyval.    sortKeyName &gt;=  :sortkeyval - true if the
  sort key value is greater than or equal to :sortkeyval.    sortKeyName BETWEEN :sortkeyval1
  AND :sortkeyval2 - true if the sort key value is greater than or equal to :sortkeyval1, and
  less than or equal to :sortkeyval2.    begins_with ( sortKeyName, :sortkeyval ) - true if
  the sort key value begins with a particular operand. (You cannot use this function with a
  sort key that is of type Number.) Note that the function name begins_with is
  case-sensitive.   Use the ExpressionAttributeValues parameter to replace tokens such as
  :partitionval and :sortval with actual values at runtime. You can optionally use the
  ExpressionAttributeNames parameter to replace the names of the partition key and sort key
  with placeholder tokens. This option might be necessary if an attribute name conflicts with
  a DynamoDB reserved word. For example, the following KeyConditionExpression parameter
  causes an error because Size is a reserved word:    Size = :myval    To work around this,
  define a placeholder (such a #S) to represent the attribute name Size.
  KeyConditionExpression then is as follows:    #S = :myval    For a list of reserved words,
  see Reserved Words in the Amazon DynamoDB Developer Guide. For more information on
  ExpressionAttributeNames and ExpressionAttributeValues, see Using Placeholders for
  Attribute Names and Values in the Amazon DynamoDB Developer Guide.
- `"KeyConditions"`: This is a legacy parameter. Use KeyConditionExpression instead. For
  more information, see KeyConditions in the Amazon DynamoDB Developer Guide.
- `"Limit"`: The maximum number of items to evaluate (not necessarily the number of
  matching items). If DynamoDB processes the number of items up to the limit while processing
  the results, it stops the operation and returns the matching values up to that point, and a
  key in LastEvaluatedKey to apply in a subsequent operation, so that you can pick up where
  you left off. Also, if the processed dataset size exceeds 1 MB before DynamoDB reaches this
  limit, it stops the operation and returns the matching values up to the limit, and a key in
  LastEvaluatedKey to apply in a subsequent operation to continue the operation. For more
  information, see Query and Scan in the Amazon DynamoDB Developer Guide.
- `"ProjectionExpression"`: A string that identifies one or more attributes to retrieve
  from the table. These attributes can include scalars, sets, or elements of a JSON document.
  The attributes in the expression must be separated by commas. If no attribute names are
  specified, then all attributes will be returned. If any of the requested attributes are not
  found, they will not appear in the result. For more information, see Accessing Item
  Attributes in the Amazon DynamoDB Developer Guide.
- `"QueryFilter"`: This is a legacy parameter. Use FilterExpression instead. For more
  information, see QueryFilter in the Amazon DynamoDB Developer Guide.
- `"ReturnConsumedCapacity"`:
- `"ScanIndexForward"`: Specifies the order for index traversal: If true (default), the
  traversal is performed in ascending order; if false, the traversal is performed in
  descending order.  Items with the same partition key value are stored in sorted order by
  sort key. If the sort key data type is Number, the results are stored in numeric order. For
  type String, the results are stored in order of UTF-8 bytes. For type Binary, DynamoDB
  treats each byte of the binary data as unsigned. If ScanIndexForward is true, DynamoDB
  returns the results in the order in which they are stored (by sort key value). This is the
  default behavior. If ScanIndexForward is false, DynamoDB reads the results in reverse order
  by sort key value, and then returns the results to the client.
- `"Select"`: The attributes to be returned in the result. You can retrieve all item
  attributes, specific item attributes, the count of matching items, or in the case of an
  index, some or all of the attributes projected into the index.    ALL_ATTRIBUTES - Returns
  all of the item attributes from the specified table or index. If you query a local
  secondary index, then for each matching item in the index, DynamoDB fetches the entire item
  from the parent table. If the index is configured to project all item attributes, then all
  of the data can be obtained from the local secondary index, and no fetching is required.
  ALL_PROJECTED_ATTRIBUTES - Allowed only when querying an index. Retrieves all attributes
  that have been projected into the index. If the index is configured to project all
  attributes, this return value is equivalent to specifying ALL_ATTRIBUTES.    COUNT -
  Returns the number of matching items, rather than the matching items themselves. Note that
  this uses the same quantity of read capacity units as getting the items, and is subject to
  the same item size calculations.    SPECIFIC_ATTRIBUTES - Returns only the attributes
  listed in ProjectionExpression. This return value is equivalent to specifying
  ProjectionExpression without specifying any value for Select. If you query or scan a local
  secondary index and request only attributes that are projected into that index, the
  operation will read only the index and not the table. If any of the requested attributes
  are not projected into the local secondary index, DynamoDB fetches each of these attributes
  from the parent table. This extra fetching incurs additional throughput cost and latency.
  If you query or scan a global secondary index, you can only request attributes that are
  projected into the index. Global secondary index queries cannot fetch attributes from the
  parent table.   If neither Select nor ProjectionExpression are specified, DynamoDB defaults
  to ALL_ATTRIBUTES when accessing a table, and ALL_PROJECTED_ATTRIBUTES when accessing an
  index. You cannot use both Select and ProjectionExpression together in a single request,
  unless the value for Select is SPECIFIC_ATTRIBUTES. (This usage is equivalent to specifying
  ProjectionExpression without any value for Select.)  If you use the ProjectionExpression
  parameter, then the value for Select can only be SPECIFIC_ATTRIBUTES. Any other value for
  Select will return an error.
"""
function query(TableName; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb(
        "Query",
        Dict{String,Any}("TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function query(
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "Query",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TableName" => TableName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_table_from_backup(backup_arn, target_table_name)
    restore_table_from_backup(backup_arn, target_table_name, params::Dict{String,<:Any})

Creates a new table from an existing backup. Any number of users can execute up to 50
concurrent restores (any type of restore) in a given account.  You can call
RestoreTableFromBackup at a maximum rate of 10 times per second. You must manually set up
the following on the restored table:   Auto scaling policies   IAM policies   Amazon
CloudWatch metrics and alarms   Tags   Stream settings   Time to Live (TTL) settings

# Arguments
- `backup_arn`: The Amazon Resource Name (ARN) associated with the backup.
- `target_table_name`: The name of the new table to which the backup must be restored.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BillingModeOverride"`: The billing mode of the restored table.
- `"GlobalSecondaryIndexOverride"`: List of global secondary indexes for the restored
  table. The indexes provided should match existing secondary indexes. You can choose to
  exclude some or all of the indexes at the time of restore.
- `"LocalSecondaryIndexOverride"`: List of local secondary indexes for the restored table.
  The indexes provided should match existing secondary indexes. You can choose to exclude
  some or all of the indexes at the time of restore.
- `"OnDemandThroughputOverride"`:
- `"ProvisionedThroughputOverride"`: Provisioned throughput settings for the restored table.
- `"SSESpecificationOverride"`: The new server-side encryption settings for the restored
  table.
"""
function restore_table_from_backup(
    BackupArn, TargetTableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "RestoreTableFromBackup",
        Dict{String,Any}("BackupArn" => BackupArn, "TargetTableName" => TargetTableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_table_from_backup(
    BackupArn,
    TargetTableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "RestoreTableFromBackup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "BackupArn" => BackupArn, "TargetTableName" => TargetTableName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_table_to_point_in_time(target_table_name)
    restore_table_to_point_in_time(target_table_name, params::Dict{String,<:Any})

Restores the specified table to the specified point in time within
EarliestRestorableDateTime and LatestRestorableDateTime. You can restore your table to any
point in time during the last 35 days. Any number of users can execute up to 50 concurrent
restores (any type of restore) in a given account.  When you restore using point in time
recovery, DynamoDB restores your table data to the state based on the selected date and
time (day:hour:minute:second) to a new table.  Along with data, the following are also
included on the new restored table using point in time recovery:    Global secondary
indexes (GSIs)   Local secondary indexes (LSIs)   Provisioned read and write capacity
Encryption settings   All these settings come from the current settings of the source table
at the time of restore.     You must manually set up the following on the restored table:
Auto scaling policies   IAM policies   Amazon CloudWatch metrics and alarms   Tags   Stream
settings   Time to Live (TTL) settings   Point in time recovery settings

# Arguments
- `target_table_name`: The name of the new table to which it must be restored to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BillingModeOverride"`: The billing mode of the restored table.
- `"GlobalSecondaryIndexOverride"`: List of global secondary indexes for the restored
  table. The indexes provided should match existing secondary indexes. You can choose to
  exclude some or all of the indexes at the time of restore.
- `"LocalSecondaryIndexOverride"`: List of local secondary indexes for the restored table.
  The indexes provided should match existing secondary indexes. You can choose to exclude
  some or all of the indexes at the time of restore.
- `"OnDemandThroughputOverride"`:
- `"ProvisionedThroughputOverride"`: Provisioned throughput settings for the restored table.
- `"RestoreDateTime"`: Time in the past to restore the table to.
- `"SSESpecificationOverride"`: The new server-side encryption settings for the restored
  table.
- `"SourceTableArn"`: The DynamoDB table that will be restored. This value is an Amazon
  Resource Name (ARN).
- `"SourceTableName"`: Name of the source table that is being restored.
- `"UseLatestRestorableTime"`: Restore the table to the latest possible time.
  LatestRestorableDateTime is typically 5 minutes before the current time.
"""
function restore_table_to_point_in_time(
    TargetTableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "RestoreTableToPointInTime",
        Dict{String,Any}("TargetTableName" => TargetTableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_table_to_point_in_time(
    TargetTableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "RestoreTableToPointInTime",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("TargetTableName" => TargetTableName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    scan(table_name)
    scan(table_name, params::Dict{String,<:Any})

The Scan operation returns one or more items and item attributes by accessing every item in
a table or a secondary index. To have DynamoDB return fewer items, you can provide a
FilterExpression operation. If the total size of scanned items exceeds the maximum dataset
size limit of 1 MB, the scan completes and results are returned to the user. The
LastEvaluatedKey value is also returned and the requestor can use the LastEvaluatedKey to
continue the scan in a subsequent operation. Each scan response also includes number of
items that were scanned (ScannedCount) as part of the request. If using a FilterExpression,
a scan result can result in no items meeting the criteria and the Count will result in
zero. If you did not use a FilterExpression in the scan request, then Count is the same as
ScannedCount.   Count and ScannedCount only return the count of items specific to a single
scan request and, unless the table is less than 1MB, do not represent the total number of
items in the table.   A single Scan operation first reads up to the maximum number of items
set (if using the Limit parameter) or a maximum of 1 MB of data and then applies any
filtering to the results if a FilterExpression is provided. If LastEvaluatedKey is present
in the response, pagination is required to complete the full table scan. For more
information, see Paginating the Results in the Amazon DynamoDB Developer Guide.  Scan
operations proceed sequentially; however, for faster performance on a large table or
secondary index, applications can request a parallel Scan operation by providing the
Segment and TotalSegments parameters. For more information, see Parallel Scan in the Amazon
DynamoDB Developer Guide. By default, a Scan uses eventually consistent reads when
accessing the items in a table. Therefore, the results from an eventually consistent Scan
may not include the latest item changes at the time the scan iterates through each item in
the table. If you require a strongly consistent read of each item as the scan iterates
through the items in the table, you can set the ConsistentRead parameter to true. Strong
consistency only relates to the consistency of the read at the item level.   DynamoDB does
not provide snapshot isolation for a scan operation when the ConsistentRead parameter is
set to true. Thus, a DynamoDB scan operation does not guarantee that all reads in a scan
see a consistent snapshot of the table when the scan operation was requested.

# Arguments
- `table_name`: The name of the table containing the requested items or if you provide
  IndexName, the name of the table to which that index belongs. You can also provide the
  Amazon Resource Name (ARN) of the table in this parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AttributesToGet"`: This is a legacy parameter. Use ProjectionExpression instead. For
  more information, see AttributesToGet in the Amazon DynamoDB Developer Guide.
- `"ConditionalOperator"`: This is a legacy parameter. Use FilterExpression instead. For
  more information, see ConditionalOperator in the Amazon DynamoDB Developer Guide.
- `"ConsistentRead"`: A Boolean value that determines the read consistency model during the
  scan:   If ConsistentRead is false, then the data returned from Scan might not contain the
  results from other recently completed write operations (PutItem, UpdateItem, or
  DeleteItem).   If ConsistentRead is true, then all of the write operations that completed
  before the Scan began are guaranteed to be contained in the Scan response.   The default
  setting for ConsistentRead is false. The ConsistentRead parameter is not supported on
  global secondary indexes. If you scan a global secondary index with ConsistentRead set to
  true, you will receive a ValidationException.
- `"ExclusiveStartKey"`: The primary key of the first item that this operation will
  evaluate. Use the value that was returned for LastEvaluatedKey in the previous operation.
  The data type for ExclusiveStartKey must be String, Number or Binary. No set data types are
  allowed. In a parallel scan, a Scan request that includes ExclusiveStartKey must specify
  the same segment whose previous Scan returned the corresponding value of LastEvaluatedKey.
- `"ExpressionAttributeNames"`: One or more substitution tokens for attribute names in an
  expression. The following are some use cases for using ExpressionAttributeNames:   To
  access an attribute whose name conflicts with a DynamoDB reserved word.   To create a
  placeholder for repeating occurrences of an attribute name in an expression.   To prevent
  special characters in an attribute name from being misinterpreted in an expression.   Use
  the # character in an expression to dereference an attribute name. For example, consider
  the following attribute name:    Percentile    The name of this attribute conflicts with a
  reserved word, so it cannot be used directly in an expression. (For the complete list of
  reserved words, see Reserved Words in the Amazon DynamoDB Developer Guide). To work around
  this, you could specify the following for ExpressionAttributeNames:
  {\"#P\":\"Percentile\"}    You could then use this substitution in an expression, as in
  this example:    #P = :val     Tokens that begin with the : character are expression
  attribute values, which are placeholders for the actual value at runtime.  For more
  information on expression attribute names, see Specifying Item Attributes in the Amazon
  DynamoDB Developer Guide.
- `"ExpressionAttributeValues"`: One or more values that can be substituted in an
  expression. Use the : (colon) character in an expression to dereference an attribute value.
  For example, suppose that you wanted to check whether the value of the ProductStatus
  attribute was one of the following:   Available | Backordered | Discontinued  You would
  first need to specify ExpressionAttributeValues as follows:  {
  \":avail\":{\"S\":\"Available\"}, \":back\":{\"S\":\"Backordered\"},
  \":disc\":{\"S\":\"Discontinued\"} }  You could then use these values in an expression,
  such as this:  ProductStatus IN (:avail, :back, :disc)  For more information on expression
  attribute values, see Condition Expressions in the Amazon DynamoDB Developer Guide.
- `"FilterExpression"`: A string that contains conditions that DynamoDB applies after the
  Scan operation, but before the data is returned to you. Items that do not satisfy the
  FilterExpression criteria are not returned.  A FilterExpression is applied after the items
  have already been read; the process of filtering does not consume any additional read
  capacity units.  For more information, see Filter Expressions in the Amazon DynamoDB
  Developer Guide.
- `"IndexName"`: The name of a secondary index to scan. This index can be any local
  secondary index or global secondary index. Note that if you use the IndexName parameter,
  you must also provide TableName.
- `"Limit"`: The maximum number of items to evaluate (not necessarily the number of
  matching items). If DynamoDB processes the number of items up to the limit while processing
  the results, it stops the operation and returns the matching values up to that point, and a
  key in LastEvaluatedKey to apply in a subsequent operation, so that you can pick up where
  you left off. Also, if the processed dataset size exceeds 1 MB before DynamoDB reaches this
  limit, it stops the operation and returns the matching values up to the limit, and a key in
  LastEvaluatedKey to apply in a subsequent operation to continue the operation. For more
  information, see Working with Queries in the Amazon DynamoDB Developer Guide.
- `"ProjectionExpression"`: A string that identifies one or more attributes to retrieve
  from the specified table or index. These attributes can include scalars, sets, or elements
  of a JSON document. The attributes in the expression must be separated by commas. If no
  attribute names are specified, then all attributes will be returned. If any of the
  requested attributes are not found, they will not appear in the result. For more
  information, see Specifying Item Attributes in the Amazon DynamoDB Developer Guide.
- `"ReturnConsumedCapacity"`:
- `"ScanFilter"`: This is a legacy parameter. Use FilterExpression instead. For more
  information, see ScanFilter in the Amazon DynamoDB Developer Guide.
- `"Segment"`: For a parallel Scan request, Segment identifies an individual segment to be
  scanned by an application worker. Segment IDs are zero-based, so the first segment is
  always 0. For example, if you want to use four application threads to scan a table or an
  index, then the first thread specifies a Segment value of 0, the second thread specifies 1,
  and so on. The value of LastEvaluatedKey returned from a parallel Scan request must be used
  as ExclusiveStartKey with the same segment ID in a subsequent Scan operation. The value for
  Segment must be greater than or equal to 0, and less than the value provided for
  TotalSegments. If you provide Segment, you must also provide TotalSegments.
- `"Select"`: The attributes to be returned in the result. You can retrieve all item
  attributes, specific item attributes, the count of matching items, or in the case of an
  index, some or all of the attributes projected into the index.    ALL_ATTRIBUTES - Returns
  all of the item attributes from the specified table or index. If you query a local
  secondary index, then for each matching item in the index, DynamoDB fetches the entire item
  from the parent table. If the index is configured to project all item attributes, then all
  of the data can be obtained from the local secondary index, and no fetching is required.
  ALL_PROJECTED_ATTRIBUTES - Allowed only when querying an index. Retrieves all attributes
  that have been projected into the index. If the index is configured to project all
  attributes, this return value is equivalent to specifying ALL_ATTRIBUTES.    COUNT -
  Returns the number of matching items, rather than the matching items themselves. Note that
  this uses the same quantity of read capacity units as getting the items, and is subject to
  the same item size calculations.    SPECIFIC_ATTRIBUTES - Returns only the attributes
  listed in ProjectionExpression. This return value is equivalent to specifying
  ProjectionExpression without specifying any value for Select. If you query or scan a local
  secondary index and request only attributes that are projected into that index, the
  operation reads only the index and not the table. If any of the requested attributes are
  not projected into the local secondary index, DynamoDB fetches each of these attributes
  from the parent table. This extra fetching incurs additional throughput cost and latency.
  If you query or scan a global secondary index, you can only request attributes that are
  projected into the index. Global secondary index queries cannot fetch attributes from the
  parent table.   If neither Select nor ProjectionExpression are specified, DynamoDB defaults
  to ALL_ATTRIBUTES when accessing a table, and ALL_PROJECTED_ATTRIBUTES when accessing an
  index. You cannot use both Select and ProjectionExpression together in a single request,
  unless the value for Select is SPECIFIC_ATTRIBUTES. (This usage is equivalent to specifying
  ProjectionExpression without any value for Select.)  If you use the ProjectionExpression
  parameter, then the value for Select can only be SPECIFIC_ATTRIBUTES. Any other value for
  Select will return an error.
- `"TotalSegments"`: For a parallel Scan request, TotalSegments represents the total number
  of segments into which the Scan operation will be divided. The value of TotalSegments
  corresponds to the number of application workers that will perform the parallel scan. For
  example, if you want to use four application threads to scan a table or an index, specify a
  TotalSegments value of 4. The value for TotalSegments must be greater than or equal to 1,
  and less than or equal to 1000000. If you specify a TotalSegments value of 1, the Scan
  operation will be sequential rather than parallel. If you specify TotalSegments, you must
  also specify Segment.
"""
function scan(TableName; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb(
        "Scan",
        Dict{String,Any}("TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function scan(
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "Scan",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TableName" => TableName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Associate a set of tags with an Amazon DynamoDB resource. You can then activate these
user-defined tags so that they appear on the Billing and Cost Management console for cost
allocation tracking. You can call TagResource up to five times per second, per account.
For an overview on tagging DynamoDB resources, see Tagging for DynamoDB in the Amazon
DynamoDB Developer Guide.

# Arguments
- `resource_arn`: Identifies the Amazon DynamoDB resource to which tags should be added.
  This value is an Amazon Resource Name (ARN).
- `tags`: The tags to be assigned to the Amazon DynamoDB resource.

"""
function tag_resource(ResourceArn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb(
        "TagResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    transact_get_items(transact_items)
    transact_get_items(transact_items, params::Dict{String,<:Any})

 TransactGetItems is a synchronous operation that atomically retrieves multiple items from
one or more tables (but not from indexes) in a single account and Region. A
TransactGetItems call can contain up to 100 TransactGetItem objects, each of which contains
a Get structure that specifies an item to retrieve from a table in the account and Region.
A call to TransactGetItems cannot retrieve items from tables in more than one Amazon Web
Services account or Region. The aggregate size of the items in the transaction cannot
exceed 4 MB. DynamoDB rejects the entire TransactGetItems request if any of the following
is true:   A conflicting operation is in the process of updating an item to be read.
There is insufficient provisioned capacity for the transaction to be completed.   There is
a user error, such as an invalid data format.   The aggregate size of the items in the
transaction exceeded 4 MB.

# Arguments
- `transact_items`: An ordered array of up to 100 TransactGetItem objects, each of which
  contains a Get structure.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ReturnConsumedCapacity"`: A value of TOTAL causes consumed capacity information to be
  returned, and a value of NONE prevents that information from being returned. No other value
  is valid.
"""
function transact_get_items(
    TransactItems; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "TransactGetItems",
        Dict{String,Any}("TransactItems" => TransactItems);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function transact_get_items(
    TransactItems,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "TransactGetItems",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TransactItems" => TransactItems), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    transact_write_items(transact_items)
    transact_write_items(transact_items, params::Dict{String,<:Any})

 TransactWriteItems is a synchronous write operation that groups up to 100 action requests.
These actions can target items in different tables, but not in different Amazon Web
Services accounts or Regions, and no two actions can target the same item. For example, you
cannot both ConditionCheck and Update the same item. The aggregate size of the items in the
transaction cannot exceed 4 MB. The actions are completed atomically so that either all of
them succeed, or all of them fail. They are defined by the following objects:    Put  —
  Initiates a PutItem operation to write a new item. This structure specifies the primary
key of the item to be written, the name of the table to write it in, an optional condition
expression that must be satisfied for the write to succeed, a list of the item's
attributes, and a field indicating whether to retrieve the item's attributes if the
condition is not met.    Update  —   Initiates an UpdateItem operation to update an
existing item. This structure specifies the primary key of the item to be updated, the name
of the table where it resides, an optional condition expression that must be satisfied for
the update to succeed, an expression that defines one or more attributes to be updated, and
a field indicating whether to retrieve the item's attributes if the condition is not met.
 Delete  —   Initiates a DeleteItem operation to delete an existing item. This
structure specifies the primary key of the item to be deleted, the name of the table where
it resides, an optional condition expression that must be satisfied for the deletion to
succeed, and a field indicating whether to retrieve the item's attributes if the condition
is not met.    ConditionCheck  —   Applies a condition to an item that is not being
modified by the transaction. This structure specifies the primary key of the item to be
checked, the name of the table where it resides, a condition expression that must be
satisfied for the transaction to succeed, and a field indicating whether to retrieve the
item's attributes if the condition is not met.   DynamoDB rejects the entire
TransactWriteItems request if any of the following is true:   A condition in one of the
condition expressions is not met.   An ongoing operation is in the process of updating the
same item.   There is insufficient provisioned capacity for the transaction to be
completed.   An item size becomes too large (bigger than 400 KB), a local secondary index
(LSI) becomes too large, or a similar validation error occurs because of changes made by
the transaction.   The aggregate size of the items in the transaction exceeds 4 MB.   There
is a user error, such as an invalid data format.

# Arguments
- `transact_items`: An ordered array of up to 100 TransactWriteItem objects, each of which
  contains a ConditionCheck, Put, Update, or Delete object. These can operate on items in
  different tables, but the tables must reside in the same Amazon Web Services account and
  Region, and no two of them can operate on the same item.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: Providing a ClientRequestToken makes the call to
  TransactWriteItems idempotent, meaning that multiple identical calls have the same effect
  as one single call. Although multiple identical calls using the same client request token
  produce the same result on the server (no side effects), the responses to the calls might
  not be the same. If the ReturnConsumedCapacity parameter is set, then the initial
  TransactWriteItems call returns the amount of write capacity units consumed in making the
  changes. Subsequent TransactWriteItems calls with the same client token return the number
  of read capacity units consumed in reading the item. A client request token is valid for 10
  minutes after the first request that uses it is completed. After 10 minutes, any request
  with the same client token is treated as a new request. Do not resubmit the same request
  with the same client token for more than 10 minutes, or the result might not be idempotent.
  If you submit a request with the same client token but a change in other parameters within
  the 10-minute idempotency window, DynamoDB returns an IdempotentParameterMismatch exception.
- `"ReturnConsumedCapacity"`:
- `"ReturnItemCollectionMetrics"`: Determines whether item collection metrics are returned.
  If set to SIZE, the response includes statistics about item collections (if any), that were
  modified during the operation and are returned in the response. If set to NONE (the
  default), no statistics are returned.
"""
function transact_write_items(
    TransactItems; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "TransactWriteItems",
        Dict{String,Any}(
            "TransactItems" => TransactItems, "ClientRequestToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function transact_write_items(
    TransactItems,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "TransactWriteItems",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransactItems" => TransactItems,
                    "ClientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes the association of tags from an Amazon DynamoDB resource. You can call
UntagResource up to five times per second, per account.  For an overview on tagging
DynamoDB resources, see Tagging for DynamoDB in the Amazon DynamoDB Developer Guide.

# Arguments
- `resource_arn`: The DynamoDB resource that the tags will be removed from. This value is
  an Amazon Resource Name (ARN).
- `tag_keys`: A list of tag keys. Existing tags of the resource whose keys are members of
  this list will be removed from the DynamoDB resource.

"""
function untag_resource(
    ResourceArn, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "UntagResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_continuous_backups(point_in_time_recovery_specification, table_name)
    update_continuous_backups(point_in_time_recovery_specification, table_name, params::Dict{String,<:Any})

 UpdateContinuousBackups enables or disables point in time recovery for the specified
table. A successful UpdateContinuousBackups call returns the current
ContinuousBackupsDescription. Continuous backups are ENABLED on all tables at table
creation. If point in time recovery is enabled, PointInTimeRecoveryStatus will be set to
ENABLED.  Once continuous backups and point in time recovery are enabled, you can restore
to any point in time within EarliestRestorableDateTime and LatestRestorableDateTime.
LatestRestorableDateTime is typically 5 minutes before the current time. You can restore
your table to any point in time during the last 35 days.

# Arguments
- `point_in_time_recovery_specification`: Represents the settings used to enable point in
  time recovery.
- `table_name`: The name of the table. You can also provide the Amazon Resource Name (ARN)
  of the table in this parameter.

"""
function update_continuous_backups(
    PointInTimeRecoverySpecification,
    TableName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "UpdateContinuousBackups",
        Dict{String,Any}(
            "PointInTimeRecoverySpecification" => PointInTimeRecoverySpecification,
            "TableName" => TableName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_continuous_backups(
    PointInTimeRecoverySpecification,
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "UpdateContinuousBackups",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PointInTimeRecoverySpecification" => PointInTimeRecoverySpecification,
                    "TableName" => TableName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_contributor_insights(contributor_insights_action, table_name)
    update_contributor_insights(contributor_insights_action, table_name, params::Dict{String,<:Any})

Updates the status for contributor insights for a specific table or index. CloudWatch
Contributor Insights for DynamoDB graphs display the partition key and (if applicable) sort
key of frequently accessed items and frequently throttled items in plaintext. If you
require the use of Amazon Web Services Key Management Service (KMS) to encrypt this
table’s partition key and sort key data with an Amazon Web Services managed key or
customer managed key, you should not enable CloudWatch Contributor Insights for DynamoDB
for this table.

# Arguments
- `contributor_insights_action`: Represents the contributor insights action.
- `table_name`: The name of the table. You can also provide the Amazon Resource Name (ARN)
  of the table in this parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IndexName"`: The global secondary index name, if applicable.
"""
function update_contributor_insights(
    ContributorInsightsAction, TableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "UpdateContributorInsights",
        Dict{String,Any}(
            "ContributorInsightsAction" => ContributorInsightsAction,
            "TableName" => TableName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_contributor_insights(
    ContributorInsightsAction,
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "UpdateContributorInsights",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ContributorInsightsAction" => ContributorInsightsAction,
                    "TableName" => TableName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_global_table(global_table_name, replica_updates)
    update_global_table(global_table_name, replica_updates, params::Dict{String,<:Any})

Adds or removes replicas in the specified global table. The global table must already exist
to be able to use this operation. Any replica to be added must be empty, have the same name
as the global table, have the same key schema, have DynamoDB Streams enabled, and have the
same provisioned and maximum write capacity units.  This documentation is for version
2017.11.29 (Legacy) of global tables, which should be avoided for new global tables.
Customers should use Global Tables version 2019.11.21 (Current) when possible, because it
provides greater flexibility, higher efficiency, and consumes less write capacity than
2017.11.29 (Legacy). To determine which version you're using, see Determining the global
table version you are using. To update existing global tables from version 2017.11.29
(Legacy) to version 2019.11.21 (Current), see Upgrading global tables.    For global
tables, this operation only applies to global tables using Version 2019.11.21 (Current
version). If you are using global tables Version 2019.11.21 you can use UpdateTable
instead.   Although you can use UpdateGlobalTable to add replicas and remove replicas in a
single request, for simplicity we recommend that you issue separate requests for adding or
removing replicas.    If global secondary indexes are specified, then the following
conditions must also be met:     The global secondary indexes must have the same name.
The global secondary indexes must have the same hash key and sort key (if present).     The
global secondary indexes must have the same provisioned and maximum write capacity units.

# Arguments
- `global_table_name`: The global table name.
- `replica_updates`: A list of Regions that should be added or removed from the global
  table.

"""
function update_global_table(
    GlobalTableName, ReplicaUpdates; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "UpdateGlobalTable",
        Dict{String,Any}(
            "GlobalTableName" => GlobalTableName, "ReplicaUpdates" => ReplicaUpdates
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_global_table(
    GlobalTableName,
    ReplicaUpdates,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "UpdateGlobalTable",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GlobalTableName" => GlobalTableName, "ReplicaUpdates" => ReplicaUpdates
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_global_table_settings(global_table_name)
    update_global_table_settings(global_table_name, params::Dict{String,<:Any})

Updates settings for a global table.  This documentation is for version 2017.11.29 (Legacy)
of global tables, which should be avoided for new global tables. Customers should use
Global Tables version 2019.11.21 (Current) when possible, because it provides greater
flexibility, higher efficiency, and consumes less write capacity than 2017.11.29 (Legacy).
To determine which version you're using, see Determining the global table version you are
using. To update existing global tables from version 2017.11.29 (Legacy) to version
2019.11.21 (Current), see Upgrading global tables.

# Arguments
- `global_table_name`: The name of the global table

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"GlobalTableBillingMode"`: The billing mode of the global table. If
  GlobalTableBillingMode is not specified, the global table defaults to PROVISIONED capacity
  billing mode.    PROVISIONED - We recommend using PROVISIONED for predictable workloads.
  PROVISIONED sets the billing mode to Provisioned capacity mode.    PAY_PER_REQUEST - We
  recommend using PAY_PER_REQUEST for unpredictable workloads. PAY_PER_REQUEST sets the
  billing mode to On-demand capacity mode.
- `"GlobalTableGlobalSecondaryIndexSettingsUpdate"`: Represents the settings of a global
  secondary index for a global table that will be modified.
- `"GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate"`: Auto scaling settings
  for managing provisioned write capacity for the global table.
- `"GlobalTableProvisionedWriteCapacityUnits"`: The maximum number of writes consumed per
  second before DynamoDB returns a ThrottlingException.
- `"ReplicaSettingsUpdate"`: Represents the settings for a global table in a Region that
  will be modified.
"""
function update_global_table_settings(
    GlobalTableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "UpdateGlobalTableSettings",
        Dict{String,Any}("GlobalTableName" => GlobalTableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_global_table_settings(
    GlobalTableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "UpdateGlobalTableSettings",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("GlobalTableName" => GlobalTableName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_item(key, table_name)
    update_item(key, table_name, params::Dict{String,<:Any})

Edits an existing item's attributes, or adds a new item to the table if it does not already
exist. You can put, delete, or add attribute values. You can also perform a conditional
update on an existing item (insert a new attribute name-value pair if it doesn't exist, or
replace an existing name-value pair if it has certain expected attribute values). You can
also return the item's attribute values in the same UpdateItem operation using the
ReturnValues parameter.

# Arguments
- `key`: The primary key of the item to be updated. Each element consists of an attribute
  name and a value for that attribute. For the primary key, you must provide all of the
  attributes. For example, with a simple primary key, you only need to provide a value for
  the partition key. For a composite primary key, you must provide values for both the
  partition key and the sort key.
- `table_name`: The name of the table containing the item to update. You can also provide
  the Amazon Resource Name (ARN) of the table in this parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AttributeUpdates"`: This is a legacy parameter. Use UpdateExpression instead. For more
  information, see AttributeUpdates in the Amazon DynamoDB Developer Guide.
- `"ConditionExpression"`: A condition that must be satisfied in order for a conditional
  update to succeed. An expression can contain any of the following:   Functions:
  attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size
  These function names are case-sensitive.   Comparison operators: = | &lt;&gt; | &lt; | &gt;
  | &lt;= | &gt;= | BETWEEN | IN      Logical operators: AND | OR | NOT    For more
  information about condition expressions, see Specifying Conditions in the Amazon DynamoDB
  Developer Guide.
- `"ConditionalOperator"`: This is a legacy parameter. Use ConditionExpression instead. For
  more information, see ConditionalOperator in the Amazon DynamoDB Developer Guide.
- `"Expected"`: This is a legacy parameter. Use ConditionExpression instead. For more
  information, see Expected in the Amazon DynamoDB Developer Guide.
- `"ExpressionAttributeNames"`: One or more substitution tokens for attribute names in an
  expression. The following are some use cases for using ExpressionAttributeNames:   To
  access an attribute whose name conflicts with a DynamoDB reserved word.   To create a
  placeholder for repeating occurrences of an attribute name in an expression.   To prevent
  special characters in an attribute name from being misinterpreted in an expression.   Use
  the # character in an expression to dereference an attribute name. For example, consider
  the following attribute name:    Percentile    The name of this attribute conflicts with a
  reserved word, so it cannot be used directly in an expression. (For the complete list of
  reserved words, see Reserved Words in the Amazon DynamoDB Developer Guide.) To work around
  this, you could specify the following for ExpressionAttributeNames:
  {\"#P\":\"Percentile\"}    You could then use this substitution in an expression, as in
  this example:    #P = :val     Tokens that begin with the : character are expression
  attribute values, which are placeholders for the actual value at runtime.  For more
  information about expression attribute names, see Specifying Item Attributes in the Amazon
  DynamoDB Developer Guide.
- `"ExpressionAttributeValues"`: One or more values that can be substituted in an
  expression. Use the : (colon) character in an expression to dereference an attribute value.
  For example, suppose that you wanted to check whether the value of the ProductStatus
  attribute was one of the following:   Available | Backordered | Discontinued  You would
  first need to specify ExpressionAttributeValues as follows:  {
  \":avail\":{\"S\":\"Available\"}, \":back\":{\"S\":\"Backordered\"},
  \":disc\":{\"S\":\"Discontinued\"} }  You could then use these values in an expression,
  such as this:  ProductStatus IN (:avail, :back, :disc)  For more information on expression
  attribute values, see Condition Expressions in the Amazon DynamoDB Developer Guide.
- `"ReturnConsumedCapacity"`:
- `"ReturnItemCollectionMetrics"`: Determines whether item collection metrics are returned.
  If set to SIZE, the response includes statistics about item collections, if any, that were
  modified during the operation are returned in the response. If set to NONE (the default),
  no statistics are returned.
- `"ReturnValues"`: Use ReturnValues if you want to get the item attributes as they appear
  before or after they are successfully updated. For UpdateItem, the valid values are:
  NONE - If ReturnValues is not specified, or if its value is NONE, then nothing is returned.
  (This setting is the default for ReturnValues.)    ALL_OLD - Returns all of the attributes
  of the item, as they appeared before the UpdateItem operation.    UPDATED_OLD - Returns
  only the updated attributes, as they appeared before the UpdateItem operation.    ALL_NEW -
  Returns all of the attributes of the item, as they appear after the UpdateItem operation.
   UPDATED_NEW - Returns only the updated attributes, as they appear after the UpdateItem
  operation.   There is no additional cost associated with requesting a return value aside
  from the small network and processing overhead of receiving a larger response. No read
  capacity units are consumed. The values returned are strongly consistent.
- `"ReturnValuesOnConditionCheckFailure"`: An optional parameter that returns the item
  attributes for an UpdateItem operation that failed a condition check. There is no
  additional cost associated with requesting a return value aside from the small network and
  processing overhead of receiving a larger response. No read capacity units are consumed.
- `"UpdateExpression"`: An expression that defines one or more attributes to be updated,
  the action to be performed on them, and new values for them. The following action values
  are available for UpdateExpression.    SET - Adds one or more attributes and values to an
  item. If any of these attributes already exist, they are replaced by the new values. You
  can also use SET to add or subtract from an attribute that is of type Number. For example:
  SET myNum = myNum + :val   SET supports the following functions:    if_not_exists (path,
  operand) - if the item does not contain an attribute at the specified path, then
  if_not_exists evaluates to operand; otherwise, it evaluates to path. You can use this
  function to avoid overwriting an attribute that may already be present in the item.
  list_append (operand, operand) - evaluates to a list with a new element added to it. You
  can append the new element to the start or the end of the list by reversing the order of
  the operands.   These function names are case-sensitive.    REMOVE - Removes one or more
  attributes from an item.    ADD - Adds the specified value to the item, if the attribute
  does not already exist. If the attribute does exist, then the behavior of ADD depends on
  the data type of the attribute:   If the existing attribute is a number, and if Value is
  also a number, then Value is mathematically added to the existing attribute. If Value is a
  negative number, then it is subtracted from the existing attribute.  If you use ADD to
  increment or decrement a number value for an item that doesn't exist before the update,
  DynamoDB uses 0 as the initial value. Similarly, if you use ADD for an existing item to
  increment or decrement an attribute value that doesn't exist before the update, DynamoDB
  uses 0 as the initial value. For example, suppose that the item you want to update doesn't
  have an attribute named itemcount, but you decide to ADD the number 3 to this attribute
  anyway. DynamoDB will create the itemcount attribute, set its initial value to 0, and
  finally add 3 to it. The result will be a new itemcount attribute in the item, with a value
  of 3.    If the existing data type is a set and if Value is also a set, then Value is added
  to the existing set. For example, if the attribute value is the set [1,2], and the ADD
  action specified [3], then the final attribute value is [1,2,3]. An error occurs if an ADD
  action is specified for a set attribute and the attribute type specified does not match the
  existing set type.  Both sets must have the same primitive data type. For example, if the
  existing data type is a set of strings, the Value must also be a set of strings.    The ADD
  action only supports Number and set data types. In addition, ADD can only be used on
  top-level attributes, not nested attributes.     DELETE - Deletes an element from a set. If
  a set of values is specified, then those values are subtracted from the old set. For
  example, if the attribute value was the set [a,b,c] and the DELETE action specifies [a,c],
  then the final attribute value is [b]. Specifying an empty set is an error.  The DELETE
  action only supports set data types. In addition, DELETE can only be used on top-level
  attributes, not nested attributes.    You can have many actions in a single expression,
  such as the following: SET a=:value1, b=:value2 DELETE :value3, :value4, :value5  For more
  information on update expressions, see Modifying Items and Attributes in the Amazon
  DynamoDB Developer Guide.
"""
function update_item(Key, TableName; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb(
        "UpdateItem",
        Dict{String,Any}("Key" => Key, "TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_item(
    Key,
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "UpdateItem",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Key" => Key, "TableName" => TableName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_kinesis_streaming_destination(stream_arn, table_name)
    update_kinesis_streaming_destination(stream_arn, table_name, params::Dict{String,<:Any})

The command to update the Kinesis stream destination.

# Arguments
- `stream_arn`: The Amazon Resource Name (ARN) for the Kinesis stream input.
- `table_name`: The table name for the Kinesis streaming destination input. You can also
  provide the ARN of the table in this parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"UpdateKinesisStreamingConfiguration"`: The command to update the Kinesis stream
  configuration.
"""
function update_kinesis_streaming_destination(
    StreamArn, TableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "UpdateKinesisStreamingDestination",
        Dict{String,Any}("StreamArn" => StreamArn, "TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_kinesis_streaming_destination(
    StreamArn,
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "UpdateKinesisStreamingDestination",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("StreamArn" => StreamArn, "TableName" => TableName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_table(table_name)
    update_table(table_name, params::Dict{String,<:Any})

Modifies the provisioned throughput settings, global secondary indexes, or DynamoDB Streams
settings for a given table.  For global tables, this operation only applies to global
tables using Version 2019.11.21 (Current version).   You can only perform one of the
following operations at once:   Modify the provisioned throughput settings of the table.
Remove a global secondary index from the table.   Create a new global secondary index on
the table. After the index begins backfilling, you can use UpdateTable to perform other
operations.    UpdateTable is an asynchronous operation; while it's executing, the table
status changes from ACTIVE to UPDATING. While it's UPDATING, you can't issue another
UpdateTable request. When the table returns to the ACTIVE state, the UpdateTable operation
is complete.

# Arguments
- `table_name`: The name of the table to be updated. You can also provide the Amazon
  Resource Name (ARN) of the table in this parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AttributeDefinitions"`: An array of attributes that describe the key schema for the
  table and indexes. If you are adding a new global secondary index to the table,
  AttributeDefinitions must include the key element(s) of the new index.
- `"BillingMode"`: Controls how you are charged for read and write throughput and how you
  manage capacity. When switching from pay-per-request to provisioned capacity, initial
  provisioned capacity values must be set. The initial provisioned capacity values are
  estimated based on the consumed read and write capacity of your table and global secondary
  indexes over the past 30 minutes.    PROVISIONED - We recommend using PROVISIONED for
  predictable workloads. PROVISIONED sets the billing mode to Provisioned capacity mode.
  PAY_PER_REQUEST - We recommend using PAY_PER_REQUEST for unpredictable workloads.
  PAY_PER_REQUEST sets the billing mode to On-demand capacity mode.
- `"DeletionProtectionEnabled"`: Indicates whether deletion protection is to be enabled
  (true) or disabled (false) on the table.
- `"GlobalSecondaryIndexUpdates"`: An array of one or more global secondary indexes for the
  table. For each index in the array, you can request one action:    Create - add a new
  global secondary index to the table.    Update - modify the provisioned throughput settings
  of an existing global secondary index.    Delete - remove a global secondary index from the
  table.   You can create or delete only one global secondary index per UpdateTable
  operation. For more information, see Managing Global Secondary Indexes in the Amazon
  DynamoDB Developer Guide.
- `"OnDemandThroughput"`: Updates the maximum number of read and write units for the
  specified table in on-demand capacity mode. If you use this parameter, you must specify
  MaxReadRequestUnits, MaxWriteRequestUnits, or both.
- `"ProvisionedThroughput"`: The new provisioned throughput settings for the specified
  table or index.
- `"ReplicaUpdates"`: A list of replica update actions (create, delete, or update) for the
  table.  For global tables, this property only applies to global tables using Version
  2019.11.21 (Current version).
- `"SSESpecification"`: The new server-side encryption settings for the specified table.
- `"StreamSpecification"`: Represents the DynamoDB Streams configuration for the table.
  You receive a ValidationException if you try to enable a stream on a table that already has
  a stream, or if you try to disable a stream on a table that doesn't have a stream.
- `"TableClass"`: The table class of the table to be updated. Valid values are STANDARD and
  STANDARD_INFREQUENT_ACCESS.
"""
function update_table(TableName; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb(
        "UpdateTable",
        Dict{String,Any}("TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_table(
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "UpdateTable",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TableName" => TableName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_table_replica_auto_scaling(table_name)
    update_table_replica_auto_scaling(table_name, params::Dict{String,<:Any})

Updates auto scaling settings on your global tables at once.  For global tables, this
operation only applies to global tables using Version 2019.11.21 (Current version).

# Arguments
- `table_name`: The name of the global table to be updated. You can also provide the Amazon
  Resource Name (ARN) of the table in this parameter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"GlobalSecondaryIndexUpdates"`: Represents the auto scaling settings of the global
  secondary indexes of the replica to be updated.
- `"ProvisionedWriteCapacityAutoScalingUpdate"`:
- `"ReplicaUpdates"`: Represents the auto scaling settings of replicas of the table that
  will be modified.
"""
function update_table_replica_auto_scaling(
    TableName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "UpdateTableReplicaAutoScaling",
        Dict{String,Any}("TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_table_replica_auto_scaling(
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "UpdateTableReplicaAutoScaling",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TableName" => TableName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_time_to_live(table_name, time_to_live_specification)
    update_time_to_live(table_name, time_to_live_specification, params::Dict{String,<:Any})

The UpdateTimeToLive method enables or disables Time to Live (TTL) for the specified table.
A successful UpdateTimeToLive call returns the current TimeToLiveSpecification. It can take
up to one hour for the change to fully process. Any additional UpdateTimeToLive calls for
the same table during this one hour duration result in a ValidationException.  TTL compares
the current time in epoch time format to the time stored in the TTL attribute of an item.
If the epoch time value stored in the attribute is less than the current time, the item is
marked as expired and subsequently deleted.   The epoch time format is the number of
seconds elapsed since 12:00:00 AM January 1, 1970 UTC.   DynamoDB deletes expired items on
a best-effort basis to ensure availability of throughput for other data operations.
DynamoDB typically deletes expired items within two days of expiration. The exact duration
within which an item gets deleted after expiration is specific to the nature of the
workload. Items that have expired and not been deleted will still show up in reads,
queries, and scans.  As items are deleted, they are removed from any local secondary index
and global secondary index immediately in the same eventually consistent way as a standard
delete operation. For more information, see Time To Live in the Amazon DynamoDB Developer
Guide.

# Arguments
- `table_name`: The name of the table to be configured. You can also provide the Amazon
  Resource Name (ARN) of the table in this parameter.
- `time_to_live_specification`: Represents the settings used to enable or disable Time to
  Live for the specified table.

"""
function update_time_to_live(
    TableName, TimeToLiveSpecification; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb(
        "UpdateTimeToLive",
        Dict{String,Any}(
            "TableName" => TableName, "TimeToLiveSpecification" => TimeToLiveSpecification
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_time_to_live(
    TableName,
    TimeToLiveSpecification,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb(
        "UpdateTimeToLive",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TableName" => TableName,
                    "TimeToLiveSpecification" => TimeToLiveSpecification,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
