# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: fms
using AWS.Compat
using AWS.UUIDs

"""
    associate_admin_account(admin_account)
    associate_admin_account(admin_account, params::Dict{String,<:Any})

Sets a Firewall Manager default administrator account. The Firewall Manager default
administrator account can manage third-party firewalls and has full administrative scope
that allows administration of all policy types, accounts, organizational units, and
Regions. This account must be a member account of the organization in Organizations whose
resources you want to protect. For information about working with Firewall Manager
administrator accounts, see Managing Firewall Manager administrators in the Firewall
Manager Developer Guide.

# Arguments
- `admin_account`: The Amazon Web Services account ID to associate with Firewall Manager as
  the Firewall Manager default administrator account. This account must be a member account
  of the organization in Organizations whose resources you want to protect. For more
  information about Organizations, see Managing the Amazon Web Services Accounts in Your
  Organization.

"""
function associate_admin_account(
    AdminAccount; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "AssociateAdminAccount",
        Dict{String,Any}("AdminAccount" => AdminAccount);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_admin_account(
    AdminAccount,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "AssociateAdminAccount",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AdminAccount" => AdminAccount), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_third_party_firewall(third_party_firewall)
    associate_third_party_firewall(third_party_firewall, params::Dict{String,<:Any})

Sets the Firewall Manager policy administrator as a tenant administrator of a third-party
firewall service. A tenant is an instance of the third-party firewall service that's
associated with your Amazon Web Services customer account.

# Arguments
- `third_party_firewall`: The name of the third-party firewall vendor.

"""
function associate_third_party_firewall(
    ThirdPartyFirewall; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "AssociateThirdPartyFirewall",
        Dict{String,Any}("ThirdPartyFirewall" => ThirdPartyFirewall);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_third_party_firewall(
    ThirdPartyFirewall,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "AssociateThirdPartyFirewall",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ThirdPartyFirewall" => ThirdPartyFirewall), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_associate_resource(items, resource_set_identifier)
    batch_associate_resource(items, resource_set_identifier, params::Dict{String,<:Any})

Associate resources to a Firewall Manager resource set.

# Arguments
- `items`: The uniform resource identifiers (URIs) of resources that should be associated
  to the resource set. The URIs must be Amazon Resource Names (ARNs).
- `resource_set_identifier`: A unique identifier for the resource set, used in a request to
  refer to the resource set.

"""
function batch_associate_resource(
    Items, ResourceSetIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "BatchAssociateResource",
        Dict{String,Any}(
            "Items" => Items, "ResourceSetIdentifier" => ResourceSetIdentifier
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_associate_resource(
    Items,
    ResourceSetIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "BatchAssociateResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Items" => Items, "ResourceSetIdentifier" => ResourceSetIdentifier
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_disassociate_resource(items, resource_set_identifier)
    batch_disassociate_resource(items, resource_set_identifier, params::Dict{String,<:Any})

Disassociates resources from a Firewall Manager resource set.

# Arguments
- `items`: The uniform resource identifiers (URI) of resources that should be disassociated
  from the resource set. The URIs must be Amazon Resource Names (ARNs).
- `resource_set_identifier`: A unique identifier for the resource set, used in a request to
  refer to the resource set.

"""
function batch_disassociate_resource(
    Items, ResourceSetIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "BatchDisassociateResource",
        Dict{String,Any}(
            "Items" => Items, "ResourceSetIdentifier" => ResourceSetIdentifier
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_disassociate_resource(
    Items,
    ResourceSetIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "BatchDisassociateResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Items" => Items, "ResourceSetIdentifier" => ResourceSetIdentifier
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_apps_list(list_id)
    delete_apps_list(list_id, params::Dict{String,<:Any})

Permanently deletes an Firewall Manager applications list.

# Arguments
- `list_id`: The ID of the applications list that you want to delete. You can retrieve this
  ID from PutAppsList, ListAppsLists, and GetAppsList.

"""
function delete_apps_list(ListId; aws_config::AbstractAWSConfig=current_aws_config())
    return fms(
        "DeleteAppsList",
        Dict{String,Any}("ListId" => ListId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_apps_list(
    ListId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "DeleteAppsList",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("ListId" => ListId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_notification_channel()
    delete_notification_channel(params::Dict{String,<:Any})

Deletes an Firewall Manager association with the IAM role and the Amazon Simple
Notification Service (SNS) topic that is used to record Firewall Manager SNS logs.

"""
function delete_notification_channel(; aws_config::AbstractAWSConfig=current_aws_config())
    return fms(
        "DeleteNotificationChannel"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function delete_notification_channel(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "DeleteNotificationChannel",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_policy(policy_id)
    delete_policy(policy_id, params::Dict{String,<:Any})

Permanently deletes an Firewall Manager policy.

# Arguments
- `policy_id`: The ID of the policy that you want to delete. You can retrieve this ID from
  PutPolicy and ListPolicies.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeleteAllPolicyResources"`: If True, the request performs cleanup according to the
  policy type.  For WAF and Shield Advanced policies, the cleanup does the following:
  Deletes rule groups created by Firewall Manager   Removes web ACLs from in-scope resources
   Deletes web ACLs that contain no rules or rule groups   For security group policies, the
  cleanup does the following for each security group in the policy:   Disassociates the
  security group from in-scope resources    Deletes the security group if it was created
  through Firewall Manager and if it's no longer associated with any resources through
  another policy    For security group common policies, even if set to False, Firewall
  Manager deletes all security groups created by Firewall Manager that aren't associated with
  any other resources through another policy.  After the cleanup, in-scope resources are no
  longer protected by web ACLs in this policy. Protection of out-of-scope resources remains
  unchanged. Scope is determined by tags that you create and accounts that you associate with
  the policy. When creating the policy, if you specify that only resources in specific
  accounts or with specific tags are in scope of the policy, those accounts and resources are
  handled by the policy. All others are out of scope. If you don't specify tags or accounts,
  all resources are in scope.
"""
function delete_policy(PolicyId; aws_config::AbstractAWSConfig=current_aws_config())
    return fms(
        "DeletePolicy",
        Dict{String,Any}("PolicyId" => PolicyId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_policy(
    PolicyId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "DeletePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PolicyId" => PolicyId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_protocols_list(list_id)
    delete_protocols_list(list_id, params::Dict{String,<:Any})

Permanently deletes an Firewall Manager protocols list.

# Arguments
- `list_id`: The ID of the protocols list that you want to delete. You can retrieve this ID
  from PutProtocolsList, ListProtocolsLists, and GetProtocolsLost.

"""
function delete_protocols_list(ListId; aws_config::AbstractAWSConfig=current_aws_config())
    return fms(
        "DeleteProtocolsList",
        Dict{String,Any}("ListId" => ListId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_protocols_list(
    ListId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "DeleteProtocolsList",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("ListId" => ListId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_resource_set(identifier)
    delete_resource_set(identifier, params::Dict{String,<:Any})

Deletes the specified ResourceSet.

# Arguments
- `identifier`: A unique identifier for the resource set, used in a request to refer to the
  resource set.

"""
function delete_resource_set(Identifier; aws_config::AbstractAWSConfig=current_aws_config())
    return fms(
        "DeleteResourceSet",
        Dict{String,Any}("Identifier" => Identifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_resource_set(
    Identifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "DeleteResourceSet",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Identifier" => Identifier), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_admin_account()
    disassociate_admin_account(params::Dict{String,<:Any})

Disassociates an Firewall Manager administrator account. To set a different account as an
Firewall Manager administrator, submit a PutAdminAccount request. To set an account as a
default administrator account, you must submit an AssociateAdminAccount request.
Disassociation of the default administrator account follows the first in, last out
principle. If you are the default administrator, all Firewall Manager administrators within
the organization must first disassociate their accounts before you can disassociate your
account.

"""
function disassociate_admin_account(; aws_config::AbstractAWSConfig=current_aws_config())
    return fms(
        "DisassociateAdminAccount"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function disassociate_admin_account(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "DisassociateAdminAccount",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_third_party_firewall(third_party_firewall)
    disassociate_third_party_firewall(third_party_firewall, params::Dict{String,<:Any})

Disassociates a Firewall Manager policy administrator from a third-party firewall tenant.
When you call DisassociateThirdPartyFirewall, the third-party firewall vendor deletes all
of the firewalls that are associated with the account.

# Arguments
- `third_party_firewall`: The name of the third-party firewall vendor.

"""
function disassociate_third_party_firewall(
    ThirdPartyFirewall; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "DisassociateThirdPartyFirewall",
        Dict{String,Any}("ThirdPartyFirewall" => ThirdPartyFirewall);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_third_party_firewall(
    ThirdPartyFirewall,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "DisassociateThirdPartyFirewall",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ThirdPartyFirewall" => ThirdPartyFirewall), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_admin_account()
    get_admin_account(params::Dict{String,<:Any})

Returns the Organizations account that is associated with Firewall Manager as the Firewall
Manager default administrator.

"""
function get_admin_account(; aws_config::AbstractAWSConfig=current_aws_config())
    return fms("GetAdminAccount"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_admin_account(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "GetAdminAccount", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_admin_scope(admin_account)
    get_admin_scope(admin_account, params::Dict{String,<:Any})

Returns information about the specified account's administrative scope. The administrative
scope defines the resources that an Firewall Manager administrator can manage.

# Arguments
- `admin_account`: The administrator account that you want to get the details for.

"""
function get_admin_scope(AdminAccount; aws_config::AbstractAWSConfig=current_aws_config())
    return fms(
        "GetAdminScope",
        Dict{String,Any}("AdminAccount" => AdminAccount);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_admin_scope(
    AdminAccount,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "GetAdminScope",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AdminAccount" => AdminAccount), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_apps_list(list_id)
    get_apps_list(list_id, params::Dict{String,<:Any})

Returns information about the specified Firewall Manager applications list.

# Arguments
- `list_id`: The ID of the Firewall Manager applications list that you want the details for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DefaultList"`: Specifies whether the list to retrieve is a default list owned by
  Firewall Manager.
"""
function get_apps_list(ListId; aws_config::AbstractAWSConfig=current_aws_config())
    return fms(
        "GetAppsList",
        Dict{String,Any}("ListId" => ListId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_apps_list(
    ListId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "GetAppsList",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("ListId" => ListId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_compliance_detail(member_account, policy_id)
    get_compliance_detail(member_account, policy_id, params::Dict{String,<:Any})

Returns detailed compliance information about the specified member account. Details include
resources that are in and out of compliance with the specified policy.  The reasons for
resources being considered compliant depend on the Firewall Manager policy type.

# Arguments
- `member_account`: The Amazon Web Services account that owns the resources that you want
  to get the details for.
- `policy_id`: The ID of the policy that you want to get the details for. PolicyId is
  returned by PutPolicy and by ListPolicies.

"""
function get_compliance_detail(
    MemberAccount, PolicyId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "GetComplianceDetail",
        Dict{String,Any}("MemberAccount" => MemberAccount, "PolicyId" => PolicyId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_compliance_detail(
    MemberAccount,
    PolicyId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "GetComplianceDetail",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("MemberAccount" => MemberAccount, "PolicyId" => PolicyId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_notification_channel()
    get_notification_channel(params::Dict{String,<:Any})

Information about the Amazon Simple Notification Service (SNS) topic that is used to record
Firewall Manager SNS logs.

"""
function get_notification_channel(; aws_config::AbstractAWSConfig=current_aws_config())
    return fms(
        "GetNotificationChannel"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_notification_channel(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "GetNotificationChannel",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_policy(policy_id)
    get_policy(policy_id, params::Dict{String,<:Any})

Returns information about the specified Firewall Manager policy.

# Arguments
- `policy_id`: The ID of the Firewall Manager policy that you want the details for.

"""
function get_policy(PolicyId; aws_config::AbstractAWSConfig=current_aws_config())
    return fms(
        "GetPolicy",
        Dict{String,Any}("PolicyId" => PolicyId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_policy(
    PolicyId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "GetPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PolicyId" => PolicyId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_protection_status(policy_id)
    get_protection_status(policy_id, params::Dict{String,<:Any})

If you created a Shield Advanced policy, returns policy-level attack summary information in
the event of a potential DDoS attack. Other policy types are currently unsupported.

# Arguments
- `policy_id`: The ID of the policy for which you want to get the attack information.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EndTime"`: The end of the time period to query for the attacks. This is a timestamp
  type. The request syntax listing indicates a number type because the default used by
  Firewall Manager is Unix time in seconds. However, any valid timestamp format is allowed.
- `"MaxResults"`: Specifies the number of objects that you want Firewall Manager to return
  for this request. If you have more objects than the number that you specify for MaxResults,
  the response includes a NextToken value that you can use to get another batch of objects.
- `"MemberAccountId"`: The Amazon Web Services account that is in scope of the policy that
  you want to get the details for.
- `"NextToken"`: If you specify a value for MaxResults and you have more objects than the
  number that you specify for MaxResults, Firewall Manager returns a NextToken value in the
  response, which you can use to retrieve another group of objects. For the second and
  subsequent GetProtectionStatus requests, specify the value of NextToken from the previous
  response to get information about another batch of objects.
- `"StartTime"`: The start of the time period to query for the attacks. This is a timestamp
  type. The request syntax listing indicates a number type because the default used by
  Firewall Manager is Unix time in seconds. However, any valid timestamp format is allowed.
"""
function get_protection_status(PolicyId; aws_config::AbstractAWSConfig=current_aws_config())
    return fms(
        "GetProtectionStatus",
        Dict{String,Any}("PolicyId" => PolicyId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_protection_status(
    PolicyId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "GetProtectionStatus",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PolicyId" => PolicyId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_protocols_list(list_id)
    get_protocols_list(list_id, params::Dict{String,<:Any})

Returns information about the specified Firewall Manager protocols list.

# Arguments
- `list_id`: The ID of the Firewall Manager protocols list that you want the details for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DefaultList"`: Specifies whether the list to retrieve is a default list owned by
  Firewall Manager.
"""
function get_protocols_list(ListId; aws_config::AbstractAWSConfig=current_aws_config())
    return fms(
        "GetProtocolsList",
        Dict{String,Any}("ListId" => ListId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_protocols_list(
    ListId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "GetProtocolsList",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("ListId" => ListId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resource_set(identifier)
    get_resource_set(identifier, params::Dict{String,<:Any})

Gets information about a specific resource set.

# Arguments
- `identifier`: A unique identifier for the resource set, used in a request to refer to the
  resource set.

"""
function get_resource_set(Identifier; aws_config::AbstractAWSConfig=current_aws_config())
    return fms(
        "GetResourceSet",
        Dict{String,Any}("Identifier" => Identifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resource_set(
    Identifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "GetResourceSet",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Identifier" => Identifier), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_third_party_firewall_association_status(third_party_firewall)
    get_third_party_firewall_association_status(third_party_firewall, params::Dict{String,<:Any})

The onboarding status of a Firewall Manager admin account to third-party firewall vendor
tenant.

# Arguments
- `third_party_firewall`: The name of the third-party firewall vendor.

"""
function get_third_party_firewall_association_status(
    ThirdPartyFirewall; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "GetThirdPartyFirewallAssociationStatus",
        Dict{String,Any}("ThirdPartyFirewall" => ThirdPartyFirewall);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_third_party_firewall_association_status(
    ThirdPartyFirewall,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "GetThirdPartyFirewallAssociationStatus",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ThirdPartyFirewall" => ThirdPartyFirewall), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_violation_details(member_account, policy_id, resource_id, resource_type)
    get_violation_details(member_account, policy_id, resource_id, resource_type, params::Dict{String,<:Any})

Retrieves violations for a resource based on the specified Firewall Manager policy and
Amazon Web Services account.

# Arguments
- `member_account`: The Amazon Web Services account ID that you want the details for.
- `policy_id`: The ID of the Firewall Manager policy that you want the details for. You can
  get violation details for the following policy types:   DNS Firewall   Imported Network
  Firewall   Network Firewall   Security group content audit   Network ACL   Third-party
  firewall
- `resource_id`: The ID of the resource that has violations.
- `resource_type`: The resource type. This is in the format shown in the Amazon Web
  Services Resource Types Reference. Supported resource types are: AWS::EC2::Instance,
  AWS::EC2::NetworkInterface, AWS::EC2::SecurityGroup, AWS::NetworkFirewall::FirewallPolicy,
  and AWS::EC2::Subnet.

"""
function get_violation_details(
    MemberAccount,
    PolicyId,
    ResourceId,
    ResourceType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "GetViolationDetails",
        Dict{String,Any}(
            "MemberAccount" => MemberAccount,
            "PolicyId" => PolicyId,
            "ResourceId" => ResourceId,
            "ResourceType" => ResourceType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_violation_details(
    MemberAccount,
    PolicyId,
    ResourceId,
    ResourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "GetViolationDetails",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "MemberAccount" => MemberAccount,
                    "PolicyId" => PolicyId,
                    "ResourceId" => ResourceId,
                    "ResourceType" => ResourceType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_admin_accounts_for_organization()
    list_admin_accounts_for_organization(params::Dict{String,<:Any})

Returns a AdminAccounts object that lists the Firewall Manager administrators within the
organization that are onboarded to Firewall Manager by AssociateAdminAccount. This
operation can be called only from the organization's management account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of objects that you want Firewall Manager to return
  for this request. If more objects are available, in the response, Firewall Manager provides
  a NextToken value that you can use in a subsequent call to get the next batch of objects.
- `"NextToken"`: When you request a list of objects with a MaxResults setting, if the
  number of objects that are still available for retrieval exceeds the maximum you requested,
  Firewall Manager returns a NextToken value in the response. To retrieve the next batch of
  objects, use the token returned from the prior request in your next request.
"""
function list_admin_accounts_for_organization(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "ListAdminAccountsForOrganization";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_admin_accounts_for_organization(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "ListAdminAccountsForOrganization",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_admins_managing_account()
    list_admins_managing_account(params::Dict{String,<:Any})

Lists the accounts that are managing the specified Organizations member account. This is
useful for any member account so that they can view the accounts who are managing their
account. This operation only returns the managing administrators that have the requested
account within their AdminScope.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of objects that you want Firewall Manager to return
  for this request. If more objects are available, in the response, Firewall Manager provides
  a NextToken value that you can use in a subsequent call to get the next batch of objects.
- `"NextToken"`: When you request a list of objects with a MaxResults setting, if the
  number of objects that are still available for retrieval exceeds the maximum you requested,
  Firewall Manager returns a NextToken value in the response. To retrieve the next batch of
  objects, use the token returned from the prior request in your next request.
"""
function list_admins_managing_account(; aws_config::AbstractAWSConfig=current_aws_config())
    return fms(
        "ListAdminsManagingAccount"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_admins_managing_account(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "ListAdminsManagingAccount",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_apps_lists(max_results)
    list_apps_lists(max_results, params::Dict{String,<:Any})

Returns an array of AppsListDataSummary objects.

# Arguments
- `max_results`: The maximum number of objects that you want Firewall Manager to return for
  this request. If more objects are available, in the response, Firewall Manager provides a
  NextToken value that you can use in a subsequent call to get the next batch of objects. If
  you don't specify this, Firewall Manager returns all available objects.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DefaultLists"`: Specifies whether the lists to retrieve are default lists owned by
  Firewall Manager.
- `"NextToken"`: If you specify a value for MaxResults in your list request, and you have
  more objects than the maximum, Firewall Manager returns this token in the response. For all
  but the first request, you provide the token returned by the prior request in the request
  parameters, to retrieve the next batch of objects.
"""
function list_apps_lists(MaxResults; aws_config::AbstractAWSConfig=current_aws_config())
    return fms(
        "ListAppsLists",
        Dict{String,Any}("MaxResults" => MaxResults);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_apps_lists(
    MaxResults,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "ListAppsLists",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("MaxResults" => MaxResults), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_compliance_status(policy_id)
    list_compliance_status(policy_id, params::Dict{String,<:Any})

Returns an array of PolicyComplianceStatus objects. Use PolicyComplianceStatus to get a
summary of which member accounts are protected by the specified policy.

# Arguments
- `policy_id`: The ID of the Firewall Manager policy that you want the details for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Specifies the number of PolicyComplianceStatus objects that you want
  Firewall Manager to return for this request. If you have more PolicyComplianceStatus
  objects than the number that you specify for MaxResults, the response includes a NextToken
  value that you can use to get another batch of PolicyComplianceStatus objects.
- `"NextToken"`: If you specify a value for MaxResults and you have more
  PolicyComplianceStatus objects than the number that you specify for MaxResults, Firewall
  Manager returns a NextToken value in the response that allows you to list another group of
  PolicyComplianceStatus objects. For the second and subsequent ListComplianceStatus
  requests, specify the value of NextToken from the previous response to get information
  about another batch of PolicyComplianceStatus objects.
"""
function list_compliance_status(
    PolicyId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "ListComplianceStatus",
        Dict{String,Any}("PolicyId" => PolicyId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_compliance_status(
    PolicyId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "ListComplianceStatus",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PolicyId" => PolicyId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_discovered_resources(member_account_ids, resource_type)
    list_discovered_resources(member_account_ids, resource_type, params::Dict{String,<:Any})

Returns an array of resources in the organization's accounts that are available to be
associated with a resource set.

# Arguments
- `member_account_ids`: The Amazon Web Services account IDs to discover resources in. Only
  one account is supported per request. The account must be a member of your organization.
- `resource_type`: The type of resources to discover.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of objects that you want Firewall Manager to return
  for this request. If more objects are available, in the response, Firewall Manager provides
  a NextToken value that you can use in a subsequent call to get the next batch of objects.
- `"NextToken"`: When you request a list of objects with a MaxResults setting, if the
  number of objects that are still available for retrieval exceeds the maximum you requested,
  Firewall Manager returns a NextToken value in the response. To retrieve the next batch of
  objects, use the token returned from the prior request in your next request.
"""
function list_discovered_resources(
    MemberAccountIds, ResourceType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "ListDiscoveredResources",
        Dict{String,Any}(
            "MemberAccountIds" => MemberAccountIds, "ResourceType" => ResourceType
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_discovered_resources(
    MemberAccountIds,
    ResourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "ListDiscoveredResources",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "MemberAccountIds" => MemberAccountIds, "ResourceType" => ResourceType
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_member_accounts()
    list_member_accounts(params::Dict{String,<:Any})

Returns a MemberAccounts object that lists the member accounts in the administrator's
Amazon Web Services organization. Either an Firewall Manager administrator or the
organization's management account can make this request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Specifies the number of member account IDs that you want Firewall Manager
  to return for this request. If you have more IDs than the number that you specify for
  MaxResults, the response includes a NextToken value that you can use to get another batch
  of member account IDs.
- `"NextToken"`: If you specify a value for MaxResults and you have more account IDs than
  the number that you specify for MaxResults, Firewall Manager returns a NextToken value in
  the response that allows you to list another group of IDs. For the second and subsequent
  ListMemberAccountsRequest requests, specify the value of NextToken from the previous
  response to get information about another batch of member account IDs.
"""
function list_member_accounts(; aws_config::AbstractAWSConfig=current_aws_config())
    return fms("ListMemberAccounts"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_member_accounts(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "ListMemberAccounts", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_policies()
    list_policies(params::Dict{String,<:Any})

Returns an array of PolicySummary objects.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Specifies the number of PolicySummary objects that you want Firewall
  Manager to return for this request. If you have more PolicySummary objects than the number
  that you specify for MaxResults, the response includes a NextToken value that you can use
  to get another batch of PolicySummary objects.
- `"NextToken"`: If you specify a value for MaxResults and you have more PolicySummary
  objects than the number that you specify for MaxResults, Firewall Manager returns a
  NextToken value in the response that allows you to list another group of PolicySummary
  objects. For the second and subsequent ListPolicies requests, specify the value of
  NextToken from the previous response to get information about another batch of
  PolicySummary objects.
"""
function list_policies(; aws_config::AbstractAWSConfig=current_aws_config())
    return fms("ListPolicies"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_policies(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "ListPolicies", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_protocols_lists(max_results)
    list_protocols_lists(max_results, params::Dict{String,<:Any})

Returns an array of ProtocolsListDataSummary objects.

# Arguments
- `max_results`: The maximum number of objects that you want Firewall Manager to return for
  this request. If more objects are available, in the response, Firewall Manager provides a
  NextToken value that you can use in a subsequent call to get the next batch of objects. If
  you don't specify this, Firewall Manager returns all available objects.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DefaultLists"`: Specifies whether the lists to retrieve are default lists owned by
  Firewall Manager.
- `"NextToken"`: If you specify a value for MaxResults in your list request, and you have
  more objects than the maximum, Firewall Manager returns this token in the response. For all
  but the first request, you provide the token returned by the prior request in the request
  parameters, to retrieve the next batch of objects.
"""
function list_protocols_lists(
    MaxResults; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "ListProtocolsLists",
        Dict{String,Any}("MaxResults" => MaxResults);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_protocols_lists(
    MaxResults,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "ListProtocolsLists",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("MaxResults" => MaxResults), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_resource_set_resources(identifier)
    list_resource_set_resources(identifier, params::Dict{String,<:Any})

Returns an array of resources that are currently associated to a resource set.

# Arguments
- `identifier`: A unique identifier for the resource set, used in a request to refer to the
  resource set.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of objects that you want Firewall Manager to return
  for this request. If more objects are available, in the response, Firewall Manager provides
  a NextToken value that you can use in a subsequent call to get the next batch of objects.
- `"NextToken"`: When you request a list of objects with a MaxResults setting, if the
  number of objects that are still available for retrieval exceeds the maximum you requested,
  Firewall Manager returns a NextToken value in the response. To retrieve the next batch of
  objects, use the token returned from the prior request in your next request.
"""
function list_resource_set_resources(
    Identifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "ListResourceSetResources",
        Dict{String,Any}("Identifier" => Identifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_resource_set_resources(
    Identifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "ListResourceSetResources",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Identifier" => Identifier), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_resource_sets()
    list_resource_sets(params::Dict{String,<:Any})

Returns an array of ResourceSetSummary objects.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of objects that you want Firewall Manager to return
  for this request. If more objects are available, in the response, Firewall Manager provides
  a NextToken value that you can use in a subsequent call to get the next batch of objects.
- `"NextToken"`: When you request a list of objects with a MaxResults setting, if the
  number of objects that are still available for retrieval exceeds the maximum you requested,
  Firewall Manager returns a NextToken value in the response. To retrieve the next batch of
  objects, use the token returned from the prior request in your next request.
"""
function list_resource_sets(; aws_config::AbstractAWSConfig=current_aws_config())
    return fms("ListResourceSets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_resource_sets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "ListResourceSets", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Retrieves the list of tags for the specified Amazon Web Services resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource to return tags for. The
  Firewall Manager resources that support tagging are policies, applications lists, and
  protocols lists.

"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "ListTagsForResource",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_third_party_firewall_firewall_policies(max_results, third_party_firewall)
    list_third_party_firewall_firewall_policies(max_results, third_party_firewall, params::Dict{String,<:Any})

Retrieves a list of all of the third-party firewall policies that are associated with the
third-party firewall administrator's account.

# Arguments
- `max_results`: The maximum number of third-party firewall policies that you want Firewall
  Manager to return. If the specified third-party firewall vendor is associated with more
  than MaxResults firewall policies, the response includes a NextToken element. NextToken
  contains an encrypted token that identifies the first third-party firewall policies that
  Firewall Manager will return if you submit another request.
- `third_party_firewall`: The name of the third-party firewall vendor.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: If the previous response included a NextToken element, the specified
  third-party firewall vendor is associated with more third-party firewall policies. To get
  more third-party firewall policies, submit another
  ListThirdPartyFirewallFirewallPoliciesRequest request.  For the value of NextToken, specify
  the value of NextToken from the previous response. If the previous response didn't include
  a NextToken element, there are no more third-party firewall policies to get.
"""
function list_third_party_firewall_firewall_policies(
    MaxResults, ThirdPartyFirewall; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "ListThirdPartyFirewallFirewallPolicies",
        Dict{String,Any}(
            "MaxResults" => MaxResults, "ThirdPartyFirewall" => ThirdPartyFirewall
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_third_party_firewall_firewall_policies(
    MaxResults,
    ThirdPartyFirewall,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "ListThirdPartyFirewallFirewallPolicies",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "MaxResults" => MaxResults, "ThirdPartyFirewall" => ThirdPartyFirewall
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_admin_account(admin_account)
    put_admin_account(admin_account, params::Dict{String,<:Any})

Creates or updates an Firewall Manager administrator account. The account must be a member
of the organization that was onboarded to Firewall Manager by AssociateAdminAccount. Only
the organization's management account can create an Firewall Manager administrator account.
When you create an Firewall Manager administrator account, the service checks to see if the
account is already a delegated administrator within Organizations. If the account isn't a
delegated administrator, Firewall Manager calls Organizations to delegate the account
within Organizations. For more information about administrator accounts within
Organizations, see Managing the Amazon Web Services Accounts in Your Organization.

# Arguments
- `admin_account`: The Amazon Web Services account ID to add as an Firewall Manager
  administrator account. The account must be a member of the organization that was onboarded
  to Firewall Manager by AssociateAdminAccount. For more information about Organizations, see
  Managing the Amazon Web Services Accounts in Your Organization.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AdminScope"`: Configures the resources that the specified Firewall Manager
  administrator can manage. As a best practice, set the administrative scope according to the
  principles of least privilege. Only grant the administrator the specific resources or
  permissions that they need to perform the duties of their role.
"""
function put_admin_account(AdminAccount; aws_config::AbstractAWSConfig=current_aws_config())
    return fms(
        "PutAdminAccount",
        Dict{String,Any}("AdminAccount" => AdminAccount);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_admin_account(
    AdminAccount,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "PutAdminAccount",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AdminAccount" => AdminAccount), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_apps_list(apps_list)
    put_apps_list(apps_list, params::Dict{String,<:Any})

Creates an Firewall Manager applications list.

# Arguments
- `apps_list`: The details of the Firewall Manager applications list to be created.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"TagList"`: The tags associated with the resource.
"""
function put_apps_list(AppsList; aws_config::AbstractAWSConfig=current_aws_config())
    return fms(
        "PutAppsList",
        Dict{String,Any}("AppsList" => AppsList);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_apps_list(
    AppsList,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "PutAppsList",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AppsList" => AppsList), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_notification_channel(sns_role_name, sns_topic_arn)
    put_notification_channel(sns_role_name, sns_topic_arn, params::Dict{String,<:Any})

Designates the IAM role and Amazon Simple Notification Service (SNS) topic that Firewall
Manager uses to record SNS logs. To perform this action outside of the console, you must
first configure the SNS topic's access policy to allow the SnsRoleName to publish SNS logs.
If the SnsRoleName provided is a role other than the AWSServiceRoleForFMS service-linked
role, this role must have a trust relationship configured to allow the Firewall Manager
service principal fms.amazonaws.com to assume this role. For information about configuring
an SNS access policy, see Service roles for Firewall Manager in the Firewall Manager
Developer Guide.

# Arguments
- `sns_role_name`: The Amazon Resource Name (ARN) of the IAM role that allows Amazon SNS to
  record Firewall Manager activity.
- `sns_topic_arn`: The Amazon Resource Name (ARN) of the SNS topic that collects
  notifications from Firewall Manager.

"""
function put_notification_channel(
    SnsRoleName, SnsTopicArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "PutNotificationChannel",
        Dict{String,Any}("SnsRoleName" => SnsRoleName, "SnsTopicArn" => SnsTopicArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_notification_channel(
    SnsRoleName,
    SnsTopicArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "PutNotificationChannel",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SnsRoleName" => SnsRoleName, "SnsTopicArn" => SnsTopicArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_policy(policy)
    put_policy(policy, params::Dict{String,<:Any})

Creates an Firewall Manager policy. A Firewall Manager policy is specific to the individual
policy type. If you want to enforce multiple policy types across accounts, you can create
multiple policies. You can create more than one policy for each type.  If you add a new
account to an organization that you created with Organizations, Firewall Manager
automatically applies the policy to the resources in that account that are within scope of
the policy.  Firewall Manager provides the following types of policies:     WAF policy -
This policy applies WAF web ACL protections to specified accounts and resources.     Shield
Advanced policy - This policy applies Shield Advanced protection to specified accounts and
resources.     Security Groups policy - This type of policy gives you control over security
groups that are in use throughout your organization in Organizations and lets you enforce a
baseline set of rules across your organization.     Network ACL policy - This type of
policy gives you control over the network ACLs that are in use throughout your organization
in Organizations and lets you enforce a baseline set of first and last network ACL rules
across your organization.     Network Firewall policy - This policy applies Network
Firewall protection to your organization's VPCs.     DNS Firewall policy - This policy
applies Amazon Route 53 Resolver DNS Firewall protections to your organization's VPCs.
Third-party firewall policy - This policy applies third-party firewall protections.
Third-party firewalls are available by subscription through the Amazon Web Services
Marketplace console at Amazon Web Services Marketplace.    Palo Alto Networks Cloud NGFW
policy - This policy applies Palo Alto Networks Cloud Next Generation Firewall (NGFW)
protections and Palo Alto Networks Cloud NGFW rulestacks to your organization's VPCs.
Fortigate CNF policy - This policy applies Fortigate Cloud Native Firewall (CNF)
protections. Fortigate CNF is a cloud-centered solution that blocks Zero-Day threats and
secures cloud infrastructures with industry-leading advanced threat prevention, smart web
application firewalls (WAF), and API protection.

# Arguments
- `policy`: The details of the Firewall Manager policy to be created.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"TagList"`: The tags to add to the Amazon Web Services resource.
"""
function put_policy(Policy; aws_config::AbstractAWSConfig=current_aws_config())
    return fms(
        "PutPolicy",
        Dict{String,Any}("Policy" => Policy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_policy(
    Policy, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "PutPolicy",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Policy" => Policy), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_protocols_list(protocols_list)
    put_protocols_list(protocols_list, params::Dict{String,<:Any})

Creates an Firewall Manager protocols list.

# Arguments
- `protocols_list`: The details of the Firewall Manager protocols list to be created.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"TagList"`: The tags associated with the resource.
"""
function put_protocols_list(
    ProtocolsList; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "PutProtocolsList",
        Dict{String,Any}("ProtocolsList" => ProtocolsList);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_protocols_list(
    ProtocolsList,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "PutProtocolsList",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ProtocolsList" => ProtocolsList), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_resource_set(resource_set)
    put_resource_set(resource_set, params::Dict{String,<:Any})

Creates the resource set. An Firewall Manager resource set defines the resources to import
into an Firewall Manager policy from another Amazon Web Services service.

# Arguments
- `resource_set`: Details about the resource set to be created or updated.&gt;

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"TagList"`: Retrieves the tags associated with the specified resource set. Tags are
  key:value pairs that you can use to categorize and manage your resources, for purposes like
  billing. For example, you might set the tag key to \"customer\" and the value to the
  customer name or ID. You can specify one or more tags to add to each Amazon Web Services
  resource, up to 50 tags for a resource.
"""
function put_resource_set(ResourceSet; aws_config::AbstractAWSConfig=current_aws_config())
    return fms(
        "PutResourceSet",
        Dict{String,Any}("ResourceSet" => ResourceSet);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_resource_set(
    ResourceSet,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "PutResourceSet",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceSet" => ResourceSet), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tag_list)
    tag_resource(resource_arn, tag_list, params::Dict{String,<:Any})

Adds one or more tags to an Amazon Web Services resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource to return tags for. The
  Firewall Manager resources that support tagging are policies, applications lists, and
  protocols lists.
- `tag_list`: The tags to add to the resource.

"""
function tag_resource(
    ResourceArn, TagList; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "TagResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "TagList" => TagList);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    TagList,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "TagList" => TagList),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes one or more tags from an Amazon Web Services resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource to return tags for. The
  Firewall Manager resources that support tagging are policies, applications lists, and
  protocols lists.
- `tag_keys`: The keys of the tags to remove from the resource.

"""
function untag_resource(
    ResourceArn, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return fms(
        "UntagResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return fms(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
