# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: inspector_scan
using AWS.Compat
using AWS.UUIDs

"""
    scan_sbom(sbom)
    scan_sbom(sbom, params::Dict{String,<:Any})

Scans a provided CycloneDX 1.5 SBOM and reports on any vulnerabilities discovered in that
SBOM. You can generate compatible SBOMs for your resources using the Amazon Inspector SBOM
generator.

# Arguments
- `sbom`: The JSON file for the SBOM you want to scan. The SBOM must be in CycloneDX 1.5
  format.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"outputFormat"`: The output format for the vulnerability report.
"""
function scan_sbom(sbom; aws_config::AbstractAWSConfig=current_aws_config())
    return inspector_scan(
        "POST",
        "/scan/sbom",
        Dict{String,Any}("sbom" => sbom);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function scan_sbom(
    sbom, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector_scan(
        "POST",
        "/scan/sbom",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("sbom" => sbom), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
