# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: lookoutvision
using AWS.Compat
using AWS.UUIDs

"""
    create_dataset(dataset_type, project_name)
    create_dataset(dataset_type, project_name, params::Dict{String,<:Any})

Creates a new dataset in an Amazon Lookout for Vision project. CreateDataset can create a
training or a test dataset from a valid dataset source (DatasetSource). If you want a
single dataset project, specify train for the value of DatasetType. To have a project with
separate training and test datasets, call CreateDataset twice. On the first call, specify
train for the value of DatasetType. On the second call, specify test for the value of
DatasetType.  This operation requires permissions to perform the
lookoutvision:CreateDataset operation.

# Arguments
- `dataset_type`: The type of the dataset. Specify train for a training dataset. Specify
  test for a test dataset.
- `project_name`: The name of the project in which you want to create a dataset.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DatasetSource"`: The location of the manifest file that Amazon Lookout for Vision uses
  to create the dataset. If you don't specify DatasetSource, an empty dataset is created and
  the operation synchronously returns. Later, you can add JSON Lines by calling
  UpdateDatasetEntries.  If you specify a value for DataSource, the manifest at the S3
  location is validated and used to create the dataset. The call to CreateDataset is
  asynchronous and might take a while to complete. To find out the current status, Check the
  value of Status returned in a call to DescribeDataset.
- `"X-Amzn-Client-Token"`: ClientToken is an idempotency token that ensures a call to
  CreateDataset completes only once. You choose the value to pass. For example, An issue
  might prevent you from getting a response from CreateDataset. In this case, safely retry
  your call to CreateDataset by using the same ClientToken parameter value. If you don't
  supply a value for ClientToken, the AWS SDK you are using inserts a value for you. This
  prevents retries after a network error from making multiple dataset creation requests.
  You'll need to provide your own value for other use cases.  An error occurs if the other
  input parameters are not the same as in the first request. Using a different value for
  ClientToken is considered a new call to CreateDataset. An idempotency token is active for 8
  hours.
"""
function create_dataset(
    DatasetType, projectName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutvision(
        "POST",
        "/2020-11-20/projects/$(projectName)/datasets",
        Dict{String,Any}(
            "DatasetType" => DatasetType, "X-Amzn-Client-Token" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_dataset(
    DatasetType,
    projectName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "POST",
        "/2020-11-20/projects/$(projectName)/datasets",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DatasetType" => DatasetType, "X-Amzn-Client-Token" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_model(output_config, project_name)
    create_model(output_config, project_name, params::Dict{String,<:Any})

Creates a new version of a model within an an Amazon Lookout for Vision project.
CreateModel is an asynchronous operation in which Amazon Lookout for Vision trains, tests,
and evaluates a new version of a model.  To get the current status, check the Status field
returned in the response from DescribeModel. If the project has a single dataset, Amazon
Lookout for Vision internally splits the dataset to create a training and a test dataset.
If the project has a training and a test dataset, Lookout for Vision uses the respective
datasets to train and test the model.  After training completes, the evaluation metrics are
stored at the location specified in OutputConfig.  This operation requires permissions to
perform the lookoutvision:CreateModel operation. If you want to tag your model, you also
require permission to the lookoutvision:TagResource operation.

# Arguments
- `output_config`: The location where Amazon Lookout for Vision saves the training results.
- `project_name`: The name of the project in which you want to create a model version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description for the version of the model.
- `"KmsKeyId"`: The identifier for your AWS KMS key. The key is used to encrypt training
  and test images copied into the service for model training. Your source images are
  unaffected. If this parameter is not specified, the copied images are encrypted by a key
  that AWS owns and manages.
- `"Tags"`: A set of tags (key-value pairs) that you want to attach to the model.
- `"X-Amzn-Client-Token"`: ClientToken is an idempotency token that ensures a call to
  CreateModel completes only once. You choose the value to pass. For example, An issue might
  prevent you from getting a response from CreateModel. In this case, safely retry your call
  to CreateModel by using the same ClientToken parameter value.  If you don't supply a value
  for ClientToken, the AWS SDK you are using inserts a value for you. This prevents retries
  after a network error from starting multiple training jobs. You'll need to provide your own
  value for other use cases.  An error occurs if the other input parameters are not the same
  as in the first request. Using a different value for ClientToken is considered a new call
  to CreateModel. An idempotency token is active for 8 hours.
"""
function create_model(
    OutputConfig, projectName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutvision(
        "POST",
        "/2020-11-20/projects/$(projectName)/models",
        Dict{String,Any}(
            "OutputConfig" => OutputConfig, "X-Amzn-Client-Token" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_model(
    OutputConfig,
    projectName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "POST",
        "/2020-11-20/projects/$(projectName)/models",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "OutputConfig" => OutputConfig, "X-Amzn-Client-Token" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_project(project_name)
    create_project(project_name, params::Dict{String,<:Any})

Creates an empty Amazon Lookout for Vision project. After you create the project, add a
dataset by calling CreateDataset. This operation requires permissions to perform the
lookoutvision:CreateProject operation.

# Arguments
- `project_name`: The name for the project.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amzn-Client-Token"`: ClientToken is an idempotency token that ensures a call to
  CreateProject completes only once. You choose the value to pass. For example, An issue
  might prevent you from getting a response from CreateProject. In this case, safely retry
  your call to CreateProject by using the same ClientToken parameter value.  If you don't
  supply a value for ClientToken, the AWS SDK you are using inserts a value for you. This
  prevents retries after a network error from making multiple project creation requests.
  You'll need to provide your own value for other use cases.  An error occurs if the other
  input parameters are not the same as in the first request. Using a different value for
  ClientToken is considered a new call to CreateProject. An idempotency token is active for 8
  hours.
"""
function create_project(ProjectName; aws_config::AbstractAWSConfig=current_aws_config())
    return lookoutvision(
        "POST",
        "/2020-11-20/projects",
        Dict{String,Any}(
            "ProjectName" => ProjectName, "X-Amzn-Client-Token" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_project(
    ProjectName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "POST",
        "/2020-11-20/projects",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ProjectName" => ProjectName, "X-Amzn-Client-Token" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_dataset(dataset_type, project_name)
    delete_dataset(dataset_type, project_name, params::Dict{String,<:Any})

Deletes an existing Amazon Lookout for Vision dataset.  If your the project has a single
dataset, you must create a new dataset before you can create a model. If you project has a
training dataset and a test dataset consider the following.    If you delete the test
dataset, your project reverts to a single dataset project. If you then train the model,
Amazon Lookout for Vision internally splits the remaining dataset into a training and test
dataset.   If you delete the training dataset, you must create a training dataset before
you can create a model.   This operation requires permissions to perform the
lookoutvision:DeleteDataset operation.

# Arguments
- `dataset_type`: The type of the dataset to delete. Specify train to delete the training
  dataset. Specify test to delete the test dataset. To delete the dataset in a single dataset
  project, specify train.
- `project_name`: The name of the project that contains the dataset that you want to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amzn-Client-Token"`: ClientToken is an idempotency token that ensures a call to
  DeleteDataset completes only once. You choose the value to pass. For example, An issue
  might prevent you from getting a response from DeleteDataset. In this case, safely retry
  your call to DeleteDataset by using the same ClientToken parameter value.  If you don't
  supply a value for ClientToken, the AWS SDK you are using inserts a value for you. This
  prevents retries after a network error from making multiple deletetion requests. You'll
  need to provide your own value for other use cases.  An error occurs if the other input
  parameters are not the same as in the first request. Using a different value for
  ClientToken is considered a new call to DeleteDataset. An idempotency token is active for 8
  hours.
"""
function delete_dataset(
    datasetType, projectName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutvision(
        "DELETE",
        "/2020-11-20/projects/$(projectName)/datasets/$(datasetType)",
        Dict{String,Any}("X-Amzn-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_dataset(
    datasetType,
    projectName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "DELETE",
        "/2020-11-20/projects/$(projectName)/datasets/$(datasetType)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("X-Amzn-Client-Token" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_model(model_version, project_name)
    delete_model(model_version, project_name, params::Dict{String,<:Any})

Deletes an Amazon Lookout for Vision model. You can't delete a running model. To stop a
running model, use the StopModel operation. It might take a few seconds to delete a model.
To determine if a model has been deleted, call ListModels and check if the version of the
model (ModelVersion) is in the Models array.   This operation requires permissions to
perform the lookoutvision:DeleteModel operation.

# Arguments
- `model_version`: The version of the model that you want to delete.
- `project_name`: The name of the project that contains the model that you want to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amzn-Client-Token"`: ClientToken is an idempotency token that ensures a call to
  DeleteModel completes only once. You choose the value to pass. For example, an issue might
  prevent you from getting a response from DeleteModel. In this case, safely retry your call
  to DeleteModel by using the same ClientToken parameter value. If you don't supply a value
  for ClientToken, the AWS SDK you are using inserts a value for you. This prevents retries
  after a network error from making multiple model deletion requests. You'll need to provide
  your own value for other use cases.  An error occurs if the other input parameters are not
  the same as in the first request. Using a different value for ClientToken is considered a
  new call to DeleteModel. An idempotency token is active for 8 hours.
"""
function delete_model(
    modelVersion, projectName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutvision(
        "DELETE",
        "/2020-11-20/projects/$(projectName)/models/$(modelVersion)",
        Dict{String,Any}("X-Amzn-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_model(
    modelVersion,
    projectName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "DELETE",
        "/2020-11-20/projects/$(projectName)/models/$(modelVersion)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("X-Amzn-Client-Token" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_project(project_name)
    delete_project(project_name, params::Dict{String,<:Any})

Deletes an Amazon Lookout for Vision project. To delete a project, you must first delete
each version of the model associated with the project. To delete a model use the
DeleteModel operation. You also have to delete the dataset(s) associated with the model.
For more information, see DeleteDataset. The images referenced by the training and test
datasets aren't deleted.  This operation requires permissions to perform the
lookoutvision:DeleteProject operation.

# Arguments
- `project_name`: The name of the project to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amzn-Client-Token"`: ClientToken is an idempotency token that ensures a call to
  DeleteProject completes only once. You choose the value to pass. For example, An issue
  might prevent you from getting a response from DeleteProject. In this case, safely retry
  your call to DeleteProject by using the same ClientToken parameter value.  If you don't
  supply a value for ClientToken, the AWS SDK you are using inserts a value for you. This
  prevents retries after a network error from making multiple project deletion requests.
  You'll need to provide your own value for other use cases.  An error occurs if the other
  input parameters are not the same as in the first request. Using a different value for
  ClientToken is considered a new call to DeleteProject. An idempotency token is active for 8
  hours.
"""
function delete_project(projectName; aws_config::AbstractAWSConfig=current_aws_config())
    return lookoutvision(
        "DELETE",
        "/2020-11-20/projects/$(projectName)",
        Dict{String,Any}("X-Amzn-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_project(
    projectName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "DELETE",
        "/2020-11-20/projects/$(projectName)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("X-Amzn-Client-Token" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dataset(dataset_type, project_name)
    describe_dataset(dataset_type, project_name, params::Dict{String,<:Any})

Describe an Amazon Lookout for Vision dataset. This operation requires permissions to
perform the lookoutvision:DescribeDataset operation.

# Arguments
- `dataset_type`: The type of the dataset to describe. Specify train to describe the
  training dataset. Specify test to describe the test dataset. If you have a single dataset
  project, specify train
- `project_name`: The name of the project that contains the dataset that you want to
  describe.

"""
function describe_dataset(
    datasetType, projectName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutvision(
        "GET",
        "/2020-11-20/projects/$(projectName)/datasets/$(datasetType)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_dataset(
    datasetType,
    projectName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "GET",
        "/2020-11-20/projects/$(projectName)/datasets/$(datasetType)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_model(model_version, project_name)
    describe_model(model_version, project_name, params::Dict{String,<:Any})

Describes a version of an Amazon Lookout for Vision model. This operation requires
permissions to perform the lookoutvision:DescribeModel operation.

# Arguments
- `model_version`: The version of the model that you want to describe.
- `project_name`: The project that contains the version of a model that you want to
  describe.

"""
function describe_model(
    modelVersion, projectName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutvision(
        "GET",
        "/2020-11-20/projects/$(projectName)/models/$(modelVersion)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_model(
    modelVersion,
    projectName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "GET",
        "/2020-11-20/projects/$(projectName)/models/$(modelVersion)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_model_packaging_job(job_name, project_name)
    describe_model_packaging_job(job_name, project_name, params::Dict{String,<:Any})

Describes an Amazon Lookout for Vision model packaging job.  This operation requires
permissions to perform the lookoutvision:DescribeModelPackagingJob operation. For more
information, see Using your Amazon Lookout for Vision model on an edge device in the Amazon
Lookout for Vision Developer Guide.

# Arguments
- `job_name`: The job name for the model packaging job.
- `project_name`: The name of the project that contains the model packaging job that you
  want to describe.

"""
function describe_model_packaging_job(
    jobName, projectName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutvision(
        "GET",
        "/2020-11-20/projects/$(projectName)/modelpackagingjobs/$(jobName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_model_packaging_job(
    jobName,
    projectName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "GET",
        "/2020-11-20/projects/$(projectName)/modelpackagingjobs/$(jobName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_project(project_name)
    describe_project(project_name, params::Dict{String,<:Any})

Describes an Amazon Lookout for Vision project. This operation requires permissions to
perform the lookoutvision:DescribeProject operation.

# Arguments
- `project_name`: The name of the project that you want to describe.

"""
function describe_project(projectName; aws_config::AbstractAWSConfig=current_aws_config())
    return lookoutvision(
        "GET",
        "/2020-11-20/projects/$(projectName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_project(
    projectName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "GET",
        "/2020-11-20/projects/$(projectName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detect_anomalies(body, content-_type, model_version, project_name)
    detect_anomalies(body, content-_type, model_version, project_name, params::Dict{String,<:Any})

Detects anomalies in an image that you supply.  The response from DetectAnomalies includes
a boolean prediction that the image contains one or more anomalies and a confidence value
for the prediction. If the model is an image segmentation model, the response also includes
segmentation information for each type of anomaly found in the image.  Before calling
DetectAnomalies, you must first start your model with the StartModel operation. You are
charged for the amount of time, in minutes, that a model runs and for the number of anomaly
detection units that your model uses. If you are not using a model, use the StopModel
operation to stop your model.   For more information, see Detecting anomalies in an image
in the Amazon Lookout for Vision developer guide. This operation requires permissions to
perform the lookoutvision:DetectAnomalies operation.

# Arguments
- `body`: The unencrypted image bytes that you want to analyze.
- `content-_type`: The type of the image passed in Body. Valid values are image/png (PNG
  format images) and image/jpeg (JPG format images).
- `model_version`: The version of the model that you want to use.
- `project_name`: The name of the project that contains the model version that you want to
  use.

"""
function detect_anomalies(
    Body,
    Content_Type,
    modelVersion,
    projectName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "POST",
        "/2020-11-20/projects/$(projectName)/models/$(modelVersion)/detect",
        Dict{String,Any}(
            "Body" => Body, "headers" => Dict{String,Any}("Content-Type" => Content_Type)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detect_anomalies(
    Body,
    Content_Type,
    modelVersion,
    projectName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "POST",
        "/2020-11-20/projects/$(projectName)/models/$(modelVersion)/detect",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Body" => Body,
                    "headers" => Dict{String,Any}("Content-Type" => Content_Type),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_dataset_entries(dataset_type, project_name)
    list_dataset_entries(dataset_type, project_name, params::Dict{String,<:Any})

Lists the JSON Lines within a dataset. An Amazon Lookout for Vision JSON Line contains the
anomaly information for a single image, including the image location and the assigned
label. This operation requires permissions to perform the lookoutvision:ListDatasetEntries
operation.

# Arguments
- `dataset_type`: The type of the dataset that you want to list. Specify train to list the
  training dataset. Specify test to list the test dataset. If you have a single dataset
  project, specify train.
- `project_name`: The name of the project that contains the dataset that you want to list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"anomalyClass"`: Specify normal to include only normal images. Specify anomaly to only
  include anomalous entries. If you don't specify a value, Amazon Lookout for Vision returns
  normal and anomalous images.
- `"createdAfter"`: Only includes entries after the specified date in the response. For
  example, 2020-06-23T00:00:00.
- `"createdBefore"`: Only includes entries before the specified date in the response. For
  example, 2020-06-23T00:00:00.
- `"labeled"`: Specify true to include labeled entries, otherwise specify false. If you
  don't specify a value, Lookout for Vision returns all entries.
- `"maxResults"`: The maximum number of results to return per paginated call. The largest
  value you can specify is 100. If you specify a value greater than 100, a
  ValidationException error occurs. The default value is 100.
- `"nextToken"`: If the previous response was incomplete (because there is more data to
  retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can
  use this pagination token to retrieve the next set of dataset entries.
- `"sourceRefContains"`: Perform a \"contains\" search on the values of the source-ref key
  within the dataset. For example a value of \"IMG_17\" returns all JSON Lines where the
  source-ref key value matches *IMG_17*.
"""
function list_dataset_entries(
    datasetType, projectName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutvision(
        "GET",
        "/2020-11-20/projects/$(projectName)/datasets/$(datasetType)/entries";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_dataset_entries(
    datasetType,
    projectName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "GET",
        "/2020-11-20/projects/$(projectName)/datasets/$(datasetType)/entries",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_model_packaging_jobs(project_name)
    list_model_packaging_jobs(project_name, params::Dict{String,<:Any})

 Lists the model packaging jobs created for an Amazon Lookout for Vision project.  This
operation requires permissions to perform the lookoutvision:ListModelPackagingJobs
operation.  For more information, see Using your Amazon Lookout for Vision model on an edge
device in the Amazon Lookout for Vision Developer Guide.

# Arguments
- `project_name`:  The name of the project for which you want to list the model packaging
  jobs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return per paginated call. The largest
  value you can specify is 100. If you specify a value greater than 100, a
  ValidationException error occurs. The default value is 100.
- `"nextToken"`: If the previous response was incomplete (because there is more results to
  retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can
  use this pagination token to retrieve the next set of results.
"""
function list_model_packaging_jobs(
    projectName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutvision(
        "GET",
        "/2020-11-20/projects/$(projectName)/modelpackagingjobs";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_model_packaging_jobs(
    projectName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "GET",
        "/2020-11-20/projects/$(projectName)/modelpackagingjobs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_models(project_name)
    list_models(project_name, params::Dict{String,<:Any})

Lists the versions of a model in an Amazon Lookout for Vision project. The ListModels
operation is eventually consistent. Recent calls to CreateModel might take a while to
appear in the response from ListProjects. This operation requires permissions to perform
the lookoutvision:ListModels operation.

# Arguments
- `project_name`: The name of the project that contains the model versions that you want to
  list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return per paginated call. The largest
  value you can specify is 100. If you specify a value greater than 100, a
  ValidationException error occurs. The default value is 100.
- `"nextToken"`: If the previous response was incomplete (because there is more data to
  retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can
  use this pagination token to retrieve the next set of models.
"""
function list_models(projectName; aws_config::AbstractAWSConfig=current_aws_config())
    return lookoutvision(
        "GET",
        "/2020-11-20/projects/$(projectName)/models";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_models(
    projectName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "GET",
        "/2020-11-20/projects/$(projectName)/models",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_projects()
    list_projects(params::Dict{String,<:Any})

Lists the Amazon Lookout for Vision projects in your AWS account that are in the AWS Region
in which you call ListProjects. The ListProjects operation is eventually consistent. Recent
calls to CreateProject and DeleteProject might take a while to appear in the response from
ListProjects. This operation requires permissions to perform the lookoutvision:ListProjects
operation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return per paginated call. The largest
  value you can specify is 100. If you specify a value greater than 100, a
  ValidationException error occurs. The default value is 100.
- `"nextToken"`: If the previous response was incomplete (because there is more data to
  retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can
  use this pagination token to retrieve the next set of projects.
"""
function list_projects(; aws_config::AbstractAWSConfig=current_aws_config())
    return lookoutvision(
        "GET",
        "/2020-11-20/projects";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_projects(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutvision(
        "GET",
        "/2020-11-20/projects",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Returns a list of tags attached to the specified Amazon Lookout for Vision model. This
operation requires permissions to perform the lookoutvision:ListTagsForResource operation.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the model for which you want to list
  tags.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutvision(
        "GET",
        "/2020-11-20/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "GET",
        "/2020-11-20/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_model(min_inference_units, model_version, project_name)
    start_model(min_inference_units, model_version, project_name, params::Dict{String,<:Any})

Starts the running of the version of an Amazon Lookout for Vision model. Starting a model
takes a while to complete. To check the current state of the model, use DescribeModel. A
model is ready to use when its status is HOSTED. Once the model is running, you can detect
custom labels in new images by calling DetectAnomalies.  You are charged for the amount of
time that the model is running. To stop a running model, call StopModel.  This operation
requires permissions to perform the lookoutvision:StartModel operation.

# Arguments
- `min_inference_units`: The minimum number of inference units to use. A single inference
  unit represents 1 hour of processing. Use a higher number to increase the TPS throughput of
  your model. You are charged for the number of inference units that you use.
- `model_version`: The version of the model that you want to start.
- `project_name`: The name of the project that contains the model that you want to start.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxInferenceUnits"`: The maximum number of inference units to use for auto-scaling the
  model. If you don't specify a value, Amazon Lookout for Vision doesn't auto-scale the model.
- `"X-Amzn-Client-Token"`: ClientToken is an idempotency token that ensures a call to
  StartModel completes only once. You choose the value to pass. For example, An issue might
  prevent you from getting a response from StartModel. In this case, safely retry your call
  to StartModel by using the same ClientToken parameter value.  If you don't supply a value
  for ClientToken, the AWS SDK you are using inserts a value for you. This prevents retries
  after a network error from making multiple start requests. You'll need to provide your own
  value for other use cases.  An error occurs if the other input parameters are not the same
  as in the first request. Using a different value for ClientToken is considered a new call
  to StartModel. An idempotency token is active for 8 hours.
"""
function start_model(
    MinInferenceUnits,
    modelVersion,
    projectName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "POST",
        "/2020-11-20/projects/$(projectName)/models/$(modelVersion)/start",
        Dict{String,Any}(
            "MinInferenceUnits" => MinInferenceUnits,
            "X-Amzn-Client-Token" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_model(
    MinInferenceUnits,
    modelVersion,
    projectName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "POST",
        "/2020-11-20/projects/$(projectName)/models/$(modelVersion)/start",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "MinInferenceUnits" => MinInferenceUnits,
                    "X-Amzn-Client-Token" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_model_packaging_job(configuration, model_version, project_name)
    start_model_packaging_job(configuration, model_version, project_name, params::Dict{String,<:Any})

Starts an Amazon Lookout for Vision model packaging job. A model packaging job creates an
AWS IoT Greengrass component for a Lookout for Vision model. You can use the component to
deploy your model to an edge device managed by Greengrass.  Use the
DescribeModelPackagingJob API to determine the current status of the job. The model
packaging job is complete if the value of Status is SUCCEEDED. To deploy the component to
the target device, use the component name and component version with the AWS IoT Greengrass
CreateDeployment API. This operation requires the following permissions:
lookoutvision:StartModelPackagingJob     s3:PutObject     s3:GetBucketLocation
kms:GenerateDataKey     greengrass:CreateComponentVersion     greengrass:DescribeComponent
  (Optional) greengrass:TagResource. Only required if you want to tag the component.   For
more information, see Using your Amazon Lookout for Vision model on an edge device in the
Amazon Lookout for Vision Developer Guide.

# Arguments
- `configuration`: The configuration for the model packaging job.
- `model_version`:  The version of the model within the project that you want to package.
- `project_name`:  The name of the project which contains the version of the model that you
  want to package.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description for the model packaging job.
- `"JobName"`: A name for the model packaging job. If you don't supply a value, the service
  creates a job name for you.
- `"X-Amzn-Client-Token"`: ClientToken is an idempotency token that ensures a call to
  StartModelPackagingJob completes only once. You choose the value to pass. For example, An
  issue might prevent you from getting a response from StartModelPackagingJob. In this case,
  safely retry your call to StartModelPackagingJob by using the same ClientToken parameter
  value. If you don't supply a value for ClientToken, the AWS SDK you are using inserts a
  value for you. This prevents retries after a network error from making multiple dataset
  creation requests. You'll need to provide your own value for other use cases.  An error
  occurs if the other input parameters are not the same as in the first request. Using a
  different value for ClientToken is considered a new call to StartModelPackagingJob. An
  idempotency token is active for 8 hours.
"""
function start_model_packaging_job(
    Configuration,
    ModelVersion,
    projectName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "POST",
        "/2020-11-20/projects/$(projectName)/modelpackagingjobs",
        Dict{String,Any}(
            "Configuration" => Configuration,
            "ModelVersion" => ModelVersion,
            "X-Amzn-Client-Token" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_model_packaging_job(
    Configuration,
    ModelVersion,
    projectName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "POST",
        "/2020-11-20/projects/$(projectName)/modelpackagingjobs",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Configuration" => Configuration,
                    "ModelVersion" => ModelVersion,
                    "X-Amzn-Client-Token" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_model(model_version, project_name)
    stop_model(model_version, project_name, params::Dict{String,<:Any})

Stops the hosting of a running model. The operation might take a while to complete. To
check the current status, call DescribeModel.  After the model hosting stops, the Status of
the model is TRAINED. This operation requires permissions to perform the
lookoutvision:StopModel operation.

# Arguments
- `model_version`: The version of the model that you want to stop.
- `project_name`: The name of the project that contains the model that you want to stop.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amzn-Client-Token"`: ClientToken is an idempotency token that ensures a call to
  StopModel completes only once. You choose the value to pass. For example, An issue might
  prevent you from getting a response from StopModel. In this case, safely retry your call to
  StopModel by using the same ClientToken parameter value. If you don't supply a value for
  ClientToken, the AWS SDK you are using inserts a value for you. This prevents retries after
  a network error from making multiple stop requests. You'll need to provide your own value
  for other use cases.  An error occurs if the other input parameters are not the same as in
  the first request. Using a different value for ClientToken is considered a new call to
  StopModel. An idempotency token is active for 8 hours.
"""
function stop_model(
    modelVersion, projectName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutvision(
        "POST",
        "/2020-11-20/projects/$(projectName)/models/$(modelVersion)/stop",
        Dict{String,Any}("X-Amzn-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_model(
    modelVersion,
    projectName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "POST",
        "/2020-11-20/projects/$(projectName)/models/$(modelVersion)/stop",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("X-Amzn-Client-Token" => string(uuid4())), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(tags, resource_arn)
    tag_resource(tags, resource_arn, params::Dict{String,<:Any})

Adds one or more key-value tags to an Amazon Lookout for Vision model. For more
information, see Tagging a model in the Amazon Lookout for Vision Developer Guide.  This
operation requires permissions to perform the lookoutvision:TagResource operation.

# Arguments
- `tags`: The key-value tags to assign to the model.
- `resource_arn`: The Amazon Resource Name (ARN) of the model to assign the tags.

"""
function tag_resource(Tags, resourceArn; aws_config::AbstractAWSConfig=current_aws_config())
    return lookoutvision(
        "POST",
        "/2020-11-20/tags/$(resourceArn)",
        Dict{String,Any}("Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    Tags,
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "POST",
        "/2020-11-20/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Tags" => Tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes one or more tags from an Amazon Lookout for Vision model. For more information, see
Tagging a model in the Amazon Lookout for Vision Developer Guide.  This operation requires
permissions to perform the lookoutvision:UntagResource operation.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the model from which you want to remove
  tags.
- `tag_keys`: A list of the keys of the tags that you want to remove.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutvision(
        "DELETE",
        "/2020-11-20/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "DELETE",
        "/2020-11-20/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_dataset_entries(changes, dataset_type, project_name)
    update_dataset_entries(changes, dataset_type, project_name, params::Dict{String,<:Any})

Adds or updates one or more JSON Line entries in a dataset. A JSON Line includes
information about an image used for training or testing an Amazon Lookout for Vision model.
To update an existing JSON Line, use the source-ref field to identify the JSON Line. The
JSON line that you supply replaces the existing JSON line. Any existing annotations that
are not in the new JSON line are removed from the dataset.  For more information, see
Defining JSON lines for anomaly classification in the Amazon Lookout for Vision Developer
Guide.   The images you reference in the source-ref field of a JSON line, must be in the
same S3 bucket as the existing images in the dataset.   Updating a dataset might take a
while to complete. To check the current status, call DescribeDataset and check the Status
field in the response. This operation requires permissions to perform the
lookoutvision:UpdateDatasetEntries operation.

# Arguments
- `changes`: The entries to add to the dataset.
- `dataset_type`: The type of the dataset that you want to update. Specify train to update
  the training dataset. Specify test to update the test dataset. If you have a single dataset
  project, specify train.
- `project_name`: The name of the project that contains the dataset that you want to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"X-Amzn-Client-Token"`: ClientToken is an idempotency token that ensures a call to
  UpdateDatasetEntries completes only once. You choose the value to pass. For example, An
  issue might prevent you from getting a response from UpdateDatasetEntries. In this case,
  safely retry your call to UpdateDatasetEntries by using the same ClientToken parameter
  value. If you don't supply a value for ClientToken, the AWS SDK you are using inserts a
  value for you. This prevents retries after a network error from making multiple updates
  with the same dataset entries. You'll need to provide your own value for other use cases.
  An error occurs if the other input parameters are not the same as in the first request.
  Using a different value for ClientToken is considered a new call to UpdateDatasetEntries.
  An idempotency token is active for 8 hours.
"""
function update_dataset_entries(
    Changes, datasetType, projectName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lookoutvision(
        "PATCH",
        "/2020-11-20/projects/$(projectName)/datasets/$(datasetType)/entries",
        Dict{String,Any}("Changes" => Changes, "X-Amzn-Client-Token" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_dataset_entries(
    Changes,
    datasetType,
    projectName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lookoutvision(
        "PATCH",
        "/2020-11-20/projects/$(projectName)/datasets/$(datasetType)/entries",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Changes" => Changes, "X-Amzn-Client-Token" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
