# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: waf
using AWS.Compat
using AWS.UUIDs

"""
    create_byte_match_set(change_token, name)
    create_byte_match_set(change_token, name, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Creates a ByteMatchSet. You then use UpdateByteMatchSet to
identify the part of a web request that you want AWS WAF to inspect, such as the values of
the User-Agent header or the query string. For example, you can create a ByteMatchSet that
matches any requests with User-Agent headers that contain the string BadBot. You can then
configure AWS WAF to reject those requests. To create and configure a ByteMatchSet, perform
the following steps:   Use GetChangeToken to get the change token that you provide in the
ChangeToken parameter of a CreateByteMatchSet request.   Submit a CreateByteMatchSet
request.   Use GetChangeToken to get the change token that you provide in the ChangeToken
parameter of an UpdateByteMatchSet request.   Submit an UpdateByteMatchSet request to
specify the part of the request that you want AWS WAF to inspect (for example, the header
or the URI) and the value that you want AWS WAF to watch for.   For more information about
how to use the AWS WAF API to allow or block HTTP requests, see the AWS WAF Developer Guide.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `name`: A friendly name or description of the ByteMatchSet. You can't change Name after
  you create a ByteMatchSet.

"""
function create_byte_match_set(
    ChangeToken, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "CreateByteMatchSet",
        Dict{String,Any}("ChangeToken" => ChangeToken, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_byte_match_set(
    ChangeToken,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "CreateByteMatchSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ChangeToken" => ChangeToken, "Name" => Name),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_geo_match_set(change_token, name)
    create_geo_match_set(change_token, name, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Creates an GeoMatchSet, which you use to specify which web
requests you want to allow or block based on the country that the requests originate from.
For example, if you're receiving a lot of requests from one or more countries and you want
to block the requests, you can create an GeoMatchSet that contains those countries and then
configure AWS WAF to block the requests.  To create and configure a GeoMatchSet, perform
the following steps:   Use GetChangeToken to get the change token that you provide in the
ChangeToken parameter of a CreateGeoMatchSet request.   Submit a CreateGeoMatchSet request.
  Use GetChangeToken to get the change token that you provide in the ChangeToken parameter
of an UpdateGeoMatchSet request.   Submit an UpdateGeoMatchSetSet request to specify the
countries that you want AWS WAF to watch for.   For more information about how to use the
AWS WAF API to allow or block HTTP requests, see the AWS WAF Developer Guide.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `name`: A friendly name or description of the GeoMatchSet. You can't change Name after
  you create the GeoMatchSet.

"""
function create_geo_match_set(
    ChangeToken, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "CreateGeoMatchSet",
        Dict{String,Any}("ChangeToken" => ChangeToken, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_geo_match_set(
    ChangeToken,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "CreateGeoMatchSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ChangeToken" => ChangeToken, "Name" => Name),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_ipset(change_token, name)
    create_ipset(change_token, name, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Creates an IPSet, which you use to specify which web requests
that you want to allow or block based on the IP addresses that the requests originate from.
For example, if you're receiving a lot of requests from one or more individual IP addresses
or one or more ranges of IP addresses and you want to block the requests, you can create an
IPSet that contains those IP addresses and then configure AWS WAF to block the requests.
To create and configure an IPSet, perform the following steps:   Use GetChangeToken to get
the change token that you provide in the ChangeToken parameter of a CreateIPSet request.
Submit a CreateIPSet request.   Use GetChangeToken to get the change token that you provide
in the ChangeToken parameter of an UpdateIPSet request.   Submit an UpdateIPSet request to
specify the IP addresses that you want AWS WAF to watch for.   For more information about
how to use the AWS WAF API to allow or block HTTP requests, see the AWS WAF Developer Guide.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `name`: A friendly name or description of the IPSet. You can't change Name after you
  create the IPSet.

"""
function create_ipset(ChangeToken, Name; aws_config::AbstractAWSConfig=current_aws_config())
    return waf(
        "CreateIPSet",
        Dict{String,Any}("ChangeToken" => ChangeToken, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_ipset(
    ChangeToken,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "CreateIPSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ChangeToken" => ChangeToken, "Name" => Name),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_rate_based_rule(change_token, metric_name, name, rate_key, rate_limit)
    create_rate_based_rule(change_token, metric_name, name, rate_key, rate_limit, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Creates a RateBasedRule. The RateBasedRule contains a RateLimit,
which specifies the maximum number of requests that AWS WAF allows from a specified IP
address in a five-minute period. The RateBasedRule also contains the IPSet objects,
ByteMatchSet objects, and other predicates that identify the requests that you want to
count or block if these requests exceed the RateLimit. If you add more than one predicate
to a RateBasedRule, a request not only must exceed the RateLimit, but it also must match
all the conditions to be counted or blocked. For example, suppose you add the following to
a RateBasedRule:   An IPSet that matches the IP address 192.0.2.44/32    A ByteMatchSet
that matches BadBot in the User-Agent header   Further, you specify a RateLimit of 1,000.
You then add the RateBasedRule to a WebACL and specify that you want to block requests that
meet the conditions in the rule. For a request to be blocked, it must come from the IP
address 192.0.2.44 and the User-Agent header in the request must contain the value BadBot.
Further, requests that match these two conditions must be received at a rate of more than
1,000 requests every five minutes. If both conditions are met and the rate is exceeded, AWS
WAF blocks the requests. If the rate drops below 1,000 for a five-minute period, AWS WAF no
longer blocks the requests. As a second example, suppose you want to limit requests to a
particular page on your site. To do this, you could add the following to a RateBasedRule:
A ByteMatchSet with FieldToMatch of URI    A PositionalConstraint of STARTS_WITH    A
TargetString of login    Further, you specify a RateLimit of 1,000. By adding this
RateBasedRule to a WebACL, you could limit requests to your login page without affecting
the rest of your site. To create and configure a RateBasedRule, perform the following
steps:   Create and update the predicates that you want to include in the rule. For more
information, see CreateByteMatchSet, CreateIPSet, and CreateSqlInjectionMatchSet.   Use
GetChangeToken to get the change token that you provide in the ChangeToken parameter of a
CreateRule request.   Submit a CreateRateBasedRule request.   Use GetChangeToken to get the
change token that you provide in the ChangeToken parameter of an UpdateRule request.
Submit an UpdateRateBasedRule request to specify the predicates that you want to include in
the rule.   Create and update a WebACL that contains the RateBasedRule. For more
information, see CreateWebACL.   For more information about how to use the AWS WAF API to
allow or block HTTP requests, see the AWS WAF Developer Guide.

# Arguments
- `change_token`: The ChangeToken that you used to submit the CreateRateBasedRule request.
  You can also use this value to query the status of the request. For more information, see
  GetChangeTokenStatus.
- `metric_name`: A friendly name or description for the metrics for this RateBasedRule. The
  name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and
  minimum length one. It can't contain whitespace or metric names reserved for AWS WAF,
  including \"All\" and \"Default_Action.\" You can't change the name of the metric after you
  create the RateBasedRule.
- `name`: A friendly name or description of the RateBasedRule. You can't change the name of
  a RateBasedRule after you create it.
- `rate_key`: The field that AWS WAF uses to determine if requests are likely arriving from
  a single source and thus subject to rate monitoring. The only valid value for RateKey is
  IP. IP indicates that requests that arrive from the same IP address are subject to the
  RateLimit that is specified in the RateBasedRule.
- `rate_limit`: The maximum number of requests, which have an identical value in the field
  that is specified by RateKey, allowed in a five-minute period. If the number of requests
  exceeds the RateLimit and the other predicates specified in the rule are also met, AWS WAF
  triggers the action that is specified for this rule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`:
"""
function create_rate_based_rule(
    ChangeToken,
    MetricName,
    Name,
    RateKey,
    RateLimit;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "CreateRateBasedRule",
        Dict{String,Any}(
            "ChangeToken" => ChangeToken,
            "MetricName" => MetricName,
            "Name" => Name,
            "RateKey" => RateKey,
            "RateLimit" => RateLimit,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_rate_based_rule(
    ChangeToken,
    MetricName,
    Name,
    RateKey,
    RateLimit,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "CreateRateBasedRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChangeToken" => ChangeToken,
                    "MetricName" => MetricName,
                    "Name" => Name,
                    "RateKey" => RateKey,
                    "RateLimit" => RateLimit,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_regex_match_set(change_token, name)
    create_regex_match_set(change_token, name, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Creates a RegexMatchSet. You then use UpdateRegexMatchSet to
identify the part of a web request that you want AWS WAF to inspect, such as the values of
the User-Agent header or the query string. For example, you can create a RegexMatchSet that
contains a RegexMatchTuple that looks for any requests with User-Agent headers that match a
RegexPatternSet with pattern B[a@]dB[o0]t. You can then configure AWS WAF to reject those
requests. To create and configure a RegexMatchSet, perform the following steps:   Use
GetChangeToken to get the change token that you provide in the ChangeToken parameter of a
CreateRegexMatchSet request.   Submit a CreateRegexMatchSet request.   Use GetChangeToken
to get the change token that you provide in the ChangeToken parameter of an
UpdateRegexMatchSet request.   Submit an UpdateRegexMatchSet request to specify the part of
the request that you want AWS WAF to inspect (for example, the header or the URI) and the
value, using a RegexPatternSet, that you want AWS WAF to watch for.   For more information
about how to use the AWS WAF API to allow or block HTTP requests, see the AWS WAF Developer
Guide.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `name`: A friendly name or description of the RegexMatchSet. You can't change Name after
  you create a RegexMatchSet.

"""
function create_regex_match_set(
    ChangeToken, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "CreateRegexMatchSet",
        Dict{String,Any}("ChangeToken" => ChangeToken, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_regex_match_set(
    ChangeToken,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "CreateRegexMatchSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ChangeToken" => ChangeToken, "Name" => Name),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_regex_pattern_set(change_token, name)
    create_regex_pattern_set(change_token, name, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Creates a RegexPatternSet. You then use UpdateRegexPatternSet to
specify the regular expression (regex) pattern that you want AWS WAF to search for, such as
B[a@]dB[o0]t. You can then configure AWS WAF to reject those requests. To create and
configure a RegexPatternSet, perform the following steps:   Use GetChangeToken to get the
change token that you provide in the ChangeToken parameter of a CreateRegexPatternSet
request.   Submit a CreateRegexPatternSet request.   Use GetChangeToken to get the change
token that you provide in the ChangeToken parameter of an UpdateRegexPatternSet request.
Submit an UpdateRegexPatternSet request to specify the string that you want AWS WAF to
watch for.   For more information about how to use the AWS WAF API to allow or block HTTP
requests, see the AWS WAF Developer Guide.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `name`: A friendly name or description of the RegexPatternSet. You can't change Name
  after you create a RegexPatternSet.

"""
function create_regex_pattern_set(
    ChangeToken, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "CreateRegexPatternSet",
        Dict{String,Any}("ChangeToken" => ChangeToken, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_regex_pattern_set(
    ChangeToken,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "CreateRegexPatternSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ChangeToken" => ChangeToken, "Name" => Name),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_rule(change_token, metric_name, name)
    create_rule(change_token, metric_name, name, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Creates a Rule, which contains the IPSet objects, ByteMatchSet
objects, and other predicates that identify the requests that you want to block. If you add
more than one predicate to a Rule, a request must match all of the specifications to be
allowed or blocked. For example, suppose that you add the following to a Rule:   An IPSet
that matches the IP address 192.0.2.44/32    A ByteMatchSet that matches BadBot in the
User-Agent header   You then add the Rule to a WebACL and specify that you want to blocks
requests that satisfy the Rule. For a request to be blocked, it must come from the IP
address 192.0.2.44 and the User-Agent header in the request must contain the value BadBot.
To create and configure a Rule, perform the following steps:   Create and update the
predicates that you want to include in the Rule. For more information, see
CreateByteMatchSet, CreateIPSet, and CreateSqlInjectionMatchSet.   Use GetChangeToken to
get the change token that you provide in the ChangeToken parameter of a CreateRule request.
  Submit a CreateRule request.   Use GetChangeToken to get the change token that you
provide in the ChangeToken parameter of an UpdateRule request.   Submit an UpdateRule
request to specify the predicates that you want to include in the Rule.   Create and update
a WebACL that contains the Rule. For more information, see CreateWebACL.   For more
information about how to use the AWS WAF API to allow or block HTTP requests, see the AWS
WAF Developer Guide.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `metric_name`: A friendly name or description for the metrics for this Rule. The name can
  contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum
  length one. It can't contain whitespace or metric names reserved for AWS WAF, including
  \"All\" and \"Default_Action.\" You can't change the name of the metric after you create
  the Rule.
- `name`: A friendly name or description of the Rule. You can't change the name of a Rule
  after you create it.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`:
"""
function create_rule(
    ChangeToken, MetricName, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "CreateRule",
        Dict{String,Any}(
            "ChangeToken" => ChangeToken, "MetricName" => MetricName, "Name" => Name
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_rule(
    ChangeToken,
    MetricName,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "CreateRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChangeToken" => ChangeToken, "MetricName" => MetricName, "Name" => Name
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_rule_group(change_token, metric_name, name)
    create_rule_group(change_token, metric_name, name, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Creates a RuleGroup. A rule group is a collection of predefined
rules that you add to a web ACL. You use UpdateRuleGroup to add rules to the rule group.
Rule groups are subject to the following limits:   Three rule groups per account. You can
request an increase to this limit by contacting customer support.   One rule group per web
ACL.   Ten rules per rule group.   For more information about how to use the AWS WAF API to
allow or block HTTP requests, see the AWS WAF Developer Guide.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `metric_name`: A friendly name or description for the metrics for this RuleGroup. The
  name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and
  minimum length one. It can't contain whitespace or metric names reserved for AWS WAF,
  including \"All\" and \"Default_Action.\" You can't change the name of the metric after you
  create the RuleGroup.
- `name`: A friendly name or description of the RuleGroup. You can't change Name after you
  create a RuleGroup.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`:
"""
function create_rule_group(
    ChangeToken, MetricName, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "CreateRuleGroup",
        Dict{String,Any}(
            "ChangeToken" => ChangeToken, "MetricName" => MetricName, "Name" => Name
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_rule_group(
    ChangeToken,
    MetricName,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "CreateRuleGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChangeToken" => ChangeToken, "MetricName" => MetricName, "Name" => Name
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_size_constraint_set(change_token, name)
    create_size_constraint_set(change_token, name, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Creates a SizeConstraintSet. You then use
UpdateSizeConstraintSet to identify the part of a web request that you want AWS WAF to
check for length, such as the length of the User-Agent header or the length of the query
string. For example, you can create a SizeConstraintSet that matches any requests that have
a query string that is longer than 100 bytes. You can then configure AWS WAF to reject
those requests. To create and configure a SizeConstraintSet, perform the following steps:
Use GetChangeToken to get the change token that you provide in the ChangeToken parameter of
a CreateSizeConstraintSet request.   Submit a CreateSizeConstraintSet request.   Use
GetChangeToken to get the change token that you provide in the ChangeToken parameter of an
UpdateSizeConstraintSet request.   Submit an UpdateSizeConstraintSet request to specify the
part of the request that you want AWS WAF to inspect (for example, the header or the URI)
and the value that you want AWS WAF to watch for.   For more information about how to use
the AWS WAF API to allow or block HTTP requests, see the AWS WAF Developer Guide.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `name`: A friendly name or description of the SizeConstraintSet. You can't change Name
  after you create a SizeConstraintSet.

"""
function create_size_constraint_set(
    ChangeToken, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "CreateSizeConstraintSet",
        Dict{String,Any}("ChangeToken" => ChangeToken, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_size_constraint_set(
    ChangeToken,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "CreateSizeConstraintSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ChangeToken" => ChangeToken, "Name" => Name),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_sql_injection_match_set(change_token, name)
    create_sql_injection_match_set(change_token, name, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Creates a SqlInjectionMatchSet, which you use to allow, block,
or count requests that contain snippets of SQL code in a specified part of web requests.
AWS WAF searches for character sequences that are likely to be malicious strings. To create
and configure a SqlInjectionMatchSet, perform the following steps:   Use GetChangeToken to
get the change token that you provide in the ChangeToken parameter of a
CreateSqlInjectionMatchSet request.   Submit a CreateSqlInjectionMatchSet request.   Use
GetChangeToken to get the change token that you provide in the ChangeToken parameter of an
UpdateSqlInjectionMatchSet request.   Submit an UpdateSqlInjectionMatchSet request to
specify the parts of web requests in which you want to allow, block, or count malicious SQL
code.   For more information about how to use the AWS WAF API to allow or block HTTP
requests, see the AWS WAF Developer Guide.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `name`: A friendly name or description for the SqlInjectionMatchSet that you're creating.
  You can't change Name after you create the SqlInjectionMatchSet.

"""
function create_sql_injection_match_set(
    ChangeToken, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "CreateSqlInjectionMatchSet",
        Dict{String,Any}("ChangeToken" => ChangeToken, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_sql_injection_match_set(
    ChangeToken,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "CreateSqlInjectionMatchSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ChangeToken" => ChangeToken, "Name" => Name),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_web_acl(change_token, default_action, metric_name, name)
    create_web_acl(change_token, default_action, metric_name, name, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Creates a WebACL, which contains the Rules that identify the
CloudFront web requests that you want to allow, block, or count. AWS WAF evaluates Rules in
order based on the value of Priority for each Rule. You also specify a default action,
either ALLOW or BLOCK. If a web request doesn't match any of the Rules in a WebACL, AWS WAF
responds to the request with the default action.  To create and configure a WebACL, perform
the following steps:   Create and update the ByteMatchSet objects and other predicates that
you want to include in Rules. For more information, see CreateByteMatchSet,
UpdateByteMatchSet, CreateIPSet, UpdateIPSet, CreateSqlInjectionMatchSet, and
UpdateSqlInjectionMatchSet.   Create and update the Rules that you want to include in the
WebACL. For more information, see CreateRule and UpdateRule.   Use GetChangeToken to get
the change token that you provide in the ChangeToken parameter of a CreateWebACL request.
Submit a CreateWebACL request.   Use GetChangeToken to get the change token that you
provide in the ChangeToken parameter of an UpdateWebACL request.   Submit an UpdateWebACL
request to specify the Rules that you want to include in the WebACL, to specify the default
action, and to associate the WebACL with a CloudFront distribution.   For more information
about how to use the AWS WAF API, see the AWS WAF Developer Guide.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `default_action`: The action that you want AWS WAF to take when a request doesn't match
  the criteria specified in any of the Rule objects that are associated with the WebACL.
- `metric_name`: A friendly name or description for the metrics for this WebACL.The name
  can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and
  minimum length one. It can't contain whitespace or metric names reserved for AWS WAF,
  including \"All\" and \"Default_Action.\" You can't change MetricName after you create the
  WebACL.
- `name`: A friendly name or description of the WebACL. You can't change Name after you
  create the WebACL.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`:
"""
function create_web_acl(
    ChangeToken,
    DefaultAction,
    MetricName,
    Name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "CreateWebACL",
        Dict{String,Any}(
            "ChangeToken" => ChangeToken,
            "DefaultAction" => DefaultAction,
            "MetricName" => MetricName,
            "Name" => Name,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_web_acl(
    ChangeToken,
    DefaultAction,
    MetricName,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "CreateWebACL",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChangeToken" => ChangeToken,
                    "DefaultAction" => DefaultAction,
                    "MetricName" => MetricName,
                    "Name" => Name,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_web_aclmigration_stack(ignore_unsupported_type, s3_bucket_name, web_aclid)
    create_web_aclmigration_stack(ignore_unsupported_type, s3_bucket_name, web_aclid, params::Dict{String,<:Any})

Creates an AWS CloudFormation WAFV2 template for the specified web ACL in the specified
Amazon S3 bucket. Then, in CloudFormation, you create a stack from the template, to create
the web ACL and its resources in AWS WAFV2. Use this to migrate your AWS WAF Classic web
ACL to the latest version of AWS WAF. This is part of a larger migration procedure for web
ACLs from AWS WAF Classic to the latest version of AWS WAF. For the full procedure,
including caveats and manual steps to complete the migration and switch over to the new web
ACL, see Migrating your AWS WAF Classic resources to AWS WAF in the AWS WAF Developer
Guide.

# Arguments
- `ignore_unsupported_type`: Indicates whether to exclude entities that can't be migrated
  or to stop the migration. Set this to true to ignore unsupported entities in the web ACL
  during the migration. Otherwise, if AWS WAF encounters unsupported entities, it stops the
  process and throws an exception.
- `s3_bucket_name`: The name of the Amazon S3 bucket to store the CloudFormation template
  in. The S3 bucket must be configured as follows for the migration:    The bucket name must
  start with aws-waf-migration-. For example, aws-waf-migration-my-web-acl.   The bucket must
  be in the Region where you are deploying the template. For example, for a web ACL in
  us-west-2, you must use an Amazon S3 bucket in us-west-2 and you must deploy the template
  stack to us-west-2.    The bucket policies must permit the migration process to write data.
  For listings of the bucket policies, see the Examples section.
- `web_aclid`: The UUID of the WAF Classic web ACL that you want to migrate to WAF v2.

"""
function create_web_aclmigration_stack(
    IgnoreUnsupportedType,
    S3BucketName,
    WebACLId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "CreateWebACLMigrationStack",
        Dict{String,Any}(
            "IgnoreUnsupportedType" => IgnoreUnsupportedType,
            "S3BucketName" => S3BucketName,
            "WebACLId" => WebACLId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_web_aclmigration_stack(
    IgnoreUnsupportedType,
    S3BucketName,
    WebACLId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "CreateWebACLMigrationStack",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IgnoreUnsupportedType" => IgnoreUnsupportedType,
                    "S3BucketName" => S3BucketName,
                    "WebACLId" => WebACLId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_xss_match_set(change_token, name)
    create_xss_match_set(change_token, name, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Creates an XssMatchSet, which you use to allow, block, or count
requests that contain cross-site scripting attacks in the specified part of web requests.
AWS WAF searches for character sequences that are likely to be malicious strings. To create
and configure an XssMatchSet, perform the following steps:   Use GetChangeToken to get the
change token that you provide in the ChangeToken parameter of a CreateXssMatchSet request.
 Submit a CreateXssMatchSet request.   Use GetChangeToken to get the change token that you
provide in the ChangeToken parameter of an UpdateXssMatchSet request.   Submit an
UpdateXssMatchSet request to specify the parts of web requests in which you want to allow,
block, or count cross-site scripting attacks.   For more information about how to use the
AWS WAF API to allow or block HTTP requests, see the AWS WAF Developer Guide.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `name`: A friendly name or description for the XssMatchSet that you're creating. You
  can't change Name after you create the XssMatchSet.

"""
function create_xss_match_set(
    ChangeToken, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "CreateXssMatchSet",
        Dict{String,Any}("ChangeToken" => ChangeToken, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_xss_match_set(
    ChangeToken,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "CreateXssMatchSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ChangeToken" => ChangeToken, "Name" => Name),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_byte_match_set(byte_match_set_id, change_token)
    delete_byte_match_set(byte_match_set_id, change_token, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Permanently deletes a ByteMatchSet. You can't delete a
ByteMatchSet if it's still used in any Rules or if it still includes any ByteMatchTuple
objects (any filters). If you just want to remove a ByteMatchSet from a Rule, use
UpdateRule. To permanently delete a ByteMatchSet, perform the following steps:   Update the
ByteMatchSet to remove filters, if any. For more information, see UpdateByteMatchSet.   Use
GetChangeToken to get the change token that you provide in the ChangeToken parameter of a
DeleteByteMatchSet request.   Submit a DeleteByteMatchSet request.

# Arguments
- `byte_match_set_id`: The ByteMatchSetId of the ByteMatchSet that you want to delete.
  ByteMatchSetId is returned by CreateByteMatchSet and by ListByteMatchSets.
- `change_token`: The value returned by the most recent call to GetChangeToken.

"""
function delete_byte_match_set(
    ByteMatchSetId, ChangeToken; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "DeleteByteMatchSet",
        Dict{String,Any}("ByteMatchSetId" => ByteMatchSetId, "ChangeToken" => ChangeToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_byte_match_set(
    ByteMatchSetId,
    ChangeToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "DeleteByteMatchSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ByteMatchSetId" => ByteMatchSetId, "ChangeToken" => ChangeToken
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_geo_match_set(change_token, geo_match_set_id)
    delete_geo_match_set(change_token, geo_match_set_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Permanently deletes a GeoMatchSet. You can't delete a
GeoMatchSet if it's still used in any Rules or if it still includes any countries. If you
just want to remove a GeoMatchSet from a Rule, use UpdateRule. To permanently delete a
GeoMatchSet from AWS WAF, perform the following steps:   Update the GeoMatchSet to remove
any countries. For more information, see UpdateGeoMatchSet.   Use GetChangeToken to get the
change token that you provide in the ChangeToken parameter of a DeleteGeoMatchSet request.
 Submit a DeleteGeoMatchSet request.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `geo_match_set_id`: The GeoMatchSetID of the GeoMatchSet that you want to delete.
  GeoMatchSetId is returned by CreateGeoMatchSet and by ListGeoMatchSets.

"""
function delete_geo_match_set(
    ChangeToken, GeoMatchSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "DeleteGeoMatchSet",
        Dict{String,Any}("ChangeToken" => ChangeToken, "GeoMatchSetId" => GeoMatchSetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_geo_match_set(
    ChangeToken,
    GeoMatchSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "DeleteGeoMatchSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChangeToken" => ChangeToken, "GeoMatchSetId" => GeoMatchSetId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_ipset(change_token, ipset_id)
    delete_ipset(change_token, ipset_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Permanently deletes an IPSet. You can't delete an IPSet if it's
still used in any Rules or if it still includes any IP addresses. If you just want to
remove an IPSet from a Rule, use UpdateRule. To permanently delete an IPSet from AWS WAF,
perform the following steps:   Update the IPSet to remove IP address ranges, if any. For
more information, see UpdateIPSet.   Use GetChangeToken to get the change token that you
provide in the ChangeToken parameter of a DeleteIPSet request.   Submit a DeleteIPSet
request.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `ipset_id`: The IPSetId of the IPSet that you want to delete. IPSetId is returned by
  CreateIPSet and by ListIPSets.

"""
function delete_ipset(
    ChangeToken, IPSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "DeleteIPSet",
        Dict{String,Any}("ChangeToken" => ChangeToken, "IPSetId" => IPSetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_ipset(
    ChangeToken,
    IPSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "DeleteIPSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ChangeToken" => ChangeToken, "IPSetId" => IPSetId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_logging_configuration(resource_arn)
    delete_logging_configuration(resource_arn, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Permanently deletes the LoggingConfiguration from the specified
web ACL.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the web ACL from which you want to
  delete the LoggingConfiguration.

"""
function delete_logging_configuration(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "DeleteLoggingConfiguration",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_logging_configuration(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "DeleteLoggingConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_permission_policy(resource_arn)
    delete_permission_policy(resource_arn, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Permanently deletes an IAM policy from the specified RuleGroup.
The user making the request must be the owner of the RuleGroup.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the RuleGroup from which you want to
  delete the policy. The user making the request must be the owner of the RuleGroup.

"""
function delete_permission_policy(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "DeletePermissionPolicy",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_permission_policy(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "DeletePermissionPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_rate_based_rule(change_token, rule_id)
    delete_rate_based_rule(change_token, rule_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Permanently deletes a RateBasedRule. You can't delete a rule if
it's still used in any WebACL objects or if it still includes any predicates, such as
ByteMatchSet objects. If you just want to remove a rule from a WebACL, use UpdateWebACL. To
permanently delete a RateBasedRule from AWS WAF, perform the following steps:   Update the
RateBasedRule to remove predicates, if any. For more information, see UpdateRateBasedRule.
 Use GetChangeToken to get the change token that you provide in the ChangeToken parameter
of a DeleteRateBasedRule request.   Submit a DeleteRateBasedRule request.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `rule_id`: The RuleId of the RateBasedRule that you want to delete. RuleId is returned by
  CreateRateBasedRule and by ListRateBasedRules.

"""
function delete_rate_based_rule(
    ChangeToken, RuleId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "DeleteRateBasedRule",
        Dict{String,Any}("ChangeToken" => ChangeToken, "RuleId" => RuleId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_rate_based_rule(
    ChangeToken,
    RuleId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "DeleteRateBasedRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ChangeToken" => ChangeToken, "RuleId" => RuleId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_regex_match_set(change_token, regex_match_set_id)
    delete_regex_match_set(change_token, regex_match_set_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Permanently deletes a RegexMatchSet. You can't delete a
RegexMatchSet if it's still used in any Rules or if it still includes any RegexMatchTuples
objects (any filters). If you just want to remove a RegexMatchSet from a Rule, use
UpdateRule. To permanently delete a RegexMatchSet, perform the following steps:   Update
the RegexMatchSet to remove filters, if any. For more information, see UpdateRegexMatchSet.
  Use GetChangeToken to get the change token that you provide in the ChangeToken parameter
of a DeleteRegexMatchSet request.   Submit a DeleteRegexMatchSet request.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `regex_match_set_id`: The RegexMatchSetId of the RegexMatchSet that you want to delete.
  RegexMatchSetId is returned by CreateRegexMatchSet and by ListRegexMatchSets.

"""
function delete_regex_match_set(
    ChangeToken, RegexMatchSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "DeleteRegexMatchSet",
        Dict{String,Any}(
            "ChangeToken" => ChangeToken, "RegexMatchSetId" => RegexMatchSetId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_regex_match_set(
    ChangeToken,
    RegexMatchSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "DeleteRegexMatchSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChangeToken" => ChangeToken, "RegexMatchSetId" => RegexMatchSetId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_regex_pattern_set(change_token, regex_pattern_set_id)
    delete_regex_pattern_set(change_token, regex_pattern_set_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Permanently deletes a RegexPatternSet. You can't delete a
RegexPatternSet if it's still used in any RegexMatchSet or if the RegexPatternSet is not
empty.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `regex_pattern_set_id`: The RegexPatternSetId of the RegexPatternSet that you want to
  delete. RegexPatternSetId is returned by CreateRegexPatternSet and by ListRegexPatternSets.

"""
function delete_regex_pattern_set(
    ChangeToken, RegexPatternSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "DeleteRegexPatternSet",
        Dict{String,Any}(
            "ChangeToken" => ChangeToken, "RegexPatternSetId" => RegexPatternSetId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_regex_pattern_set(
    ChangeToken,
    RegexPatternSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "DeleteRegexPatternSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChangeToken" => ChangeToken, "RegexPatternSetId" => RegexPatternSetId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_rule(change_token, rule_id)
    delete_rule(change_token, rule_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Permanently deletes a Rule. You can't delete a Rule if it's
still used in any WebACL objects or if it still includes any predicates, such as
ByteMatchSet objects. If you just want to remove a Rule from a WebACL, use UpdateWebACL. To
permanently delete a Rule from AWS WAF, perform the following steps:   Update the Rule to
remove predicates, if any. For more information, see UpdateRule.   Use GetChangeToken to
get the change token that you provide in the ChangeToken parameter of a DeleteRule request.
  Submit a DeleteRule request.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `rule_id`: The RuleId of the Rule that you want to delete. RuleId is returned by
  CreateRule and by ListRules.

"""
function delete_rule(
    ChangeToken, RuleId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "DeleteRule",
        Dict{String,Any}("ChangeToken" => ChangeToken, "RuleId" => RuleId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_rule(
    ChangeToken,
    RuleId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "DeleteRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ChangeToken" => ChangeToken, "RuleId" => RuleId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_rule_group(change_token, rule_group_id)
    delete_rule_group(change_token, rule_group_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Permanently deletes a RuleGroup. You can't delete a RuleGroup if
it's still used in any WebACL objects or if it still includes any rules. If you just want
to remove a RuleGroup from a WebACL, use UpdateWebACL. To permanently delete a RuleGroup
from AWS WAF, perform the following steps:   Update the RuleGroup to remove rules, if any.
For more information, see UpdateRuleGroup.   Use GetChangeToken to get the change token
that you provide in the ChangeToken parameter of a DeleteRuleGroup request.   Submit a
DeleteRuleGroup request.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `rule_group_id`: The RuleGroupId of the RuleGroup that you want to delete. RuleGroupId is
  returned by CreateRuleGroup and by ListRuleGroups.

"""
function delete_rule_group(
    ChangeToken, RuleGroupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "DeleteRuleGroup",
        Dict{String,Any}("ChangeToken" => ChangeToken, "RuleGroupId" => RuleGroupId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_rule_group(
    ChangeToken,
    RuleGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "DeleteRuleGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChangeToken" => ChangeToken, "RuleGroupId" => RuleGroupId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_size_constraint_set(change_token, size_constraint_set_id)
    delete_size_constraint_set(change_token, size_constraint_set_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Permanently deletes a SizeConstraintSet. You can't delete a
SizeConstraintSet if it's still used in any Rules or if it still includes any
SizeConstraint objects (any filters). If you just want to remove a SizeConstraintSet from a
Rule, use UpdateRule. To permanently delete a SizeConstraintSet, perform the following
steps:   Update the SizeConstraintSet to remove filters, if any. For more information, see
UpdateSizeConstraintSet.   Use GetChangeToken to get the change token that you provide in
the ChangeToken parameter of a DeleteSizeConstraintSet request.   Submit a
DeleteSizeConstraintSet request.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `size_constraint_set_id`: The SizeConstraintSetId of the SizeConstraintSet that you want
  to delete. SizeConstraintSetId is returned by CreateSizeConstraintSet and by
  ListSizeConstraintSets.

"""
function delete_size_constraint_set(
    ChangeToken, SizeConstraintSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "DeleteSizeConstraintSet",
        Dict{String,Any}(
            "ChangeToken" => ChangeToken, "SizeConstraintSetId" => SizeConstraintSetId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_size_constraint_set(
    ChangeToken,
    SizeConstraintSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "DeleteSizeConstraintSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChangeToken" => ChangeToken,
                    "SizeConstraintSetId" => SizeConstraintSetId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_sql_injection_match_set(change_token, sql_injection_match_set_id)
    delete_sql_injection_match_set(change_token, sql_injection_match_set_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Permanently deletes a SqlInjectionMatchSet. You can't delete a
SqlInjectionMatchSet if it's still used in any Rules or if it still contains any
SqlInjectionMatchTuple objects. If you just want to remove a SqlInjectionMatchSet from a
Rule, use UpdateRule. To permanently delete a SqlInjectionMatchSet from AWS WAF, perform
the following steps:   Update the SqlInjectionMatchSet to remove filters, if any. For more
information, see UpdateSqlInjectionMatchSet.   Use GetChangeToken to get the change token
that you provide in the ChangeToken parameter of a DeleteSqlInjectionMatchSet request.
Submit a DeleteSqlInjectionMatchSet request.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `sql_injection_match_set_id`: The SqlInjectionMatchSetId of the SqlInjectionMatchSet that
  you want to delete. SqlInjectionMatchSetId is returned by CreateSqlInjectionMatchSet and by
  ListSqlInjectionMatchSets.

"""
function delete_sql_injection_match_set(
    ChangeToken, SqlInjectionMatchSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "DeleteSqlInjectionMatchSet",
        Dict{String,Any}(
            "ChangeToken" => ChangeToken, "SqlInjectionMatchSetId" => SqlInjectionMatchSetId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_sql_injection_match_set(
    ChangeToken,
    SqlInjectionMatchSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "DeleteSqlInjectionMatchSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChangeToken" => ChangeToken,
                    "SqlInjectionMatchSetId" => SqlInjectionMatchSetId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_web_acl(change_token, web_aclid)
    delete_web_acl(change_token, web_aclid, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Permanently deletes a WebACL. You can't delete a WebACL if it
still contains any Rules. To delete a WebACL, perform the following steps:   Update the
WebACL to remove Rules, if any. For more information, see UpdateWebACL.   Use
GetChangeToken to get the change token that you provide in the ChangeToken parameter of a
DeleteWebACL request.   Submit a DeleteWebACL request.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `web_aclid`: The WebACLId of the WebACL that you want to delete. WebACLId is returned by
  CreateWebACL and by ListWebACLs.

"""
function delete_web_acl(
    ChangeToken, WebACLId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "DeleteWebACL",
        Dict{String,Any}("ChangeToken" => ChangeToken, "WebACLId" => WebACLId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_web_acl(
    ChangeToken,
    WebACLId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "DeleteWebACL",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ChangeToken" => ChangeToken, "WebACLId" => WebACLId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_xss_match_set(change_token, xss_match_set_id)
    delete_xss_match_set(change_token, xss_match_set_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Permanently deletes an XssMatchSet. You can't delete an
XssMatchSet if it's still used in any Rules or if it still contains any XssMatchTuple
objects. If you just want to remove an XssMatchSet from a Rule, use UpdateRule. To
permanently delete an XssMatchSet from AWS WAF, perform the following steps:   Update the
XssMatchSet to remove filters, if any. For more information, see UpdateXssMatchSet.   Use
GetChangeToken to get the change token that you provide in the ChangeToken parameter of a
DeleteXssMatchSet request.   Submit a DeleteXssMatchSet request.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `xss_match_set_id`: The XssMatchSetId of the XssMatchSet that you want to delete.
  XssMatchSetId is returned by CreateXssMatchSet and by ListXssMatchSets.

"""
function delete_xss_match_set(
    ChangeToken, XssMatchSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "DeleteXssMatchSet",
        Dict{String,Any}("ChangeToken" => ChangeToken, "XssMatchSetId" => XssMatchSetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_xss_match_set(
    ChangeToken,
    XssMatchSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "DeleteXssMatchSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChangeToken" => ChangeToken, "XssMatchSetId" => XssMatchSetId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_byte_match_set(byte_match_set_id)
    get_byte_match_set(byte_match_set_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns the ByteMatchSet specified by ByteMatchSetId.

# Arguments
- `byte_match_set_id`: The ByteMatchSetId of the ByteMatchSet that you want to get.
  ByteMatchSetId is returned by CreateByteMatchSet and by ListByteMatchSets.

"""
function get_byte_match_set(
    ByteMatchSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "GetByteMatchSet",
        Dict{String,Any}("ByteMatchSetId" => ByteMatchSetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_byte_match_set(
    ByteMatchSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "GetByteMatchSet",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ByteMatchSetId" => ByteMatchSetId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_change_token()
    get_change_token(params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   When you want to create, update, or delete AWS WAF objects, get
a change token and include the change token in the create, update, or delete request.
Change tokens ensure that your application doesn't submit conflicting requests to AWS WAF.
Each create, update, or delete request must use a unique change token. If your application
submits a GetChangeToken request and then submits a second GetChangeToken request before
submitting a create, update, or delete request, the second GetChangeToken request returns
the same value as the first GetChangeToken request. When you use a change token in a
create, update, or delete request, the status of the change token changes to PENDING, which
indicates that AWS WAF is propagating the change to all AWS WAF servers. Use
GetChangeTokenStatus to determine the status of your change token.

"""
function get_change_token(; aws_config::AbstractAWSConfig=current_aws_config())
    return waf("GetChangeToken"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_change_token(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "GetChangeToken", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_change_token_status(change_token)
    get_change_token_status(change_token, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns the status of a ChangeToken that you got by calling
GetChangeToken. ChangeTokenStatus is one of the following values:    PROVISIONED: You
requested the change token by calling GetChangeToken, but you haven't used it yet in a call
to create, update, or delete an AWS WAF object.    PENDING: AWS WAF is propagating the
create, update, or delete request to all AWS WAF servers.    INSYNC: Propagation is
complete.

# Arguments
- `change_token`: The change token for which you want to get the status. This change token
  was previously returned in the GetChangeToken response.

"""
function get_change_token_status(
    ChangeToken; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "GetChangeTokenStatus",
        Dict{String,Any}("ChangeToken" => ChangeToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_change_token_status(
    ChangeToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "GetChangeTokenStatus",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ChangeToken" => ChangeToken), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_geo_match_set(geo_match_set_id)
    get_geo_match_set(geo_match_set_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns the GeoMatchSet that is specified by GeoMatchSetId.

# Arguments
- `geo_match_set_id`: The GeoMatchSetId of the GeoMatchSet that you want to get.
  GeoMatchSetId is returned by CreateGeoMatchSet and by ListGeoMatchSets.

"""
function get_geo_match_set(
    GeoMatchSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "GetGeoMatchSet",
        Dict{String,Any}("GeoMatchSetId" => GeoMatchSetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_geo_match_set(
    GeoMatchSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "GetGeoMatchSet",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GeoMatchSetId" => GeoMatchSetId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_ipset(ipset_id)
    get_ipset(ipset_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns the IPSet that is specified by IPSetId.

# Arguments
- `ipset_id`: The IPSetId of the IPSet that you want to get. IPSetId is returned by
  CreateIPSet and by ListIPSets.

"""
function get_ipset(IPSetId; aws_config::AbstractAWSConfig=current_aws_config())
    return waf(
        "GetIPSet",
        Dict{String,Any}("IPSetId" => IPSetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_ipset(
    IPSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "GetIPSet",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("IPSetId" => IPSetId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_logging_configuration(resource_arn)
    get_logging_configuration(resource_arn, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns the LoggingConfiguration for the specified web ACL.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the web ACL for which you want to get
  the LoggingConfiguration.

"""
function get_logging_configuration(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "GetLoggingConfiguration",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_logging_configuration(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "GetLoggingConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_permission_policy(resource_arn)
    get_permission_policy(resource_arn, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns the IAM policy attached to the RuleGroup.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the RuleGroup for which you want to get
  the policy.

"""
function get_permission_policy(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "GetPermissionPolicy",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_permission_policy(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "GetPermissionPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_rate_based_rule(rule_id)
    get_rate_based_rule(rule_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns the RateBasedRule that is specified by the RuleId that
you included in the GetRateBasedRule request.

# Arguments
- `rule_id`: The RuleId of the RateBasedRule that you want to get. RuleId is returned by
  CreateRateBasedRule and by ListRateBasedRules.

"""
function get_rate_based_rule(RuleId; aws_config::AbstractAWSConfig=current_aws_config())
    return waf(
        "GetRateBasedRule",
        Dict{String,Any}("RuleId" => RuleId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_rate_based_rule(
    RuleId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "GetRateBasedRule",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("RuleId" => RuleId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_rate_based_rule_managed_keys(rule_id)
    get_rate_based_rule_managed_keys(rule_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns an array of IP addresses currently being blocked by the
RateBasedRule that is specified by the RuleId. The maximum number of managed keys that will
be blocked is 10,000. If more than 10,000 addresses exceed the rate limit, the 10,000
addresses with the highest rates will be blocked.

# Arguments
- `rule_id`: The RuleId of the RateBasedRule for which you want to get a list of
  ManagedKeys. RuleId is returned by CreateRateBasedRule and by ListRateBasedRules.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextMarker"`: A null value and not currently used. Do not include this in your request.
"""
function get_rate_based_rule_managed_keys(
    RuleId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "GetRateBasedRuleManagedKeys",
        Dict{String,Any}("RuleId" => RuleId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_rate_based_rule_managed_keys(
    RuleId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "GetRateBasedRuleManagedKeys",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("RuleId" => RuleId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_regex_match_set(regex_match_set_id)
    get_regex_match_set(regex_match_set_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns the RegexMatchSet specified by RegexMatchSetId.

# Arguments
- `regex_match_set_id`: The RegexMatchSetId of the RegexMatchSet that you want to get.
  RegexMatchSetId is returned by CreateRegexMatchSet and by ListRegexMatchSets.

"""
function get_regex_match_set(
    RegexMatchSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "GetRegexMatchSet",
        Dict{String,Any}("RegexMatchSetId" => RegexMatchSetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_regex_match_set(
    RegexMatchSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "GetRegexMatchSet",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("RegexMatchSetId" => RegexMatchSetId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_regex_pattern_set(regex_pattern_set_id)
    get_regex_pattern_set(regex_pattern_set_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns the RegexPatternSet specified by RegexPatternSetId.

# Arguments
- `regex_pattern_set_id`: The RegexPatternSetId of the RegexPatternSet that you want to
  get. RegexPatternSetId is returned by CreateRegexPatternSet and by ListRegexPatternSets.

"""
function get_regex_pattern_set(
    RegexPatternSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "GetRegexPatternSet",
        Dict{String,Any}("RegexPatternSetId" => RegexPatternSetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_regex_pattern_set(
    RegexPatternSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "GetRegexPatternSet",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("RegexPatternSetId" => RegexPatternSetId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_rule(rule_id)
    get_rule(rule_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns the Rule that is specified by the RuleId that you
included in the GetRule request.

# Arguments
- `rule_id`: The RuleId of the Rule that you want to get. RuleId is returned by CreateRule
  and by ListRules.

"""
function get_rule(RuleId; aws_config::AbstractAWSConfig=current_aws_config())
    return waf(
        "GetRule",
        Dict{String,Any}("RuleId" => RuleId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_rule(
    RuleId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "GetRule",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("RuleId" => RuleId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_rule_group(rule_group_id)
    get_rule_group(rule_group_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns the RuleGroup that is specified by the RuleGroupId that
you included in the GetRuleGroup request. To view the rules in a rule group, use
ListActivatedRulesInRuleGroup.

# Arguments
- `rule_group_id`: The RuleGroupId of the RuleGroup that you want to get. RuleGroupId is
  returned by CreateRuleGroup and by ListRuleGroups.

"""
function get_rule_group(RuleGroupId; aws_config::AbstractAWSConfig=current_aws_config())
    return waf(
        "GetRuleGroup",
        Dict{String,Any}("RuleGroupId" => RuleGroupId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_rule_group(
    RuleGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "GetRuleGroup",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RuleGroupId" => RuleGroupId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sampled_requests(max_items, rule_id, time_window, web_acl_id)
    get_sampled_requests(max_items, rule_id, time_window, web_acl_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Gets detailed information about a specified number of
requests--a sample--that AWS WAF randomly selects from among the first 5,000 requests that
your AWS resource received during a time range that you choose. You can specify a sample
size of up to 500 requests, and you can specify any time range in the previous three hours.
 GetSampledRequests returns a time range, which is usually the time range that you
specified. However, if your resource (such as a CloudFront distribution) received 5,000
requests before the specified time range elapsed, GetSampledRequests returns an updated
time range. This new time range indicates the actual period during which AWS WAF selected
the requests in the sample.

# Arguments
- `max_items`: The number of requests that you want AWS WAF to return from among the first
  5,000 requests that your AWS resource received during the time range. If your resource
  received fewer requests than the value of MaxItems, GetSampledRequests returns information
  about all of them.
- `rule_id`:  RuleId is one of three values:   The RuleId of the Rule or the RuleGroupId of
  the RuleGroup for which you want GetSampledRequests to return a sample of requests.
  Default_Action, which causes GetSampledRequests to return a sample of the requests that
  didn't match any of the rules in the specified WebACL.
- `time_window`: The start date and time and the end date and time of the range for which
  you want GetSampledRequests to return a sample of requests. You must specify the times in
  Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For
  example, \"2016-09-27T14:50Z\". You can specify any time range in the previous three hours.
- `web_acl_id`: The WebACLId of the WebACL for which you want GetSampledRequests to return
  a sample of requests.

"""
function get_sampled_requests(
    MaxItems,
    RuleId,
    TimeWindow,
    WebAclId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "GetSampledRequests",
        Dict{String,Any}(
            "MaxItems" => MaxItems,
            "RuleId" => RuleId,
            "TimeWindow" => TimeWindow,
            "WebAclId" => WebAclId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sampled_requests(
    MaxItems,
    RuleId,
    TimeWindow,
    WebAclId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "GetSampledRequests",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "MaxItems" => MaxItems,
                    "RuleId" => RuleId,
                    "TimeWindow" => TimeWindow,
                    "WebAclId" => WebAclId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_size_constraint_set(size_constraint_set_id)
    get_size_constraint_set(size_constraint_set_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns the SizeConstraintSet specified by SizeConstraintSetId.

# Arguments
- `size_constraint_set_id`: The SizeConstraintSetId of the SizeConstraintSet that you want
  to get. SizeConstraintSetId is returned by CreateSizeConstraintSet and by
  ListSizeConstraintSets.

"""
function get_size_constraint_set(
    SizeConstraintSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "GetSizeConstraintSet",
        Dict{String,Any}("SizeConstraintSetId" => SizeConstraintSetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_size_constraint_set(
    SizeConstraintSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "GetSizeConstraintSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SizeConstraintSetId" => SizeConstraintSetId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sql_injection_match_set(sql_injection_match_set_id)
    get_sql_injection_match_set(sql_injection_match_set_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns the SqlInjectionMatchSet that is specified by
SqlInjectionMatchSetId.

# Arguments
- `sql_injection_match_set_id`: The SqlInjectionMatchSetId of the SqlInjectionMatchSet that
  you want to get. SqlInjectionMatchSetId is returned by CreateSqlInjectionMatchSet and by
  ListSqlInjectionMatchSets.

"""
function get_sql_injection_match_set(
    SqlInjectionMatchSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "GetSqlInjectionMatchSet",
        Dict{String,Any}("SqlInjectionMatchSetId" => SqlInjectionMatchSetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sql_injection_match_set(
    SqlInjectionMatchSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "GetSqlInjectionMatchSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SqlInjectionMatchSetId" => SqlInjectionMatchSetId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_web_acl(web_aclid)
    get_web_acl(web_aclid, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns the WebACL that is specified by WebACLId.

# Arguments
- `web_aclid`: The WebACLId of the WebACL that you want to get. WebACLId is returned by
  CreateWebACL and by ListWebACLs.

"""
function get_web_acl(WebACLId; aws_config::AbstractAWSConfig=current_aws_config())
    return waf(
        "GetWebACL",
        Dict{String,Any}("WebACLId" => WebACLId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_web_acl(
    WebACLId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "GetWebACL",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("WebACLId" => WebACLId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_xss_match_set(xss_match_set_id)
    get_xss_match_set(xss_match_set_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns the XssMatchSet that is specified by XssMatchSetId.

# Arguments
- `xss_match_set_id`: The XssMatchSetId of the XssMatchSet that you want to get.
  XssMatchSetId is returned by CreateXssMatchSet and by ListXssMatchSets.

"""
function get_xss_match_set(
    XssMatchSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "GetXssMatchSet",
        Dict{String,Any}("XssMatchSetId" => XssMatchSetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_xss_match_set(
    XssMatchSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "GetXssMatchSet",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("XssMatchSetId" => XssMatchSetId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_activated_rules_in_rule_group()
    list_activated_rules_in_rule_group(params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns an array of ActivatedRule objects.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies the number of ActivatedRules that you want AWS WAF to return for
  this request. If you have more ActivatedRules than the number that you specify for Limit,
  the response includes a NextMarker value that you can use to get another batch of
  ActivatedRules.
- `"NextMarker"`: If you specify a value for Limit and you have more ActivatedRules than
  the value of Limit, AWS WAF returns a NextMarker value in the response that allows you to
  list another group of ActivatedRules. For the second and subsequent
  ListActivatedRulesInRuleGroup requests, specify the value of NextMarker from the previous
  response to get information about another batch of ActivatedRules.
- `"RuleGroupId"`: The RuleGroupId of the RuleGroup for which you want to get a list of
  ActivatedRule objects.
"""
function list_activated_rules_in_rule_group(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "ListActivatedRulesInRuleGroup";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_activated_rules_in_rule_group(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "ListActivatedRulesInRuleGroup",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_byte_match_sets()
    list_byte_match_sets(params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns an array of ByteMatchSetSummary objects.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies the number of ByteMatchSet objects that you want AWS WAF to return
  for this request. If you have more ByteMatchSets objects than the number you specify for
  Limit, the response includes a NextMarker value that you can use to get another batch of
  ByteMatchSet objects.
- `"NextMarker"`: If you specify a value for Limit and you have more ByteMatchSets than the
  value of Limit, AWS WAF returns a NextMarker value in the response that allows you to list
  another group of ByteMatchSets. For the second and subsequent ListByteMatchSets requests,
  specify the value of NextMarker from the previous response to get information about another
  batch of ByteMatchSets.
"""
function list_byte_match_sets(; aws_config::AbstractAWSConfig=current_aws_config())
    return waf("ListByteMatchSets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_byte_match_sets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "ListByteMatchSets", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_geo_match_sets()
    list_geo_match_sets(params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns an array of GeoMatchSetSummary objects in the response.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies the number of GeoMatchSet objects that you want AWS WAF to return
  for this request. If you have more GeoMatchSet objects than the number you specify for
  Limit, the response includes a NextMarker value that you can use to get another batch of
  GeoMatchSet objects.
- `"NextMarker"`: If you specify a value for Limit and you have more GeoMatchSets than the
  value of Limit, AWS WAF returns a NextMarker value in the response that allows you to list
  another group of GeoMatchSet objects. For the second and subsequent ListGeoMatchSets
  requests, specify the value of NextMarker from the previous response to get information
  about another batch of GeoMatchSet objects.
"""
function list_geo_match_sets(; aws_config::AbstractAWSConfig=current_aws_config())
    return waf("ListGeoMatchSets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_geo_match_sets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "ListGeoMatchSets", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_ipsets()
    list_ipsets(params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns an array of IPSetSummary objects in the response.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies the number of IPSet objects that you want AWS WAF to return for this
  request. If you have more IPSet objects than the number you specify for Limit, the response
  includes a NextMarker value that you can use to get another batch of IPSet objects.
- `"NextMarker"`: AWS WAF returns a NextMarker value in the response that allows you to
  list another group of IPSets. For the second and subsequent ListIPSets requests, specify
  the value of NextMarker from the previous response to get information about another batch
  of IPSets.
"""
function list_ipsets(; aws_config::AbstractAWSConfig=current_aws_config())
    return waf("ListIPSets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_ipsets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf("ListIPSets", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end

"""
    list_logging_configurations()
    list_logging_configurations(params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns an array of LoggingConfiguration objects.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies the number of LoggingConfigurations that you want AWS WAF to return
  for this request. If you have more LoggingConfigurations than the number that you specify
  for Limit, the response includes a NextMarker value that you can use to get another batch
  of LoggingConfigurations.
- `"NextMarker"`: If you specify a value for Limit and you have more LoggingConfigurations
  than the value of Limit, AWS WAF returns a NextMarker value in the response that allows you
  to list another group of LoggingConfigurations. For the second and subsequent
  ListLoggingConfigurations requests, specify the value of NextMarker from the previous
  response to get information about another batch of ListLoggingConfigurations.
"""
function list_logging_configurations(; aws_config::AbstractAWSConfig=current_aws_config())
    return waf(
        "ListLoggingConfigurations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_logging_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "ListLoggingConfigurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_rate_based_rules()
    list_rate_based_rules(params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns an array of RuleSummary objects.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies the number of Rules that you want AWS WAF to return for this
  request. If you have more Rules than the number that you specify for Limit, the response
  includes a NextMarker value that you can use to get another batch of Rules.
- `"NextMarker"`: If you specify a value for Limit and you have more Rules than the value
  of Limit, AWS WAF returns a NextMarker value in the response that allows you to list
  another group of Rules. For the second and subsequent ListRateBasedRules requests, specify
  the value of NextMarker from the previous response to get information about another batch
  of Rules.
"""
function list_rate_based_rules(; aws_config::AbstractAWSConfig=current_aws_config())
    return waf("ListRateBasedRules"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_rate_based_rules(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "ListRateBasedRules", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_regex_match_sets()
    list_regex_match_sets(params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns an array of RegexMatchSetSummary objects.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies the number of RegexMatchSet objects that you want AWS WAF to return
  for this request. If you have more RegexMatchSet objects than the number you specify for
  Limit, the response includes a NextMarker value that you can use to get another batch of
  RegexMatchSet objects.
- `"NextMarker"`: If you specify a value for Limit and you have more RegexMatchSet objects
  than the value of Limit, AWS WAF returns a NextMarker value in the response that allows you
  to list another group of ByteMatchSets. For the second and subsequent ListRegexMatchSets
  requests, specify the value of NextMarker from the previous response to get information
  about another batch of RegexMatchSet objects.
"""
function list_regex_match_sets(; aws_config::AbstractAWSConfig=current_aws_config())
    return waf("ListRegexMatchSets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_regex_match_sets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "ListRegexMatchSets", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_regex_pattern_sets()
    list_regex_pattern_sets(params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns an array of RegexPatternSetSummary objects.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies the number of RegexPatternSet objects that you want AWS WAF to
  return for this request. If you have more RegexPatternSet objects than the number you
  specify for Limit, the response includes a NextMarker value that you can use to get another
  batch of RegexPatternSet objects.
- `"NextMarker"`: If you specify a value for Limit and you have more RegexPatternSet
  objects than the value of Limit, AWS WAF returns a NextMarker value in the response that
  allows you to list another group of RegexPatternSet objects. For the second and subsequent
  ListRegexPatternSets requests, specify the value of NextMarker from the previous response
  to get information about another batch of RegexPatternSet objects.
"""
function list_regex_pattern_sets(; aws_config::AbstractAWSConfig=current_aws_config())
    return waf(
        "ListRegexPatternSets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_regex_pattern_sets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "ListRegexPatternSets",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_rule_groups()
    list_rule_groups(params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns an array of RuleGroup objects.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies the number of RuleGroups that you want AWS WAF to return for this
  request. If you have more RuleGroups than the number that you specify for Limit, the
  response includes a NextMarker value that you can use to get another batch of RuleGroups.
- `"NextMarker"`: If you specify a value for Limit and you have more RuleGroups than the
  value of Limit, AWS WAF returns a NextMarker value in the response that allows you to list
  another group of RuleGroups. For the second and subsequent ListRuleGroups requests, specify
  the value of NextMarker from the previous response to get information about another batch
  of RuleGroups.
"""
function list_rule_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return waf("ListRuleGroups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_rule_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "ListRuleGroups", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_rules()
    list_rules(params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns an array of RuleSummary objects.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies the number of Rules that you want AWS WAF to return for this
  request. If you have more Rules than the number that you specify for Limit, the response
  includes a NextMarker value that you can use to get another batch of Rules.
- `"NextMarker"`: If you specify a value for Limit and you have more Rules than the value
  of Limit, AWS WAF returns a NextMarker value in the response that allows you to list
  another group of Rules. For the second and subsequent ListRules requests, specify the value
  of NextMarker from the previous response to get information about another batch of Rules.
"""
function list_rules(; aws_config::AbstractAWSConfig=current_aws_config())
    return waf("ListRules"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_rules(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf("ListRules", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end

"""
    list_size_constraint_sets()
    list_size_constraint_sets(params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns an array of SizeConstraintSetSummary objects.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies the number of SizeConstraintSet objects that you want AWS WAF to
  return for this request. If you have more SizeConstraintSets objects than the number you
  specify for Limit, the response includes a NextMarker value that you can use to get another
  batch of SizeConstraintSet objects.
- `"NextMarker"`: If you specify a value for Limit and you have more SizeConstraintSets
  than the value of Limit, AWS WAF returns a NextMarker value in the response that allows you
  to list another group of SizeConstraintSets. For the second and subsequent
  ListSizeConstraintSets requests, specify the value of NextMarker from the previous response
  to get information about another batch of SizeConstraintSets.
"""
function list_size_constraint_sets(; aws_config::AbstractAWSConfig=current_aws_config())
    return waf(
        "ListSizeConstraintSets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_size_constraint_sets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "ListSizeConstraintSets",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_sql_injection_match_sets()
    list_sql_injection_match_sets(params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns an array of SqlInjectionMatchSet objects.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies the number of SqlInjectionMatchSet objects that you want AWS WAF to
  return for this request. If you have more SqlInjectionMatchSet objects than the number you
  specify for Limit, the response includes a NextMarker value that you can use to get another
  batch of Rules.
- `"NextMarker"`: If you specify a value for Limit and you have more SqlInjectionMatchSet
  objects than the value of Limit, AWS WAF returns a NextMarker value in the response that
  allows you to list another group of SqlInjectionMatchSets. For the second and subsequent
  ListSqlInjectionMatchSets requests, specify the value of NextMarker from the previous
  response to get information about another batch of SqlInjectionMatchSets.
"""
function list_sql_injection_match_sets(; aws_config::AbstractAWSConfig=current_aws_config())
    return waf(
        "ListSqlInjectionMatchSets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_sql_injection_match_sets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "ListSqlInjectionMatchSets",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_subscribed_rule_groups()
    list_subscribed_rule_groups(params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns an array of RuleGroup objects that you are subscribed to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies the number of subscribed rule groups that you want AWS WAF to return
  for this request. If you have more objects than the number you specify for Limit, the
  response includes a NextMarker value that you can use to get another batch of objects.
- `"NextMarker"`: If you specify a value for Limit and you have more
  ByteMatchSetssubscribed rule groups than the value of Limit, AWS WAF returns a NextMarker
  value in the response that allows you to list another group of subscribed rule groups. For
  the second and subsequent ListSubscribedRuleGroupsRequest requests, specify the value of
  NextMarker from the previous response to get information about another batch of subscribed
  rule groups.
"""
function list_subscribed_rule_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return waf(
        "ListSubscribedRuleGroups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_subscribed_rule_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "ListSubscribedRuleGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Retrieves the tags associated with the specified AWS resource.
Tags are key:value pairs that you can use to categorize and manage your resources, for
purposes like billing. For example, you might set the tag key to \"customer\" and the value
to the customer name or ID. You can specify one or more tags to add to each AWS resource,
up to 50 tags for a resource. Tagging is only available through the API, SDKs, and CLI. You
can't manage or view tags through the AWS WAF Classic console. You can tag the AWS
resources that you manage through AWS WAF Classic: web ACLs, rule groups, and rules.

# Arguments
- `resource_arn`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`:
- `"NextMarker"`:
"""
function list_tags_for_resource(
    ResourceARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "ListTagsForResource",
        Dict{String,Any}("ResourceARN" => ResourceARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceARN" => ResourceARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_web_acls()
    list_web_acls(params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns an array of WebACLSummary objects in the response.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies the number of WebACL objects that you want AWS WAF to return for
  this request. If you have more WebACL objects than the number that you specify for Limit,
  the response includes a NextMarker value that you can use to get another batch of WebACL
  objects.
- `"NextMarker"`: If you specify a value for Limit and you have more WebACL objects than
  the number that you specify for Limit, AWS WAF returns a NextMarker value in the response
  that allows you to list another group of WebACL objects. For the second and subsequent
  ListWebACLs requests, specify the value of NextMarker from the previous response to get
  information about another batch of WebACL objects.
"""
function list_web_acls(; aws_config::AbstractAWSConfig=current_aws_config())
    return waf("ListWebACLs"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_web_acls(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "ListWebACLs", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_xss_match_sets()
    list_xss_match_sets(params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Returns an array of XssMatchSet objects.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: Specifies the number of XssMatchSet objects that you want AWS WAF to return
  for this request. If you have more XssMatchSet objects than the number you specify for
  Limit, the response includes a NextMarker value that you can use to get another batch of
  Rules.
- `"NextMarker"`: If you specify a value for Limit and you have more XssMatchSet objects
  than the value of Limit, AWS WAF returns a NextMarker value in the response that allows you
  to list another group of XssMatchSets. For the second and subsequent ListXssMatchSets
  requests, specify the value of NextMarker from the previous response to get information
  about another batch of XssMatchSets.
"""
function list_xss_match_sets(; aws_config::AbstractAWSConfig=current_aws_config())
    return waf("ListXssMatchSets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_xss_match_sets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "ListXssMatchSets", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    put_logging_configuration(logging_configuration)
    put_logging_configuration(logging_configuration, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Associates a LoggingConfiguration with a specified web ACL. You
can access information about all traffic that AWS WAF inspects using the following steps:
Create an Amazon Kinesis Data Firehose.  Create the data firehose with a PUT source and in
the region that you are operating. However, if you are capturing logs for Amazon
CloudFront, always create the firehose in US East (N. Virginia).   Do not create the data
firehose using a Kinesis stream as your source.    Associate that firehose to your web ACL
using a PutLoggingConfiguration request.   When you successfully enable logging using a
PutLoggingConfiguration request, AWS WAF will create a service linked role with the
necessary permissions to write logs to the Amazon Kinesis Data Firehose. For more
information, see Logging Web ACL Traffic Information in the AWS WAF Developer Guide.

# Arguments
- `logging_configuration`: The Amazon Kinesis Data Firehose that contains the inspected
  traffic information, the redacted fields details, and the Amazon Resource Name (ARN) of the
  web ACL to monitor.  When specifying Type in RedactedFields, you must use one of the
  following values: URI, QUERY_STRING, HEADER, or METHOD.

"""
function put_logging_configuration(
    LoggingConfiguration; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "PutLoggingConfiguration",
        Dict{String,Any}("LoggingConfiguration" => LoggingConfiguration);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_logging_configuration(
    LoggingConfiguration,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "PutLoggingConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("LoggingConfiguration" => LoggingConfiguration),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_permission_policy(policy, resource_arn)
    put_permission_policy(policy, resource_arn, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Attaches an IAM policy to the specified resource. The only
supported use for this action is to share a RuleGroup across accounts. The
PutPermissionPolicy is subject to the following restrictions:   You can attach only one
policy with each PutPermissionPolicy request.   The policy must include an Effect, Action
and Principal.     Effect must specify Allow.   The Action in the policy must be
waf:UpdateWebACL, waf-regional:UpdateWebACL, waf:GetRuleGroup and waf-regional:GetRuleGroup
. Any extra or wildcard actions in the policy will be rejected.   The policy cannot include
a Resource parameter.   The ARN in the request must be a valid WAF RuleGroup ARN and the
RuleGroup must exist in the same region.   The user making the request must be the owner of
the RuleGroup.   Your policy must be composed using IAM Policy version 2012-10-17.   For
more information, see IAM Policies.  An example of a valid policy parameter is shown in the
Examples section below.

# Arguments
- `policy`: The policy to attach to the specified RuleGroup.
- `resource_arn`: The Amazon Resource Name (ARN) of the RuleGroup to which you want to
  attach the policy.

"""
function put_permission_policy(
    Policy, ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "PutPermissionPolicy",
        Dict{String,Any}("Policy" => Policy, "ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_permission_policy(
    Policy,
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "PutPermissionPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Policy" => Policy, "ResourceArn" => ResourceArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Associates tags with the specified AWS resource. Tags are
key:value pairs that you can use to categorize and manage your resources, for purposes like
billing. For example, you might set the tag key to \"customer\" and the value to the
customer name or ID. You can specify one or more tags to add to each AWS resource, up to 50
tags for a resource. Tagging is only available through the API, SDKs, and CLI. You can't
manage or view tags through the AWS WAF Classic console. You can use this action to tag the
AWS resources that you manage through AWS WAF Classic: web ACLs, rule groups, and rules.

# Arguments
- `resource_arn`:
- `tags`:

"""
function tag_resource(ResourceARN, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return waf(
        "TagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceARN,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

# Arguments
- `resource_arn`:
- `tag_keys`:

"""
function untag_resource(
    ResourceARN, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "UntagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceARN,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_byte_match_set(byte_match_set_id, change_token, updates)
    update_byte_match_set(byte_match_set_id, change_token, updates, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Inserts or deletes ByteMatchTuple objects (filters) in a
ByteMatchSet. For each ByteMatchTuple object, you specify the following values:    Whether
to insert or delete the object from the array. If you want to change a ByteMatchSetUpdate
object, you delete the existing object and add a new one.   The part of a web request that
you want AWS WAF to inspect, such as a query string or the value of the User-Agent header.
  The bytes (typically a string that corresponds with ASCII characters) that you want AWS
WAF to look for. For more information, including how you specify the values for the AWS WAF
API and the AWS CLI or SDKs, see TargetString in the ByteMatchTuple data type.    Where to
look, such as at the beginning or the end of a query string.   Whether to perform any
conversions on the request, such as converting it to lowercase, before inspecting it for
the specified string.   For example, you can add a ByteMatchSetUpdate object that matches
web requests in which User-Agent headers contain the string BadBot. You can then configure
AWS WAF to block those requests. To create and configure a ByteMatchSet, perform the
following steps:   Create a ByteMatchSet. For more information, see CreateByteMatchSet.
Use GetChangeToken to get the change token that you provide in the ChangeToken parameter of
an UpdateByteMatchSet request.   Submit an UpdateByteMatchSet request to specify the part
of the request that you want AWS WAF to inspect (for example, the header or the URI) and
the value that you want AWS WAF to watch for.   For more information about how to use the
AWS WAF API to allow or block HTTP requests, see the AWS WAF Developer Guide.

# Arguments
- `byte_match_set_id`: The ByteMatchSetId of the ByteMatchSet that you want to update.
  ByteMatchSetId is returned by CreateByteMatchSet and by ListByteMatchSets.
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `updates`: An array of ByteMatchSetUpdate objects that you want to insert into or delete
  from a ByteMatchSet. For more information, see the applicable data types:
  ByteMatchSetUpdate: Contains Action and ByteMatchTuple     ByteMatchTuple: Contains
  FieldToMatch, PositionalConstraint, TargetString, and TextTransformation     FieldToMatch:
  Contains Data and Type

"""
function update_byte_match_set(
    ByteMatchSetId, ChangeToken, Updates; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "UpdateByteMatchSet",
        Dict{String,Any}(
            "ByteMatchSetId" => ByteMatchSetId,
            "ChangeToken" => ChangeToken,
            "Updates" => Updates,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_byte_match_set(
    ByteMatchSetId,
    ChangeToken,
    Updates,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "UpdateByteMatchSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ByteMatchSetId" => ByteMatchSetId,
                    "ChangeToken" => ChangeToken,
                    "Updates" => Updates,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_geo_match_set(change_token, geo_match_set_id, updates)
    update_geo_match_set(change_token, geo_match_set_id, updates, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Inserts or deletes GeoMatchConstraint objects in an GeoMatchSet.
For each GeoMatchConstraint object, you specify the following values:    Whether to insert
or delete the object from the array. If you want to change an GeoMatchConstraint object,
you delete the existing object and add a new one.   The Type. The only valid value for Type
is Country.   The Value, which is a two character code for the country to add to the
GeoMatchConstraint object. Valid codes are listed in GeoMatchConstraintValue.   To create
and configure an GeoMatchSet, perform the following steps:   Submit a CreateGeoMatchSet
request.   Use GetChangeToken to get the change token that you provide in the ChangeToken
parameter of an UpdateGeoMatchSet request.   Submit an UpdateGeoMatchSet request to specify
the country that you want AWS WAF to watch for.   When you update an GeoMatchSet, you
specify the country that you want to add and/or the country that you want to delete. If you
want to change a country, you delete the existing country and add the new one. For more
information about how to use the AWS WAF API to allow or block HTTP requests, see the AWS
WAF Developer Guide.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `geo_match_set_id`: The GeoMatchSetId of the GeoMatchSet that you want to update.
  GeoMatchSetId is returned by CreateGeoMatchSet and by ListGeoMatchSets.
- `updates`: An array of GeoMatchSetUpdate objects that you want to insert into or delete
  from an GeoMatchSet. For more information, see the applicable data types:
  GeoMatchSetUpdate: Contains Action and GeoMatchConstraint     GeoMatchConstraint: Contains
  Type and Value  You can have only one Type and Value per GeoMatchConstraint. To add
  multiple countries, include multiple GeoMatchSetUpdate objects in your request.

"""
function update_geo_match_set(
    ChangeToken, GeoMatchSetId, Updates; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "UpdateGeoMatchSet",
        Dict{String,Any}(
            "ChangeToken" => ChangeToken,
            "GeoMatchSetId" => GeoMatchSetId,
            "Updates" => Updates,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_geo_match_set(
    ChangeToken,
    GeoMatchSetId,
    Updates,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "UpdateGeoMatchSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChangeToken" => ChangeToken,
                    "GeoMatchSetId" => GeoMatchSetId,
                    "Updates" => Updates,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_ipset(change_token, ipset_id, updates)
    update_ipset(change_token, ipset_id, updates, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Inserts or deletes IPSetDescriptor objects in an IPSet. For each
IPSetDescriptor object, you specify the following values:    Whether to insert or delete
the object from the array. If you want to change an IPSetDescriptor object, you delete the
existing object and add a new one.   The IP address version, IPv4 or IPv6.    The IP
address in CIDR notation, for example, 192.0.2.0/24 (for the range of IP addresses from
192.0.2.0 to 192.0.2.255) or 192.0.2.44/32 (for the individual IP address 192.0.2.44).
AWS WAF supports IPv4 address ranges: /8 and any range between /16 through /32. AWS WAF
supports IPv6 address ranges: /24, /32, /48, /56, /64, and /128. For more information about
CIDR notation, see the Wikipedia entry Classless Inter-Domain Routing. IPv6 addresses can
be represented using any of the following formats:
1111:0000:0000:0000:0000:0000:0000:0111/128   1111:0:0:0:0:0:0:0111/128   1111::0111/128
1111::111/128   You use an IPSet to specify which web requests you want to allow or block
based on the IP addresses that the requests originated from. For example, if you're
receiving a lot of requests from one or a small number of IP addresses and you want to
block the requests, you can create an IPSet that specifies those IP addresses, and then
configure AWS WAF to block the requests.  To create and configure an IPSet, perform the
following steps:   Submit a CreateIPSet request.   Use GetChangeToken to get the change
token that you provide in the ChangeToken parameter of an UpdateIPSet request.   Submit an
UpdateIPSet request to specify the IP addresses that you want AWS WAF to watch for.   When
you update an IPSet, you specify the IP addresses that you want to add and/or the IP
addresses that you want to delete. If you want to change an IP address, you delete the
existing IP address and add the new one. You can insert a maximum of 1000 addresses in a
single request. For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the AWS WAF Developer Guide.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `ipset_id`: The IPSetId of the IPSet that you want to update. IPSetId is returned by
  CreateIPSet and by ListIPSets.
- `updates`: An array of IPSetUpdate objects that you want to insert into or delete from an
  IPSet. For more information, see the applicable data types:    IPSetUpdate: Contains Action
  and IPSetDescriptor     IPSetDescriptor: Contains Type and Value    You can insert a
  maximum of 1000 addresses in a single request.

"""
function update_ipset(
    ChangeToken, IPSetId, Updates; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "UpdateIPSet",
        Dict{String,Any}(
            "ChangeToken" => ChangeToken, "IPSetId" => IPSetId, "Updates" => Updates
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_ipset(
    ChangeToken,
    IPSetId,
    Updates,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "UpdateIPSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChangeToken" => ChangeToken, "IPSetId" => IPSetId, "Updates" => Updates
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_rate_based_rule(change_token, rate_limit, rule_id, updates)
    update_rate_based_rule(change_token, rate_limit, rule_id, updates, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Inserts or deletes Predicate objects in a rule and updates the
RateLimit in the rule.  Each Predicate object identifies a predicate, such as a
ByteMatchSet or an IPSet, that specifies the web requests that you want to block or count.
The RateLimit specifies the number of requests every five minutes that triggers the rule.
If you add more than one predicate to a RateBasedRule, a request must match all the
predicates and exceed the RateLimit to be counted or blocked. For example, suppose you add
the following to a RateBasedRule:   An IPSet that matches the IP address 192.0.2.44/32    A
ByteMatchSet that matches BadBot in the User-Agent header   Further, you specify a
RateLimit of 1,000. You then add the RateBasedRule to a WebACL and specify that you want to
block requests that satisfy the rule. For a request to be blocked, it must come from the IP
address 192.0.2.44 and the User-Agent header in the request must contain the value BadBot.
Further, requests that match these two conditions much be received at a rate of more than
1,000 every five minutes. If the rate drops below this limit, AWS WAF no longer blocks the
requests. As a second example, suppose you want to limit requests to a particular page on
your site. To do this, you could add the following to a RateBasedRule:   A ByteMatchSet
with FieldToMatch of URI    A PositionalConstraint of STARTS_WITH    A TargetString of
login    Further, you specify a RateLimit of 1,000. By adding this RateBasedRule to a
WebACL, you could limit requests to your login page without affecting the rest of your site.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `rate_limit`: The maximum number of requests, which have an identical value in the field
  specified by the RateKey, allowed in a five-minute period. If the number of requests
  exceeds the RateLimit and the other predicates specified in the rule are also met, AWS WAF
  triggers the action that is specified for this rule.
- `rule_id`: The RuleId of the RateBasedRule that you want to update. RuleId is returned by
  CreateRateBasedRule and by ListRateBasedRules.
- `updates`: An array of RuleUpdate objects that you want to insert into or delete from a
  RateBasedRule.

"""
function update_rate_based_rule(
    ChangeToken,
    RateLimit,
    RuleId,
    Updates;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "UpdateRateBasedRule",
        Dict{String,Any}(
            "ChangeToken" => ChangeToken,
            "RateLimit" => RateLimit,
            "RuleId" => RuleId,
            "Updates" => Updates,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_rate_based_rule(
    ChangeToken,
    RateLimit,
    RuleId,
    Updates,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "UpdateRateBasedRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChangeToken" => ChangeToken,
                    "RateLimit" => RateLimit,
                    "RuleId" => RuleId,
                    "Updates" => Updates,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_regex_match_set(change_token, regex_match_set_id, updates)
    update_regex_match_set(change_token, regex_match_set_id, updates, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Inserts or deletes RegexMatchTuple objects (filters) in a
RegexMatchSet. For each RegexMatchSetUpdate object, you specify the following values:
Whether to insert or delete the object from the array. If you want to change a
RegexMatchSetUpdate object, you delete the existing object and add a new one.   The part of
a web request that you want AWS WAF to inspectupdate, such as a query string or the value
of the User-Agent header.    The identifier of the pattern (a regular expression) that you
want AWS WAF to look for. For more information, see RegexPatternSet.    Whether to perform
any conversions on the request, such as converting it to lowercase, before inspecting it
for the specified string.    For example, you can create a RegexPatternSet that matches any
requests with User-Agent headers that contain the string B[a@]dB[o0]t. You can then
configure AWS WAF to reject those requests. To create and configure a RegexMatchSet,
perform the following steps:   Create a RegexMatchSet. For more information, see
CreateRegexMatchSet.   Use GetChangeToken to get the change token that you provide in the
ChangeToken parameter of an UpdateRegexMatchSet request.   Submit an UpdateRegexMatchSet
request to specify the part of the request that you want AWS WAF to inspect (for example,
the header or the URI) and the identifier of the RegexPatternSet that contain the regular
expression patters you want AWS WAF to watch for.   For more information about how to use
the AWS WAF API to allow or block HTTP requests, see the AWS WAF Developer Guide.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `regex_match_set_id`: The RegexMatchSetId of the RegexMatchSet that you want to update.
  RegexMatchSetId is returned by CreateRegexMatchSet and by ListRegexMatchSets.
- `updates`: An array of RegexMatchSetUpdate objects that you want to insert into or delete
  from a RegexMatchSet. For more information, see RegexMatchTuple.

"""
function update_regex_match_set(
    ChangeToken,
    RegexMatchSetId,
    Updates;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "UpdateRegexMatchSet",
        Dict{String,Any}(
            "ChangeToken" => ChangeToken,
            "RegexMatchSetId" => RegexMatchSetId,
            "Updates" => Updates,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_regex_match_set(
    ChangeToken,
    RegexMatchSetId,
    Updates,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "UpdateRegexMatchSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChangeToken" => ChangeToken,
                    "RegexMatchSetId" => RegexMatchSetId,
                    "Updates" => Updates,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_regex_pattern_set(change_token, regex_pattern_set_id, updates)
    update_regex_pattern_set(change_token, regex_pattern_set_id, updates, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Inserts or deletes RegexPatternString objects in a
RegexPatternSet. For each RegexPatternString object, you specify the following values:
Whether to insert or delete the RegexPatternString.   The regular expression pattern that
you want to insert or delete. For more information, see RegexPatternSet.     For example,
you can create a RegexPatternString such as B[a@]dB[o0]t. AWS WAF will match this
RegexPatternString to:   BadBot   BadB0t   B@dBot   B@dB0t   To create and configure a
RegexPatternSet, perform the following steps:   Create a RegexPatternSet. For more
information, see CreateRegexPatternSet.   Use GetChangeToken to get the change token that
you provide in the ChangeToken parameter of an UpdateRegexPatternSet request.   Submit an
UpdateRegexPatternSet request to specify the regular expression pattern that you want AWS
WAF to watch for.   For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the AWS WAF Developer Guide.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `regex_pattern_set_id`: The RegexPatternSetId of the RegexPatternSet that you want to
  update. RegexPatternSetId is returned by CreateRegexPatternSet and by ListRegexPatternSets.
- `updates`: An array of RegexPatternSetUpdate objects that you want to insert into or
  delete from a RegexPatternSet.

"""
function update_regex_pattern_set(
    ChangeToken,
    RegexPatternSetId,
    Updates;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "UpdateRegexPatternSet",
        Dict{String,Any}(
            "ChangeToken" => ChangeToken,
            "RegexPatternSetId" => RegexPatternSetId,
            "Updates" => Updates,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_regex_pattern_set(
    ChangeToken,
    RegexPatternSetId,
    Updates,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "UpdateRegexPatternSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChangeToken" => ChangeToken,
                    "RegexPatternSetId" => RegexPatternSetId,
                    "Updates" => Updates,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_rule(change_token, rule_id, updates)
    update_rule(change_token, rule_id, updates, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Inserts or deletes Predicate objects in a Rule. Each Predicate
object identifies a predicate, such as a ByteMatchSet or an IPSet, that specifies the web
requests that you want to allow, block, or count. If you add more than one predicate to a
Rule, a request must match all of the specifications to be allowed, blocked, or counted.
For example, suppose that you add the following to a Rule:    A ByteMatchSet that matches
the value BadBot in the User-Agent header   An IPSet that matches the IP address 192.0.2.44
   You then add the Rule to a WebACL and specify that you want to block requests that
satisfy the Rule. For a request to be blocked, the User-Agent header in the request must
contain the value BadBot and the request must originate from the IP address 192.0.2.44. To
create and configure a Rule, perform the following steps:   Create and update the
predicates that you want to include in the Rule.   Create the Rule. See CreateRule.   Use
GetChangeToken to get the change token that you provide in the ChangeToken parameter of an
UpdateRule request.   Submit an UpdateRule request to add predicates to the Rule.   Create
and update a WebACL that contains the Rule. See CreateWebACL.   If you want to replace one
ByteMatchSet or IPSet with another, you delete the existing one and add the new one. For
more information about how to use the AWS WAF API to allow or block HTTP requests, see the
AWS WAF Developer Guide.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `rule_id`: The RuleId of the Rule that you want to update. RuleId is returned by
  CreateRule and by ListRules.
- `updates`: An array of RuleUpdate objects that you want to insert into or delete from a
  Rule. For more information, see the applicable data types:    RuleUpdate: Contains Action
  and Predicate     Predicate: Contains DataId, Negated, and Type     FieldToMatch: Contains
  Data and Type

"""
function update_rule(
    ChangeToken, RuleId, Updates; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "UpdateRule",
        Dict{String,Any}(
            "ChangeToken" => ChangeToken, "RuleId" => RuleId, "Updates" => Updates
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_rule(
    ChangeToken,
    RuleId,
    Updates,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "UpdateRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChangeToken" => ChangeToken, "RuleId" => RuleId, "Updates" => Updates
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_rule_group(change_token, rule_group_id, updates)
    update_rule_group(change_token, rule_group_id, updates, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Inserts or deletes ActivatedRule objects in a RuleGroup. You can
only insert REGULAR rules into a rule group. You can have a maximum of ten rules per rule
group. To create and configure a RuleGroup, perform the following steps:   Create and
update the Rules that you want to include in the RuleGroup. See CreateRule.   Use
GetChangeToken to get the change token that you provide in the ChangeToken parameter of an
UpdateRuleGroup request.   Submit an UpdateRuleGroup request to add Rules to the RuleGroup.
  Create and update a WebACL that contains the RuleGroup. See CreateWebACL.   If you want
to replace one Rule with another, you delete the existing one and add the new one. For more
information about how to use the AWS WAF API to allow or block HTTP requests, see the AWS
WAF Developer Guide.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `rule_group_id`: The RuleGroupId of the RuleGroup that you want to update. RuleGroupId is
  returned by CreateRuleGroup and by ListRuleGroups.
- `updates`: An array of RuleGroupUpdate objects that you want to insert into or delete
  from a RuleGroup. You can only insert REGULAR rules into a rule group.
  ActivatedRule|OverrideAction applies only when updating or adding a RuleGroup to a WebACL.
  In this case you do not use ActivatedRule|Action. For all other update requests,
  ActivatedRule|Action is used instead of ActivatedRule|OverrideAction.

"""
function update_rule_group(
    ChangeToken, RuleGroupId, Updates; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "UpdateRuleGroup",
        Dict{String,Any}(
            "ChangeToken" => ChangeToken, "RuleGroupId" => RuleGroupId, "Updates" => Updates
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_rule_group(
    ChangeToken,
    RuleGroupId,
    Updates,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "UpdateRuleGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChangeToken" => ChangeToken,
                    "RuleGroupId" => RuleGroupId,
                    "Updates" => Updates,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_size_constraint_set(change_token, size_constraint_set_id, updates)
    update_size_constraint_set(change_token, size_constraint_set_id, updates, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Inserts or deletes SizeConstraint objects (filters) in a
SizeConstraintSet. For each SizeConstraint object, you specify the following values:
Whether to insert or delete the object from the array. If you want to change a
SizeConstraintSetUpdate object, you delete the existing object and add a new one.   The
part of a web request that you want AWS WAF to evaluate, such as the length of a query
string or the length of the User-Agent header.   Whether to perform any transformations on
the request, such as converting it to lowercase, before checking its length. Note that
transformations of the request body are not supported because the AWS resource forwards
only the first 8192 bytes of your request to AWS WAF. You can only specify a single type of
TextTransformation.   A ComparisonOperator used for evaluating the selected part of the
request against the specified Size, such as equals, greater than, less than, and so on.
The length, in bytes, that you want AWS WAF to watch for in selected part of the request.
The length is computed after applying the transformation.   For example, you can add a
SizeConstraintSetUpdate object that matches web requests in which the length of the
User-Agent header is greater than 100 bytes. You can then configure AWS WAF to block those
requests. To create and configure a SizeConstraintSet, perform the following steps:
Create a SizeConstraintSet. For more information, see CreateSizeConstraintSet.   Use
GetChangeToken to get the change token that you provide in the ChangeToken parameter of an
UpdateSizeConstraintSet request.   Submit an UpdateSizeConstraintSet request to specify the
part of the request that you want AWS WAF to inspect (for example, the header or the URI)
and the value that you want AWS WAF to watch for.   For more information about how to use
the AWS WAF API to allow or block HTTP requests, see the AWS WAF Developer Guide.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `size_constraint_set_id`: The SizeConstraintSetId of the SizeConstraintSet that you want
  to update. SizeConstraintSetId is returned by CreateSizeConstraintSet and by
  ListSizeConstraintSets.
- `updates`: An array of SizeConstraintSetUpdate objects that you want to insert into or
  delete from a SizeConstraintSet. For more information, see the applicable data types:
  SizeConstraintSetUpdate: Contains Action and SizeConstraint     SizeConstraint: Contains
  FieldToMatch, TextTransformation, ComparisonOperator, and Size     FieldToMatch: Contains
  Data and Type

"""
function update_size_constraint_set(
    ChangeToken,
    SizeConstraintSetId,
    Updates;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "UpdateSizeConstraintSet",
        Dict{String,Any}(
            "ChangeToken" => ChangeToken,
            "SizeConstraintSetId" => SizeConstraintSetId,
            "Updates" => Updates,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_size_constraint_set(
    ChangeToken,
    SizeConstraintSetId,
    Updates,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "UpdateSizeConstraintSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChangeToken" => ChangeToken,
                    "SizeConstraintSetId" => SizeConstraintSetId,
                    "Updates" => Updates,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_sql_injection_match_set(change_token, sql_injection_match_set_id, updates)
    update_sql_injection_match_set(change_token, sql_injection_match_set_id, updates, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Inserts or deletes SqlInjectionMatchTuple objects (filters) in a
SqlInjectionMatchSet. For each SqlInjectionMatchTuple object, you specify the following
values:    Action: Whether to insert the object into or delete the object from the array.
To change a SqlInjectionMatchTuple, you delete the existing object and add a new one.
FieldToMatch: The part of web requests that you want AWS WAF to inspect and, if you want
AWS WAF to inspect a header or custom query parameter, the name of the header or parameter.
   TextTransformation: Which text transformation, if any, to perform on the web request
before inspecting the request for snippets of malicious SQL code. You can only specify a
single type of TextTransformation.   You use SqlInjectionMatchSet objects to specify which
CloudFront requests that you want to allow, block, or count. For example, if you're
receiving requests that contain snippets of SQL code in the query string and you want to
block the requests, you can create a SqlInjectionMatchSet with the applicable settings, and
then configure AWS WAF to block the requests.  To create and configure a
SqlInjectionMatchSet, perform the following steps:   Submit a CreateSqlInjectionMatchSet
request.   Use GetChangeToken to get the change token that you provide in the ChangeToken
parameter of an UpdateIPSet request.   Submit an UpdateSqlInjectionMatchSet request to
specify the parts of web requests that you want AWS WAF to inspect for snippets of SQL
code.   For more information about how to use the AWS WAF API to allow or block HTTP
requests, see the AWS WAF Developer Guide.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `sql_injection_match_set_id`: The SqlInjectionMatchSetId of the SqlInjectionMatchSet that
  you want to update. SqlInjectionMatchSetId is returned by CreateSqlInjectionMatchSet and by
  ListSqlInjectionMatchSets.
- `updates`: An array of SqlInjectionMatchSetUpdate objects that you want to insert into or
  delete from a SqlInjectionMatchSet. For more information, see the applicable data types:
  SqlInjectionMatchSetUpdate: Contains Action and SqlInjectionMatchTuple
  SqlInjectionMatchTuple: Contains FieldToMatch and TextTransformation     FieldToMatch:
  Contains Data and Type

"""
function update_sql_injection_match_set(
    ChangeToken,
    SqlInjectionMatchSetId,
    Updates;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "UpdateSqlInjectionMatchSet",
        Dict{String,Any}(
            "ChangeToken" => ChangeToken,
            "SqlInjectionMatchSetId" => SqlInjectionMatchSetId,
            "Updates" => Updates,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_sql_injection_match_set(
    ChangeToken,
    SqlInjectionMatchSetId,
    Updates,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "UpdateSqlInjectionMatchSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChangeToken" => ChangeToken,
                    "SqlInjectionMatchSetId" => SqlInjectionMatchSetId,
                    "Updates" => Updates,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_web_acl(change_token, web_aclid)
    update_web_acl(change_token, web_aclid, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Inserts or deletes ActivatedRule objects in a WebACL. Each Rule
identifies web requests that you want to allow, block, or count. When you update a WebACL,
you specify the following values:   A default action for the WebACL, either ALLOW or BLOCK.
AWS WAF performs the default action if a request doesn't match the criteria in any of the
Rules in a WebACL.   The Rules that you want to add or delete. If you want to replace one
Rule with another, you delete the existing Rule and add the new one.   For each Rule,
whether you want AWS WAF to allow requests, block requests, or count requests that match
the conditions in the Rule.   The order in which you want AWS WAF to evaluate the Rules in
a WebACL. If you add more than one Rule to a WebACL, AWS WAF evaluates each request against
the Rules in order based on the value of Priority. (The Rule that has the lowest value for
Priority is evaluated first.) When a web request matches all the predicates (such as
ByteMatchSets and IPSets) in a Rule, AWS WAF immediately takes the corresponding action,
allow or block, and doesn't evaluate the request against the remaining Rules in the WebACL,
if any.    To create and configure a WebACL, perform the following steps:   Create and
update the predicates that you want to include in Rules. For more information, see
CreateByteMatchSet, UpdateByteMatchSet, CreateIPSet, UpdateIPSet,
CreateSqlInjectionMatchSet, and UpdateSqlInjectionMatchSet.   Create and update the Rules
that you want to include in the WebACL. For more information, see CreateRule and
UpdateRule.   Create a WebACL. See CreateWebACL.   Use GetChangeToken to get the change
token that you provide in the ChangeToken parameter of an UpdateWebACL request.   Submit an
UpdateWebACL request to specify the Rules that you want to include in the WebACL, to
specify the default action, and to associate the WebACL with a CloudFront distribution.
The ActivatedRule can be a rule group. If you specify a rule group as your ActivatedRule ,
you can exclude specific rules from that rule group. If you already have a rule group
associated with a web ACL and want to submit an UpdateWebACL request to exclude certain
rules from that rule group, you must first remove the rule group from the web ACL, the
re-insert it again, specifying the excluded rules. For details, see
ActivatedRuleExcludedRules .    Be aware that if you try to add a RATE_BASED rule to a web
ACL without setting the rule type when first creating the rule, the UpdateWebACL request
will fail because the request tries to add a REGULAR rule (the default rule type) with the
specified ID, which does not exist.  For more information about how to use the AWS WAF API
to allow or block HTTP requests, see the AWS WAF Developer Guide.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `web_aclid`: The WebACLId of the WebACL that you want to update. WebACLId is returned by
  CreateWebACL and by ListWebACLs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DefaultAction"`: A default action for the web ACL, either ALLOW or BLOCK. AWS WAF
  performs the default action if a request doesn't match the criteria in any of the rules in
  a web ACL.
- `"Updates"`: An array of updates to make to the WebACL. An array of WebACLUpdate objects
  that you want to insert into or delete from a WebACL. For more information, see the
  applicable data types:    WebACLUpdate: Contains Action and ActivatedRule
  ActivatedRule: Contains Action, OverrideAction, Priority, RuleId, and Type.
  ActivatedRule|OverrideAction applies only when updating or adding a RuleGroup to a WebACL.
  In this case, you do not use ActivatedRule|Action. For all other update requests,
  ActivatedRule|Action is used instead of ActivatedRule|OverrideAction.     WafAction:
  Contains Type
"""
function update_web_acl(
    ChangeToken, WebACLId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "UpdateWebACL",
        Dict{String,Any}("ChangeToken" => ChangeToken, "WebACLId" => WebACLId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_web_acl(
    ChangeToken,
    WebACLId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "UpdateWebACL",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ChangeToken" => ChangeToken, "WebACLId" => WebACLId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_xss_match_set(change_token, updates, xss_match_set_id)
    update_xss_match_set(change_token, updates, xss_match_set_id, params::Dict{String,<:Any})

 This is AWS WAF Classic documentation. For more information, see AWS WAF Classic in the
developer guide.  For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
WAF Developer Guide. With the latest version, AWS WAF has a single set of endpoints for
regional and global use.   Inserts or deletes XssMatchTuple objects (filters) in an
XssMatchSet. For each XssMatchTuple object, you specify the following values:    Action:
Whether to insert the object into or delete the object from the array. To change an
XssMatchTuple, you delete the existing object and add a new one.    FieldToMatch: The part
of web requests that you want AWS WAF to inspect and, if you want AWS WAF to inspect a
header or custom query parameter, the name of the header or parameter.
TextTransformation: Which text transformation, if any, to perform on the web request before
inspecting the request for cross-site scripting attacks. You can only specify a single type
of TextTransformation.   You use XssMatchSet objects to specify which CloudFront requests
that you want to allow, block, or count. For example, if you're receiving requests that
contain cross-site scripting attacks in the request body and you want to block the
requests, you can create an XssMatchSet with the applicable settings, and then configure
AWS WAF to block the requests.  To create and configure an XssMatchSet, perform the
following steps:   Submit a CreateXssMatchSet request.   Use GetChangeToken to get the
change token that you provide in the ChangeToken parameter of an UpdateIPSet request.
Submit an UpdateXssMatchSet request to specify the parts of web requests that you want AWS
WAF to inspect for cross-site scripting attacks.   For more information about how to use
the AWS WAF API to allow or block HTTP requests, see the AWS WAF Developer Guide.

# Arguments
- `change_token`: The value returned by the most recent call to GetChangeToken.
- `updates`: An array of XssMatchSetUpdate objects that you want to insert into or delete
  from an XssMatchSet. For more information, see the applicable data types:
  XssMatchSetUpdate: Contains Action and XssMatchTuple     XssMatchTuple: Contains
  FieldToMatch and TextTransformation     FieldToMatch: Contains Data and Type
- `xss_match_set_id`: The XssMatchSetId of the XssMatchSet that you want to update.
  XssMatchSetId is returned by CreateXssMatchSet and by ListXssMatchSets.

"""
function update_xss_match_set(
    ChangeToken, Updates, XssMatchSetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return waf(
        "UpdateXssMatchSet",
        Dict{String,Any}(
            "ChangeToken" => ChangeToken,
            "Updates" => Updates,
            "XssMatchSetId" => XssMatchSetId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_xss_match_set(
    ChangeToken,
    Updates,
    XssMatchSetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return waf(
        "UpdateXssMatchSet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChangeToken" => ChangeToken,
                    "Updates" => Updates,
                    "XssMatchSetId" => XssMatchSetId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
