```@meta
CurrentModule = DelaunayTriangulation
```

# Overview 

This section gives some mathematical details for the algorithms in this package. Not all details of the algorithms will be provided in these discussions, only those sufficient for understanding the algorithms themselves. We only discuss a specific set of algorithms in this package where extra mathematical details could be useful. For example, we do not give a section on point location since there the math is reasonably straightforward, as described in the [triangulation section](delaunay.md), and the main complexity is just on getting a working implementation. We do not talk about e.g. how we manually compute convex hulls without a triangulation since they are not a main focus in any part of this package (even though we do provide a function for it). Our discussion in these sections follows several references:

- The book [_Delaunay Mesh Generation_](https://people.eecs.berkeley.edu/~jrs/meshbook.html) by Cheng, Dey, and Shewchuk (2012). This is a great book that discusses in detail the algorithms for Delaunay triangulations and mesh generation.
- The book [_Computational Geometry: Algorithms and Applications_](https://link.springer.com/book/10.1007/978-3-540-77974-2) by de Berg, Cheong, Kreveld, and Overmars (2008, 3d). This book is a great reference for computational geometry in general. 
- The PhD thesis [_Delaunay Refinement Mesh Generation of Curve-bounded Domains_](https://open.library.ubc.ca/media/stream/pdf/24/1.0067778/2) by Serge Gosselin (2009). This thesis discusses the algorithms for mesh refinement in detail, and is the basis of our implementation of mesh refinement for curve-bounded domains. Another good reference for this topic is the PhD thesis [_Delaunay refinement for curved complexes_](https://repositorio.ufmg.br/bitstream/1843/RHCT-7GMJR6/1/adriano_chaves_lisboa.pdf) by Adriano Lisboa (2008).
- The paper [_Triangle: Engineering a 2D quality mesh generator and Delaunay triangulator_](https://link.springer.com/chapter/10.1007/BFb0014497) by Shewchuk (2005) is a great paper discussing constrained Delaunay refinement. Similarly, Shewchuk's [_PhD thesis_](https://www.cs.cmu.edu/~quake-papers/delaunay-refinement.pdf) (1997) is a great reference.
- Shewchuk's paper [_Adaptive precision floating-point arithmetic and fast robust geometric predicates_](https://link.springer.com/article/10.1007/PL00009321) is a good reference regarding the necessity of, and construction of, fast robust geometric predicates, as well as his [_lecture notes_](https://perso.uclouvain.be/jean-francois.remacle/LMECA2170/robnotes.pdf).
- The paper [_Fast segment insertion and incremental construction of constrained Delaunay triangulations_](https://www.sciencedirect.com/science/article/pii/S0925772115000322) by Shewchuk and Brown (2015) is where our implementation of constrained Delaunay triangulations comes from.
- The resource [_A Primer on Bézier Curves_](https://pomax.github.io/bezierinfo/) by Pomax is a great resource for understanding Bézier curves and their properties. Similarly, [_The NURBs Book_](https://link.springer.com/book/10.1007/978-3-642-97385-7) by Piegl and Tiller (1997) is a great reference for implementing BSplines. 
- The website <https://www.mvps.org/directx/articles/catmull/> by Robert Dunlop (last updated 2005) was useful for understanding Catmull Rom splines, as well as <https://qroph.github.io/2018/07/30/smooth-paths-using-catmull-rom-splines.html> by Mika Rananen (2018). Lastly, the notes by Christopher Twigg, <https://www.cs.cmu.edu/~fp/courses/graphics/asst5/catmullRom.pdf>, were helpful.
- The paper [_Fast randomized point location without preprocessing in two- and three-dimensional Delaunay triangulations_](https://doi.org/10.1016/S0925-7721(98)00035-2) by Mücke, Saias, and Zhu (1999) is where our point location algorithm comes from.
- The paper [_Where and how Chew's second Delaunay refinement algorithm works_](http://www.cccg.ca/proceedings/2011/papers/paper91.pdf) by Rand (2011) discusses Chew's algorithm for mesh refinement, originally introduced by Shew in 1993 in [_Guaranteed-quality mesh generation for curved surfaces](https://dl.acm.org/doi/10.1145/160985.161150).
- The paper [_Delaunay refinement by corner lopping_](https://link.springer.com/chapter/10.1007/3-540-29090-7_10) is another good reference for mesh refinement on curved domains.
- The paper [_Guaranteed-quality triangular mesh generation for domains with curved boundaries_](https://onlinelibrary.wiley.com/doi/abs/10.1002/nme.542) was our initial reference for triangulating curved-bounded domains, although now we only source it for ideas on implementing curves generically.
- The resource <https://www.bartoszsypytkowski.com/r-tree/> by Bartosz Sypytkowski was useful for understanding and properly implementing R-Trees, as was the code in [SpatialIndexing.jl](https://github.com/alyst/SpatialIndexing.jl).
- The paper [_Efficient computation of clipped Voronoi diagram for mesh generation_](https://doi.org/10.1016/j.cad.2011.09.004) by Yan, Wang, Lévy, and Liu (2013) is a good reference for clipped Voronoi tessellations.
- The Wikipedia article for the [_Sutherland-Hodgman algorithm_](https://en.wikipedia.org/wiki/Sutherland%E2%80%93Hodgman_algorithm) is a good resource for understanding and implementing it, as is the article for the [_Liang-Barsky algorithm_](https://en.wikipedia.org/wiki/Liang%E2%80%93Barsky_algorithm).