```@meta
CurrentModule = Tulip
```

# Tulip.jl

## Overview

Tulip is an open-source interior-point solver for linear programming.


## Installation

Tulip is 100% Julia, so install it just like any Julia package:
```julia
julia> ]
pkg> add Tulip
```

No additional building step is required.


## Citing `Tulip.jl`

If you use Tulip in your work, we kindly ask that you cite the following reference.
The PDF is freely available [here](https://www.gerad.ca/fr/papers/G-2019-36/view), and serves as a user manual for advanced users.

```
@TechReport{Tulip.jl,
    title = {{Tulip}.jl: an open-source interior-point linear optimization
    solver with abstract linear algebra},
    url = {https://www.gerad.ca/fr/papers/G-2019-36},
    Journal = {Les Cahiers du Gerad},
    Author = {Anjos, Miguel F. and Lodi, Andrea and Tanneau, Mathieu},
    year = {2019}
}
```