/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv.boxes;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jcodec.common.UsedViaReflection;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.containers.mkv.MKVType;
import org.jcodec.containers.mkv.boxes.EbmlMaster;
import org.jcodec.containers.mkv.util.EbmlUtil;
import org.jcodec.platform.Platform;

public abstract class EbmlBase {
    protected EbmlMaster parent;
    public MKVType type;
    public byte[] id;
    public int dataLen = 0;
    public long offset;
    public long dataOffset;
    public int typeSizeLength;

    @UsedViaReflection
    public EbmlBase(byte[] id) {
        this.id = id;
    }

    public boolean equalId(byte[] typeId) {
        return Platform.arrayEqualsByte(this.id, typeId);
    }

    public abstract ByteBuffer getData();

    public long size() {
        return this.dataLen + EbmlUtil.ebmlLength(this.dataLen) + this.id.length;
    }

    public long mux(SeekableByteChannel os) throws IOException {
        ByteBuffer bb = this.getData();
        return os.write(bb);
    }
}

