/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.array.NcArrayLonLatAuxiliary;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLat;
import java.awt.Dimension;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcGridderLonLatAuxiliary
extends NcGridderLonLat {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public NcGridderLonLatAuxiliary() {
        this(100, 50);
    }

    public NcGridderLonLatAuxiliary(Dimension size) {
        this(size.width, size.height);
    }

    public NcGridderLonLatAuxiliary(int w, int h) {
        super(w, h);
    }

    @Override
    public void regridNoInterpolate(NcArray a, double[] target) {
        this.prepareGridAxes();
        NcArrayLonLatAuxiliary nca = (NcArrayLonLatAuxiliary)((Object)a);
        boolean hasBad = a.hasBadValues();
        int numXs = nca.getXAxis().getLength();
        int numYs = nca.getYAxis().getLength();
        for (int j = 0; j < numYs; ++j) {
            for (int i = 0; i < numXs; ++i) {
                double[][] corners;
                double lon0 = nca.longitudeAt(i, j);
                double lat0 = nca.latitudeAt(i, j);
                if (lon0 > 720.0 || lon0 < -720.0 || Double.isNaN(lon0) || lat0 > 90.0 || lat0 < -90.0 || Double.isNaN(lat0)) continue;
                double value = nca.valueAt(i, j);
                if (hasBad && a.isMissingOrInvalid(value) || (corners = nca.cornerLonLats(i, j)) == null) continue;
                double lon1 = corners[0][0];
                double lon2 = corners[1][0];
                double lon3 = corners[2][0];
                double lon4 = corners[3][0];
                double lat1 = corners[0][1];
                double lat2 = corners[1][1];
                double lat3 = corners[2][1];
                double lat4 = corners[3][1];
                this.quadSolidFillLL(lon1, lat1, lon2, lat2, lon3, lat3, lon4, lat4, value, target);
            }
        }
    }

    @Override
    public void regridInterpolate(NcArray a, double[] target) {
        this.prepareGridAxes();
        NcArrayLonLatAuxiliary nca = (NcArrayLonLatAuxiliary)((Object)a);
        int numXs = nca.getXAxis().getLength();
        int numYs = nca.getYAxis().getLength();
        boolean wrapsOnX = this.doesGridWrapOnX(nca);
        boolean wrapsOnY = this.doesGridWrapOnY(nca);
        int lastX = wrapsOnX ? numXs : numXs - 1;
        int lastY = wrapsOnY ? numYs : numYs - 1;
        for (int j = 0; j < lastY; ++j) {
            int jp1 = j < numYs - 1 ? j + 1 : 0;
            for (int i = 0; i < lastX; ++i) {
                int ip1 = i < numXs - 1 ? i + 1 : 0;
                double lat1 = nca.latitudeAt(i, j);
                double lat2 = nca.latitudeAt(ip1, j);
                double lat3 = nca.latitudeAt(ip1, jp1);
                double lat4 = nca.latitudeAt(i, jp1);
                double lon1 = nca.longitudeAt(i, j);
                double lon2 = nca.longitudeAt(ip1, j);
                double lon3 = nca.longitudeAt(ip1, jp1);
                double lon4 = nca.longitudeAt(i, jp1);
                if (Double.isNaN(lat1) || Math.abs(lat1) > 90.0 || Double.isNaN(lat2) || Math.abs(lat2) > 90.0 || Double.isNaN(lat3) || Math.abs(lat3) > 90.0 || Double.isNaN(lat4) || Math.abs(lat4) > 90.0 || lon1 > 720.0 || lon1 < -720.0 || Double.isNaN(lon1) || lon2 > 720.0 || lon2 < -720.0 || Double.isNaN(lon2) || lon3 > 720.0 || lon3 < -720.0 || Double.isNaN(lon3) || lon4 > 720.0 || lon4 < -720.0 || Double.isNaN(lon4)) continue;
                if (lon1 - 90.0 > lon2) {
                    lon2 += 360.0;
                } else if (lon2 - 90.0 > lon1) {
                    lon2 -= 360.0;
                }
                if (lon1 - 90.0 > lon3) {
                    lon3 += 360.0;
                } else if (lon3 - 90.0 > lon1) {
                    lon3 -= 360.0;
                }
                if (lon1 - 90.0 > lon4) {
                    lon4 += 360.0;
                } else if (lon4 - 90.0 > lon1) {
                    lon4 -= 360.0;
                }
                double value1 = nca.valueAt(i, j);
                double value2 = nca.valueAt(ip1, j);
                double value3 = nca.valueAt(ip1, jp1);
                double value4 = nca.valueAt(i, jp1);
                if (Double.isNaN(value2) && Double.isNaN(value3) || Double.isNaN(value3) && Double.isNaN(value4)) continue;
                this.quadInterpolateFillLL(lon1, lat1, value1, lon2, lat2, value2, lon3, lat3, value3, lon4, lat4, value4, target);
            }
        }
    }

    private boolean doesGridWrapOnX(NcArrayLonLatAuxiliary nca) {
        int numXs = nca.getXAxis().getLength();
        int numYs = nca.getYAxis().getLength();
        int lastX = numXs - 1;
        int lastY = numYs - 1;
        for (int j = 0; j < lastY; ++j) {
            boolean abutting = nca.doCellsAbut(lastX, j, 0, j);
            if (abutting) continue;
            return false;
        }
        return true;
    }

    private boolean doesGridWrapOnY(NcArrayLonLatAuxiliary nca) {
        int numXs = nca.getXAxis().getLength();
        int numYs = nca.getYAxis().getLength();
        int lastX = numXs - 1;
        int lastY = numYs - 1;
        for (int i = 0; i < lastX; ++i) {
            boolean abutting = nca.doCellsAbut(i, lastY, i, 0);
            if (abutting) continue;
            return false;
        }
        return true;
    }
}

