/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.ui;

import gov.nasa.giss.data.nc.NcCatalog;
import gov.nasa.giss.data.nc.NcCatalogList;
import gov.nasa.giss.data.nc.NcCatalogNode;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.ui.treetable.TreeTableModel;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcCatalogTreeTableModel
extends TreeTableModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String[] COLUMN_NAMES = new String[]{"Name"};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{TreeTableModel.class};

    public NcCatalogTreeTableModel() {
        super(new NcCatalogList());
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col < 0 || col >= COLUMN_CLASSES.length) {
            LOGGER.trace("col index out of range, {}", (Object)col);
            return null;
        }
        return COLUMN_CLASSES[col];
    }

    @Override
    public int getColumnAlignment(int col) {
        return 2;
    }

    @Override
    public Object getValueAt(TreeTableNode node, int col) {
        if (node == null) {
            return "";
        }
        NcCatalogNode o = (NcCatalogNode)node;
        try {
            switch (col) {
                case 0: {
                    return o.getName();
                }
                case 1: {
                    return o.getClass().toString();
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void setValueAt(Object value, TreeTableNode node, int col) {
    }

    public NcCatalogNode addCatalog(NcCatalog catalog) {
        URI uri = catalog.getURI();
        if (this.containsCatalogWithURI(uri)) {
            throw new NcException("Catalog is already open.");
        }
        NcCatalogList root = (NcCatalogList)this.getRoot();
        root.add(catalog);
        int isize = root.getChildCount();
        this.nodeInserted(root, isize - 1, catalog);
        return catalog;
    }

    public NcCatalog tryCatalogURL(URL url) throws FileNotFoundException, IOException, URISyntaxException {
        URI uri = url.toURI();
        if (this.containsCatalogWithURI(uri)) {
            throw new NcException("Catalog is already open.");
        }
        return new NcCatalog(null, uri);
    }

    public void removeCatalog(NcCatalogNode child) {
        block4: {
            if (!(child instanceof NcCatalog)) {
                return;
            }
            NcCatalogList root = (NcCatalogList)this.getRoot();
            int index = root.getIndex(child);
            if (index < 0) {
                LOGGER.warn("Apparently trying to remove NcCatalogNode which is not child catalog list.");
                return;
            }
            try {
                root.remove(index);
                this.nodeRemoved(root, index, child);
            }
            catch (Exception exc) {
                LOGGER.error("{}", (Object)exc.toString());
                if (!LOGGER.isTraceEnabled()) break block4;
                exc.printStackTrace();
            }
        }
    }

    public NcCatalog catalogWithURI(URI uri) {
        NcCatalogList root = (NcCatalogList)this.getRoot();
        for (TreeTableNode child : root.getChildren()) {
            NcCatalog catalog = (NcCatalog)child;
            if (!uri.equals(catalog.getURI())) continue;
            return catalog;
        }
        return null;
    }

    public boolean containsCatalogWithURI(URI uri) {
        return this.catalogWithURI(uri) != null;
    }
}

