/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.ui;

import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcDatasetList;
import gov.nasa.giss.data.nc.NcVarVisibility;
import gov.nasa.giss.ui.treetable.TreeTableModel;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcDataTreeTableModel
extends TreeTableModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Long Name", "Type"};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{TreeTableModel.class, String.class, String.class};
    private static final int[] COLUMN_ALIGNMENTS = new int[]{2, 2, 0};
    protected NcVarVisibility varVisibility_ = NcVarVisibility.ALL;

    public NcDataTreeTableModel() {
        super(new NcDatasetList());
        this.setVisibleVarClass(NcVarVisibility.ALL);
    }

    @Override
    public int getColumnAlignment(int col) {
        return COLUMN_ALIGNMENTS[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        try {
            return COLUMN_CLASSES[col];
        }
        catch (Exception exc) {
            LOGGER.debug("Exception getting column {} class: {}", (Object)col, (Object)exc.getClass().getSimpleName());
            return String.class;
        }
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    @Override
    public Object getValueAt(TreeTableNode node, int col) {
        NcDataNode ncn = (NcDataNode)node;
        try {
            switch (col) {
                case 0: {
                    return ncn.getName();
                }
                case 1: {
                    return ncn.getLongName();
                }
                case 2: {
                    LOGGER.trace("{}, {}", (Object)ncn.getName(), (Object)ncn.getNcType());
                    return ncn.getNcType();
                }
            }
            LOGGER.debug("Switch default case: How did we get here? {}", (Object)col);
            return null;
        }
        catch (Exception ignore) {
            return null;
        }
    }

    @Override
    public void setValueAt(Object aValue, TreeTableNode node, int col) {
    }

    public NcDataset addDataset(NcDataset ncd) throws IOException {
        LOGGER.trace("dataset {}, url {}", (Object)ncd, (Object)ncd.getAddress());
        NcDataset already = this.datasetWithAddress(ncd.getAddress());
        if (already != null) {
            return already;
        }
        NcDatasetList ndl = (NcDatasetList)this.getRoot();
        ncd.setVisibleVarClass(null, this.varVisibility_);
        int index = ndl.addDataset(ncd, this.varVisibility_);
        this.nodeInserted(ndl, index, ncd);
        return ncd;
    }

    public void removeDataset(NcDataNode child) {
        block4: {
            if (!(child instanceof NcDataset)) {
                return;
            }
            NcDatasetList ndl = (NcDatasetList)this.getRoot();
            int index = ndl.getIndex(child);
            try {
                if (ndl.removeDataset((NcDataset)child)) {
                    this.nodeRemoved(ndl, index, child);
                }
            }
            catch (Exception exc) {
                LOGGER.error(exc.toString());
                if (!LOGGER.isTraceEnabled()) break block4;
                exc.printStackTrace();
            }
        }
    }

    public final void setVisibleVarClass(NcVarVisibility vclass) {
        this.varVisibility_ = vclass;
        NcDatasetList root = (NcDatasetList)this.getRoot();
        root.setVisibleVarClass(this, vclass);
    }

    public NcDataset datasetWithAddress(String address) {
        NcDatasetList root = (NcDatasetList)this.getRoot();
        for (TreeTableNode child : root.getChildren()) {
            NcDataset dataset = (NcDataset)child;
            String daddr = dataset.getAddress();
            if (!daddr.equals(address)) continue;
            return dataset;
        }
        return null;
    }
}

