/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.PointPoleProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Eisenlohr
extends PointPoleProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Eisenlohr";
    public static final int PROPERTIES = 4096;
    private static final double THREE_PLUS_SQRT8 = 3.0 + Math.sqrt(8.0);
    private static final double LOBE_DY = THREE_PLUS_SQRT8 * 0.6848532563722796;
    private static final double MAX_X_OVER_RS = THREE_PLUS_SQRT8 * 1.0656799507071;
    private static final double MAX_Y_OVER_RS = LOBE_DY;

    public Eisenlohr(int width, int height) {
        this(width, height, 0, 0);
    }

    public Eisenlohr(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4096, width, height, xmargin, ymargin, MAX_X_OVER_RS, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double absLambdaRad = Math.abs(lambdaRad);
        double absPhiRad = Math.abs(phiRad);
        double halfLambdaRad = Math.abs(0.5 * absLambdaRad);
        double halfPhiRad = Math.abs(0.5 * absPhiRad);
        double x = 0.0;
        double y = 0.0;
        double cosPhi = Math.cos(absPhiRad);
        double cosPhiOver2 = Math.cos(halfPhiRad);
        double sinPhiOver2 = Math.sin(halfPhiRad);
        double c1 = Math.cos(halfLambdaRad);
        double s1 = Math.sin(halfLambdaRad);
        double tt = sinPhiOver2 / (cosPhiOver2 + Math.sqrt(2.0 * cosPhi) * c1);
        double cc = Math.sqrt(2.0 / (1.0 + tt * tt));
        double pp = Math.sqrt(0.5 * cosPhi);
        double vv = Math.sqrt((cosPhiOver2 + pp * (c1 + s1)) / (cosPhiOver2 + pp * (c1 - s1)));
        double invVV = 1.0 / vv;
        x = THREE_PLUS_SQRT8 * (cc * (vv - invVV) - 2.0 * Math.log(vv));
        y = THREE_PLUS_SQRT8 * (cc * tt * (vv + invVV) - 2.0 * Math.atan(tt));
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (phiRad < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Eisenlohr eisenlohr = this;
        synchronized (eisenlohr) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = Math.abs(y * this.invRS_);
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xOverRS = Math.abs(x * this.invRS_);
                }
            }
        }
    }
}

