/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanToggleToolBarLabelsAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String ACTION_NAME = PanProperties.MENU_PROPS.getString("toggle-toolbar-labels");
    private static final PanPreferences PREFS = PanPreferences.getSharedInstance();
    private boolean busy_;
    private long last_;

    public static synchronized PanToggleToolBarLabelsAction getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanToggleToolBarLabelsAction() {
        super(ACTION_NAME);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.busy_) {
            return;
        }
        this.busy_ = true;
        boolean oldval = PREFS.getBoolean("sources:toolbar.labels");
        long now = System.currentTimeMillis();
        if (now - this.last_ >= 200L) {
            PREFS.setBoolean("sources:toolbar.labels", !oldval);
            PanSourcesFrame.getSharedInstance().refresh();
        }
        GuiUtils.refreshFrontFrameMenuBar();
        this.last_ = now;
        this.busy_ = false;
    }

    private static class Singleton {
        private static final PanToggleToolBarLabelsAction INSTANCE = new PanToggleToolBarLabelsAction();

        private Singleton() {
        }
    }
}

