/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.panoply.data.PanData1D;
import gov.nasa.giss.panoply.data.PanDataTime1D;
import gov.nasa.giss.panoply.plot.PanPlot;
import gov.nasa.giss.panoply.plot.PanPlotConstraints;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanGraphicUtils;
import gov.nasa.giss.panoply.util.PanParamKeys;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanStringUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.lang.invoke.MethodHandles;
import java.text.AttributedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PanLinePlot
extends PanPlot {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected boolean isHorizontal_;
    protected boolean isCompare_;
    protected double lBound_ = -90.0;
    protected double rBound_ = 90.0;
    protected double bBound_;
    protected double tBound_ = 100.0;
    protected double logTop_;
    protected double logBottom_;
    protected double logLeft_;
    protected double logRight_;
    protected PanAxisMethod xaxisMethod_ = PanAxisMethod.SCALAR;
    protected PanAxisMethod yaxisMethod_ = PanAxisMethod.SCALAR;
    protected PanData1D data1D_;
    protected boolean isPatternTimeAxis_;
    protected boolean isLongitudeAxis_;
    protected boolean isLatitudeAxis_;
    protected NcTimeAxis timeAxis_;
    protected boolean includeAxes_;
    protected boolean axesOffset_;
    protected float yAxisX_;
    protected float xAxisY_;
    protected Color[] lineColors_ = new Color[2];
    protected BasicStroke[] lineStrokes_ = new BasicStroke[2];
    protected float sLabelY_;
    protected float sStrokeY_;
    protected Font strokeLabelFont_;
    protected float strokeLabelFhgt_;
    protected boolean[] useCustomStrokeLabel_ = new boolean[2];
    protected String[] customStrokeLabelText_ = new String[2];

    public PanLinePlot(PanPlotMeta pmeta) {
        super(pmeta);
        if (!(this.data_ instanceof PanData1D)) {
            throw new IllegalArgumentException("Data object must be 1D.");
        }
        this.data1D_ = (PanData1D)this.data_;
        this.isHorizontal_ = this.ptype_ == PanPlotType.HORZ_LINE || this.ptype_.isLonLatZonal();
        this.isPatternTimeAxis_ = this.data1D_ instanceof PanDataTime1D;
        NcAxis nca = this.data1D_.getAxis();
        if (this.isPatternTimeAxis_) {
            this.timeAxis_ = (NcTimeAxis)nca;
        } else {
            this.isLongitudeAxis_ = nca.isLongitudeAxis();
            this.isLatitudeAxis_ = nca.isLatitudeAxis();
        }
        this.parameterChangedPrivate("all");
    }

    @Override
    protected void prepareToPaint() {
        super.prepareToPaint();
        int sfactor = this.pmeta_.getInt("size.factor");
        float scaling = 0.01f * (float)sfactor;
        this.includeAxes_ = this.pmeta_.getBoolean("include.axes");
        this.axesOffset_ = this.pmeta_.getBoolean("axes.offset");
        Rectangle mfBounds = this.pmeta_.getLayout().getRect("bounds.figure");
        Dimension gsize = this.pmeta_.getLayout().getDimension("size.gridding");
        Rectangle sBounds = this.pmeta_.getLayout().getRect("bounds.strokeinfo");
        this.gridWidth_ = gsize.width;
        this.gridHeight_ = gsize.height;
        this.gridLeft_ = (float)mfBounds.x + 0.5f * (float)(mfBounds.width - gsize.width);
        this.gridTop_ = mfBounds.y;
        this.gridRight_ = this.gridLeft_ + this.gridWidth_;
        this.gridBottom_ = this.gridTop_ + this.gridHeight_;
        this.gridColor_ = this.getForeground();
        this.tickLengthMajor_ = Math.max(4.0f, scaling * 6.0f);
        this.tickLengthMinor_ = Math.max(2.0f, scaling * 3.0f);
        this.tickLabelOffset_ = Math.max(2.0f, scaling * 3.0f);
        int tickWeight = PanPlotConstraints.constrainAxisTickWeight(this.pmeta_.getInt("axes.tickmark.weight"));
        this.tickStroke_ = this.axesOffset_ && this.includeAxes_ ? PanGraphicUtils.solidStroke(100, sfactor) : PanGraphicUtils.tickStroke((int)(0.01 * (double)tickWeight * (double)sfactor));
        this.yAxisX_ = this.axesOffset_ ? this.gridLeft_ - this.tickLengthMajor_ : this.gridLeft_;
        this.xAxisY_ = this.axesOffset_ ? this.gridBottom_ + this.tickLengthMajor_ : this.gridBottom_;
        this.sLabelY_ = (float)sBounds.y + 0.5f * (float)sBounds.height;
        this.sStrokeY_ = this.sLabelY_ - 0.4f * this.strokeLabelFhgt_;
    }

    @Override
    protected synchronized void paintPiece(Graphics2D gx, boolean printing) {
        Graphics2D g2d = (Graphics2D)gx.create();
        g2d.setColor(this.getForeground());
        g2d.setStroke(this.borderStroke_);
        GraphicUtils.drawRect(g2d, this.gridLeft_, this.gridTop_, this.gridWidth_, this.gridHeight_);
        this.drawXAxis(g2d);
        if (this.includeAxes_) {
            this.drawXAxisLabel(g2d);
        }
        int maxLabelWidth = this.drawYAxis(g2d);
        if (this.includeAxes_) {
            this.drawYAxisLabel(g2d, maxLabelWidth);
        }
        this.drawCurve(g2d);
        this.drawCurveLabels(g2d);
        g2d.dispose();
        this.needsDataRedraw_ = false;
    }

    protected abstract void drawXAxis(Graphics2D var1);

    protected abstract String getXAxisLabelStr();

    protected int drawXAxisTickLabel(Graphics2D g2d, String labelstr, float tickX) {
        String label;
        if (!this.includeAxes_) {
            return 0;
        }
        g2d.setFont(this.xAxisTickFont_);
        g2d.setColor(this.getForeground());
        String string = label = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertENotationToSuperscript(labelstr, g2d) : labelstr;
        if (label == null) {
            return 0;
        }
        float labelWidth = GraphicUtils.stringWidth(label, g2d);
        float x = tickX - 0.5f * labelWidth;
        float y = this.xAxisY_ + 1.5f * this.tickLabelOffset_ + this.xAxisTickFhgt_;
        GraphicUtils.drawString(g2d, (Object)label, x, y);
        return Math.round(labelWidth);
    }

    protected int drawXAxisTickLabelE(Graphics2D g2d, double logValue, float tickX) {
        if (!this.includeAxes_) {
            return 0;
        }
        g2d.setFont(this.xAxisTickFont_);
        g2d.setColor(this.getForeground());
        AttributedString label = PanStringUtils.getSuperscriptedE(logValue, g2d);
        float labelWidth = GraphicUtils.stringWidth(label, g2d);
        float x = tickX - 0.5f * labelWidth;
        float y = this.xAxisY_ + 1.5f * this.tickLabelOffset_ + this.xAxisTickFhgt_;
        GraphicUtils.drawString(g2d, (Object)label, x, y);
        return Math.round(labelWidth);
    }

    protected void drawXAxisLabel(Graphics2D g2d) {
        if (!this.includeAxes_) {
            return;
        }
        String labelstr = this.getXAxisLabelStr();
        if (labelstr == null || labelstr.isEmpty()) {
            return;
        }
        g2d.setColor(this.getForeground());
        g2d.setFont(this.xAxisLabelFont_);
        labelstr = GraphicUtils.trimStringToFit(labelstr, g2d, (int)this.gridWidth_);
        String label = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertCaretNotationToSuperscript(labelstr, g2d) : labelstr;
        int labelWidth = (int)GraphicUtils.stringWidth(label, g2d);
        float x = this.gridLeft_ + 0.5f * (this.gridWidth_ - (float)labelWidth);
        float y = this.xAxisY_ + this.tickLabelOffset_ + this.xAxisTickFhgt_ + 0.33f * this.xAxisTickFhgt_ + this.xAxisLabelFhgt_;
        GraphicUtils.drawString(g2d, (Object)label, x, y);
    }

    protected abstract int drawYAxis(Graphics2D var1);

    protected abstract String getYAxisLabelStr();

    protected int drawYAxisTickLabel(Graphics2D g2d, String labelstr, float tickY) {
        String label;
        if (!this.includeAxes_) {
            return 0;
        }
        g2d.setFont(this.yAxisTickFont_);
        g2d.setColor(this.getForeground());
        String string = label = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertENotationToSuperscript(labelstr, g2d) : labelstr;
        if (label == null) {
            return 0;
        }
        float labelWidth = GraphicUtils.stringWidth(label, g2d);
        float x = this.yAxisX_ - 1.5f * this.tickLabelOffset_ - labelWidth;
        float y = tickY + 0.5f * this.yAxisTickFhgt_ - 1.0f;
        GraphicUtils.drawString(g2d, (Object)label, x, y);
        return Math.round(labelWidth);
    }

    protected int drawYAxisTickLabelE(Graphics2D g2d, double logValue, float tickY) {
        if (!this.includeAxes_) {
            return 0;
        }
        g2d.setFont(this.xAxisTickFont_);
        g2d.setColor(this.getForeground());
        AttributedString label = PanStringUtils.getSuperscriptedE(logValue, g2d);
        float labelWidth = GraphicUtils.stringWidth(label, g2d);
        float x = this.yAxisX_ - 1.5f * this.tickLabelOffset_ - labelWidth;
        float y = tickY + 0.5f * this.yAxisTickFhgt_ - 1.0f;
        GraphicUtils.drawString(g2d, (Object)label, x, y);
        return Math.round(labelWidth);
    }

    protected void drawYAxisLabel(Graphics2D g2d, int maxLabelWidth) {
        if (!this.includeAxes_) {
            return;
        }
        String labelstr = this.getYAxisLabelStr();
        if (labelstr == null || labelstr.isEmpty()) {
            return;
        }
        g2d.setColor(this.getForeground());
        g2d.setFont(this.yAxisLabelFont_);
        labelstr = GraphicUtils.trimStringToFit(labelstr, g2d, (int)this.gridHeight_);
        String label = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertCaretNotationToSuperscript(labelstr, g2d) : labelstr;
        int labelWidth = (int)GraphicUtils.stringWidth(label, g2d);
        float x = this.yAxisX_ - 1.5f * this.tickLabelOffset_ - (float)maxLabelWidth - 0.67f * this.yAxisTickFhgt_;
        float y = this.gridBottom_ - 0.5f * (this.gridHeight_ - (float)labelWidth);
        g2d.translate(x, y);
        g2d.rotate(-1.5707963267948966);
        GraphicUtils.drawString(g2d, (Object)label, 0, 0);
        g2d.rotate(1.5707963267948966);
        g2d.translate(-x, -y);
    }

    protected abstract void drawCurve(Graphics2D var1);

    private void drawCurveLabels(Graphics2D g2d) {
        if (!this.pmeta_.getBoolean("include.strokeinfo")) {
            return;
        }
        int sfactor = this.pmeta_.getInt("size.factor");
        float scaling = 0.01f * (float)sfactor;
        int strokeLength = (int)(scaling * 20.0f);
        int lspace = (int)(scaling * 24.0f);
        g2d.setFont(this.strokeLabelFont_);
        String[] labels = new String[2];
        if (this.isCompare_) {
            String labelstr1 = this.useCustomStrokeLabel_[0] ? this.customStrokeLabelText_[0] : this.data1D_.getVarShortName(0);
            String labelstr2 = this.useCustomStrokeLabel_[1] ? this.customStrokeLabelText_[1] : this.data1D_.getVarShortName(1);
            int maxLWidth = (int)(0.5f * (this.gridWidth_ - 2.0f * (float)lspace));
            int maxTWidth = (int)(0.5f * (this.gridWidth_ - 2.0f * (float)lspace) - (float)lspace);
            labelstr1 = GraphicUtils.trimStringToFit(labelstr1, g2d, maxTWidth);
            labelstr2 = GraphicUtils.trimStringToFit(labelstr2, g2d, maxTWidth);
            int twidth1 = Math.min(maxTWidth, (int)GraphicUtils.stringWidth(labelstr1, g2d));
            int twidth2 = Math.min(maxTWidth, (int)GraphicUtils.stringWidth(labelstr2, g2d));
            int left1 = (int)(this.gridLeft_ + 0.5f * (float)(maxLWidth - twidth1));
            int left2 = (int)(this.gridLeft_ + (float)maxLWidth + (float)lspace + 0.5f * (float)(maxLWidth - twidth2));
            if (labelstr1.length() > 0 && this.lineStrokes_[0] != null) {
                g2d.setColor(this.lineColors_[0]);
                g2d.setStroke(this.lineStrokes_[0]);
                GraphicUtils.drawLine(g2d, left1, this.sStrokeY_, left1 + strokeLength, this.sStrokeY_);
                g2d.setColor(this.getForeground());
                String label1 = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertCaretNotationToSuperscript(labelstr1, g2d) : labelstr1;
                GraphicUtils.drawString(g2d, (Object)label1, (float)(left1 + lspace), this.sLabelY_);
            }
            if (labelstr2.length() > 0 && this.lineStrokes_[1] != null) {
                g2d.setColor(this.lineColors_[1]);
                g2d.setStroke(this.lineStrokes_[1]);
                GraphicUtils.drawLine(g2d, left2, this.sStrokeY_, left2 + strokeLength, this.sStrokeY_);
                g2d.setColor(this.getForeground());
                String label2 = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertCaretNotationToSuperscript(labelstr2, g2d) : labelstr2;
                GraphicUtils.drawString(g2d, (Object)label2, (float)(left2 + lspace), this.sLabelY_);
            }
        } else {
            String labelstr1;
            String string = labelstr1 = this.useCustomStrokeLabel_[0] ? this.customStrokeLabelText_[0] : this.data1D_.getDescription();
            if (labelstr1.length() > 0 && this.lineStrokes_[0] != null) {
                int maxTWidth = (int)(0.75f * this.gridWidth_ - (float)lspace);
                labelstr1 = GraphicUtils.trimStringToFit(labelstr1, g2d, maxTWidth);
                int tlength = Math.min(maxTWidth, (int)GraphicUtils.stringWidth(labelstr1, g2d));
                int totWidth = lspace + tlength;
                int left1 = (int)(this.gridLeft_ + 0.5f * (this.gridWidth_ - (float)totWidth));
                g2d.setColor(this.lineColors_[0]);
                g2d.setStroke(this.lineStrokes_[0]);
                GraphicUtils.drawLine(g2d, left1, this.sStrokeY_, left1 + strokeLength, this.sStrokeY_);
                g2d.setColor(this.getForeground());
                String label1 = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertCaretNotationToSuperscript(labelstr1, g2d) : labelstr1;
                GraphicUtils.drawString(g2d, (Object)label1, (float)(left1 + lspace), this.sLabelY_);
            }
        }
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private void parameterChangedPrivate(String pname) {
        String method;
        String fn;
        boolean changeAll = pname == null || "all".equals(pname);
        int sfactor = this.pmeta_.getInt("size.factor");
        float scaling = 0.01f * (float)sfactor;
        if (changeAll || pname.contains("combination")) {
            String ctype = this.pmeta_.getString("combination");
            this.isCompare_ = PanCombinationType.COMPARE.matches(ctype);
        }
        if (changeAll || pname.contains(PanParamKeys.STROKE_COLOR[0]) || pname.contains(PanParamKeys.STROKE_STYLE[0]) || pname.contains(PanParamKeys.STROKE_WGT[0])) {
            this.lineColors_[0] = this.pmeta_.getColor(PanParamKeys.STROKE_COLOR[0]);
            this.lineStrokes_[0] = PanGraphicUtils.roundStroke(this.pmeta_.getString(PanParamKeys.STROKE_STYLE[0]), this.pmeta_.getInt(PanParamKeys.STROKE_WGT[0]), sfactor);
        }
        if (changeAll || pname.contains(PanParamKeys.STROKE_COLOR[1]) || pname.contains(PanParamKeys.STROKE_STYLE[1]) || pname.contains(PanParamKeys.STROKE_WGT[1])) {
            this.lineColors_[1] = this.pmeta_.getColor(PanParamKeys.STROKE_COLOR[1]);
            this.lineStrokes_[1] = PanGraphicUtils.roundStroke(this.pmeta_.getString(PanParamKeys.STROKE_STYLE[1]), this.pmeta_.getInt(PanParamKeys.STROKE_WGT[1]), sfactor);
        }
        if (changeAll || pname.contains(PanParamKeys.STROKE_LABEL_CUSTOM[0]) || pname.contains(PanParamKeys.STROKE_LABEL_CUSTOM[1]) || pname.contains(PanParamKeys.STROKE_LABEL_TEXT[0]) || pname.contains(PanParamKeys.STROKE_LABEL_TEXT[1])) {
            this.useCustomStrokeLabel_[0] = this.pmeta_.getBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[0]);
            this.useCustomStrokeLabel_[1] = this.pmeta_.getBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[1]);
            this.customStrokeLabelText_[0] = this.pmeta_.getString(PanParamKeys.STROKE_LABEL_TEXT[0]);
            this.customStrokeLabelText_[1] = this.pmeta_.getString(PanParamKeys.STROKE_LABEL_TEXT[1]);
        }
        if (changeAll || pname.contains("grid.style") || pname.contains("grid.weight")) {
            int gridWeight = PanPlotConstraints.constrainGridWeight(this.pmeta_.getInt("grid.weight"));
            String gs = this.pmeta_.getString("grid.style");
            this.gridStroke_ = gridWeight > 0 ? PanGraphicUtils.buttMiterStroke(gs, gridWeight, sfactor) : null;
        }
        if (changeAll || pname.contains("border.weight")) {
            int weight = PanPlotConstraints.constrainBorderWeight(this.pmeta_.getInt("border.weight"));
            this.borderStroke_ = PanGraphicUtils.solidStroke(weight, sfactor);
        }
        if (changeAll || pname.contains("color.background")) {
            this.setBackground(this.pmeta_.getColor("color.background"));
        }
        if (changeAll || pname.contains("interpolate") || pname.contains("scale.method")) {
            this.needsDataRedraw_ = true;
        }
        if (changeAll || pname.contains("labels.font") || pname.contains("size.factor") || pname.contains("stroke.label.size")) {
            fn = this.pmeta_.getString("labels.font");
            this.strokeLabelFhgt_ = scaling * PanPlotConstraints.constrainStrokeLabelSize(this.pmeta_.getFloat("stroke.label.size"));
            this.strokeLabelFont_ = PanGraphicUtils.getFont(fn, this.strokeLabelFhgt_);
            LOGGER.trace("label fhgt {}", (Object)Float.valueOf(this.strokeLabelFhgt_));
        }
        if (changeAll || pname.contains("labels.font") || pname.contains("size.factor") || pname.contains("scale.tick.size") || pname.contains("scale.label.size") || pname.contains("xaxis.label.size") || pname.contains("yaxis.label.size") || pname.contains("xaxis.tick.size") || pname.contains("yaxis.tick.size")) {
            fn = this.pmeta_.getString("labels.font");
            if (this.isHorizontal_) {
                this.xAxisLabelFhgt_ = scaling * PanPlotConstraints.constrainAxisLabelSize(this.pmeta_.getFloat("xaxis.label.size"));
                this.xAxisTickFhgt_ = scaling * PanPlotConstraints.constrainAxisTickLabelSize(this.pmeta_.getFloat("xaxis.tick.size"));
                this.yAxisLabelFhgt_ = scaling * PanPlotConstraints.constrainAxisLabelSize(this.pmeta_.getFloat("scale.label.size"));
                this.yAxisTickFhgt_ = scaling * PanPlotConstraints.constrainAxisTickLabelSize(this.pmeta_.getFloat("scale.tick.size"));
            } else {
                this.xAxisLabelFhgt_ = scaling * PanPlotConstraints.constrainAxisLabelSize(this.pmeta_.getFloat("scale.label.size"));
                this.xAxisTickFhgt_ = scaling * PanPlotConstraints.constrainAxisTickLabelSize(this.pmeta_.getFloat("scale.tick.size"));
                this.yAxisLabelFhgt_ = scaling * PanPlotConstraints.constrainAxisLabelSize(this.pmeta_.getFloat("yaxis.label.size"));
                this.yAxisTickFhgt_ = scaling * PanPlotConstraints.constrainAxisTickLabelSize(this.pmeta_.getFloat("yaxis.tick.size"));
            }
            this.xAxisLabelFont_ = PanGraphicUtils.getFont(fn, this.xAxisLabelFhgt_);
            this.yAxisLabelFont_ = PanGraphicUtils.getFont(fn, this.yAxisLabelFhgt_);
            this.xAxisTickFont_ = PanGraphicUtils.getFont(fn, this.xAxisTickFhgt_);
            this.yAxisTickFont_ = PanGraphicUtils.getFont(fn, this.yAxisTickFhgt_);
        }
        if (changeAll || pname.contains("xaxis.begin") || pname.contains("xaxis.end") || pname.contains("xaxis.method") || pname.contains("xaxis.units")) {
            this.lBound_ = this.pmeta_.getDouble("xaxis.begin");
            this.rBound_ = this.pmeta_.getDouble("xaxis.end");
            method = this.pmeta_.getString("xaxis.method");
            this.xaxisMethod_ = PanAxisMethod.matching(method);
            switch (this.xaxisMethod_) {
                case LOG10: {
                    this.logLeft_ = Math.log10(this.lBound_);
                    this.logRight_ = Math.log10(this.rBound_);
                    break;
                }
                default: {
                    this.logLeft_ = 0.0;
                    this.logRight_ = 0.0;
                }
            }
            this.needsDataRedraw_ = true;
        }
        if (changeAll || pname.contains("xaxis.div.major") || pname.contains("xaxis.div.minor")) {
            this.xMajorDiv_ = PanPlotConstraints.constrainAxisDivs(this.pmeta_.getInt("xaxis.div.major"));
            this.xMinorDiv_ = PanPlotConstraints.constrainAxisDivs(this.pmeta_.getInt("xaxis.div.minor"));
        }
        if (changeAll || pname.contains("xaxis.label.custom") || pname.contains("xaxis.label.text")) {
            this.xAxisLabelText_ = this.pmeta_.getBoolean("xaxis.label.custom") ? this.pmeta_.getString("xaxis.label.text") : null;
        }
        if (changeAll || pname.contains("yaxis.begin") || pname.contains("yaxis.end") || pname.contains("yaxis.method") || pname.contains("yaxis.units")) {
            this.bBound_ = this.pmeta_.getDouble("yaxis.begin");
            this.tBound_ = this.pmeta_.getDouble("yaxis.end");
            method = this.pmeta_.getString("yaxis.method");
            this.yaxisMethod_ = PanAxisMethod.matching(method);
            switch (this.yaxisMethod_) {
                case LOG10: {
                    this.logTop_ = Math.log10(this.tBound_);
                    this.logBottom_ = Math.log10(this.bBound_);
                    break;
                }
                default: {
                    this.logTop_ = 0.0;
                    this.logBottom_ = 0.0;
                }
            }
            this.needsDataRedraw_ = true;
        }
        if (changeAll || pname.contains("yaxis.div.major") || pname.contains("yaxis.div.minor")) {
            this.yMajorDiv_ = PanPlotConstraints.constrainAxisDivs(this.pmeta_.getInt("yaxis.div.major"));
            this.yMinorDiv_ = PanPlotConstraints.constrainAxisDivs(this.pmeta_.getInt("yaxis.div.minor"));
        }
        if (changeAll || pname.contains("yaxis.label.custom") || pname.contains("yaxis.label.text")) {
            this.yAxisLabelText_ = this.pmeta_.getBoolean("yaxis.label.custom") ? this.pmeta_.getString("yaxis.label.text") : null;
        }
        if (changeAll || pname.contains("scale.div.major") || pname.contains("scale.div.minor") || pname.contains("scale.tick.format") || pname.contains("scale.label.custom") || pname.contains("scale.label.text") || pname.contains("scale.units")) {
            // empty if block
        }
    }
}

