/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.sources;

import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcStructure;
import gov.nasa.giss.data.nc.NcStructureMember;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.panoply.action.PanCreatePlotAction;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.util.PanActionHash;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.util.PropertyList;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PanDnVPopup
extends JPopupMenu {
    private static final PropertyList POPUP_PROPS = PanProperties.POPUP_PROPS;
    private final AbstractAction createPlotAction_;
    private final AbstractAction exportCdlAction_;
    private final AbstractAction exportCsvAction_;
    private final AbstractAction exportTextAction_;
    private final AbstractAction closeDatasetAction_;
    private final PanSourcesFrame parent_;

    public PanDnVPopup(PanSourcesFrame parent) {
        this.parent_ = parent;
        final PanActionHash actionHash = this.parent_.getActionHash();
        this.createPlotAction_ = new AbstractAction(POPUP_PROPS.getString("create-plot")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PanCreatePlotAction)actionHash.get("create-plot")).createPlot(null);
            }
        };
        this.add(new JMenuItem(this.createPlotAction_));
        this.addSeparator();
        this.exportCdlAction_ = new AbstractAction(POPUP_PROPS.getString("export-cdl")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Action)actionHash.get("export-cdl")).actionPerformed(null);
            }
        };
        this.add(new JMenuItem(this.exportCdlAction_));
        this.exportCsvAction_ = new AbstractAction(POPUP_PROPS.getString("export-csv")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Action)actionHash.get("export-csv")).actionPerformed(null);
            }
        };
        this.add(new JMenuItem(this.exportCsvAction_));
        this.exportTextAction_ = new AbstractAction(POPUP_PROPS.getString("export-text")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Action)actionHash.get("export-text")).actionPerformed(null);
            }
        };
        this.add(new JMenuItem(this.exportTextAction_));
        this.addSeparator();
        this.closeDatasetAction_ = new AbstractAction(POPUP_PROPS.getString("remove-one")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Action)actionHash.get("remove-one")).actionPerformed(null);
            }
        };
        this.add(new JMenuItem(this.closeDatasetAction_));
    }

    void refresh(NcDataNode node) {
        this.createPlotAction_.setEnabled(false);
        this.exportCdlAction_.setEnabled(false);
        this.exportCsvAction_.setEnabled(false);
        this.exportTextAction_.setEnabled(false);
        this.closeDatasetAction_.setEnabled(false);
        if (node == null) {
            return;
        }
        if (node instanceof NcDataset) {
            this.exportCdlAction_.setEnabled(true);
            this.closeDatasetAction_.setEnabled(true);
            return;
        }
        if (node instanceof NcStructure) {
            return;
        }
        if (node instanceof NcStructureMember) {
            return;
        }
        if (!(node instanceof NcVariable)) {
            return;
        }
        this.exportCdlAction_.setEnabled(true);
        this.exportCsvAction_.setEnabled(true);
        this.exportTextAction_.setEnabled(true);
        NcVariable ncv = (NcVariable)node;
        if (ncv.isGriddable()) {
            this.createPlotAction_.setEnabled(true);
        }
    }
}

