/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import gov.nasa.giss.time.TimeUnits;
import java.text.DecimalFormat;

public final class HourFormatter {
    private static final DecimalFormat FORMAT_10 = new DecimalFormat("0");
    private static final DecimalFormat FORMAT_20 = new DecimalFormat("00");
    private static final DecimalFormat FORMAT_30 = new DecimalFormat("000");

    public static String format(double hours, TimeUnits smallest) {
        return HourFormatter.format(hours, smallest, null, null);
    }

    public static String format(double hours, TimeUnits smallest, String prefix, String suffix) {
        double mins = (hours - Math.floor(hours)) * 60.0;
        double secs = (mins - Math.floor(mins)) * 60.0;
        double millis = (secs - Math.floor(secs)) * 1000.0;
        return HourFormatter.format((int)hours, (int)mins, (int)secs, (int)millis, smallest, prefix, suffix);
    }

    public static String format(int hours, int minutes, int seconds, int millis, TimeUnits smallest, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder().append(FORMAT_20.format(hours));
        if (smallest != TimeUnits.HOURS) {
            sb.append(':').append(FORMAT_20.format(minutes));
            if (smallest != TimeUnits.MINUTES) {
                sb.append(':').append(FORMAT_20.format(seconds));
                if (smallest == TimeUnits.TENTHS) {
                    int t = millis / 100;
                    sb.append('.').append(FORMAT_10.format(t));
                } else if (smallest == TimeUnits.HUNDREDTHS) {
                    int t = millis / 10;
                    sb.append('.').append(FORMAT_20.format(t));
                } else if (smallest == TimeUnits.MILLIS) {
                    sb.append('.').append(FORMAT_30.format(millis));
                }
            }
        }
        if (prefix != null) {
            sb.insert(0, " ").insert(0, prefix);
        }
        if (suffix != null) {
            sb.append(' ').append(suffix);
        }
        return sb.toString();
    }

    private HourFormatter() {
    }
}

