/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui;

import gov.nasa.giss.ui.SizeVariant;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JComboBox;

public class FontComboBox
extends JComboBox<String> {
    private static ArrayList<String> fnames_;

    private FontComboBox() {
    }

    public static FontComboBox create() {
        return FontComboBox.create(SizeVariant.REGULAR);
    }

    public static FontComboBox create(String ... fnames) {
        FontComboBox fcb = new FontComboBox();
        for (String fname : fnames) {
            fcb.addItem(fname);
        }
        return fcb;
    }

    public static FontComboBox create(SizeVariant size) {
        if (fnames_ == null) {
            FontComboBox.initList();
        }
        return FontComboBox.create(fnames_.toArray(new String[0]));
    }

    private static void initList() {
        String[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(Locale.getDefault());
        fnames_ = new ArrayList(names.length);
        for (String name : names) {
            if (!Character.isLetter(name.charAt(0))) continue;
            fnames_.add(name);
        }
    }
}

