/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.menu;

import gov.nasa.giss.ui.menu.GissMenuItem;
import gov.nasa.giss.ui.menu.GissRadioButtonMenuItem;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class GissMenuUtils {
    public static GissMenuItem makeItem(String name, String text, String ksdesc, AbstractAction a) {
        KeyStroke ks;
        Objects.requireNonNull(text, "Menu item text cannot be null");
        GissMenuItem mi = new GissMenuItem(a);
        mi.setText(text);
        if (name != null) {
            mi.setName(name);
        } else {
            mi.setName("_" + text);
        }
        if (ksdesc != null && (ks = KeyStroke.getKeyStroke(ksdesc)) != null) {
            mi.setAccelerator(ks);
        }
        return mi;
    }

    public static GissRadioButtonMenuItem makeRadioButtonItem(String text, AbstractAction a) {
        GissRadioButtonMenuItem mi = GissRadioButtonMenuItem.createItem(text, a);
        mi.setName("_" + text);
        return mi;
    }

    private GissMenuUtils() {
    }
}

