/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.panel;

import gov.nasa.giss.ui.panel.PanelSectionHeader;
import gov.nasa.giss.ui.panel.PanelSectionHeaderMouseListener;
import gov.nasa.giss.ui.panel.PseudoPalette;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.lang.invoke.MethodHandles;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanelSection
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanelSectionHeader header_;
    private JComponent content_;
    private boolean expanded_;

    public PanelSection(String title, JComponent content) {
        this.content_ = content;
        this.header_ = new PanelSectionHeader(title);
        this.setBorder(null);
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        super.add(this.header_);
        this.setContent(content);
        this.setExpanded(content != null);
        this.header_.addMouseListener(new PanelSectionHeaderMouseListener(this));
    }

    PanelSectionHeader getHeader() {
        return this.header_;
    }

    public void setTitle(String title) {
        this.header_.setTitle(title);
    }

    public boolean hasContent() {
        return this.content_ != null;
    }

    public void setContent(JComponent content) {
        if (this.content_ != null) {
            super.remove(this.content_);
        }
        this.content_ = content;
        if (content == null) {
            this.setExpanded(false);
            this.header_.setEnabled(false);
        } else {
            super.add(content);
            this.header_.setEnabled(true);
        }
    }

    public void toggleExpanded() {
        this.setExpanded(!this.expanded_);
    }

    public boolean isExpanded() {
        return this.expanded_;
    }

    public void setExpanded(boolean expanded) {
        if (this.content_ == null && expanded) {
            LOGGER.trace("Cannot expand because content is null.");
            return;
        }
        this.expanded_ = expanded;
        this.header_.setExpanded(this.expanded_);
        if (this.content_ != null) {
            this.content_.setVisible(this.expanded_);
        }
        this.revalidateSelfAndAncestors();
        this.firePropertyChange("expanded", (Object)(!expanded ? 1 : 0), (Object)expanded);
    }

    protected void revalidateSelfAndAncestors() {
        Container cc = this;
        while (true) {
            ((Component)cc).setPreferredSize(null);
            cc.setSize(((Component)cc).getPreferredSize());
            Container parent = cc.getParent();
            if (parent == null) {
                ((Component)cc).revalidate();
                cc.repaint();
                break;
            }
            if (parent instanceof Window || parent instanceof PseudoPalette) {
                parent.setPreferredSize(null);
                parent.setSize(parent.getPreferredSize());
                parent.revalidate();
                parent.repaint();
                break;
            }
            cc = parent;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Insets ins = this.getInsets();
        Dimension hsize = this.header_.getPreferredSize();
        Dimension cpref = this.content_ != null ? this.content_.getPreferredSize() : new Dimension(0, 0);
        int minw = Math.max(cpref.width, hsize.width);
        if (this.expanded_) {
            return new Dimension(minw + ins.left + ins.right, hsize.height + cpref.height + ins.top + ins.bottom);
        }
        return new Dimension(minw + ins.left + ins.right, hsize.height + 2 + ins.top + ins.bottom);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = new Dimension(this.getPreferredSize());
        d.width = 4000;
        return d;
    }

    @Override
    public void doLayout() {
        Insets ins = this.getInsets();
        int cww = this.getSize().width - ins.left - ins.right;
        this.header_.setBounds(ins.left, ins.top, cww, this.header_.getPreferredSize().height);
        if (this.content_ != null) {
            int ww = Math.min(cww, this.content_.getPreferredSize().width);
            this.content_.setBounds(ins.left, ins.top + this.header_.getPreferredSize().height, ww, this.content_.getPreferredSize().height);
        }
        super.doLayout();
    }
}

