/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.g2d.GraphicContext;
import io.sf.carte.echosvg.svggen.DOMGroupManager;
import io.sf.carte.echosvg.svggen.ErrorConstants;
import io.sf.carte.echosvg.svggen.ExtensionHandler;
import io.sf.carte.echosvg.svggen.SVGBufferedImageOp;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGGraphicContext;
import io.sf.carte.echosvg.svggen.SVGGraphicContextConverter;
import io.sf.carte.echosvg.svggen.SVGGraphics2DRuntimeException;
import io.sf.carte.echosvg.svggen.SVGSyntax;
import io.sf.carte.echosvg.svggen.StyleHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DOMTreeManager
implements SVGSyntax,
ErrorConstants {
    int maxGCOverrides;
    private final List<DOMGroupManager> groupManagers = Collections.synchronizedList(new ArrayList());
    private List<Element> genericDefSet = new LinkedList<Element>();
    SVGGraphicContext defaultGC;
    private Element topLevelGroup;
    private SVGGraphicContextConverter gcConverter;
    private SVGGeneratorContext generatorContext;
    private SVGBufferedImageOp filterConverter;
    private List<Element> otherDefs;

    public DOMTreeManager(GraphicContext gc, SVGGeneratorContext generatorContext, int maxGCOverrides) {
        if (gc == null) {
            throw new SVGGraphics2DRuntimeException("gc should not be null");
        }
        if (maxGCOverrides <= 0) {
            throw new SVGGraphics2DRuntimeException("maxGcOverrides should be greater than zero");
        }
        if (generatorContext == null) {
            throw new SVGGraphics2DRuntimeException("generatorContext should not be null");
        }
        this.generatorContext = generatorContext;
        this.maxGCOverrides = maxGCOverrides;
        this.recycleTopLevelGroup();
        this.defaultGC = this.gcConverter.toSVG(gc);
    }

    public void addGroupManager(DOMGroupManager groupManager) {
        if (groupManager != null) {
            this.groupManagers.add(groupManager);
        }
    }

    public void removeGroupManager(DOMGroupManager groupManager) {
        if (groupManager != null) {
            this.groupManagers.remove(groupManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendGroup(Element group, DOMGroupManager groupManager) {
        this.topLevelGroup.appendChild(group);
        List<DOMGroupManager> list = this.groupManagers;
        synchronized (list) {
            for (DOMGroupManager gm : this.groupManagers) {
                if (gm == groupManager) continue;
                gm.recycleCurrentGroup();
            }
        }
    }

    protected void recycleTopLevelGroup() {
        this.recycleTopLevelGroup(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycleTopLevelGroup(boolean recycleConverters) {
        List<DOMGroupManager> list = this.groupManagers;
        synchronized (list) {
            for (DOMGroupManager gm : this.groupManagers) {
                gm.recycleCurrentGroup();
            }
        }
        this.topLevelGroup = this.generatorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "g");
        if (recycleConverters) {
            this.filterConverter = new SVGBufferedImageOp(this.generatorContext);
            this.gcConverter = new SVGGraphicContextConverter(this.generatorContext);
        }
    }

    public void setTopLevelGroup(Element topLevelGroup) {
        if (topLevelGroup == null) {
            throw new SVGGraphics2DRuntimeException("topLevelGroup should not be null");
        }
        if (!"g".equalsIgnoreCase(topLevelGroup.getTagName())) {
            throw new SVGGraphics2DRuntimeException("topLevelGroup should be a group <g>");
        }
        this.recycleTopLevelGroup(false);
        this.topLevelGroup = topLevelGroup;
    }

    public Element getRoot() {
        return this.getRoot(null);
    }

    public Element getRoot(Element svgElement) {
        Element svg = svgElement;
        if (svg == null) {
            svg = this.generatorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "svg");
        }
        if (this.gcConverter.getCompositeConverter().getAlphaCompositeConverter().requiresBackgroundAccess()) {
            svg.setAttributeNS(null, "enable-background", "new");
        }
        if (this.generatorContext.getComment() != null) {
            Comment generatorComment = this.generatorContext.getDOMFactory().createComment(this.generatorContext.getComment());
            svg.appendChild(generatorComment);
        }
        this.applyDefaultRenderingStyle(svg);
        svg.appendChild(this.getGenericDefinitions());
        svg.appendChild(this.getTopLevelGroup());
        return svg;
    }

    public void applyDefaultRenderingStyle(Element element) {
        Map<String, String> groupDefaults = this.defaultGC.getGroupContext();
        this.generatorContext.getStyleHandler().setStyle(element, groupDefaults, this.generatorContext);
    }

    public Element getGenericDefinitions() {
        Element genericDefs = this.generatorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "defs");
        for (Element aGenericDefSet : this.genericDefSet) {
            genericDefs.appendChild(aGenericDefSet);
        }
        genericDefs.setAttributeNS(null, "id", "genericDefs");
        return genericDefs;
    }

    public ExtensionHandler getExtensionHandler() {
        return this.generatorContext.getExtensionHandler();
    }

    void setExtensionHandler(ExtensionHandler extensionHandler) {
        this.generatorContext.setExtensionHandler(extensionHandler);
    }

    public List<Element> getDefinitionSet() {
        List<Element> defSet = this.gcConverter.getDefinitionSet();
        defSet.removeAll(this.genericDefSet);
        defSet.addAll(this.filterConverter.getDefinitionSet());
        if (this.otherDefs != null) {
            defSet.addAll(this.otherDefs);
            this.otherDefs = null;
        }
        this.filterConverter = new SVGBufferedImageOp(this.generatorContext);
        this.gcConverter = new SVGGraphicContextConverter(this.generatorContext);
        return defSet;
    }

    public void addOtherDef(Element definition) {
        if (this.otherDefs == null) {
            this.otherDefs = new LinkedList<Element>();
        }
        this.otherDefs.add(definition);
    }

    public Element getTopLevelGroup() {
        boolean includeDefinitionSet = true;
        return this.getTopLevelGroup(includeDefinitionSet);
    }

    public Element getTopLevelGroup(boolean includeDefinitionSet) {
        List<Element> defSet;
        Element topLevelGroup = this.topLevelGroup;
        if (includeDefinitionSet && (defSet = this.getDefinitionSet()).size() > 0) {
            Element defElement = null;
            NodeList defsElements = topLevelGroup.getElementsByTagName("defs");
            if (defsElements.getLength() > 0) {
                defElement = (Element)defsElements.item(0);
            }
            if (defElement == null) {
                defElement = this.generatorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "defs");
                defElement.setAttributeNS(null, "id", this.generatorContext.getIDGenerator().generateID("defs"));
                topLevelGroup.insertBefore(defElement, topLevelGroup.getFirstChild());
            }
            for (Element aDefSet : defSet) {
                defElement.appendChild(aDefSet);
            }
        }
        this.recycleTopLevelGroup(false);
        return topLevelGroup;
    }

    public SVGBufferedImageOp getFilterConverter() {
        return this.filterConverter;
    }

    public SVGGraphicContextConverter getGraphicContextConverter() {
        return this.gcConverter;
    }

    SVGGeneratorContext getGeneratorContext() {
        return this.generatorContext;
    }

    Document getDOMFactory() {
        return this.generatorContext.getDOMFactory();
    }

    StyleHandler getStyleHandler() {
        return this.generatorContext.getStyleHandler();
    }
}

