/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.text.PrintfFormat;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.VariableDS;
import ucar.units.Unit;

public abstract class NcArray {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final NcDataset dataset_;
    protected final NcVariable ncvar_;
    protected final VariableDS njvarDS_;
    protected int rank_;
    protected int[] shape_;
    protected Array slice_;
    protected Index sliceIdx_;
    private boolean hasInvalid_;
    private boolean hasMissing_;
    private boolean hasFill_;
    protected NcDimension[] dimensions_;
    protected int[] sIndex_;
    protected boolean needsSlice_ = true;
    protected double minimum_ = Double.NaN;
    protected double maximum_ = Double.NaN;
    protected boolean needsExtrema_ = true;

    public NcArray(NcVariable ncvar) throws NcException {
        Objects.requireNonNull(ncvar, "Variable cannot be null.");
        this.ncvar_ = ncvar;
        this.dataset_ = ncvar.getDataset();
        this.njvarDS_ = (VariableDS)ncvar.getObject();
        LOGGER.trace("ncvar   {}", (Object)this.ncvar_);
        LOGGER.trace("class   {}", (Object)this.ncvar_.getClass().getSimpleName());
        LOGGER.trace("njpath  {}", (Object)this.ncvar_.getNjPath());
        LOGGER.trace("njvarDS {}", (Object)this.njvarDS_.getShortName());
        this.rank_ = this.ncvar_.getRank();
        this.shape_ = this.ncvar_.getShape();
        this.sIndex_ = new int[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            this.sIndex_[i] = 0;
        }
        this.hasInvalid_ = this.njvarDS_.hasMissing();
        this.hasMissing_ = this.njvarDS_.hasMissingValue();
        this.hasFill_ = this.njvarDS_.hasFillValue();
        double validMin = this.njvarDS_.getValidMin();
        double validMax = this.njvarDS_.getValidMax();
        DataType datatype = this.njvarDS_.getDataType();
        boolean isInteger = datatype.isIntegral();
        boolean hasScaleOffset = this.njvarDS_.hasScaleOffset();
        LOGGER.trace("bad {}, missing {}, fill {}", this.hasInvalid_, this.hasMissing_, this.hasFill_);
        LOGGER.trace("valid min {}, max {}", (Object)validMin, (Object)validMax);
        LOGGER.trace("integer {}, scaleOffset {}", (Object)isInteger, (Object)hasScaleOffset);
    }

    public NcVariable getNcVariable() {
        return this.ncvar_;
    }

    protected int findDimensionIndex(String dimName) {
        if (dimName == null || dimName.isEmpty()) {
            return -1;
        }
        return this.njvarDS_.findDimensionIndex(dimName);
    }

    protected int findDimensionIndex(VariableDS dimvar) {
        Attribute aa;
        Objects.requireNonNull(dimvar, "Dimension variable cannot be null.");
        String ddFullName = dimvar.getFullName();
        String ddShortName = dimvar.getShortName();
        int vi = this.findDimensionIndex(ddFullName);
        if (vi >= 0) {
            return vi;
        }
        if (vi < 0 && (aa = dimvar.findAttribute("_CoordinateAliasForDimension")) != null) {
            String aname = aa.getStringValue();
            vi = this.njvarDS_.findDimensionIndex(aname);
        }
        if (vi >= 0) {
            LOGGER.trace("-- _CoordinateAliasForDimension matched for dim {}", (Object)vi);
            return vi;
        }
        if (dimvar.getRank() != 1) {
            LOGGER.trace("-- Dim var does not have rank 1");
        }
        Dimension dd = dimvar.getDimension(0);
        int ddLength = dd.getLength();
        for (int i = 0; i < this.ncvar_.getRank(); ++i) {
            Dimension d = this.njvarDS_.getDimension(i);
            if (d.equals(dd)) {
                LOGGER.trace("-- Objects matched for dim {}", (Object)i);
                return i;
            }
            if (d.getLength() != ddLength || !d.getShortName().equals(ddShortName)) continue;
            LOGGER.trace("-- Short name and lengths matched for dim {}", (Object)i);
            return i;
        }
        return vi;
    }

    protected abstract void createFreeDimensions();

    public boolean hasFreeDimensions() {
        if (this.dimensions_ == null) {
            this.createFreeDimensions();
        }
        for (int i = 0; i < this.rank_; ++i) {
            if (this.dimensions_[i] == null) continue;
            return true;
        }
        return false;
    }

    public NcDimension[] getFreeDimensions() {
        if (this.dimensions_ == null) {
            this.createFreeDimensions();
        }
        return this.dimensions_;
    }

    public int getDimensionId(NcDimension dim) {
        Objects.requireNonNull(dim, "NcDimension cannot be null.");
        if (this.dimensions_ == null) {
            this.createFreeDimensions();
        }
        for (int i = 0; i < this.rank_; ++i) {
            if (this.dimensions_[i] == null || this.dimensions_[i] != dim) continue;
            return i;
        }
        return -1;
    }

    public boolean isAveragingDimension(int dimIndex) {
        return false;
    }

    public boolean hasBadValues() {
        return this.hasInvalid_;
    }

    public boolean isMissingOrInvalid(double value) {
        if (Double.isNaN(value)) {
            return true;
        }
        if (this.hasMissing_ && this.njvarDS_.isMissingValue(value)) {
            return true;
        }
        return this.hasInvalid_ && this.njvarDS_.isMissing(value);
    }

    public double minimumValue() throws NcException {
        if (this.needsExtrema_) {
            this.findExtrema();
        }
        return this.minimum_;
    }

    public double maximumValue() throws NcException {
        if (this.needsExtrema_) {
            this.findExtrema();
        }
        return this.maximum_;
    }

    protected double[] getActualRangeAttrValues() {
        Array rarray;
        double[] rvalues;
        Attribute rangeA = this.njvarDS_.findAttribute("actual_range");
        LOGGER.trace("Has actual_range attrib: {}", (Object)(rangeA != null ? 1 : 0));
        if (rangeA == null) {
            return null;
        }
        if (rangeA.isArray() && (rvalues = (double[])(rarray = rangeA.getValues()).get1DJavaArray(DataType.DOUBLE)).length == 2) {
            return rvalues;
        }
        return null;
    }

    protected void findExtrema() {
        this.minimum_ = Double.POSITIVE_INFINITY;
        this.maximum_ = Double.NEGATIVE_INFINITY;
        try {
            this.findExtremaImpl();
        }
        catch (Exception exc) {
            LOGGER.debug("Exc scanning values: {}", (Object)exc.getMessage());
        }
        if (Double.isInfinite(this.minimum_)) {
            this.minimum_ = Double.NaN;
            this.maximum_ = Double.NaN;
        }
        this.needsExtrema_ = false;
    }

    protected abstract void findExtremaImpl();

    protected void findExtremaTestValue(double value) {
        if (this.isMissingOrInvalid(value) || Double.isInfinite(value)) {
            return;
        }
        if (this.maximum_ < this.minimum_) {
            this.minimum_ = value;
            this.maximum_ = value;
        } else if (value < this.minimum_) {
            this.minimum_ = value;
        } else if (value > this.maximum_) {
            this.maximum_ = value;
        }
    }

    public int getSliceIndex(int dimNum) {
        if (dimNum < 0 || dimNum >= this.shape_.length) {
            throw new IndexOutOfBoundsException("Invalid dimension ID");
        }
        return this.sIndex_[dimNum];
    }

    public void setSliceIndex(int dimNum, int index) {
        if (dimNum < 0 || dimNum >= this.shape_.length) {
            throw new IndexOutOfBoundsException("Invalid dimension ID");
        }
        if (index < 0 && !this.isAveragingDimension(dimNum)) {
            throw new IndexOutOfBoundsException("Invalid index.");
        }
        if (this.sIndex_[dimNum] != index) {
            this.sIndex_[dimNum] = index;
            this.needsSlice_ = true;
            this.needsExtrema_ = true;
        }
    }

    public NcDataset getDataset() {
        return this.ncvar_.getDataset();
    }

    public String getShortName() {
        return this.njvarDS_.getShortName();
    }

    public String getNjPath() {
        String vpath = this.njvarDS_.getFullName();
        LOGGER.trace("vpath {}", (Object)vpath);
        return vpath;
    }

    public String getLongName() {
        return NcUtils.getLongName(this.njvarDS_);
    }

    public String getUnitsStr() {
        return NcUtils.getUnitsStr(this.njvarDS_);
    }

    public Unit getUdunits() {
        return NcUtils.getUdunits(this.njvarDS_);
    }

    public boolean isCompatibleUnits(NcArray v2) {
        Objects.requireNonNull(v2, "Second array cannot be null.");
        return this.isCompatibleUnits(v2.getUdunits());
    }

    public boolean isCompatibleUnits(Unit u2) {
        Unit u1 = this.getUdunits();
        if (u1 == null && u2 == null) {
            return true;
        }
        if (u1 == null || u2 == null) {
            return false;
        }
        return u2.isCompatible(u1);
    }

    public abstract NcGridder getGridder();

    public abstract void describeCell(StringBuilder var1, PrintfFormat var2, int ... var3);
}

