/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcCatalogDataset;
import gov.nasa.giss.data.nc.NcCatalogNode;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.builder.CatalogBuilder;

public class NcCatalog
extends NcCatalogNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Catalog njcat_;
    private boolean childrenInitialized_;
    private URI uri_;

    public NcCatalog(NcCatalogNode parent, URI uri) throws FileNotFoundException, IOException {
        this.setParent(parent);
        this.uri_ = uri;
        CatalogBuilder factory = new CatalogBuilder();
        this.njcat_ = factory.buildFromURI(uri);
        if (this.njcat_ == null) {
            throw new FileNotFoundException("Got null from buildFromURI.");
        }
    }

    private void initChildren() {
        Iterator<Dataset> iterator = this.njcat_.getDatasetsLogical().iterator();
        while (iterator.hasNext()) {
            Dataset o;
            Dataset d = o = iterator.next();
            LOGGER.trace("{}, add {}, {}", this.toString(), d.getID(), d.getIdOrPath());
            NcCatalogDataset ncd = new NcCatalogDataset(this, d);
            super.add(ncd);
        }
        this.childrenInitialized_ = true;
    }

    public URI getURI() {
        return this.njcat_.getBaseURI();
    }

    @Override
    public String toString() {
        Object name = this.njcat_.getName();
        if (name == null) {
            name = "[" + this.njcat_.getBaseURI().getHost() + "]";
        }
        return name;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public Object getObject() {
        return this.njcat_;
    }

    @Override
    public String getName() {
        String ss = this.njcat_.getName();
        if (ss == null) {
            ss = this.njcat_.getBaseURI().getHost();
        }
        return ss;
    }

    @Override
    public String getLongName() {
        return this.njcat_.getName();
    }

    @Override
    public String getDetail() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("<html>").append("<head>");
        this.appendDetailStyle(sb);
        sb.append("</head>").append("<body>").append("<h2>Catalog \"").append(this.getName()).append("\"</h2>\n").append("<hr>").append("<pre>");
        sb.append("Base URI: ").append(this.njcat_.getBaseURI()).append('\n');
        if (this.njcat_.getVersion() != null) {
            sb.append("Version:  ").append(this.njcat_.getVersion()).append('\n');
        }
        if (this.njcat_.getExpires() != null) {
            sb.append("Expires:  ").append(this.njcat_.getExpires()).append('\n');
        }
        sb.append("</pre>");
        if (LOGGER.isDebugEnabled()) {
            try {
                String oneline;
                URL url = new URL(this.uri_.toString());
                BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
                sb.append("<hr />").append("<pre>");
                while ((oneline = br.readLine()) != null) {
                    sb.append(StringUtils.escapeHtmlSimplistic(oneline)).append("\n");
                }
                br.close();
                sb.append("</pre>");
            }
            catch (Exception exc) {
                sb.append("<hr />").append("<p>For URI ").append(this.uri_).append("<br />\n").append("Exception attempting to get XML: ").append(exc.toString()).append("</p>");
            }
        }
        sb.append("</body><").append("</html>");
        return sb.toString();
    }

    @Override
    public String getDetailType() {
        return "text/html";
    }

    @Override
    public int getChildCount() {
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        return super.getChildCount();
    }

    @Override
    public TreeTableNode getChildAt(int index) {
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        return super.getChildAt(index);
    }

    @Override
    public TreeTableNode[] getChildren() {
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        return super.getChildren();
    }

    @Override
    public void add(TreeTableNode child) throws IllegalStateException {
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        super.add(child);
    }
}

