/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.exc.NcNullException;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderTimeVert;
import gov.nasa.giss.text.PrintfFormat;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.VariableDS;

public class NcArrayTimeVert
extends NcArray2D {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public NcArrayTimeVert(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.createAxes();
        this.measureAxes();
    }

    @Override
    protected void createAxes() {
        int dindex;
        NcDataset ncd = this.getDataset();
        CoordinateAxis x = NcUtils.getCoordinateAxisOfType(this.ncvar_, NcAxisType.TIME);
        CoordinateAxis y = NcUtils.getCoordinateAxisOfType(this.ncvar_, NcAxisType.VERT);
        if (x == null) {
            VariableDS cv = NcUtils.getCoordinateVariable(this.ncvar_, NcAxisType.TIME);
            if (cv != null) {
                this.xAxis_ = new NcTimeAxis(ncd, cv);
                this.xDimIndex_ = this.findDimensionIndex(cv);
            }
        } else {
            this.xAxis_ = new NcTimeAxis(ncd, x);
            this.xDimIndex_ = this.findDimensionIndex(x);
        }
        if (y != null) {
            this.yAxis_ = new NcAxis(NcAxisType.VERT, ncd, y);
            this.yDimIndex_ = this.findDimensionIndex(y);
        }
        if (this.xAxis_ == null) {
            throw new NcNullException("Found null when retrieving TIME coordinate axis");
        }
        if (this.yAxis_ == null) {
            throw new NcNullException("Found null when retrieving VERT coordinate axis");
        }
        if (this.xDimIndex_ == -1) {
            throw new NcException("Unable to determine dim index for TIME axis");
        }
        if (this.yDimIndex_ == -1) {
            throw new NcException("Unable to determine dim index for VERT axis");
        }
        CoordinateAxis lonaxis = NcUtils.getCoordinateAxisOfType(this.ncvar_, NcAxisType.LON);
        if (lonaxis instanceof CoordinateAxis1D && lonaxis.getRank() == 1 && lonaxis.getShape()[0] > 0 && (dindex = this.findDimensionIndex(lonaxis)) > -1) {
            this.setAveDimIndex(dindex);
        }
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderTimeVert();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        int col = index[0];
        int row = index[1];
        if (row < 0 || col < 0) {
            sb.append("Pt apparently outside data bounds");
            return;
        }
        int colDisplay = col + 1;
        int rowDisplay = row + 1;
        double time = this.getXAxis().valueAt(col);
        double yy = this.getYAxis().valueAt(row);
        double value = this.valueAt(col, row);
        PrintfFormat pformat10g = new PrintfFormat("%.10g");
        sb.append("Cell [").append(colDisplay).append(", ").append(rowDisplay).append("] at [").append(pformat10g.sprintfx(time)).append(", ").append(pformat10g.sprintfx(yy));
        if (this.getYAxis().getUnitsStr() != null) {
            sb.append(' ').append(this.getYAxis().getUnitsStr());
        }
        sb.append("], value = ").append(valFormat.sprintfx(value));
        if (Double.isNaN(value)) {
            return;
        }
        String unitsStr = this.getUnitsStr();
        if (unitsStr != null && !unitsStr.isEmpty() && !"1".equals(unitsStr)) {
            sb.append(' ').append(unitsStr);
        }
    }
}

