/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcLLAltGridding;
import gov.nasa.giss.data.nc.NcLLAltGriddingVarType;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjGridding;
import gov.nasa.giss.data.nc.exc.NcNullException;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.TransverseMercator;
import ucar.unidata.geoloc.projection.proj4.TransverseMercatorProjection;
import ucar.units.Converter;
import ucar.units.SI;
import ucar.units.ScaledUnit;
import ucar.units.Unit;

public class NcArrayLonLatTransverseMercator
extends NcArrayLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final boolean USE_NJ_PROJ = false;
    private static final double TINY_VALUE = 1.0E-8;
    private Projection njProj_;
    private Converter toProjUnits_;
    private Converter fromProjUnits_;
    private double k0_ = 1.0;
    private double rK0_;
    private double oneOverRK0_;
    private double phiCRad_;
    private double ep2_;
    private double mcoef1_;
    private double mcoef2_;
    private double mcoef3_;
    private double mcoef4_;
    private double mm0_;
    private double invMuDenom_;
    private double phi1coef1_;
    private double phi1coef2_;
    private double phi1coef3_;

    public NcArrayLonLatTransverseMercator(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjGridding.TRANSVERSE_MERCATOR);
        this.initMe();
    }

    private void initMe() {
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcLLAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcLLAltGriddingVarType)vtype).isGrid(NcLLAltGridding.TRANSVERSE_MERCATOR)) {
            throw new NcException("Variable is not projected type transverse Mercator.");
        }
        LOGGER.trace("Using GISS proj.");
        this.initGissProj();
    }

    private void initUnidataProj() {
        VariableDS njvarDS = (VariableDS)this.ncvar_.getObject();
        List csList = njvarDS.getCoordinateSystems();
        if (csList.isEmpty()) {
            throw new NcException("No coordinate system(s) reported.");
        }
        LOGGER.trace("CS list has size {}", (Object)csList.size());
        CoordinateSystem cs = (CoordinateSystem)csList.get(0);
        ProjectionImpl pj = cs.getProjection();
        if (pj == null) {
            throw new NcNullException("C.S. returned null projection handler.");
        }
        LOGGER.trace("C.S. returned projection {}", (Object)pj.getClass().getSimpleName());
        LOGGER.trace("pj class {}", (Object)pj.getClass().getSimpleName());
        if (!(pj instanceof TransverseMercator) && !(pj instanceof TransverseMercatorProjection)) {
            LOGGER.warn("Expected TransverseMercator[Projection] class but got {}", (Object)pj.getClass().getSimpleName());
            throw new NcException("C.S. returned projection class " + pj.getClass().getSimpleName() + " when TransverseMercator was expected");
        }
        this.njProj_ = pj;
        String xUnits = NcUtils.getCoordinateAxisOfType(this.ncvar_, NcAxisType.GEOX).getUnitsString();
        try {
            ScaledUnit projUnit = new ScaledUnit(1000.0, SI.METER);
            Unit eastUnit = NcUnitUtils.parse(xUnits);
            this.toProjUnits_ = eastUnit.getConverterTo(projUnit);
            this.fromProjUnits_ = projUnit.getConverterTo(eastUnit);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initGissProj() {
        this.getGridMappingName();
        if (!this.mappingName_.equalsIgnoreCase("transverse_mercator") && !this.mappingName_.toLowerCase().contains("utm")) {
            LOGGER.trace("Found unusable mapping name {}", (Object)this.mappingName_);
            throw new NcException("Mapping name is not transverse_mercator");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
        LOGGER.trace("ellipsoid {}", (Object)this.ellipsoid_);
        Attribute sfactorA = this.mappingVarDS_.findAttribute("scale_factor_at_central_meridian");
        if (sfactorA == null) {
            sfactorA = this.mappingVarDS_.findAttribute("scale_factor_at_projection_origin");
        }
        LOGGER.trace("sfactorA {}", (Object)sfactorA);
        if (sfactorA != null) {
            this.k0_ = sfactorA.getNumericValue().doubleValue();
            LOGGER.trace("k0 {}", (Object)this.k0_);
        } else {
            this.k0_ = 1.0;
        }
        this.rK0_ = this.ellipsoid_ ? this.semimajor_ * this.k0_ : this.radius_ * this.k0_;
        this.oneOverRK0_ = 1.0 / this.rK0_;
        this.ep2_ = this.eccen2_ / (1.0 - this.eccen2_);
        double eccen4 = this.eccen2_ * this.eccen2_;
        this.mcoef1_ = 1.0 - this.eccen2_ * (0.25 + 3.0 * this.eccen2_ / 64.0 + 5.0 * eccen4 / 256.0);
        this.mcoef2_ = -this.eccen2_ * (0.375 + 3.0 * this.eccen2_ / 32.0 + 45.0 * eccen4 / 1024.0);
        this.mcoef3_ = this.eccen2_ * (15.0 * this.eccen2_ / 256.0 + 45.0 * eccen4 / 1024.0);
        this.mcoef4_ = -this.eccen2_ * (35.0 * eccen4 / 3072.0);
        this.mm0_ = this.semimajor_ * (this.mcoef1_ * this.phiCRad_ + this.mcoef2_ * Math.sin(2.0 * this.phiCRad_) + this.mcoef3_ * Math.sin(4.0 * this.phiCRad_) + this.mcoef4_ * Math.sin(6.0 * this.phiCRad_));
        this.invMuDenom_ = 1.0 / (this.semimajor_ * this.mcoef1_);
        double sqrtOneMinusE2 = Math.sqrt(1.0 - this.eccen2_);
        double e1 = (1.0 - sqrtOneMinusE2) / (1.0 + sqrtOneMinusE2);
        double e1sq = e1 * e1;
        this.phi1coef1_ = e1 * (1.5 - 27.0 * e1sq / 32.0);
        this.phi1coef2_ = e1sq * (1.3125 - 55.0 * e1sq / 32.0);
        this.phi1coef3_ = e1sq * 151.0 * e1 / 96.0;
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return null;
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        if (this.ellipsoid_) {
            double sinPhi = Math.sin(phiRad);
            double cosPhi = Math.cos(phiRad);
            double tanPhi = Math.abs(cosPhi) > 1.0E-8 ? sinPhi / cosPhi : 0.0;
            double nn = this.semimajor_ / Math.sqrt(1.0 - this.eccen2_ * sinPhi * sinPhi);
            double tt = tanPhi * tanPhi;
            double tt2 = tt * tt;
            double cc = this.ep2_ * cosPhi * cosPhi;
            double cc2 = cc * cc;
            double aa = cosPhi * lambdaRad;
            double aa2 = aa * aa;
            double aa3 = aa2 * aa;
            double aa4 = aa3 * aa;
            double aa5 = aa4 * aa;
            double aa6 = aa5 * aa;
            double mm = this.semimajor_ * (this.mcoef1_ * phiRad + this.mcoef2_ * Math.sin(2.0 * phiRad) + this.mcoef3_ * Math.sin(4.0 * phiRad) + this.mcoef4_ * Math.sin(6.0 * phiRad));
            double x = nn * (aa + (1.0 - tt + cc) * aa3 / 6.0 + (5.0 - 18.0 * tt + tt2 + 72.0 * cc - 58.0 * this.ep2_) * aa5 / 120.0);
            double y = mm - this.mm0_ + nn * tanPhi * (aa2 / 2.0 + aa4 * (5.0 - tt + 9.0 * cc + 4.0 * cc2) / 24.0 + aa6 * (61.0 - 58.0 * tt + tt2 + 600.0 * cc - 330.0 * this.ep2_) / 720.0);
            return new Point2D.Double(x * this.k0_ + this.falseEasting_, y * this.k0_ + this.falseNorthing_);
        }
        double bb = Math.cos(phiRad) * Math.sin(lambdaRad);
        if (Math.abs(bb) >= 0.999) {
            return null;
        }
        double x = 0.5 * Math.log((1.0 + bb) / (1.0 - bb));
        double y = Math.atan2(Math.tan(phiRad), Math.cos(lambdaRad)) - this.phiCRad_;
        return new Point2D.Double(x * this.rK0_ + this.falseEasting_, y * this.rK0_ + this.falseNorthing_);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        if (this.ellipsoid_) {
            double xx = x - this.falseEasting_;
            double yy = y - this.falseNorthing_;
            double mm = this.mm0_ + yy / this.k0_;
            double mu = mm * this.invMuDenom_;
            double phi1Rad = mu + this.phi1coef1_ * Math.sin(2.0 * mu) + this.phi1coef2_ * Math.sin(4.0 * mu) + this.phi1coef3_ * Math.sin(6.0 * mu);
            if (Math.abs(phi1Rad) > 1.5707963167948966) {
                double phiRad = 1.5707963267948966 * Math.signum(yy);
                return new PointLL(this.lambdaC_, Math.toDegrees(phiRad));
            }
            double cosPhi1 = Math.cos(phi1Rad);
            double sinPhi1 = Math.sin(phi1Rad);
            double tanPhi1 = sinPhi1 / cosPhi1;
            double cosSqPhi1 = cosPhi1 * cosPhi1;
            double sinSqPhi1 = sinPhi1 * sinPhi1;
            double cc1 = this.ep2_ * cosSqPhi1;
            double cc1sq = cc1 * cc1;
            double tt1 = tanPhi1 * tanPhi1;
            double tt1sq = tt1 * tt1;
            double oneMinusE2sinSqPhi1 = 1.0 - this.eccen2_ * sinSqPhi1;
            double sqrtOneMinusE2sinSqPhi1 = Math.sqrt(oneMinusE2sinSqPhi1);
            double nn1 = this.semimajor_ / sqrtOneMinusE2sinSqPhi1;
            double rr1 = this.semimajor_ * (1.0 - this.eccen2_) / (oneMinusE2sinSqPhi1 * sqrtOneMinusE2sinSqPhi1);
            double dd = xx / (nn1 * this.k0_);
            double dd2 = dd * dd;
            double dd4 = dd2 * dd2;
            double phiRad = phi1Rad - nn1 * tanPhi1 / rr1 * (dd2 / 2.0 - (5.0 + 3.0 * tt1 + 10.0 * cc1 - 4.0 * cc1sq - 9.0 * this.ep2_) * dd4 / 24.0 + (61.0 + 90.0 * tt1 + 298.0 * cc1 + 45.0 * tt1sq - 252.0 * this.ep2_ - 3.0 * cc1sq) * dd2 * dd4 / 720.0);
            double lambdaRad = dd * (1.0 - (1.0 + 2.0 * tt1 + cc1) * dd2 / 6.0 + (5.0 - 2.0 * cc1 + 28.0 * tt1 - 3.0 * cc1sq + 8.0 * this.ep2_ + 24.0 * tt1sq) * dd4 / 120.0) / cosPhi1;
            return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
        }
        double yOverRS = (y - this.falseNorthing_) * this.oneOverRK0_;
        double xOverRS = (x - this.falseEasting_) * this.oneOverRK0_;
        double dd = yOverRS + this.phiCRad_;
        double phiRad = Math.asin(Math.sin(dd) / Math.cosh(xOverRS));
        if (Double.isNaN(phiRad) || Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = Math.atan2(Math.sinh(xOverRS), Math.cos(dd));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
    }
}

