/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import gov.nasa.giss.math.Elliptic;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class AdamsWorldInASquare1
extends QuadSymmetricProjection {
    public static final String PROJECTION_NAME = "Adams World in a Square I";
    public static final int PROPERTIES = 4096;
    private static final double MODULUS = 0.7071067811865476;
    private static final double MODULUS2 = 0.5000000000000001;
    private static final double CAP_K = 1.854074677301372;
    private static final double MAX_X_OVER_RS = 1.854074677301372;
    private static final double MAX_Y_OVER_RS = 1.854074677301372;
    private double kRS_;

    public AdamsWorldInASquare1(int width, int height) {
        this(width, height, 0, 0);
    }

    public AdamsWorldInASquare1(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4096, width, height, xmargin, ymargin, 1.854074677301372, 1.854074677301372);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.kRS_ = 1.854074677301372 * this.rS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double cosB;
        double cosA;
        if (lat > 89.99999) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - this.kRS_);
        }
        if (lat < -89.99999) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ + this.kRS_);
        }
        double phiRad = Math.toRadians(lat);
        double absPhiRad = Math.abs(phiRad);
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        double sinHalfLambda = Math.sin(0.5 * absLambdaRad);
        if (absPhiRad < 1.0E-5) {
            cosA = 0.7071067811865476 * sinHalfLambda;
            cosB = 0.7071067811865476 * sinHalfLambda;
        } else {
            double sinPhiP = Math.tan(0.5 * absPhiRad);
            double cosPhiP = Math.sqrt(1.0 - sinPhiP * sinPhiP);
            if (absLambdaRad < 1.0E-5) {
                cosA = -0.7071067811865476 * sinPhiP;
                cosB = 0.7071067811865476 * sinPhiP;
            } else {
                cosA = 0.7071067811865476 * (cosPhiP * sinHalfLambda - sinPhiP);
                cosB = 0.7071067811865476 * (cosPhiP * sinHalfLambda + sinPhiP);
            }
        }
        double sinA = Math.sqrt(1.0 - cosA * cosA);
        double sinB = Math.sqrt(1.0 - cosB * cosB);
        double cosAcosB = cosA * cosB;
        double sinAsinB = sinA * sinB;
        double sinM = Math.sqrt(1.0 + cosAcosB - sinAsinB);
        double sinN = Math.sqrt(1.0 - cosAcosB - sinAsinB);
        double mmm = Math.asin(sinM);
        double nnn = Math.asin(sinN);
        double x = Elliptic.ellipticF(mmm, 0.5000000000000001);
        double y = Elliptic.ellipticF(nnn, 0.5000000000000001);
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (phiRad < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        if (absX > (double)this.dxMax_ || absY > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = absX * this.invRS_;
        double yOverRS = absY * this.invRS_;
        double[] absLL = this.transformAbsXYrs2LL(xOverRS, yOverRS);
        if (absLL == null || Double.isNaN(absLL[0]) || Double.isNaN(absLL[1])) {
            return null;
        }
        double lambda = x < 0.0 ? -absLL[0] : absLL[0];
        double phi = y < 0.0 ? -absLL[1] : absLL[1];
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        AdamsWorldInASquare1 adamsWorldInASquare1 = this;
        synchronized (adamsWorldInASquare1) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double[] absLL = this.transformAbsXYrs2LL(xOverRS, yOverRS);
                    this.setInvPoints(ix, iy, absLL[0], absLL[1]);
                }
            }
        }
    }

    private double[] transformAbsXYrs2LL(double xOverRS, double yOverRS) {
        double[] jacobiM = Elliptic.jacobiSnCnDn(xOverRS, 0.5000000000000001);
        double[] jacobiN = Elliptic.jacobiSnCnDn(yOverRS, 0.5000000000000001);
        double sinM = jacobiM[0];
        double sinN = jacobiN[0];
        double sinSqM = sinM * sinM;
        double sinSqN = sinN * sinN;
        double sinAsinB = -0.5 * (sinSqM + sinSqN - 2.0);
        double cosAcosB = 0.5 * (sinSqM - sinSqN);
        double cosAplusB = cosAcosB - sinAsinB;
        double cosAminusB = cosAcosB + sinAsinB;
        double aPlusB = Math.acos(cosAplusB);
        double aMinusB = Math.acos(cosAminusB);
        double a = 0.5 * (aPlusB + aMinusB);
        double b = 0.5 * (aPlusB - aMinusB);
        double cosA = Math.cos(a);
        double cosB = Math.cos(b);
        double sinPhiP = 0.7071067811865476 * (cosB - cosA);
        double phiPRad = Math.asin(sinPhiP);
        double cosPhiP = Math.cos(phiPRad);
        double phiRad = 2.0 * Math.atan(sinPhiP);
        double sinHalfLambda = 0.7071067811865476 * (cosA + cosB) / cosPhiP;
        double lambdaRad = 2.0 * Math.asin(sinHalfLambda);
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new double[]{lambda, phi};
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjGraphicUtils.drawRectBorder(g2d, (double)this.outCenterX_ - this.kRS_, (double)this.outCenterY_ - this.kRS_, 2.0 * this.kRS_, 2.0 * this.kRS_);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (Math.abs(lat) < 1.0E-5) {
            double ll = (double)this.outCenterX_ - this.kRS_;
            double rr = (double)this.outCenterX_ + this.kRS_;
            GraphicUtils.drawLine(g2d, ll, this.outCenterY_, rr, this.outCenterY_);
        } else {
            super.drawParallel(g2d, lat, label);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double absLambda = Math.abs(this.lonToLambda(lon));
        if (absLambda > 179.99999) {
            return;
        }
        if (absLambda < 1.0E-5) {
            Point2D.Double dotN = this.transformLL2XYIgnoreMargins(lon, maxLat);
            Point2D.Double dotS = this.transformLL2XYIgnoreMargins(lon, -maxLat);
            GraphicUtils.drawLine(g2d, dotN, dotS);
        } else {
            super.drawMeridian(g2d, lon, maxLat, label);
        }
    }
}

