/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalCylindric;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CylindricalEqualArea
extends GlobalCylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Cylindrical Equal-Area";
    public static final int PROPERTIES = 8196;
    private static final double DEFAULT_PHITS = 30.0;
    private static final double MAX_PHITS = 85.0;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.0;
    private double cosPhiTS_;
    private double csubx_;
    private double csuby_;
    private double csubxRS_;
    private double csubyRS_;
    private final ProjDoubleParameter phi1Param_;

    public CylindricalEqualArea(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8196, width, height, xmargin, ymargin, Math.PI, 1.0);
        this.csubx_ = this.cosPhiTS_ = Math.cos(Math.toRadians(30.0));
        this.csuby_ = 1.0 / this.cosPhiTS_;
        this.csubxRS_ = 1.0;
        this.csubyRS_ = 1.0;
        this.phi1Param_ = new ProjDoubleParameter("Latitude of standard parallel", "Std. Parallel", "\u00b0N", 30.0, 0.0, 85.0, true, false);
        this.addParameter(this.phi1Param_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.phi1Param_)) {
            this.setStandardParallel(this.phi1Param_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setStandardParallel(double lat) {
        if (Math.abs(lat) > 85.0) {
            throw new IllegalArgumentException("Lat must be in range [0,85.0].");
        }
        this.csubx_ = this.cosPhiTS_ = Math.cos(Math.toRadians(lat));
        this.csuby_ = 1.0 / this.cosPhiTS_;
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        double widthFactor = this.csubx_ * Math.PI;
        double heightFactor = this.csuby_ * 1.0;
        this.setMaxXYOverRS(widthFactor, heightFactor);
    }

    @Override
    protected final void finishScaling() {
        this.csubxRS_ = this.csubx_ * this.rS_;
        this.csubyRS_ = this.csuby_ * this.rS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double phiRad = Math.toRadians(lat);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double x = this.csubxRS_ * this.lonToLambdaRad(lon);
        double y = this.csubyRS_ * Math.sin(phiRad);
        x = (double)this.outCenterX_ + x;
        y = (double)this.outCenterY_ - y;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double yOverCyRS = y / this.csubyRS_;
        double phiRad = Math.asin(yOverCyRS);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double xOverCxRS = x / this.csubxRS_;
        double lambdaRad = xOverCxRS;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        CylindricalEqualArea cylindricalEqualArea = this;
        synchronized (cylindricalEqualArea) {
            double y;
            double yOverCyRS;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = Math.asin(yOverCyRS = (y = (double)iy + 0.5) / this.csubyRS_)) > 1.5707963267948966); ++iy) {
                double x;
                double xOverCxRS;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (xOverCxRS = (x = (double)ix + 0.5) / this.csubxRS_)) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

