/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.LonLatEdges;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EquirectangularRegional
extends AbstractProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Equirectangular Regional";
    public static final int PROPERTIES = 0x200004;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.5707963267948966;
    private double xPxlPerDeg_ = 1.0;
    private double yPxlPerDeg_ = 1.0;
    private double xDegPerPxl_ = 1.0;
    private double yDegPerPxl_ = 1.0;
    private double widthDeg_ = 1.0;
    private double heightDeg_ = 1.0;
    private Path2D.Double borderPath_;
    private final ProjDoubleParameter hgtParam_ = new ProjDoubleParameter("Angular distance between top and bottom center", "Height", "\u00b0", 45.0, 0.002, 180.0, true, true);
    private final ProjDoubleParameter wdthParam_ = new ProjDoubleParameter("Angular distance between left and right sides", "Width", "\u00b0", 90.0, 0.002, 360.0, true, true);

    public EquirectangularRegional(int width, int height) {
        this(width, height, 0, 0);
    }

    public EquirectangularRegional(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200004, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(this.wdthParam_);
        this.addParameter(this.hgtParam_);
        this.finishConstruction();
        this.borderPath_ = new Path2D.Double();
    }

    @Override
    public boolean canLabelGrid() {
        return true;
    }

    @Override
    public boolean canPruneMeridians() {
        return false;
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.wdthParam_) || p.equals(this.hgtParam_)) {
            this.setWidthDeg(this.wdthParam_.getValue());
            this.setHeightDeg(this.hgtParam_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
        this.autoscale();
    }

    public ProjDoubleParameter getWidthParam() {
        return this.wdthParam_;
    }

    public double getWidthDeg() {
        return this.widthDeg_;
    }

    private void setWidthDeg(double w) {
        this.widthDeg_ = w;
        this.autoscale();
    }

    public ProjDoubleParameter getHeightParam() {
        return this.hgtParam_;
    }

    public double getHeightDeg() {
        return this.heightDeg_;
    }

    private void setHeightDeg(double h) {
        this.heightDeg_ = h;
        this.autoscale();
    }

    @Override
    public boolean isRecenterableLat() {
        return true;
    }

    @Override
    protected final void finishScaling() {
        Insets ins = this.getInsets();
        this.xPxlPerDeg_ = ((double)this.getWidth() - 2.0 * (double)ins.left) / this.widthDeg_;
        this.yPxlPerDeg_ = ((double)this.getHeight() - 2.0 * (double)ins.top) / this.heightDeg_;
        this.xDegPerPxl_ = 1.0 / this.xPxlPerDeg_;
        this.yDegPerPxl_ = 1.0 / this.yPxlPerDeg_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x = this.lonToLambda(lon) * this.xPxlPerDeg_;
        double y = -(lat - this.phiC_) * this.yPxlPerDeg_;
        return new Point2D.Double(x += (double)this.outCenterX_, y += (double)this.outCenterY_);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phi = this.phiC_ + y * this.yDegPerPxl_;
        if (Math.abs(phi) > 90.0) {
            return null;
        }
        double lambda = x * this.xDegPerPxl_;
        if (Math.abs(lambda) > 180.0) {
            return null;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        EquirectangularRegional equirectangularRegional = this;
        synchronized (equirectangularRegional) {
            int ww = this.getWidth();
            int hh = this.getHeight();
            Insets ins = this.getInsets();
            double copLat = this.phiC_;
            int maxdx = (ww - 2 * ins.left) / 2;
            int maxdy = (hh - 2 * ins.top) / 2;
            for (int iy = -maxdy; iy < maxdy; ++iy) {
                double x;
                double lambda;
                double y = (double)iy + 0.5;
                double phi = copLat + y * this.yDegPerPxl_;
                if (phi < -90.0) continue;
                if (phi > 90.0) break;
                for (int ix = 0; ix < maxdx && !((lambda = (x = (double)ix + 0.5) * this.xDegPerPxl_) > 180.0); ++ix) {
                    this.setInvPoints(ix, iy, lambda, phi);
                }
            }
        }
    }

    private void setInvPoints(int ix, int iy, double lambda, double phi) {
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        int colF = this.outCenterX_ - ix - 1;
        this.setInverseArrayLocation(col, row, this.lambdaC_ + lambda, phi);
        this.setInverseArrayLocation(colF, row, this.lambdaC_ - lambda, phi);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Point2D.Double dotN = this.transformLL2XY(this.lambdaC_, 90.0);
        Point2D.Double dotS = this.transformLL2XY(this.lambdaC_, -90.0);
        int ww = this.getWidth();
        int hh = this.getHeight();
        Insets ins = this.getInsets();
        float top = dotN == null || dotN.y < (double)ins.left ? (float)ins.left : (float)dotN.y;
        float bottom = dotS == null || dotS.y > (double)(hh - ins.bottom) ? (float)(hh - ins.bottom) : (float)dotS.y;
        this.borderPath_.reset();
        this.borderPath_.moveTo(ins.left, top);
        this.borderPath_.lineTo(ins.left, bottom);
        this.borderPath_.lineTo(ww - ins.right, bottom);
        this.borderPath_.lineTo(ww - ins.right, top);
        this.borderPath_.closePath();
        Graphics2D g2x = (Graphics2D)g2d.create();
        g2x.setStroke(ProjGraphicUtils.getSquareMiterStroke(g2x.getStroke()));
        g2x.draw(this.borderPath_);
        g2x.dispose();
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        Point2D.Double dot = this.transformLL2XY(this.lambdaC_, lat);
        if (dot == null) {
            return;
        }
        int ww = this.getWidth();
        Insets ins = this.getInsets();
        if (dot.y <= (double)ins.top - 0.5) {
            return;
        }
        if (dot.y >= (double)(this.getHeight() - ins.bottom) + 0.5) {
            return;
        }
        if (label == null || label.length() == 0) {
            GraphicUtils.drawLine(g2d, ins.left, dot.y, ww - ins.right, dot.y);
            return;
        }
        FontMetrics fm = g2d.getFontMetrics();
        int w = fm.stringWidth(label);
        int des = fm.getDescent();
        int fh = fm.getHeight();
        int fh2 = fh / 2;
        int fh4 = fh / 4;
        float labelx = ww - ins.right - fh2 - w;
        g2d.drawString(label, labelx, (float)(dot.y + (double)fh2 - (double)(0.5f * (float)des)));
        Graphics2D g2x = (Graphics2D)g2d.create();
        Shape oldclip = g2x.getClip();
        if (oldclip == null) {
            oldclip = this.getMarginRectClose();
        }
        Rectangle2D.Double textRect = new Rectangle2D.Double(labelx - (float)fh4, dot.y - (double)fh2, w + fh2, fh);
        Area clipArea = new Area(oldclip);
        Area textArea = new Area(textRect);
        clipArea.subtract(textArea);
        g2x.setClip(clipArea);
        GraphicUtils.drawLine(g2x, ins.left, dot.y, ww - ins.right, dot.y);
        g2x.dispose();
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        float bottom;
        Point2D.Double dot = this.transformLL2XY(lon, this.phiC_);
        if (dot == null) {
            return;
        }
        int ww = this.getWidth();
        int hh = this.getHeight();
        Insets ins = this.getInsets();
        if (dot.x <= (double)ins.left + 0.5) {
            return;
        }
        if (dot.x >= (double)(ww - ins.right) - 0.5) {
            return;
        }
        Point2D.Double dotN = this.transformLL2XY(this.lambdaC_, 90.0);
        Point2D.Double dotS = this.transformLL2XY(this.lambdaC_, -90.0);
        float top = dotN == null || dotN.y < (double)ins.top ? (float)ins.top : (float)dotN.y;
        float f = bottom = dotS == null || dotS.y > (double)(hh - ins.bottom) ? (float)(hh - ins.bottom) : (float)dotS.y;
        if (label == null || label.length() == 0) {
            GraphicUtils.drawLine(g2d, dot.x, top, dot.x, bottom);
            return;
        }
        FontMetrics fm = g2d.getFontMetrics();
        int w = fm.stringWidth(label);
        int des = fm.getDescent();
        int fh = fm.getHeight();
        int fh2 = fh / 2;
        int fh4 = fh / 4;
        float labelx = (float)(dot.x - 0.5 * (double)w);
        g2d.drawString(label, labelx, bottom - (float)fh2 - (float)des);
        Graphics2D g2x = (Graphics2D)g2d.create();
        Shape oldclip = g2x.getClip();
        if (oldclip == null) {
            oldclip = this.getMarginRectClose();
        }
        Rectangle2D.Double textRect = new Rectangle2D.Double(labelx - (float)fh4, bottom - (float)fh2 - (float)fh, w + fh2, fh);
        Area clipArea = new Area(oldclip);
        Area textArea = new Area(textRect);
        clipArea.subtract(textArea);
        g2x.setClip(clipArea);
        GraphicUtils.drawLine(g2x, dot.x, top, dot.x, bottom);
        g2x.dispose();
    }

    @Override
    public LonLatEdges getBounds() {
        double llLeft = this.lambdaC_ - 0.5 * this.widthDeg_;
        double llRight = this.lambdaC_ + 0.5 * this.widthDeg_;
        double llTop = Math.min(90.0, this.phiC_ + 0.5 * this.heightDeg_);
        double llBottom = Math.max(-90.0, this.phiC_ - 0.5 * this.heightDeg_);
        return new LonLatEdges(llLeft, llTop, llRight, llBottom);
    }
}

