/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.FlowerProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HexafoliateEquidistant
extends FlowerProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Hexafoliate Equidistant";
    public static final int PROPERTIES = 131074;
    private static final double JOIN_LAT = 0.0;
    private static final double JOIN_LAT_RAD = Math.toRadians(0.0);
    private static final double JOIN_COLAT_RAD = 1.5707963267948966 - JOIN_LAT_RAD;
    private static final double COS_JOIN = Math.cos(JOIN_LAT_RAD);
    private static final double SEC_JOIN = 1.0 / COS_JOIN;
    private static final int NUM_LOBES = 6;
    private static final double LOBE_WIDTH = 60.0;
    private static final double HALF_LOBE_WIDTH = 30.0;
    private static final double LOBE_WIDTH_RAD = Math.toRadians(60.0);
    private static final double HALF_LOBE_WIDTH_RAD = 0.5 * LOBE_WIDTH_RAD;
    private static final double PAR_SCALING = JOIN_COLAT_RAD * SEC_JOIN;
    private static final double INV_PAR_SCALING = COS_JOIN / JOIN_COLAT_RAD;
    private static final double COS_HALF_LOBE_WIDTH = Math.cos(HALF_LOBE_WIDTH_RAD);
    private static final double SIN_HALF_LOBE_WIDTH = Math.sin(HALF_LOBE_WIDTH_RAD);
    private static final double COS_LOBE_WIDTH = Math.cos(LOBE_WIDTH_RAD);
    private static final double SIN_LOBE_WIDTH = Math.sin(LOBE_WIDTH_RAD);
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = Math.PI * COS_HALF_LOBE_WIDTH;
    private static final double REFERENCE_LON = -20.0;

    public HexafoliateEquidistant(int width, int height) {
        this(width, height, 0, 0);
    }

    public HexafoliateEquidistant(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 131074, width, height, xmargin, ymargin, Math.PI, MAX_Y_OVER_RS, 0.0, 6);
        super.setCenter(-20.0, 90.0);
        this.finishConstruction();
    }

    @Override
    public final void setCenter(double lon, double lat) {
        LOGGER.trace("Projection does not support changing center.");
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        if (lat > 89.99999) {
            return new Point2D.Double(this.outCenterX_, this.outCenterY_);
        }
        double phiRad = Math.toRadians(lat);
        if (lat >= 0.0) {
            double sinPhi;
            double lambdaRad = this.lonToLambdaRad(lon);
            double cosPhi = Math.cos(phiRad);
            double cosZ = sinPhi = Math.sin(phiRad);
            double z = Math.acos(cosZ);
            double k = z / Math.sin(z);
            double rho = k * cosPhi;
            x = rho * Math.sin(lambdaRad);
            y = -rho * Math.cos(lambdaRad);
        } else {
            double alphaRad;
            double lambda;
            for (lambda = this.lonToLambda(lon); lambda < 0.0; lambda += 360.0) {
            }
            int lobe = (int)(lambda / 60.0);
            double rho = alphaRad = 1.5707963267948966 - phiRad;
            double rotateDeg = -(60.0 * (double)lobe + 30.0);
            double xlambdaRad = Math.toRadians(lambda + rotateDeg);
            double betaRad = lat < -89.99999 ? 0.0 : PAR_SCALING * xlambdaRad * Math.cos(phiRad) / alphaRad;
            double xx = rho * Math.sin(betaRad);
            double yy = -rho * Math.cos(betaRad);
            double xxx = xx * COS_HALF_LOBE_WIDTH - yy * SIN_HALF_LOBE_WIDTH;
            double yyy = xx * SIN_HALF_LOBE_WIDTH + yy * COS_HALF_LOBE_WIDTH;
            for (int i = 1; i <= lobe; ++i) {
                x = COS_LOBE_WIDTH * xxx - SIN_LOBE_WIDTH * yyy;
                y = SIN_LOBE_WIDTH * xxx + COS_LOBE_WIDTH * yyy;
                xxx = x;
                yyy = y;
            }
            x = xxx;
            y = yyy;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double phi;
        double lambdaRad;
        double yOverRS;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (x == 0.0 && y == 0.0) {
            return this.getCenter();
        }
        double absx = Math.abs(x);
        double xOverRS = absx * this.invRS_;
        double rho = Math.sqrt(xOverRS * xOverRS + (yOverRS = y * this.invRS_) * yOverRS);
        if (rho > Math.PI) {
            return null;
        }
        double phiRad = 1.5707963267948966 - rho;
        if (phiRad >= JOIN_LAT_RAD) {
            lambdaRad = Math.atan2(absx, -y);
        } else {
            double zetaRad;
            for (zetaRad = Math.atan2(absx, -y); zetaRad < 0.0; zetaRad += Math.PI * 2) {
            }
            int lobe = (int)(zetaRad / LOBE_WIDTH_RAD);
            double rotateRad = -(HALF_LOBE_WIDTH_RAD + (double)lobe * LOBE_WIDTH_RAD);
            double cosRotate = Math.cos(rotateRad);
            double sinRotate = Math.sin(rotateRad);
            double xrot = xOverRS * cosRotate - yOverRS * sinRotate;
            double yrot = xOverRS * sinRotate + yOverRS * cosRotate;
            double alphaRad = rho;
            double betaRad = Math.atan2(Math.abs(xrot), -yrot);
            lambdaRad = alphaRad * betaRad * INV_PAR_SCALING / Math.cos(phiRad);
            if (lambdaRad > HALF_LOBE_WIDTH_RAD) {
                return null;
            }
            if (xrot < 0.0) {
                lambdaRad = -lambdaRad;
            }
            lambdaRad -= rotateRad;
        }
        if (x < 0.0) {
            lambdaRad = -lambdaRad;
        }
        if ((phi = Math.toDegrees(phiRad)) < -90.0) {
            return null;
        }
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        HexafoliateEquidistant hexafoliateEquidistant = this;
        synchronized (hexafoliateEquidistant) {
            for (int iiy = this.dyMax_; iiy > -this.dyMax_; --iiy) {
                int iy = -iiy;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                double y2OverR2S2 = yOverRS * yOverRS;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double lambdaRad;
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double rho = Math.sqrt(xOverRS * xOverRS + y2OverR2S2);
                    if (rho > Math.PI) continue;
                    double phiRad = 1.5707963267948966 - rho;
                    if (phiRad >= JOIN_LAT_RAD) {
                        lambdaRad = Math.atan2(xOverRS, -yOverRS);
                    } else {
                        double zetaRad = Math.atan2(xOverRS, -yOverRS);
                        int lobe = (int)(zetaRad / LOBE_WIDTH_RAD);
                        double rotateRad = -(HALF_LOBE_WIDTH_RAD + (double)lobe * LOBE_WIDTH_RAD);
                        double cosRotate = Math.cos(rotateRad);
                        double sinRotate = Math.sin(rotateRad);
                        double xrot = xOverRS * cosRotate - yOverRS * sinRotate;
                        double yrot = xOverRS * sinRotate + yOverRS * cosRotate;
                        double alphaRad = rho;
                        double betaRad = Math.atan2(Math.abs(xrot), -yrot);
                        lambdaRad = alphaRad * betaRad * INV_PAR_SCALING / Math.cos(phiRad);
                        if (lambdaRad > HALF_LOBE_WIDTH_RAD) continue;
                        if (xrot < 0.0) {
                            lambdaRad = -lambdaRad;
                        }
                        lambdaRad -= rotateRad;
                    }
                    double lambda = Math.toDegrees(lambdaRad);
                    double phi = Math.toDegrees(phiRad);
                    this.setInvPoints(ix, iy, lambda, phi);
                }
            }
        }
    }
}

