/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class USGSDaisy
extends AbstractProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "USGS Daisy";
    public static final int PROPERTIES = 0x3000002;
    private static final double JOIN_LAT = 75.0;
    private static final double JOIN_LAT_RAD = Math.toRadians(75.0);
    final double RHO_JOIN = 2.0 * Math.sin(0.5 * (1.5707963267948966 - JOIN_LAT_RAD));
    private static final int NUM_LOBES = 12;
    private static final double LOBE_WIDTH = 30.0;
    private static final double HALF_LOBE_WIDTH = 15.0;
    private static final double LOBE_WIDTH_RAD = Math.toRadians(30.0);
    private static final double HALF_LOBE_WIDTH_RAD = 0.5 * LOBE_WIDTH_RAD;
    private static final double COS_LOBE_WIDTH = Math.cos(LOBE_WIDTH_RAD);
    private static final double SIN_LOBE_WIDTH = Math.sin(LOBE_WIDTH_RAD);
    private static final double MAX_X_OVER_RS = 1.5707963267948966;
    private static final double REFERENCE_LON = 0.0;
    protected int leftCenterX_;
    protected int rightCenterX_;

    public USGSDaisy(int width, int height) {
        this(width, height, 0, 0);
    }

    public USGSDaisy(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x3000002, width, height, xmargin, ymargin, 3.204424506661589, 1.5707963267948966);
        super.setCenter(0.0, 90.0);
        this.finishConstruction();
    }

    @Override
    public final void setCenter(double lon, double lat) {
        LOGGER.trace("Projection does not support changing center.");
    }

    @Override
    protected final void finishScaling() {
        Insets ins = this.getInsets();
        this.leftCenterX_ = (int)(0.5 * (double)(this.outCenterX_ + ins.left));
        this.rightCenterX_ = (int)(0.5 * (double)(this.outCenterX_ + this.getWidth() - ins.right));
    }

    @Override
    public boolean isRecenterableLon() {
        return false;
    }

    @Override
    public boolean isRecenterableLat() {
        return false;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        boolean leftside = lat >= 0.0;
        double absLat = Math.abs(lat);
        if (absLat > 90.0) {
            return null;
        }
        if (absLat > 89.99999) {
            if (leftside) {
                return new Point2D.Double(this.leftCenterX_, this.outCenterY_);
            }
            return new Point2D.Double(this.rightCenterX_, this.outCenterY_);
        }
        double phiRad = Math.toRadians(absLat);
        if (absLat >= 75.0) {
            double halfPhiRad = 0.5 * phiRad;
            double cosHalfPhi = Math.cos(halfPhiRad);
            double sinHalfPhi = Math.sin(halfPhiRad);
            double rho = 1.4142135623730951 * (cosHalfPhi - sinHalfPhi);
            double lambdaRad = this.lonToLambdaRad(lon);
            x = rho * Math.sin(lambdaRad);
            y = -rho * Math.cos(lambdaRad);
        } else {
            double lambda = MapUtils.normalize360(this.lonToLambda(lon));
            int lobe = (int)((lambda + 15.0) / 30.0);
            double rotateDeg = -30.0 * (double)lobe;
            double xlambdaRad = Math.toRadians(lambda + rotateDeg);
            double b = Math.cos(phiRad) * Math.sin(xlambdaRad);
            if (Math.abs(b) >= 0.95) {
                return null;
            }
            double xx = 0.5 * Math.log((1.0 + b) / (1.0 - b));
            double yy = Math.atan2(Math.tan(phiRad), Math.cos(xlambdaRad)) - this.phiCRad_;
            double xxx = xx;
            double yyy = yy;
            for (int i = 1; i <= lobe; ++i) {
                x = COS_LOBE_WIDTH * xxx - SIN_LOBE_WIDTH * yyy;
                y = SIN_LOBE_WIDTH * xxx + COS_LOBE_WIDTH * yyy;
                xxx = x;
                yyy = y;
            }
            x = xxx;
            y = yyy;
        }
        if (leftside) {
            x = (double)this.leftCenterX_ + x * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
        } else {
            x = (double)this.rightCenterX_ - x * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
        }
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double phiRad;
        boolean leftside = xx <= (double)this.outCenterX_;
        double x = leftside ? xx - (double)this.leftCenterX_ : xx - (double)this.rightCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (x == 0.0 && y == 0.0) {
            return this.getCenter();
        }
        double absx = Math.abs(x);
        if (absx > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = absx * this.invRS_;
        double yOverRS = y * this.invRS_;
        double rho = Math.sqrt(xOverRS * xOverRS + yOverRS * yOverRS);
        if (rho <= this.RHO_JOIN) {
            double z = 2.0 * Math.asin(0.5 * rho);
            double sinZ = Math.sin(z);
            phiRad = 1.5707963267948966 - z;
            lambdaRad = Math.atan2(x * sinZ, -y * sinZ);
        } else {
            double zetaRad;
            for (zetaRad = Math.atan2(absx, -y); zetaRad < 0.0; zetaRad += Math.PI * 2) {
            }
            int lobe = (int)((zetaRad + HALF_LOBE_WIDTH_RAD) / LOBE_WIDTH_RAD);
            double rotateRad = (double)(-lobe) * LOBE_WIDTH_RAD;
            double cosRotate = Math.cos(rotateRad);
            double sinRotate = Math.sin(rotateRad);
            double xrot = xOverRS * cosRotate - yOverRS * sinRotate;
            double yrot = xOverRS * sinRotate + yOverRS * cosRotate;
            double d = yrot + this.phiCRad_;
            phiRad = Math.asin(Math.sin(d) / Math.cosh(xrot));
            if (phiRad < 0.0) {
                return null;
            }
            lambdaRad = Math.atan2(Math.sinh(xrot), Math.cos(d));
            if (Math.abs(lambdaRad) > HALF_LOBE_WIDTH_RAD) {
                return null;
            }
            lambdaRad -= rotateRad;
            if (x < 0.0) {
                lambdaRad = -lambdaRad;
            }
        }
        if (!leftside) {
            phiRad = -phiRad;
            lambdaRad = -lambdaRad;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        USGSDaisy uSGSDaisy = this;
        synchronized (uSGSDaisy) {
            block3: for (int iiy = this.dyMax_; iiy > -this.dyMax_; --iiy) {
                int iy = -iiy;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                double y2OverRS2 = yOverRS * yOverRS;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double lambdaRad;
                    double phiRad;
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double rho = Math.sqrt(xOverRS * xOverRS + y2OverRS2);
                    if (rho <= this.RHO_JOIN) {
                        double z = 2.0 * Math.asin(0.5 * rho);
                        double sinZ = Math.sin(z);
                        phiRad = 1.5707963267948966 - z;
                        lambdaRad = Math.atan2(x * sinZ, -y * sinZ);
                    } else {
                        double zetaRad;
                        for (zetaRad = Math.atan2(x, -y); zetaRad < 0.0; zetaRad += Math.PI * 2) {
                        }
                        int lobe = (int)((zetaRad + HALF_LOBE_WIDTH_RAD) / LOBE_WIDTH_RAD);
                        double rotateRad = (double)(-lobe) * LOBE_WIDTH_RAD;
                        double cosRotate = Math.cos(rotateRad);
                        double sinRotate = Math.sin(rotateRad);
                        double xrot = xOverRS * cosRotate - yOverRS * sinRotate;
                        double yrot = xOverRS * sinRotate + yOverRS * cosRotate;
                        double d = yrot + this.phiCRad_;
                        phiRad = Math.asin(Math.sin(d) / Math.cosh(xrot));
                        if (phiRad < 0.0) continue block3;
                        lambdaRad = Math.atan2(Math.sinh(xrot), Math.cos(d));
                        if (Math.abs(lambdaRad) > HALF_LOBE_WIDTH_RAD) continue;
                        lambdaRad -= rotateRad;
                    }
                    double lambda = Math.toDegrees(lambdaRad);
                    double phi = Math.toDegrees(phiRad);
                    this.setInvPoints(ix, iy, lambda, phi);
                }
            }
        }
    }

    protected void setInvPoints(int ix, int iy, double dlambda, double lat) {
        int row = this.outCenterY_ - iy - 1;
        int col = this.leftCenterX_ + ix;
        int colF = this.leftCenterX_ - ix - 1;
        this.setInverseArrayLocation(col, row, this.lambdaC_ + dlambda, lat);
        this.setInverseArrayLocation(colF, row, this.lambdaC_ - dlambda, lat);
        row = this.outCenterY_ - iy - 1;
        col = this.rightCenterX_ - ix - 1;
        colF = this.rightCenterX_ + ix;
        this.setInverseArrayLocation(col, row, this.lambdaC_ + dlambda, -lat);
        this.setInverseArrayLocation(colF, row, this.lambdaC_ - dlambda, -lat);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        for (int i = 0; i < 12; ++i) {
            double lon1 = this.lambdaC_ + (double)i * 30.0 - 15.0 + 1.0E-5;
            double lon2 = this.lambdaC_ + (double)i * 30.0 + 15.0 - 1.0E-5;
            this.drawLobeMeridianBezier(g2d, lon1, true);
            this.drawLobeMeridianBezier(g2d, lon2, true);
            this.drawLobeMeridianBezier(g2d, lon1, false);
            this.drawLobeMeridianBezier(g2d, lon2, false);
            this.drawParallelImpl(g2d, 0.0);
            this.drawParallelImpl(g2d, -1.0E-5);
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (lat == 0.0) {
            return;
        }
        this.drawParallelImpl(g2d, lat);
    }

    private void drawParallelImpl(Graphics2D g2d, double lat) {
        boolean leftside = lat >= 0.0;
        double absLat = Math.abs(lat);
        if (absLat >= 75.0) {
            Point2D.Double dot = this.transformLL2XYIgnoreMargins(this.lambdaC_, lat);
            if (dot == null) {
                return;
            }
            Point2D.Double pole = leftside ? this.transformLL2XYIgnoreMargins(0.0, 90.0) : this.transformLL2XYIgnoreMargins(0.0, -90.0);
            double dx = pole.x - dot.x;
            double dy = pole.y - dot.y;
            double r = Math.hypot(dx, dy);
            Graphics2D g2x = (Graphics2D)g2d.create();
            g2x.translate(pole.x, pole.y);
            ProjGraphicUtils.drawEllipse(g2x, 0.0, 0.0, r, r);
            g2x.dispose();
        } else {
            for (int i = 0; i < 12; ++i) {
                double lobeLon = this.lambdaC_ + (double)i * 30.0;
                double lon1 = lobeLon - 15.0 + 1.0E-5;
                double lon2 = lobeLon;
                double lon3 = lobeLon + 15.0 - 1.0E-5;
                Point2D.Double dot1 = this.transformLL2XYIgnoreMargins(lon1, lat);
                Point2D.Double dot2 = this.transformLL2XYIgnoreMargins(lon2, lat);
                Point2D.Double dot3 = this.transformLL2XYIgnoreMargins(lon3, lat);
                if (Math.abs(lat) < 1.0E-5) {
                    GraphicUtils.drawLine(g2d, dot1.x, dot1.y, dot3.x, dot3.y);
                    continue;
                }
                GraphicUtils.drawCircularArc(g2d, dot1.x, dot1.y, dot2.x, dot2.y, dot3.x, dot3.y);
            }
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        Point2D.Double dotN = this.transformLL2XYIgnoreMargins(lon, maxLat);
        Point2D.Double dotS = this.transformLL2XYIgnoreMargins(lon, -maxLat);
        double lambda = MapUtils.normalize360(this.lonToLambda(lon));
        int lobe = (int)((lambda + 15.0) / 30.0);
        double lobeLon = MapUtils.normalizeMP180(this.lambdaC_ + (double)lobe * 30.0);
        double absDiff = Math.abs(MapUtils.normalizeMP180(lon - lobeLon));
        if (absDiff > 15.0) {
            return;
        }
        Point2D.Double dotEqN = this.transformLL2XYIgnoreMargins(lon, 0.0);
        Point2D.Double dotEqS = this.transformLL2XYIgnoreMargins(lon, -1.0E-5);
        if (absDiff < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dotN, dotEqN);
            GraphicUtils.drawLine(g2d, dotS, dotEqS);
            return;
        }
        Point2D.Double dotJoinN = this.transformLL2XYIgnoreMargins(lon, 75.0);
        Point2D.Double dotJoinS = this.transformLL2XYIgnoreMargins(lon, -75.0);
        GraphicUtils.drawLine(g2d, dotN, dotJoinN);
        GraphicUtils.drawLine(g2d, dotS, dotJoinS);
        if (Math.abs(absDiff - 15.0) < 1.0E-5) {
            return;
        }
        this.drawLobeMeridianBezier(g2d, lon, true);
        this.drawLobeMeridianBezier(g2d, lon, false);
    }

    private void drawLobeMeridianBezier(Graphics2D g2d, double lon, boolean north) {
        Point2D.Double dot;
        double lat;
        ArrayList<Point2D.Double> ptlist = new ArrayList<Point2D.Double>(400);
        double d = lat = north ? 0.0 : 1.0E-5;
        while (lat < 75.0) {
            dot = north ? this.transformLL2XYIgnoreMargins(lon, lat) : this.transformLL2XYIgnoreMargins(lon, -lat);
            ptlist.add(new Point2D.Double(dot.x, dot.y));
            lat += 0.5;
        }
        dot = north ? this.transformLL2XY(lon, 75.0) : this.transformLL2XY(lon, -75.0);
        ptlist.add(new Point2D.Double(dot.x, dot.y));
        new Bezier(false, ptlist).draw(g2d);
    }
}

