/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanProperties;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanInterpolateAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanPlotMeta pmeta_;
    private long last_;
    private boolean busy_;

    public PanInterpolateAction(PanPlotMeta pmeta) {
        super(PanProperties.MENU_PROPS.getString("interpolate"));
        this.pmeta_ = pmeta;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PanPlotFrame pframe = this.pmeta_.getFrame();
        if (pframe == null) {
            return;
        }
        PanPlotType ptype = this.pmeta_.getType();
        if (ptype.isLinePlot()) {
            return;
        }
        if (this.busy_) {
            return;
        }
        this.busy_ = true;
        Object source = e == null ? null : e.getSource();
        long now = System.currentTimeMillis();
        if (now - this.last_ >= 200L) {
            if (source instanceof JCheckBoxMenuItem) {
                boolean oldval = this.pmeta_.getBoolean("interpolate");
                this.pmeta_.setBoolean("interpolate", !oldval);
            } else if (source instanceof JCheckBox) {
                boolean newval = ((JCheckBox)source).isSelected();
                this.pmeta_.setBoolean("interpolate", newval);
            } else if (source == null) {
                LOGGER.trace("Null source?");
            } else {
                LOGGER.trace("Unexpected source: {}", (Object)source.getClass().getSimpleName());
            }
        }
        EventQueue.invokeLater(() -> pframe.refreshMenu("plot-menu"));
        this.last_ = now;
        this.busy_ = false;
    }
}

