/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.plotui.PanPlotWindoid;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.ui.PanCaptionListener;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.util.task.Task;
import java.awt.Component;
import java.awt.Container;
import java.lang.invoke.MethodHandles;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanControlsPanel
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final PanPreferences PREFS = PanPreferences.getSharedInstance();
    protected PanPlotMeta pmeta_;
    protected PanPlotType ptype_;
    protected PanData data_;
    protected PanMenuBar mbar_;

    public PanControlsPanel(String name, PanPlotMeta pmeta, PanMenuBar mbar) {
        this.setName(name);
        this.setBorder(PanGuiUtils.WINDOID_SECT_BORDER);
        this.setOpaque(false);
        this.pmeta_ = pmeta;
        this.data_ = pmeta.getData();
        this.ptype_ = pmeta.getType();
        this.mbar_ = mbar;
    }

    public PanPlotFrame getPlotFrame() {
        Container tla = this.getTopLevelAncestor();
        if (tla instanceof PanPlotWindoid) {
            return (PanPlotFrame)((PanPlotWindoid)tla).getOwner();
        }
        if (tla instanceof PanPlotFrame) {
            return (PanPlotFrame)tla;
        }
        if (tla == null) {
            LOGGER.debug("Parent frame is null!");
        } else {
            LOGGER.debug("Parent frame is {}?", (Object)tla.getClass().getSimpleName());
        }
        return null;
    }

    public void scheduleRefreshTask() {
        String cname = this.getClass().getSimpleName();
        PanPlotFrame pf = this.getPlotFrame();
        if (pf == null) {
            LOGGER.debug("Parent frame for {} is null. Doing nothing", (Object)cname);
            return;
        }
        LOGGER.trace("Scheduling refresh for {}", (Object)cname);
        Task task = new Task("Update controls"){

            @Override
            protected void finishTask() {
                PanControlsPanel.this.refresh();
            }
        };
        pf.addTask(task);
    }

    public void refresh() {
        LOGGER.trace("Not implemented. Override as necessary.");
    }

    protected void refreshTextField(JTextField jtf, String pkey) {
        DocumentListener[] dll = ((AbstractDocument)jtf.getDocument()).getDocumentListeners();
        DocumentListener capdl = null;
        for (DocumentListener dl : dll) {
            if (!(dl instanceof PanCaptionListener)) continue;
            capdl = dl;
            jtf.getDocument().removeDocumentListener(capdl);
            break;
        }
        jtf.setText(this.pmeta_.getString(pkey));
        if (capdl != null) {
            jtf.getDocument().addDocumentListener(capdl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PanControlsPanel panControlsPanel = this;
        synchronized (panControlsPanel) {
            for (Component child : this.getComponents()) {
                if (child == null || !(child instanceof PanControlsPanel)) continue;
                ((PanControlsPanel)child).flush();
            }
            this.removeAll();
        }
    }
}

