/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanControlsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.GTextField;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatShadingControls
extends PanControlsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PrintfFormat PFORMAT_7G = new PrintfFormat("%.7g");
    private PanCheckBox shadingCB_;
    private PanIntSpinner sOpacitySpinner_;
    private GTextField subsolarLonTF_;
    private GTextField subsolarLatTF_;
    private boolean refreshing_;

    public PanLonLatShadingControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("shading-controls", pmeta, mbar);
        this.createLayout();
        this.attachListeners();
    }

    private void createLayout() {
        this.shadingCB_ = PanCheckBox.small("proj.shading.vis", "Shade nightside", this.pmeta_.getBoolean("proj.shading.vis"));
        QuickBox line1 = QuickBox.createLeftBox(this.shadingCB_);
        JLabel s2Label2 = new JLabel("Max. Darkness: ");
        JLabel s2Label3 = new JLabel("%");
        this.sOpacitySpinner_ = PanIntSpinner.smallPct("proj.shading.opacity", this.pmeta_.getInt("proj.shading.opacity"));
        QuickBox line2 = QuickBox.createLeftBox(s2Label2, this.sOpacitySpinner_, s2Label3);
        JLabel s3Label2 = new JLabel("Subsolar Pt: ");
        JLabel s3Label3 = new JLabel("Lon:\u2009");
        JLabel s3Label4 = new JLabel("\u00b0E, Lat:\u2009");
        JLabel s3Label5 = new JLabel("\u00b0N");
        this.subsolarLonTF_ = GTextField.createDoubleField(this.pmeta_.getDouble("proj.subsolar.lon"), 6);
        this.subsolarLatTF_ = GTextField.createDoubleField(this.pmeta_.getDouble("proj.subsolar.lat"), 6);
        this.subsolarLonTF_.setName("proj.subsolar.lon");
        this.subsolarLatTF_.setName("proj.subsolar.lat");
        QuickBox line3 = QuickBox.createLeftBox(s3Label2, s3Label3, this.subsolarLonTF_, s3Label4, this.subsolarLatTF_, s3Label5);
        this.setLayout(new BoxLayout(this, 1));
        this.add(line1);
        this.add(Box.createVerticalStrut(1));
        this.add(line2);
        this.add(Box.createVerticalStrut(1));
        this.add(line3);
        GuiUtils.setSizeSmall(this);
        this.refresh();
    }

    private void attachListeners() {
        this.shadingCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setBoolean("proj.shading.vis", this.shadingCB_.isSelected());
        });
        this.sOpacitySpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("proj.shading.opacity", this.sOpacitySpinner_.getIntValue());
        });
        FocusAdapter lonlatFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanLonLatShadingControls.this.handleSubsolarTF();
            }
        };
        this.subsolarLonTF_.addFocusListener(lonlatFL);
        this.subsolarLatTF_.addFocusListener(lonlatFL);
        this.subsolarLonTF_.addActionListener(e -> this.handleSubsolarTF());
        this.subsolarLatTF_.addActionListener(e -> this.handleSubsolarTF());
    }

    private void handleSubsolarTF() {
        double lat;
        if (this.refreshing_) {
            return;
        }
        if (this.subsolarLonTF_ == null || this.subsolarLatTF_ == null || this.pmeta_ == null) {
            return;
        }
        double lon = this.getSubsolarLon();
        if (Double.isNaN(lon)) {
            lon = this.pmeta_.getDouble("proj.subsolar.lon");
            this.subsolarLonTF_.setText(PFORMAT_7G.sprintfx(lon));
        }
        boolean shifted = false;
        while (lon > 180.0) {
            lon -= 360.0;
            shifted = true;
        }
        while (lon < -180.0) {
            lon += 360.0;
            shifted = true;
        }
        if (shifted) {
            this.subsolarLonTF_.setText(PFORMAT_7G.sprintfx(lon));
        }
        if (Math.abs(lat = this.getSubsolarLat()) > 90.0) {
            lat = 90.0 * Math.signum(lat);
            this.subsolarLatTF_.setText(PFORMAT_7G.sprintfx(lat));
        }
        if (this.pmeta_ != null) {
            this.pmeta_.setGroup({"proj.subsolar.lon", lon}, {"proj.subsolar.lat", lat});
        }
    }

    private double getSubsolarLon() {
        String s = this.subsolarLonTF_.getText();
        try {
            return StringUtils.parseDouble(s);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse lon TF '{}'", (Object)s);
            return Double.NaN;
        }
    }

    private double getSubsolarLat() {
        String s = this.subsolarLatTF_.getText();
        try {
            return StringUtils.parseDouble(s);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse lat TF '{}')", (Object)s);
            return Double.NaN;
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.shadingCB_.setSelected(this.pmeta_.getBoolean("proj.shading.vis"));
        this.sOpacitySpinner_.setValue(this.pmeta_.getInt("proj.shading.opacity"));
        this.subsolarLonTF_.setText(PFORMAT_7G.sprintfx(this.pmeta_.getDouble("proj.subsolar.lon")));
        this.subsolarLatTF_.setText(PFORMAT_7G.sprintfx(this.pmeta_.getDouble("proj.subsolar.lat")));
        this.refreshing_ = false;
    }
}

