/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.graphics.ColorTableResourceList;
import gov.nasa.giss.graphics.clut.AbstractColorTable;
import gov.nasa.giss.panoply.prefsui.PanPrefsTableModel;
import gov.nasa.giss.panoply.util.PanResourceUtils;
import gov.nasa.giss.util.reslist.ResourceListDataEvent;
import gov.nasa.giss.util.reslist.ResourceListDataListener;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanColorbarTableModel
extends PanPrefsTableModel
implements ResourceListDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ColorTableResourceList reslist_;

    public PanColorbarTableModel() {
        super(true);
        LOGGER.trace("");
        this.reslist_ = PanResourceUtils.getColorTableList();
        LOGGER.trace("");
        this.reslist_.addListDataListener(this);
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        if (this.reslist_ == null) {
            return 0;
        }
        return this.reslist_.getSize();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return AbstractColorTable.class;
            }
        }
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Fave?";
            }
            case 1: {
                return "Sample";
            }
            case 2: {
                return "Name";
            }
            case 3: {
                return "Status";
            }
        }
        return "Error";
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.reslist_.isFavorite(row);
            }
            case 1: {
                return PanResourceUtils.getColorTable(row);
            }
            case 2: {
                return this.reslist_.getName(row);
            }
            case 3: {
                switch (this.reslist_.getLocType(row)) {
                    case INCODE: 
                    case JAR: {
                        return "Built-in";
                    }
                    case USERLIB: {
                        return "User Lib";
                    }
                }
                return "Session";
            }
        }
        return "Error";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col != 0) {
            return false;
        }
        String lcname = this.reslist_.getName(row).toLowerCase();
        boolean required = "blank.act".equals(lcname) || "bluescale.act".equals(lcname) || "grayscale.act".equals(lcname) || "redscale.act".equals(lcname) || "ml_parula.rgb".equals(lcname) || "mpl_magma.rgb".equals(lcname) || "mpl_viridis.rgb".equals(lcname) || "panoply_16.act".equals(lcname) || "panoply_diff.act".equals(lcname) || "panoply_diff_32.gct".equals(lcname) || "panoply.act".equals(lcname) || "SCM_broc.cpt".equals(lcname) || "SCM_imola.act".equals(lcname) || "SCM_nuuk.act".equals(lcname) || "SCM_roma.act".equals(lcname);
        return !required;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col != 0) {
            return;
        }
        if (this.isCellEditable(row, col)) {
            this.reslist_.setFavorite(row, (Boolean)value);
        } else {
            this.reslist_.setFavorite(row, true);
        }
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public void contentsChanged(ResourceListDataEvent e) {
        this.fireTableDataChanged();
    }

    @Override
    public void statusChanged(ResourceListDataEvent e) {
    }

    @Override
    public void intervalAdded(ResourceListDataEvent e) {
        int index0 = e.getIndex0();
        int index1 = e.getIndex1();
        this.fireTableRowsInserted(index0, index1);
    }

    @Override
    public void intervalRemoved(ResourceListDataEvent e) {
        int index0 = e.getIndex0();
        int index1 = e.getIndex1();
        this.fireTableRowsDeleted(index0, index1);
    }

    @Override
    public void sortByColumn(int col) {
        LOGGER.trace("Does nothing. Not implemented.");
    }
}

