/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.task;

import gov.nasa.giss.panoply.io.PanKmzUtils;
import gov.nasa.giss.panoply.plot.PanLonLatPlot;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.util.PanExportKmlOption;
import gov.nasa.giss.ui.SlowMessage;
import gov.nasa.giss.util.task.Task;
import java.awt.Component;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanExportKmzTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanPlotFrame parent_;
    private final File file_;
    private final Hashtable<PanExportKmlOption, Object> opts_;
    private String errMsg_;

    public PanExportKmzTask(PanPlotFrame parent, File file, Hashtable<PanExportKmlOption, Object> opts) {
        super("Exporting KMZ file");
        this.parent_ = parent;
        this.opts_ = opts;
        this.file_ = file;
    }

    @Override
    protected Object beginTask() {
        block2: {
            try {
                PanLonLatPlot llplot = (PanLonLatPlot)this.parent_.getPlot();
                LOGGER.trace("Begin writing KMZ");
                PanKmzUtils.save(this.file_, llplot, this.opts_);
                LOGGER.trace("Done writing KMZ");
            }
            catch (Exception exc) {
                this.errMsg_ = exc.toString().replaceAll("\\:.*", "");
                LOGGER.error("Could not write KMZ file.");
                LOGGER.error(exc.toString());
                if (!LOGGER.isTraceEnabled()) break block2;
                exc.printStackTrace();
            }
        }
        return null;
    }

    @Override
    protected void finishTask() {
        if (this.errMsg_ == null) {
            this.parent_.setControlWindoidsVisible(true);
        } else {
            SlowMessage.show((Component)this.parent_, "Output Error", new StringBuilder("Unable to write KMZ file: ").append(this.errMsg_));
        }
    }
}

