/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.filechooser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.invoke.MethodHandles;
import javax.swing.JFileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectDirectoryChooser
extends JFileChooser
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static File recentPath_;

    public SelectDirectoryChooser() {
        this.setDialogType(0);
        this.setFileSelectionMode(1);
        this.setMultiSelectionEnabled(false);
        if (recentPath_ != null) {
            this.setCurrentDirectory(recentPath_);
        }
        this.addActionListener(this);
    }

    public final void setCurrentDirectory(String dirpath) {
        if (dirpath == null || dirpath.length() == 0) {
            return;
        }
        try {
            File dir = new File(dirpath);
            if (!dir.exists()) {
                LOGGER.warn("Directory {} does not exist", (Object)dirpath);
                return;
            }
            this.setCurrentDirectory(new File(dirpath));
        }
        catch (Exception ignore) {
            LOGGER.warn("Could not set file chooser path to {}", (Object)dirpath);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ApproveSelection")) {
            recentPath_ = this.getCurrentDirectory();
        }
    }
}

