/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.panel;

import gov.nasa.giss.ui.panel.PanelSection;
import gov.nasa.giss.ui.panel.PanelSectionHeader;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PanelSectionHeaderMouseListener
extends MouseAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanelSection section_;
    private Point pressPt_;
    private long lastClick_;

    public PanelSectionHeaderMouseListener(PanelSection section) {
        this.section_ = section;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.finishClick(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.pressPt_ = e.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Point releasePt = e.getPoint();
        int dx = Math.abs(releasePt.x - this.pressPt_.x);
        int dy = Math.abs(releasePt.y - this.pressPt_.y);
        if (dx < 2 && dy < 2) {
            this.finishClick(e);
        }
    }

    private void finishClick(MouseEvent e) {
        long now = System.currentTimeMillis();
        if (now - this.lastClick_ < 100L) {
            LOGGER.debug("Too soon, {}; caught twice?", (Object)(now - this.lastClick_));
            return;
        }
        this.lastClick_ = now;
        Point pt = e.getPoint();
        PanelSectionHeader header = this.section_.getHeader();
        if (header.inDisclosureButton(pt)) {
            this.section_.toggleExpanded();
        }
    }
}

