/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.plaf;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLabelUI;

public class EmphasizedLabelUI
extends BasicLabelUI {
    private static final Color ENABLED_BACKGROUND_COLOR = new Color(255, 255, 255, 110);
    private static final Color ENABLED_FOREGROUND_COLOR = new Color(0, 0, 0);
    private static final Color DISABLED_BACKGROUND_COLOR = new Color(255, 255, 255, 110);
    private static final Color DISABLED_FOREGROUND_COLOR = new Color(63, 63, 63);

    @Override
    public void installUI(JComponent jc) {
        super.installUI(jc);
        jc.setOpaque(false);
    }

    @Override
    protected void paintDisabledText(JLabel label, Graphics g, String s, int textX, int textY) {
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        g2d.setColor(DISABLED_BACKGROUND_COLOR);
        BasicGraphicsUtils.drawStringUnderlineCharAt(g2d, s, -1, textX, textY + 1);
        g2d.setColor(DISABLED_FOREGROUND_COLOR);
        BasicGraphicsUtils.drawStringUnderlineCharAt(g2d, s, -1, textX, textY);
        g2d.dispose();
    }

    @Override
    protected void paintEnabledText(JLabel label, Graphics g, String s, int textX, int textY) {
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        g2d.setColor(ENABLED_BACKGROUND_COLOR);
        BasicGraphicsUtils.drawStringUnderlineCharAt(g2d, s, -1, textX, textY + 1);
        if (GuiUtils.isParentWindowFocused(label)) {
            g2d.setColor(ENABLED_FOREGROUND_COLOR);
        } else {
            g2d.setColor(DISABLED_FOREGROUND_COLOR);
        }
        BasicGraphicsUtils.drawStringUnderlineCharAt(g2d, s, -1, textX, textY);
        g2d.dispose();
    }
}

