/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common;

import org.jcodec.common.TrackType;

public enum Codec {
    H264(TrackType.VIDEO),
    MPEG2(TrackType.VIDEO),
    MPEG4(TrackType.VIDEO),
    PRORES(TrackType.VIDEO),
    DV(TrackType.VIDEO),
    VC1(TrackType.VIDEO),
    VC3(TrackType.VIDEO),
    V210(TrackType.VIDEO),
    SORENSON(TrackType.VIDEO),
    FLASH_SCREEN_VIDEO(TrackType.VIDEO),
    FLASH_SCREEN_V2(TrackType.VIDEO),
    PNG(TrackType.VIDEO),
    JPEG(TrackType.VIDEO),
    J2K(TrackType.VIDEO),
    VP6(TrackType.VIDEO),
    VP8(TrackType.VIDEO),
    VP9(TrackType.VIDEO),
    VORBIS(TrackType.VIDEO),
    AAC(TrackType.AUDIO),
    MP3(TrackType.AUDIO),
    MP2(TrackType.AUDIO),
    MP1(TrackType.AUDIO),
    AC3(TrackType.AUDIO),
    DTS(TrackType.AUDIO),
    TRUEHD(TrackType.AUDIO),
    PCM_DVD(TrackType.AUDIO),
    PCM(TrackType.AUDIO),
    ADPCM(TrackType.AUDIO),
    ALAW(TrackType.AUDIO),
    NELLYMOSER(TrackType.AUDIO),
    G711(TrackType.AUDIO),
    SPEEX(TrackType.AUDIO),
    RAW(null),
    TIMECODE(TrackType.OTHER);

    private TrackType type;

    private Codec(TrackType type) {
        this.type = type;
    }

    public TrackType getType() {
        return this.type;
    }

    public static Codec codecByFourcc(String fourcc) {
        if (fourcc.equals("avc1")) {
            return H264;
        }
        if (fourcc.equals("m1v1") || fourcc.equals("m2v1")) {
            return MPEG2;
        }
        if (fourcc.equals("apco") || fourcc.equals("apcs") || fourcc.equals("apcn") || fourcc.equals("apch") || fourcc.equals("ap4h")) {
            return PRORES;
        }
        if (fourcc.equals("mp4a")) {
            return AAC;
        }
        if (fourcc.equals("jpeg")) {
            return JPEG;
        }
        return null;
    }
}

