/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.macos;

import gov.nasa.giss.util.PlatformUtils;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MacNative {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static boolean loaded_;

    public static boolean isLoaded() {
        return loaded_;
    }

    public native String[] showOpenDialog(String var1, String[][] var2, String var3, String var4, boolean var5, boolean var6);

    public native String showSaveDialog(String var1, String[][] var2, String var3, String var4, String var5);

    public native String showSimpleSaveDialog(String var1, String var2, String var3, String var4, String var5);

    static {
        boolean macArm64 = PlatformUtils.isMacintoshArm64();
        boolean canLoad = false;
        String lname = macArm64 ? "giss_a64" : "giss";
        LOGGER.debug("Lib path is {}", (Object)System.getProperty("java.library.path"));
        loaded_ = false;
        try {
            LOGGER.debug("Trying to load lib{}", (Object)lname);
            System.loadLibrary(lname);
            loaded_ = true;
        }
        catch (UnsatisfiedLinkError err) {
            String msg = err.getMessage();
            if (msg.contains("incompatible architecture")) {
                LOGGER.warn("libgiss found but architecture is not compatible.");
            } else {
                LOGGER.debug("UnsatisfiedLinkError loading {}", (Object)lname);
                LOGGER.debug("Message reads {}", (Object)msg);
                if (LOGGER.isTraceEnabled()) {
                    err.printStackTrace();
                }
            }
        }
        catch (Error err) {
            LOGGER.debug("Error loading {}", (Object)lname);
            LOGGER.debug("Message reads {}", (Object)err.getMessage());
        }
        catch (Exception exc) {
            LOGGER.debug("Exception loading {}", (Object)lname);
            LOGGER.debug("Message reads {}", (Object)exc.getMessage());
        }
        if (loaded_) {
            LOGGER.info("... success!");
        } else {
            LOGGER.info("... failed.");
        }
    }
}

