/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.kml;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Objects;

public class KMLDataFilenameFilter
implements FilenameFilter {
    private static final String KMZ_EXT = "kmz";
    private static final String DOT_KMZ = ".kmz";
    private static String[] EXTENSIONS = new String[]{".kmz"};

    @Override
    public boolean accept(File dir, String name) {
        if (KMLDataFilenameFilter.isKMLName(name)) {
            return true;
        }
        return new File(dir, name).isDirectory();
    }

    public static boolean isKMLName(File f) {
        Objects.requireNonNull(f, "File cannot be null.");
        return KMLDataFilenameFilter.isKMLName(f.getName());
    }

    public static boolean isKMLName(String fname) {
        Objects.requireNonNull(fname, "File name cannot be null.");
        String lcname = fname.toLowerCase();
        for (String extension : EXTENSIONS) {
            if (!lcname.endsWith(extension.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

