/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class McBrydeThomas5
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "McBryde-Thomas Flat-Polar Parabolic";
    private static final double CONST_K = 0.5;
    private static final double CONST_N = 1.75;
    private static final double THREE_N = 5.25;
    private static final double TWO_N_PLUS_1 = 4.5;
    private static final double CAP_M = Math.sqrt(0.8571428571428571);
    private static final double CSUBX = CAP_M / 3.0;
    private static final double CSUBY = 3.0 * CAP_M;
    private static final double INV_CSUBX = 1.0 / CSUBX;
    private static final double INV_CSUBY = 1.0 / CSUBY;
    private static final double SEVEN_SQRT6_OVER_18 = 7.0 * Math.sqrt(6.0) / 18.0;
    private static final double SQRT6_OVER_2 = 0.5 * Math.sqrt(6.0);
    private static final double MAX_X_OVER_RS = CSUBX * Math.PI * 3.0;
    private static final double MAX_Y_OVER_RS = CSUBY * 0.5;
    private double xFactor0_;

    public McBrydeThomas5(int width, int height) {
        this(width, height, 0, 0);
    }

    public McBrydeThomas5(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x1000008, width, height, xmargin, ymargin, MAX_X_OVER_RS, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.xFactor0_ = this.invRS_ / CAP_M;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        double phiRad = Math.toRadians(lat);
        double sinPhi = Math.sin(phiRad);
        if (Math.abs(phiRad) < 1.0E-5) {
            x = CSUBX * this.lonToLambdaRad(lon) * 3.0;
            y = 0.0;
        } else {
            double sinU = SEVEN_SQRT6_OVER_18 * sinPhi;
            double uRad = Math.asin(sinU);
            double sinAlphaOver3 = SQRT6_OVER_2 * Math.sin(uRad / 3.0);
            double alphaRadOver3 = Math.asin(sinAlphaOver3);
            double alphaRad = 3.0 * alphaRadOver3;
            y = CSUBY * sinAlphaOver3;
            double cosAlpha = Math.cos(alphaRad);
            double cosAlphaOver3 = Math.cos(alphaRadOver3);
            double alphaTerm = 1.0 + 2.0 * cosAlpha / cosAlphaOver3;
            if (this.isInterrupted()) {
                double[] gore = this.getGore(lon, lat);
                double nlon = MapUtils.normalizeMP180(lon);
                double dlon = nlon - gore[1];
                double dx = CSUBX * Math.toRadians(dlon) * alphaTerm;
                double cx = CSUBX * this.lonToLambdaRad(gore[1]) * 3.0;
                x = cx + dx;
            } else {
                x = CSUBX * this.lonToLambdaRad(lon) * alphaTerm;
            }
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double cosAlphaOver3;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double alphaRad = 3.0 * Math.asin(y * this.invRS_ * INV_CSUBY);
        double sinAlpha = Math.sin(alphaRad);
        double sinAlphaOver3 = Math.sin(alphaRad / 3.0);
        double nSinPhi = 1.5 * sinAlphaOver3 + sinAlpha;
        double phiRad = Math.asin(nSinPhi / 1.75);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double cosAlpha = Math.cos(alphaRad);
        double alphaTerm = 1.0 + 2.0 * cosAlpha / (cosAlphaOver3 = Math.cos(alphaRad / 3.0));
        double xFactor = this.invRS_ * INV_CSUBX / alphaTerm;
        double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        McBrydeThomas5 mcBrydeThomas5 = this;
        synchronized (mcBrydeThomas5) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                double alphaRad = 3.0 * Math.asin(yOverRS * INV_CSUBY);
                double sinAlpha = Math.sin(alphaRad);
                double sinAlphaOver3 = Math.sin(alphaRad / 3.0);
                double nSinPhi = 1.5 * sinAlphaOver3 + sinAlpha;
                double phiRad = Math.asin(nSinPhi / 1.75);
                if (phiRad < -1.5707963267948966) continue;
                if (phiRad > 1.5707963267948966) break;
                double phi = Math.toDegrees(phiRad);
                double cosAlpha = Math.cos(alphaRad);
                double cosAlphaOver3 = Math.cos(alphaRad / 3.0);
                double alphaTerm = 1.0 + 2.0 * cosAlpha / cosAlphaOver3;
                double xFactor = this.invRS_ * INV_CSUBX / alphaTerm;
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phi > 0.0);
                    if (Double.isNaN(lon)) continue;
                    this.setInvPoint(ix, iy, lon, phi);
                }
            }
        }
    }
}

